/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.docs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.rust.ide.docs.ColoredDocumentationGenerator;
import org.rust.ide.docs.RsDocumentationProvider;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsTypeParameter;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0006\u001a\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u001a\f\u0010\r\u001a\u00020\u0003*\u00020\fH\u0002\u001a-\u0010\u000e\u001a\u00020\u00062\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u0013H\u0082\b\u001a6\u0010\u0014\u001a\u00020\u00062\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\u0002\b\u0018H\u0082\b\u001a7\u0010\u0019\u001a\u00020\u00062\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u000b2\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u0013H\u0082\b\u001a\u001b\u0010\u001b\u001a\u00020\u0006*\u00060\u0010j\u0002`\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0082\u0002\u001a)\u0010\u001e\u001a\u00020\u0006*\u00060\u0010j\u0002`\u00112\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u0013H\u0082\b\u001a.\u0010\u001f\u001a\u00020\u0006*\u00060\u0010j\u0002`\u00112\u001b\u0010\b\u001a\u0017\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\u0002\b\u0018H\u0082\b\u001a.\u0010 \u001a\u00020\u0006*\u00060\u0010j\u0002`\u00112\u001b\u0010\b\u001a\u0017\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\u0002\b\u0018H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010!\u001a\u00020\u00038\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\"\u001a\u00020\u00038\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "EXTERNAL_DOCUMENTATION_URL_SETTING_KEY", "", "getExternalDocumentationBaseUrl", "withExternalDocumentationBaseUrl", "", "url", "action", "Lkotlin/Function0;", "isLinkNeeded", "", "Lorg/rust/lang/core/psi/RsPath;", "link", "definition", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "block", "Lkotlin/Function1;", "coloredDefinition", "crate", "Lorg/rust/lang/core/crate/Crate;", "Lorg/rust/ide/docs/ColoredDocumentationGenerator;", "Lkotlin/ExtensionFunctionType;", "content", "separated", "plusAssign", "value", "", "b", "p", "code", "RAW_STRINGS_EXAMPLE", "RAW_BYTE_STRINGS_EXAMPLE", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocumentationProvider.kt\norg/rust/ide/docs/RsDocumentationProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1145:1\n1#2:1146\n13#3:1147\n*S KotlinDebug\n*F\n+ 1 RsDocumentationProvider.kt\norg/rust/ide/docs/RsDocumentationProviderKt\n*L\n64#1:1147\n*E\n"})
public final class RsDocumentationProviderKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String EXTERNAL_DOCUMENTATION_URL_SETTING_KEY = "org.rust.external.doc.url";
    @Language(value="Rust")
    @NotNull
    private static final String RAW_STRINGS_EXAMPLE = "    \"foo\"; r\"foo\";                     // foo\n    \"\\\"foo\\\"\"; r#\"\"foo\"\"#;             // \"foo\"\n\n    \"foo #\\\"# bar\";\n    r##\"foo #\"# bar\"##;                // foo #\"# bar\n\n    \"\\x52\"; \"R\"; r\"R\";                 // R\n    \"\\\\x52\"; r\"\\x52\";                  // \\x52\n";
    @Language(value="Rust")
    @NotNull
    private static final String RAW_BYTE_STRINGS_EXAMPLE = "    b\"foo\"; br\"foo\";                     // foo\n    b\"\\\"foo\\\"\"; br#\"\"foo\"\"#;             // \"foo\"\n\n    b\"foo #\\\"# bar\";\n    br##\"foo #\"# bar\"##;                 // foo #\"# bar\n\n    b\"\\x52\"; b\"R\"; br\"R\";                // R\n    b\"\\\\x52\"; br\"\\x52\";                  // \\x52\n";

    @NotNull
    public static final String getExternalDocumentationBaseUrl() {
        String url = AdvancedSettings.Companion.getString(EXTERNAL_DOCUMENTATION_URL_SETTING_KEY);
        return StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null) ? url : url + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static final void withExternalDocumentationBaseUrl(@NotNull String url, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        String originalUrl = RsDocumentationProviderKt.getExternalDocumentationBaseUrl();
        try {
            AdvancedSettings.Companion.setString(EXTERNAL_DOCUMENTATION_URL_SETTING_KEY, url);
            action2.invoke();
        }
        finally {
            AdvancedSettings.Companion.setString(EXTERNAL_DOCUMENTATION_URL_SETTING_KEY, originalUrl);
        }
    }

    private static final boolean isLinkNeeded(RsPath $this$isLinkNeeded) {
        RsPathReference rsPathReference = $this$isLinkNeeded.getReference();
        RsElement element = rsPathReference != null ? rsPathReference.resolve() : null;
        return element != null && !(element instanceof RsTypeParameter);
    }

    private static final String link(RsPath $this$link) {
        Object object;
        String prefix;
        Object object2;
        RsPath path;
        RsPath rsPath = path = $this$link.getPath();
        if (rsPath != null) {
            String string = rsPath.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            object2 = UtilsKt.getEscaped(string) + "::";
        } else {
            Object object3 = $this$link.getTypeQual();
            object2 = object3 != null && (object3 = object3.getText()) != null ? UtilsKt.getEscaped((String)object3) : null;
        }
        String string = prefix = object2;
        if (string != null) {
            String string2 = $this$link.getReferenceName();
            if (string2 == null) {
                string2 = "";
            }
            object = string + string2;
        } else {
            object = $this$link.getReferenceName();
            if (object == null) {
                object = "";
            }
        }
        return object;
    }

    private static final void definition(StringBuilder buffer, Function1<? super StringBuilder, Unit> block) {
        boolean $i$f$definition = false;
        RsDocumentationProviderKt.plusAssign(buffer, "<div class='definition'><pre>");
        block.invoke((Object)buffer);
        RsDocumentationProviderKt.plusAssign(buffer, "</pre></div>");
    }

    private static final void coloredDefinition(StringBuilder buffer, Crate crate, Function1<? super ColoredDocumentationGenerator, Unit> block) {
        boolean $i$f$coloredDefinition = false;
        RsDocumentationProviderKt.plusAssign(buffer, "<div class='definition'><pre>");
        ColoredDocumentationGenerator $this$coloredDefinition_u24lambda_u240 = new ColoredDocumentationGenerator(crate, buffer, false, 4, null);
        boolean bl = false;
        block.invoke((Object)$this$coloredDefinition_u24lambda_u240);
        RsDocumentationProviderKt.plusAssign(buffer, "</pre></div>");
    }

    private static final void content(StringBuilder buffer, boolean separated, Function1<? super StringBuilder, Unit> block) {
        boolean $i$f$content = false;
        String clazz = separated ? "content-separated" : "content";
        RsDocumentationProviderKt.plusAssign(buffer, "<div class='" + clazz + "'>");
        block.invoke((Object)buffer);
        RsDocumentationProviderKt.plusAssign(buffer, "</div>");
    }

    static /* synthetic */ void content$default(StringBuilder buffer, boolean separated, Function1 block, int n, Object object) {
        if ((n & 2) != 0) {
            separated = false;
        }
        boolean $i$f$content = false;
        String clazz = separated ? "content-separated" : "content";
        RsDocumentationProviderKt.plusAssign(buffer, "<div class='" + clazz + "'>");
        block.invoke((Object)buffer);
        RsDocumentationProviderKt.plusAssign(buffer, "</div>");
    }

    private static final void plusAssign(StringBuilder $this$plusAssign, CharSequence value) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        if (value != null) {
            $this$plusAssign.append(value);
        }
    }

    private static final void b(StringBuilder $this$b, Function1<? super StringBuilder, Unit> action2) {
        boolean $i$f$b = false;
        $this$b.append("<b>");
        action2.invoke((Object)$this$b);
        $this$b.append("</b>");
    }

    private static final void p(StringBuilder $this$p, Function1<? super StringBuilder, Unit> action2) {
        boolean $i$f$p = false;
        $this$p.append("<p>");
        action2.invoke((Object)$this$p);
        $this$p.append("</p>");
    }

    private static final void code(StringBuilder $this$code, Function1<? super StringBuilder, Unit> action2) {
        boolean $i$f$code = false;
        $this$code.append("<pre>");
        action2.invoke((Object)$this$code);
        $this$code.append("</pre>");
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isLinkNeeded(RsPath $receiver) {
        return RsDocumentationProviderKt.isLinkNeeded($receiver);
    }

    public static final /* synthetic */ String access$link(RsPath $receiver) {
        return RsDocumentationProviderKt.link($receiver);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsDocumentationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

