/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.debugger.runconfig;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.util.PlatformUtils;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.RsCommandConfiguration;
import org.rust.cargo.runconfig.RsCommandConfigurationKt;
import org.rust.cargo.runconfig.RsDefaultProgramRunnerBase;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.ide.debugger.UtilsKt;
import org.rust.ide.debugger.runconfig.RsDebugAdvertisingRunnerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner;", "Lorg/rust/cargo/runconfig/RsDefaultProgramRunnerBase;", "<init>", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getRunnerId", "isSupportedPlatform", "Companion", "Action", "intellij.rustrover.core"})
public final class RsDebugAdvertisingRunner
extends RsDefaultProgramRunnerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUNNER_ID = "RsDebugAdvertisingRunner";

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (org.rust.openapiext.UtilsKt.isUnitTestMode()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)executorId, (Object)"Debug")) {
            return false;
        }
        if (!(profile instanceof CargoCommandConfiguration)) {
            return false;
        }
        if (!this.isSupportedPlatform()) {
            return false;
        }
        if (RsCommandConfigurationKt.getHasRemoteTarget((RsCommandConfiguration)profile)) {
            return false;
        }
        IdeaPluginDescriptor ideaPluginDescriptor = UtilsKt.nativeDebuggingSupportPlugin();
        if (ideaPluginDescriptor == null) {
            return true;
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        List<IdeaPluginDescriptor> loadedPlugins = RsDebugAdvertisingRunnerKt.getLoadedPlugins(PluginManagerCore.INSTANCE);
        return !loadedPlugins.contains(plugin) || !plugin.isEnabled();
    }

    @Override
    public void execute(@NotNull ExecutionEnvironment environment) {
        Action action2;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IdeaPluginDescriptor plugin = UtilsKt.nativeDebuggingSupportPlugin();
        InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
        if (plugin == null && !pluginsState.wasInstalled(UtilsKt.getNATIVE_DEBUGGING_SUPPORT_PLUGIN_ID())) {
            action2 = Action.INSTALL;
        } else {
            IdeaPluginDescriptor ideaPluginDescriptor = plugin;
            action2 = (ideaPluginDescriptor != null ? !ideaPluginDescriptor.isEnabled() : false) ? Action.ENABLE : Action.RESTART;
        }
        Action action3 = action2;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String[] stringArray = new String[]{action3.getActionName()};
        int options = Messages.showDialog((Project)project2, (String)action3.getMessage(), (String)RsBundle.INSTANCE.message("dialog.title.unable.to.run.debugger", new Object[0]), (String[])stringArray, (int)0, (Icon)Messages.getErrorIcon());
        if (options == 0) {
            action3.doOkAction(project2, UtilsKt.getNATIVE_DEBUGGING_SUPPORT_PLUGIN_ID());
        }
    }

    @NotNull
    public String getRunnerId() {
        return RUNNER_ID;
    }

    private final boolean isSupportedPlatform() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isRubyMine() || PlatformUtils.isGoIde() || PlatformUtils.isPyCharmPro();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&R\u001d\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u00070\b\u00a2\u0006\u0002\b\u000fX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\rj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner$Action;", "", "<init>", "(Ljava/lang/String;I)V", "INSTALL", "ENABLE", "RESTART", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "getMessage$annotations", "()V", "getMessage", "()Ljava/lang/String;", "actionName", "Lcom/intellij/openapi/util/NlsContexts$Button;", "getActionName$annotations", "getActionName", "doOkAction", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.rustrover.core"})
    private static final abstract class Action
    extends Enum<Action> {
        public static final /* enum */ Action INSTALL = new INSTALL("INSTALL", 0);
        public static final /* enum */ Action ENABLE = new ENABLE("ENABLE", 1);
        public static final /* enum */ Action RESTART = new RESTART("RESTART", 2);
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Action() {
        }

        @NotNull
        public abstract String getMessage();

        public static /* synthetic */ void getMessage$annotations() {
        }

        @NotNull
        public abstract String getActionName();

        public static /* synthetic */ void getActionName$annotations() {
        }

        public abstract void doOkAction(@NotNull Project var1, @NotNull PluginId var2);

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Action(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = actionArray = new Action[]{Action.INSTALL, Action.ENABLE, Action.RESTART};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u000e"}, d2={"org/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner.Action.ENABLE", "Lorg/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner$Action;", "message", "", "getMessage", "()Ljava/lang/String;", "actionName", "getActionName", "doOkAction", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.rustrover.core"})
        static final class ENABLE
        extends Action {
            /*
             * WARNING - void declaration
             */
            ENABLE() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getMessage() {
                return "Native Debugging Support plugin is not enabled";
            }

            @Override
            @NotNull
            public String getActionName() {
                return "Enable";
            }

            @Override
            public void doOkAction(@NotNull Project project, @NotNull PluginId pluginId) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                PluginsAdvertiser.installAndEnable$default((Project)project, (Set)SetsKt.setOf((Object)pluginId), (boolean)false, (boolean)false, null, ENABLE::doOkAction$lambda$0, (int)24, null);
            }

            private static final void doOkAction$lambda$0() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u000e"}, d2={"org/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner.Action.INSTALL", "Lorg/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner$Action;", "message", "", "getMessage", "()Ljava/lang/String;", "actionName", "getActionName", "doOkAction", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.rustrover.core"})
        static final class INSTALL
        extends Action {
            /*
             * WARNING - void declaration
             */
            INSTALL() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getMessage() {
                return "Native Debugging Support plugin is not installed";
            }

            @Override
            @NotNull
            public String getActionName() {
                return "Install";
            }

            @Override
            public void doOkAction(@NotNull Project project, @NotNull PluginId pluginId) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                PluginsAdvertiser.installAndEnable$default((Project)project, (Set)SetsKt.setOf((Object)pluginId), (boolean)false, (boolean)false, null, INSTALL::doOkAction$lambda$0, (int)24, null);
            }

            private static final void doOkAction$lambda$0() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u000e"}, d2={"org/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner.Action.RESTART", "Lorg/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner$Action;", "message", "", "getMessage", "()Ljava/lang/String;", "actionName", "getActionName", "doOkAction", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.rustrover.core"})
        static final class RESTART
        extends Action {
            /*
             * WARNING - void declaration
             */
            RESTART() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getMessage() {
                return "Need to restart " + ApplicationNamesInfo.getInstance().getFullProductName() + " to apply changes in plugins";
            }

            @Override
            @NotNull
            public String getActionName() {
                String string = IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            public void doOkAction(@NotNull Project project, @NotNull PluginId pluginId) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                ApplicationManagerEx.getApplicationEx().restart(true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/debugger/runconfig/RsDebugAdvertisingRunner$Companion;", "", "<init>", "()V", "RUNNER_ID", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

