/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBSplitter;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.console.RsConsoleCodeFragmentContext;
import org.rust.ide.console.RsConsoleExecuteActionHandler;
import org.rust.ide.console.RsConsoleOneCommandContext;
import org.rust.ide.console.RsConsoleOptions;
import org.rust.ide.console.RsConsoleVariablesView;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.psi.RsReplCodeFragment;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u001a\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!J\u0014\u0010\"\u001a\u00020#2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0002J\u0006\u0010\r\u001a\u00020\u001aJ\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020)J\b\u0010-\u001a\u00020\u001aH\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\u0006\u0010/\u001a\u00020\u001aJ\u000e\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u001fJ\b\u00102\u001a\u00020\u001aH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010*\u00a8\u00064"}, d2={"Lorg/rust/ide/console/RsConsoleView;", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "Lcom/intellij/execution/ui/ObservableConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "executeActionHandler", "Lorg/rust/ide/console/RsConsoleExecuteActionHandler;", "getExecuteActionHandler", "()Lorg/rust/ide/console/RsConsoleExecuteActionHandler;", "setExecuteActionHandler", "(Lorg/rust/ide/console/RsConsoleExecuteActionHandler;)V", "initialized", "Lcom/intellij/openapi/util/ActionCallback;", "codeFragment", "Lorg/rust/lang/core/psi/RsReplCodeFragment;", "getCodeFragment", "()Lorg/rust/lang/core/psi/RsReplCodeFragment;", "codeFragmentContext", "Lorg/rust/ide/console/RsConsoleCodeFragmentContext;", "variablesView", "Lorg/rust/ide/console/RsConsoleVariablesView;", "options", "Lorg/rust/ide/console/RsConsoleOptions;", "requestFocus", "", "createCenterComponent", "Ljavax/swing/JComponent;", "print", "text", "", "attributes", "Lcom/intellij/openapi/util/Key;", "outputTypeForAttributes", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "addToContext", "lastCommandContext", "Lorg/rust/ide/console/RsConsoleOneCommandContext;", "removeBorders", "isShowVariables", "", "()Z", "updateVariables", "state", "showVariables", "hideVariables", "initVariablesWindow", "handleEvcxrCommand", "command", "dispose", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsConsoleView.kt\norg/rust/ide/console/RsConsoleView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class RsConsoleView
extends LanguageConsoleImpl
implements ObservableConsoleView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public RsConsoleExecuteActionHandler executeActionHandler;
    @NotNull
    private final ActionCallback initialized;
    @Nullable
    private final RsReplCodeFragment codeFragment;
    @NotNull
    private final RsConsoleCodeFragmentContext codeFragmentContext;
    @Nullable
    private RsConsoleVariablesView variablesView;
    @NotNull
    private final RsConsoleOptions options;
    @NotNull
    public static final String PROMPT = ">> ";
    @NotNull
    public static final String INDENT_PROMPT = ".. ";
    @NotNull
    public static final String VIRTUAL_FILE_NAME = "IntellijRustRepl.rs";
    @NotNull
    private static final Key<Boolean> RUST_CONSOLE_KEY = new Key("RS_CONSOLE_KEY");

    public RsConsoleView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, VIRTUAL_FILE_NAME, (Language)RsLanguage.INSTANCE);
        this.initialized = new ActionCallback();
        PsiFile psiFile = UtilsKt.toPsiFile(this.getVirtualFile(), project);
        this.codeFragment = psiFile instanceof RsReplCodeFragment ? (RsReplCodeFragment)psiFile : null;
        this.codeFragmentContext = new RsConsoleCodeFragmentContext(this.codeFragment);
        this.options = RsConsoleOptions.Companion.getInstance(project);
        VirtualFile virtualFile = this.getVirtualFile();
        virtualFile.putUserData(RUST_CONSOLE_KEY, (Object)true);
        this.getHistoryViewer().putUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW, (Object)true);
        this.setPrompt(PROMPT);
        this.getConsolePromptDecorator().setIndentPrompt(INDENT_PROMPT);
        this.setUpdateFoldingsEnabled(false);
    }

    @NotNull
    public final RsConsoleExecuteActionHandler getExecuteActionHandler() {
        RsConsoleExecuteActionHandler rsConsoleExecuteActionHandler = this.executeActionHandler;
        if (rsConsoleExecuteActionHandler != null) {
            return rsConsoleExecuteActionHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"executeActionHandler");
        return null;
    }

    public final void setExecuteActionHandler(@NotNull RsConsoleExecuteActionHandler rsConsoleExecuteActionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)rsConsoleExecuteActionHandler), (String)"<set-?>");
        this.executeActionHandler = rsConsoleExecuteActionHandler;
    }

    @Nullable
    public final RsReplCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    public void requestFocus() {
        this.initialized.doWhenDone(() -> RsConsoleView.requestFocus$lambda$0(this));
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent centerComponent = super.createCenterComponent();
        this.getHistoryViewer().getSettings().setAdditionalLinesCount(0);
        this.getHistoryViewer().getSettings().setUseSoftWraps(false);
        this.getConsoleEditor().getGutterComponentEx().setBackground(this.getConsoleEditor().getBackgroundColor());
        this.getConsoleEditor().getGutterComponentEx().revalidate();
        this.getConsoleEditor().getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.getConsoleEditor().getBackgroundColor());
        return centerComponent;
    }

    public final void print(@NotNull String text, @NotNull Key<?> attributes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.print(text, this.outputTypeForAttributes(attributes));
    }

    private final ConsoleViewContentType outputTypeForAttributes(Key<?> attributes) {
        ConsoleViewContentType consoleViewContentType;
        if (attributes == ProcessOutputTypes.STDERR) {
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
            consoleViewContentType = consoleViewContentType2;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"ERROR_OUTPUT");
        } else if (attributes == ProcessOutputTypes.SYSTEM) {
            ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.SYSTEM_OUTPUT;
            consoleViewContentType = consoleViewContentType3;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"SYSTEM_OUTPUT");
        } else {
            ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.getConsoleViewType(attributes);
            consoleViewContentType = consoleViewContentType4;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"getConsoleViewType(...)");
        }
        return consoleViewContentType;
    }

    public final void initialized() {
        this.initialized.setDone();
    }

    public final void addToContext(@NotNull RsConsoleOneCommandContext lastCommandContext) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)lastCommandContext, (String)"lastCommandContext");
            if (this.codeFragment == null) break block1;
            this.codeFragmentContext.addToContext(lastCommandContext);
            this.codeFragmentContext.updateContextAsync(this.getProject(), this.codeFragment);
            RsConsoleVariablesView rsConsoleVariablesView = this.variablesView;
            if (rsConsoleVariablesView != null) {
                rsConsoleVariablesView.rebuild();
            }
        }
    }

    public final void removeBorders() {
        this.getHistoryViewer().setBorder(null);
        this.getConsoleEditor().setBorder(null);
    }

    public final boolean isShowVariables() {
        return this.options.getShowVariables();
    }

    public final void updateVariables(boolean state) {
        if (this.options.getShowVariables() == state) {
            return;
        }
        this.options.setShowVariables(state);
        if (state) {
            this.showVariables();
        } else {
            this.hideVariables();
        }
    }

    private final void showVariables() {
        JBSplitter jBSplitter;
        this.variablesView = new RsConsoleVariablesView(this.getProject(), this.codeFragmentContext);
        Component console = this.getComponent(0);
        this.removeAll();
        JBSplitter $this$showVariables_u24lambda_u240 = jBSplitter = new JBSplitter(false, 0.6666667f);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)console, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        $this$showVariables_u24lambda_u240.setFirstComponent((JComponent)console);
        $this$showVariables_u24lambda_u240.setSecondComponent((JComponent)((Object)this.variablesView));
        $this$showVariables_u24lambda_u240.setShowDividerControls(true);
        $this$showVariables_u24lambda_u240.setHonorComponentsMinimumSize(true);
        JBSplitter splitter = jBSplitter;
        this.add((Component)splitter, "Center");
        this.validate();
        this.repaint();
    }

    private final void hideVariables() {
        Component splitter = this.getComponent(0);
        RsConsoleVariablesView variablesView = this.variablesView;
        if (variablesView != null && splitter instanceof JBSplitter) {
            this.removeAll();
            Disposer.dispose((Disposable)variablesView);
            this.variablesView = null;
            this.add(((JBSplitter)splitter).getFirstComponent(), "Center");
            this.validate();
            this.repaint();
        }
    }

    public final void initVariablesWindow() {
        if (this.options.getShowVariables()) {
            this.showVariables();
        }
    }

    public final void handleEvcxrCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (Intrinsics.areEqual((Object)command, (Object)":clear")) {
            this.codeFragmentContext.clearAllCommands();
        }
    }

    public void dispose() {
        super.dispose();
        RsConsoleVariablesView rsConsoleVariablesView = this.variablesView;
        if (rsConsoleVariablesView != null) {
            RsConsoleVariablesView it2 = rsConsoleVariablesView;
            boolean bl = false;
            Disposer.dispose((Disposable)it2);
        }
        this.variablesView = null;
    }

    private static final void requestFocus$lambda$0(RsConsoleView this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.getConsoleEditor().getContentComponent(), true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/console/RsConsoleView$Companion;", "", "<init>", "()V", "PROMPT", "", "INDENT_PROMPT", "VIRTUAL_FILE_NAME", "RUST_CONSOLE_KEY", "Lcom/intellij/openapi/util/Key;", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

