/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.console;

import com.intellij.execution.actions.EOFAction;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.Evcxr;
import org.rust.cargo.toolchain.tools.EvcxrKt;
import org.rust.ide.console.PrintAction;
import org.rust.ide.console.RestartAction;
import org.rust.ide.console.RsConsoleCommunication;
import org.rust.ide.console.RsConsoleExecuteActionHandler;
import org.rust.ide.console.RsConsoleProcessHandler;
import org.rust.ide.console.RsConsoleRootType;
import org.rust.ide.console.RsConsoleRunner;
import org.rust.ide.console.RsConsoleView;
import org.rust.ide.console.ShowVariablesAction;
import org.rust.ide.console.SoftWrapAction;
import org.rust.ide.console.StopAction;
import org.rust.ide.icons.RsIcons;
import org.rust.openapiext.RsPluginDisposable;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020 H\u0014J\b\u0010#\u001a\u00020\u0011H\u0002J\b\u0010$\u001a\u00020\fH\u0014J\u0006\u0010%\u001a\u00020\u0011J\u0014\u0010&\u001a\u00020\u00112\n\u0010'\u001a\u00060(j\u0002`)H\u0002J\b\u0010*\u001a\u00020+H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/rust/ide/console/RsConsoleRunner;", "Lcom/intellij/execution/runners/AbstractConsoleRunnerWithHistory;", "Lorg/rust/ide/console/RsConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "consoleCommunication", "Lorg/rust/ide/console/RsConsoleCommunication;", "getConsoleExecuteActionHandler", "Lorg/rust/ide/console/RsConsoleExecuteActionHandler;", "getProcessHandler", "Lorg/rust/ide/console/RsConsoleProcessHandler;", "createConsoleView", "createContentDescriptorAndActions", "", "createConsoleExecAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "consoleExecuteActionHandler", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "getExecuteActionShortcut", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "runSync", "requestEditorFocus", "", "run", "initAndRun", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "Ljava/lang/Process;", "createCommandLine", "createProcess", "connect", "createExecuteActionHandler", "rerun", "showErrorsInConsole", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getConsoleIcon", "Ljavax/swing/Icon;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsConsoleRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsConsoleRunner.kt\norg/rust/ide/console/RsConsoleRunner\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,304:1\n37#2,2:305\n13#3:307\n*S KotlinDebug\n*F\n+ 1 RsConsoleRunner.kt\norg/rust/ide/console/RsConsoleRunner\n*L\n285#1:305,2\n298#1:307\n*E\n"})
public final class RsConsoleRunner
extends AbstractConsoleRunnerWithHistory<RsConsoleView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private GeneralCommandLine commandLine;
    private RsConsoleCommunication consoleCommunication;
    @NotNull
    private static final Logger LOG;
    @Nls
    @NotNull
    private static final String TOOL_WINDOW_TITLE;

    public RsConsoleRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, TOOL_WINDOW_TITLE, null);
    }

    @NotNull
    public RsConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        ProcessBackedConsoleExecuteActionHandler processBackedConsoleExecuteActionHandler = super.getConsoleExecuteActionHandler();
        Intrinsics.checkNotNull((Object)processBackedConsoleExecuteActionHandler, (String)"null cannot be cast to non-null type org.rust.ide.console.RsConsoleExecuteActionHandler");
        return (RsConsoleExecuteActionHandler)processBackedConsoleExecuteActionHandler;
    }

    @Nullable
    public RsConsoleProcessHandler getProcessHandler() {
        return (RsConsoleProcessHandler)super.getProcessHandler();
    }

    @NotNull
    protected RsConsoleView createConsoleView() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsConsoleView consoleView = new RsConsoleView(project);
        this.consoleCommunication = new RsConsoleCommunication(consoleView);
        return consoleView;
    }

    protected void createContentDescriptorAndActions() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup runActionGroup = new DefaultActionGroup();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("RustConsoleRunner", (ActionGroup)runActionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar runToolbar = actionToolbar;
        DefaultActionGroup outputActionGroup = new DefaultActionGroup();
        Object object = actionManager.createActionToolbar("RustConsoleRunner", (ActionGroup)outputActionGroup, false);
        ActionToolbar $this$createContentDescriptorAndActions_u24lambda_u240 = object;
        boolean bl = false;
        int emptyBorderSize = $this$createContentDescriptorAndActions_u24lambda_u240.getComponent().getBorder().getBorderInsets((Component)((Component)$this$createContentDescriptorAndActions_u24lambda_u240.getComponent())).left;
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border());
        JBEmptyBorder insideBorder = new JBEmptyBorder(emptyBorderSize);
        $this$createContentDescriptorAndActions_u24lambda_u240.getComponent().setBorder(BorderFactory.createCompoundBorder(outsideBorder, (Border)insideBorder));
        ActionToolbar actionToolbar2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar outputToolbar = actionToolbar2;
        Object $this$createContentDescriptorAndActions_u24lambda_u241 = object = new JPanel(new BorderLayout());
        boolean bl2 = false;
        ((Container)$this$createContentDescriptorAndActions_u24lambda_u241).add((Component)runToolbar.getComponent(), "West");
        ((Container)$this$createContentDescriptorAndActions_u24lambda_u241).add((Component)outputToolbar.getComponent(), "Center");
        Object actionsPanel = object;
        Object $this$createContentDescriptorAndActions_u24lambda_u242 = $this$createContentDescriptorAndActions_u24lambda_u241 = new JPanel(new BorderLayout());
        boolean bl3 = false;
        ((Container)$this$createContentDescriptorAndActions_u24lambda_u242).add((Component)actionsPanel, "West");
        ((Container)$this$createContentDescriptorAndActions_u24lambda_u242).add((Component)((RsConsoleView)this.getConsoleView()).getComponent(), "Center");
        runToolbar.setTargetComponent((JComponent)$this$createContentDescriptorAndActions_u24lambda_u242);
        outputToolbar.setTargetComponent((JComponent)$this$createContentDescriptorAndActions_u24lambda_u242);
        Object mainPanel = $this$createContentDescriptorAndActions_u24lambda_u241;
        String title = this.constructConsoleTitle(this.getConsoleTitle());
        Object[] $this$createContentDescriptorAndActions_u24lambda_u243 = bl3 = new RunContentDescriptor((ExecutionConsole)this.getConsoleView(), (ProcessHandler)this.getProcessHandler(), (JComponent)mainPanel, title, this.getConsoleIcon());
        boolean $i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22 = false;
        $this$createContentDescriptorAndActions_u24lambda_u243.setFocusComputable(() -> RsConsoleRunner.createContentDescriptorAndActions$lambda$3$0(this));
        $this$createContentDescriptorAndActions_u24lambda_u243.setAutoFocusContent($this$createContentDescriptorAndActions_u24lambda_u243.isAutoFocusContent());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Disposer.register((Disposable)RsPluginDisposable.Companion.getInstance(project), (Disposable)((Disposable)$this$createContentDescriptorAndActions_u24lambda_u243));
        Object[] contentDescriptor = bl3;
        $this$createContentDescriptorAndActions_u24lambda_u243 = new AnAction[4];
        $this$createContentDescriptorAndActions_u24lambda_u243[0] = new RestartAction(this);
        $this$createContentDescriptorAndActions_u24lambda_u243[1] = this.createConsoleExecAction(this.getConsoleExecuteActionHandler());
        RsConsoleProcessHandler rsConsoleProcessHandler = this.getProcessHandler();
        Intrinsics.checkNotNull((Object)((Object)rsConsoleProcessHandler));
        $this$createContentDescriptorAndActions_u24lambda_u243[2] = new StopAction(rsConsoleProcessHandler);
        $this$createContentDescriptorAndActions_u24lambda_u243[3] = new CloseAction(this.getExecutor(), (RunContentDescriptor)contentDescriptor, this.getProject());
        List runActions = CollectionsKt.listOf((Object[])$this$createContentDescriptorAndActions_u24lambda_u243);
        runActionGroup.addAll((Collection)runActions);
        Object[] $i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22 = new AnAction[5];
        LanguageConsoleView languageConsoleView = this.getConsoleView();
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView, (String)"getConsoleView(...)");
        $i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22[0] = new SoftWrapAction((RsConsoleView)languageConsoleView);
        $i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22[1] = new ScrollToTheEndToolbarAction(((RsConsoleView)this.getConsoleView()).getEditor());
        LanguageConsoleView languageConsoleView2 = this.getConsoleView();
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView2, (String)"getConsoleView(...)");
        $i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22[2] = new PrintAction((RsConsoleView)languageConsoleView2);
        ConsoleHistoryController consoleHistoryController = ConsoleHistoryController.getController((LanguageConsoleView)this.getConsoleView());
        Intrinsics.checkNotNull((Object)consoleHistoryController);
        Intrinsics.checkNotNullExpressionValue((Object)consoleHistoryController.getBrowseHistory(), (String)"getBrowseHistory(...)");
        LanguageConsoleView languageConsoleView3 = this.getConsoleView();
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView3, (String)"getConsoleView(...)");
        $i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22[4] = new ShowVariablesAction((RsConsoleView)languageConsoleView3);
        List outputActions = CollectionsKt.listOf((Object[])$i$a$-apply-RsConsoleRunner$createContentDescriptorAndActions$contentDescriptor$22);
        outputActionGroup.addAll((Collection)outputActions);
        List actions = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)outputActions, (Iterable)runActions), (Object)new EOFAction());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts((List)actions, (JComponent)((RsConsoleView)this.getConsoleView()).getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts((List)actions, (JComponent)((JComponent)mainPanel));
        this.showConsole(this.getExecutor(), (RunContentDescriptor)contentDescriptor);
    }

    @NotNull
    protected AnAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        Intrinsics.checkNotNullParameter((Object)consoleExecuteActionHandler, (String)"consoleExecuteActionHandler");
        EditorEx consoleEditor = ((RsConsoleView)this.getConsoleView()).getConsoleEditor();
        AnAction executeAction = super.createConsoleExecAction(consoleExecuteActionHandler);
        executeAction.registerCustomShortcutSet(this.getExecuteActionShortcut(), consoleEditor.getComponent());
        String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)executeAction);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String actionShortcutText = string;
        Object[] objectArray = new Object[]{actionShortcutText};
        consoleEditor.setPlaceholder((CharSequence)RsBundle.INSTANCE.message("0.to.execute", objectArray));
        consoleEditor.setShowPlaceholderWhenFocused(true);
        Intrinsics.checkNotNull((Object)executeAction);
        return executeAction;
    }

    private final ShortcutSet getExecuteActionShortcut() {
        ShortcutSet shortcutSet;
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
        Keymap keymap2 = keymap;
        Shortcut[] shortcutArray = keymap2.getShortcuts("Console.Execute.Multiline");
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        Shortcut[] shortcuts = shortcutArray;
        if (!(shortcuts.length == 0)) {
            shortcutSet = (ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcuts, shortcuts.length));
        } else {
            ShortcutSet shortcutSet2 = CommonShortcuts.CTRL_ENTER;
            Intrinsics.checkNotNull((Object)shortcutSet2);
            shortcutSet = shortcutSet2;
        }
        return shortcutSet;
    }

    public final void runSync(boolean requestEditorFocus) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (Cargo.Companion.checkNeedInstallEvcxr(project)) {
            return;
        }
        try {
            this.initAndRun();
            Project project2 = this.getProject();
            String string = RsBundle.INSTANCE.message("progress.title.connecting.to.console", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, requestEditorFocus, project2, string){
                final /* synthetic */ RsConsoleRunner this$0;
                final /* synthetic */ boolean $requestEditorFocus;
                {
                    this.this$0 = $receiver;
                    this.$requestEditorFocus = $requestEditorFocus;
                    super($super_call_param$1, $super_call_param$2, false);
                }

                public void run(ProgressIndicator indicator) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        indicator.setText(RsBundle.INSTANCE.message("progress.text.connecting.to.console", new Object[0]));
                        RsConsoleRunner.access$connect(this.this$0);
                        if (!this.$requestEditorFocus) break block1;
                        RsConsoleView rsConsoleView = (RsConsoleView)this.this$0.getConsoleView();
                        if (rsConsoleView != null) {
                            rsConsoleView.requestFocus();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Error running console", (Throwable)e);
            this.showErrorsInConsole(e);
        }
    }

    public final void run(boolean requestEditorFocus) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (Cargo.Companion.checkNeedInstallEvcxr(project)) {
            return;
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        TransactionGuard.submitTransaction((Disposable)RsPluginDisposable.Companion.getInstance(project2), RsConsoleRunner::run$lambda$0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> RsConsoleRunner.run$lambda$1(this, requestEditorFocus));
    }

    public void initAndRun() {
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> RsConsoleRunner.initAndRun$lambda$0(this), (int)1, null);
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process2) {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        LanguageConsoleView languageConsoleView = this.getConsoleView();
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView, (String)"getConsoleView(...)");
        RsConsoleView rsConsoleView = (RsConsoleView)languageConsoleView;
        RsConsoleCommunication rsConsoleCommunication = this.consoleCommunication;
        if (rsConsoleCommunication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleCommunication");
            rsConsoleCommunication = null;
        }
        if ((generalCommandLine = this.commandLine) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandLine");
            generalCommandLine = null;
        }
        String string = generalCommandLine.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        return (OSProcessHandler)new RsConsoleProcessHandler(process2, rsConsoleView, rsConsoleCommunication, string, charset);
    }

    private final GeneralCommandLine createCommandLine() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CargoProject cargoProject = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(project).getAllProjects());
        if (cargoProject == null) {
            throw new RuntimeException("No cargo project");
        }
        CargoProject cargoProject2 = cargoProject;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project2);
        if (rsToolchainBase == null) {
            throw new RuntimeException("Rust toolchain is not defined");
        }
        RsToolchainBase toolchain2 = rsToolchainBase;
        Evcxr evcxr = EvcxrKt.evcxr(toolchain2);
        if (evcxr == null) {
            throw new RuntimeException("Evcxr executable not found");
        }
        Evcxr evcxr2 = evcxr;
        Path workingDir = cargoProject2.getRootDirPath();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        File file = workingDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return (GeneralCommandLine)evcxr2.createCommandLine(project3, file);
    }

    @NotNull
    protected Process createProcess() {
        this.commandLine = this.createCommandLine();
        GeneralCommandLine generalCommandLine = this.commandLine;
        if (generalCommandLine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandLine");
            generalCommandLine = null;
        }
        Process process2 = generalCommandLine.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"createProcess(...)");
        return process2;
    }

    private final void connect() {
        ActionsKt.invokeLater$default(null, () -> RsConsoleRunner.connect$lambda$0(this), (int)1, null);
    }

    @NotNull
    protected RsConsoleExecuteActionHandler createExecuteActionHandler() {
        RsConsoleProcessHandler rsConsoleProcessHandler = this.getProcessHandler();
        Intrinsics.checkNotNull((Object)((Object)rsConsoleProcessHandler));
        ProcessHandler processHandler = (ProcessHandler)rsConsoleProcessHandler;
        RsConsoleCommunication rsConsoleCommunication = this.consoleCommunication;
        if (rsConsoleCommunication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleCommunication");
            rsConsoleCommunication = null;
        }
        RsConsoleExecuteActionHandler consoleExecuteActionHandler = new RsConsoleExecuteActionHandler(processHandler, rsConsoleCommunication);
        consoleExecuteActionHandler.setEnabled(false);
        new ConsoleHistoryController((ConsoleRootType)RsConsoleRootType.Helper.INSTANCE.getInstance(), "", this.getConsoleView()).install();
        return consoleExecuteActionHandler;
    }

    public final void rerun() {
        Project project = this.getProject();
        String string = RsBundle.INSTANCE.message("progress.title.restarting.console", new Object[0]);
        new Task.Backgroundable(this, project, string){
            final /* synthetic */ RsConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RsConsoleProcessHandler processHandler = this.this$0.getProcessHandler();
                if (processHandler != null) {
                    processHandler.destroyProcess();
                    processHandler.waitFor();
                }
                ActionsKt.runInEdt$default(null, () -> rerun.1.run$lambda$0(this), (int)1, null);
            }

            private static final Unit run$lambda$0(rerun.1 this$0) {
                Project project = this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                new RsConsoleRunner(project).run(true);
                return Unit.INSTANCE;
            }
        }.queue();
    }

    private final void showErrorsInConsole(Exception e) {
        AnAction[] anActionArray = new AnAction[]{new RestartAction(this)};
        DefaultActionGroup actionGroup = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RsConsoleRunnerErrors", (ActionGroup)actionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar2.getComponent(), "West");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        NewErrorTreeViewPanel errorViewPanel = new NewErrorTreeViewPanel(project, null, false, false, null, null, null, 96, null);
        Object[] objectArray = new String[]{"Can't start evcxr."};
        List messages = CollectionsKt.mutableListOf((Object[])objectArray);
        String message = e.getMessage();
        CharSequence charSequence = message;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            CollectionsKt.addAll((Collection)messages, (Iterable)StringsKt.lines((CharSequence)message));
        }
        Collection $this$toTypedArray$iv = messages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        errorViewPanel.addMessage(4, thisCollection$iv.toArray(new String[0]), null, -1, -1, null);
        panel2.add((Component)errorViewPanel, "Center");
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, (ProcessHandler)this.getProcessHandler(), (JComponent)panel2, RsBundle.INSTANCE.message("tab.title.error.running.console", new Object[0]));
        this.showConsole(this.getExecutor(), contentDescriptor);
    }

    @NotNull
    protected Icon getConsoleIcon() {
        return RsIcons.INSTANCE.getREPL();
    }

    private static final JComponent createContentDescriptorAndActions$lambda$3$0(RsConsoleRunner this$0) {
        return ((RsConsoleView)this$0.getConsoleView()).getConsoleEditor().getContentComponent();
    }

    private static final void run$lambda$0() {
        UtilsKt.saveAllDocuments$default(false, 1, null);
    }

    private static final void run$lambda$1(RsConsoleRunner this$0, boolean $requestEditorFocus) {
        Project project = this$0.getProject();
        String string = RsBundle.INSTANCE.message("progress.title.connecting.to.console", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this$0, $requestEditorFocus, project, string){
            final /* synthetic */ RsConsoleRunner this$0;
            final /* synthetic */ boolean $requestEditorFocus;
            {
                this.this$0 = $receiver;
                this.$requestEditorFocus = $requestEditorFocus;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(RsBundle.INSTANCE.message("progress.text.connecting.to.console", new Object[0]));
                try {
                    this.this$0.initAndRun();
                    RsConsoleRunner.access$connect(this.this$0);
                    if (this.$requestEditorFocus) {
                        RsConsoleView rsConsoleView = (RsConsoleView)this.this$0.getConsoleView();
                        if (rsConsoleView != null) {
                            rsConsoleView.requestFocus();
                        }
                    }
                }
                catch (Exception e) {
                    RsConsoleRunner.Companion.getLOG().warn("Error running console", (Throwable)e);
                    ActionsKt.invokeAndWaitIfNeeded$default(null, () -> run.2.1.run$lambda$0(this.this$0, e), (int)1, null);
                }
            }

            private static final Unit run$lambda$0(RsConsoleRunner this$0, Exception $e) {
                RsConsoleRunner.access$showErrorsInConsole(this$0, $e);
                return Unit.INSTANCE;
            }
        });
    }

    private static final Unit initAndRun$lambda$0(RsConsoleRunner this$0) {
        super.initAndRun();
        return Unit.INSTANCE;
    }

    private static final Unit connect$lambda$0(RsConsoleRunner this$0) {
        ((RsConsoleView)this$0.getConsoleView()).removeBorders();
        ((RsConsoleView)this$0.getConsoleView()).initVariablesWindow();
        ((RsConsoleView)this$0.getConsoleView()).setExecuteActionHandler(this$0.getConsoleExecuteActionHandler());
        this$0.getConsoleExecuteActionHandler().setEnabled(true);
        ((RsConsoleView)this$0.getConsoleView()).initialized();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$connect(RsConsoleRunner $this) {
        $this.connect();
    }

    public static final /* synthetic */ void access$showErrorsInConsole(RsConsoleRunner $this, Exception e) {
        $this.showErrorsInConsole(e);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsConsoleRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TOOL_WINDOW_TITLE = RsBundle.INSTANCE.message("rust.repl", new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/ide/console/RsConsoleRunner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TOOL_WINDOW_TITLE", "", "getTOOL_WINDOW_TITLE", "()Ljava/lang/String;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final String getTOOL_WINDOW_TITLE() {
            return TOOL_WINDOW_TITLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

