/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.console;

import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.console.RsConsoleCommunication;
import org.rust.ide.console.RsConsoleView;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/console/RsConsoleProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "process", "Ljava/lang/Process;", "consoleView", "Lorg/rust/ide/console/RsConsoleView;", "consoleCommunication", "Lorg/rust/ide/console/RsConsoleCommunication;", "commandLine", "", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Ljava/lang/Process;Lorg/rust/ide/console/RsConsoleView;Lorg/rust/ide/console/RsConsoleCommunication;Ljava/lang/String;Ljava/nio/charset/Charset;)V", "coloredTextAvailable", "", "textOriginal", "attributes", "Lcom/intellij/openapi/util/Key;", "isSilentlyDestroyOnClose", "", "shouldKillProcessSoftly", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "intellij.rustrover.core"})
public final class RsConsoleProcessHandler
extends KillableColoredProcessHandler {
    @NotNull
    private final RsConsoleView consoleView;
    @NotNull
    private final RsConsoleCommunication consoleCommunication;

    public RsConsoleProcessHandler(@NotNull Process process2, @NotNull RsConsoleView consoleView, @NotNull RsConsoleCommunication consoleCommunication, @NotNull String commandLine, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)consoleCommunication, (String)"consoleCommunication");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super(process2, commandLine, charset);
        this.consoleView = consoleView;
        this.consoleCommunication = consoleCommunication;
        Disposer.register((Disposable)((Disposable)this.consoleView), () -> RsConsoleProcessHandler._init_$lambda$0(this));
    }

    public void coloredTextAvailable(@NotNull String textOriginal, @NotNull Key<?> attributes) {
        Intrinsics.checkNotNullParameter((Object)textOriginal, (String)"textOriginal");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        String text = this.consoleCommunication.processText(textOriginal);
        this.consoleView.print(text, attributes);
    }

    public boolean isSilentlyDestroyOnClose() {
        return !this.consoleCommunication.isExecuting();
    }

    public boolean shouldKillProcessSoftly() {
        return true;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
        return options;
    }

    private static final void _init_$lambda$0(RsConsoleProcessHandler this$0) {
        if (!this$0.isProcessTerminated()) {
            this$0.destroyProcess();
        }
    }
}

