/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.console;

import com.intellij.execution.ConsoleFolding;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.runconfig.filters.FilterUtils;
import org.rust.cargo.runconfig.filters.RsBacktraceItemFilter;
import org.rust.cargo.runconfig.filters.RsBacktraceLineRegexpFileLinkFilter;
import org.rust.lang.core.resolve.NameResolutionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/console/RsConsoleFolding;", "Lcom/intellij/execution/ConsoleFolding;", "<init>", "()V", "getPlaceholderText", "", "project", "Lcom/intellij/openapi/project/Project;", "lines", "", "shouldFoldLine", "", "line", "shouldBeAttachedToThePreviousLine", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsConsoleFolding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsConsoleFolding.kt\norg/rust/ide/console/RsConsoleFolding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1761#2,3:58\n1761#2,3:61\n*S KotlinDebug\n*F\n+ 1 RsConsoleFolding.kt\norg/rust/ide/console/RsConsoleFolding\n*L\n33#1:58,3\n44#1:61,3\n*E\n"})
public final class RsConsoleFolding
extends ConsoleFolding {
    @Nullable
    public String getPlaceholderText(@NotNull Project project, @NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        if (lines.size() < 2) {
            return null;
        }
        int count = lines.size() / 2;
        String string = StringUtil.pluralize((String)"call", (int)count);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
        String callText = string;
        return "<" + count + " internal " + callText + ">";
    }

    public boolean shouldFoldLine(@NotNull Project project, @NotNull String line) {
        boolean bl;
        block16: {
            boolean functionNameFound;
            CargoProject it2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block15: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                $this$any$iv = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        it2 = (CargoProject)element$iv;
                        boolean bl3 = false;
                        Object object = RsBacktraceItemFilter.Companion.parseBacktraceRecord(line);
                        if (object == null || (object = ((RsBacktraceItemFilter.Companion.BacktraceRecord)object).getFunctionName()) == null) {
                            bl2 = false;
                        } else {
                            Object functionName = object;
                            String func = FilterUtils.INSTANCE.normalizeFunctionPath((String)functionName);
                            if (it2.getWorkspace() == null) {
                                bl2 = false;
                            } else {
                                CargoWorkspace.Package pkg;
                                String pkgName;
                                CargoWorkspace workspace;
                                Pair<String, String> pair = NameResolutionKt.splitAbsolutePath(func);
                                bl2 = pair == null ? true : (CargoWorkspace.findPackageByName$default(workspace, pkgName = (String)pair.component1(), null, 2, null) == null ? true : pkg.getOrigin() != PackageOrigin.WORKSPACE);
                            }
                        }
                        if (!bl2) continue;
                        v0 = true;
                        break block15;
                    }
                    v0 = functionNameFound = false;
                }
            }
            if (functionNameFound) {
                return true;
            }
            $this$any$iv = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    it2 = (CargoProject)element$iv;
                    boolean bl5 = false;
                    VirtualFile virtualFile = it2.getWorkspaceRootDir();
                    if (virtualFile == null && (virtualFile = it2.getRootDir()) == null) {
                        bl4 = false;
                    } else {
                        VirtualFile dir = virtualFile;
                        RsBacktraceLineRegexpFileLinkFilter filter2 = new RsBacktraceLineRegexpFileLinkFilter(project, dir);
                        Object object = filter2.matchLine(line);
                        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
                            bl4 = false;
                        } else {
                            String systemIndependentPath;
                            Object filePath = object;
                            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)filePath), (String)"toSystemIndependentName(...)");
                            bl4 = dir.findFileByRelativePath(systemIndependentPath) == null;
                        }
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldBeAttachedToThePreviousLine() {
        return false;
    }
}

