/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.console.RsConsoleCommunication;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/console/RsConsoleExecuteActionHandler;", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "consoleCommunication", "Lorg/rust/ide/console/RsConsoleCommunication;", "<init>", "(Lcom/intellij/execution/process/ProcessHandler;Lorg/rust/ide/console/RsConsoleCommunication;)V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "processLine", "", "line", "", "runExecuteAction", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "canExecuteNow", "copyToHistoryAndExecute", "Companion", "intellij.rustrover.core"})
public final class RsConsoleExecuteActionHandler
extends ProcessBackedConsoleExecuteActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsConsoleCommunication consoleCommunication;
    private boolean isEnabled;
    @Nls
    @NotNull
    private static final String prevCommandRunningMessage = RsBundle.INSTANCE.message("previous.command.is.still.running.please.wait.or.press.ctrl.c.in.console.to.interrupt", new Object[0]);
    @Nls
    @NotNull
    private static final String consoleIsNotEnabledMessage = RsBundle.INSTANCE.message("console.is.not.enabled", new Object[0]);

    public RsConsoleExecuteActionHandler(@NotNull ProcessHandler processHandler, @NotNull RsConsoleCommunication consoleCommunication) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)consoleCommunication, (String)"consoleCommunication");
        super(processHandler, false);
        this.consoleCommunication = consoleCommunication;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void processLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String lineEscaped = StringsKt.replace$default((String)line, (String)"\n", (String)"\u2028", (boolean)false, (int)4, null);
        super.processLine(lineEscaped);
    }

    public void runExecuteAction(@NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        if (!this.isEnabled) {
            EditorKt.showErrorHint((Editor)console.getConsoleEditor(), consoleIsNotEnabledMessage);
            return;
        }
        if (!this.canExecuteNow()) {
            EditorKt.showErrorHint((Editor)console.getConsoleEditor(), prevCommandRunningMessage);
            return;
        }
        this.consoleCommunication.onExecutionBegin();
        this.copyToHistoryAndExecute(console);
    }

    private final boolean canExecuteNow() {
        return !this.consoleCommunication.isExecuting();
    }

    private final void copyToHistoryAndExecute(LanguageConsoleView console) {
        super.runExecuteAction(console);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/rust/ide/console/RsConsoleExecuteActionHandler$Companion;", "", "<init>", "()V", "prevCommandRunningMessage", "", "getPrevCommandRunningMessage", "()Ljava/lang/String;", "consoleIsNotEnabledMessage", "getConsoleIsNotEnabledMessage", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPrevCommandRunningMessage() {
            return prevCommandRunningMessage;
        }

        @NotNull
        public final String getConsoleIsNotEnabledMessage() {
            return consoleIsNotEnabledMessage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

