/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.console;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.console.RsConsoleOneCommandContext;
import org.rust.ide.console.RsConsoleView;
import org.rust.lang.core.psi.RsReplCodeFragment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/console/RsConsoleCommunication;", "", "consoleView", "Lorg/rust/ide/console/RsConsoleView;", "<init>", "(Lorg/rust/ide/console/RsConsoleView;)V", "value", "", "isExecuting", "()Z", "receivedInitialPrompt", "lastCommandContext", "Lorg/rust/ide/console/RsConsoleOneCommandContext;", "onExecutionBegin", "", "onExecutionEnd", "success", "processText", "", "textOriginal", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsConsoleCommunication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsConsoleCommunication.kt\norg/rust/ide/console/RsConsoleCommunication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class RsConsoleCommunication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsConsoleView consoleView;
    private boolean isExecuting;
    private boolean receivedInitialPrompt;
    @Nullable
    private RsConsoleOneCommandContext lastCommandContext;
    @NotNull
    public static final String SUCCESS_EXECUTION_MARKER = "\u0091";
    @NotNull
    public static final String FAILED_EXECUTION_MARKER = "\u0092";

    public RsConsoleCommunication(@NotNull RsConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        this.consoleView = consoleView;
        this.receivedInitialPrompt = true;
    }

    public final boolean isExecuting() {
        return this.isExecuting;
    }

    public final void onExecutionBegin() {
        if (!(!this.isExecuting)) {
            boolean $i$a$-check-RsConsoleCommunication$onExecutionBegin$22 = false;
            String $i$a$-check-RsConsoleCommunication$onExecutionBegin$22 = "new command must not be executed before previous command finishes";
            throw new IllegalStateException($i$a$-check-RsConsoleCommunication$onExecutionBegin$22.toString());
        }
        this.isExecuting = true;
        RsReplCodeFragment rsReplCodeFragment = this.consoleView.getCodeFragment();
        if (rsReplCodeFragment == null) {
            return;
        }
        RsReplCodeFragment codeFragment = rsReplCodeFragment;
        String string = codeFragment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String codeFragmentText = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)codeFragmentText).length() == 0) {
            return;
        }
        if (StringsKt.startsWith$default((String)codeFragmentText, (String)":", (boolean)false, (int)2, null)) {
            this.consoleView.handleEvcxrCommand(codeFragmentText);
        }
        this.lastCommandContext = new RsConsoleOneCommandContext(codeFragment);
    }

    private final void onExecutionEnd(boolean success) {
        if (!this.receivedInitialPrompt) {
            this.receivedInitialPrompt = true;
            return;
        }
        RsConsoleOneCommandContext lastCommandContext = this.lastCommandContext;
        if (success && lastCommandContext != null) {
            this.consoleView.addToContext(lastCommandContext);
        }
        this.lastCommandContext = null;
        if (!this.isExecuting) {
            throw new IllegalStateException("Check failed.");
        }
        this.isExecuting = false;
    }

    @NotNull
    public final String processText(@NotNull String textOriginal) {
        String string;
        Intrinsics.checkNotNullParameter((Object)textOriginal, (String)"textOriginal");
        String text = StringsKt.replace$default((String)textOriginal, (String)"\r", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)SUCCESS_EXECUTION_MARKER, (boolean)false, (int)2, null)) {
            this.onExecutionEnd(true);
            string = StringsKt.replace$default((String)text, (String)SUCCESS_EXECUTION_MARKER, (String)"", (boolean)false, (int)4, null);
        } else if (StringsKt.contains$default((CharSequence)text, (CharSequence)FAILED_EXECUTION_MARKER, (boolean)false, (int)2, null)) {
            this.onExecutionEnd(false);
            string = StringsKt.replace$default((String)text, (String)FAILED_EXECUTION_MARKER, (String)"", (boolean)false, (int)4, null);
        } else {
            string = Intrinsics.areEqual((Object)text, (Object)">> ") ? "" : text;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/rust/ide/console/RsConsoleCommunication$Companion;", "", "<init>", "()V", "SUCCESS_EXECUTION_MARKER", "", "FAILED_EXECUTION_MARKER", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

