/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator.format;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.annotator.format.ErrorAnnotation;
import org.rust.ide.annotator.format.FormatParameter;
import org.rust.ide.annotator.format.ParameterLookup;
import org.rust.ide.annotator.format.ParameterMatchInfo;
import org.rust.ide.annotator.format.ParseContext;
import org.rust.ide.annotator.format.ParsedParameter;
import org.rust.ide.colors.RsColor;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.parser.RustParserUtil;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFormatArgumentOwner;
import org.rust.lang.core.psi.RsFormatMacroArg;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsMacro;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyArray;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TySlice;
import org.rust.lang.utils.RsEscapesUtilsKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f*\u00020\bH\u0002\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\n\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u0012\u001a\u00020\n\u001a\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0086\u0010\u001a*\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u0010\u0018\u00010!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'\u001a2\u0010(\u001a\u0004\u0018\u00010\"2\u000b\u0010)\u001a\u00070\u0003\u00a2\u0006\u0002\b*2\u0006\u0010$\u001a\u00020%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\u0010H\u0002\u00a2\u0006\u0002\u0010,\u001a\f\u0010-\u001a\u0004\u0018\u00010\u0003*\u00020#\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"formatParser", "Lkotlin/text/Regex;", "ARGUMENT", "", "formatParameterParser", "hasParameters", "", "formatStr", "Lorg/rust/lang/core/psi/RsLitExpr;", "parseParameters", "Lorg/rust/ide/annotator/format/ParseContext;", "getUnescapedTextAndRawMapAndTextRange", "Lkotlin/Triple;", "", "Lcom/intellij/openapi/util/TextRange;", "checkSyntaxErrors", "", "Lorg/rust/ide/annotator/format/ErrorAnnotation;", "ctx", "highlightParametersOutside", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "highlightParametersInside", "buildLookup", "Lorg/rust/ide/annotator/format/ParameterLookup;", "value", "buildParameters", "Lorg/rust/ide/annotator/format/FormatParameter;", "baseType", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "Lorg/rust/lang/core/types/ty/Ty;", "getFormatMacroCtx", "Lkotlin/Pair;", "", "Lorg/rust/lang/core/psi/RsFormatMacroArg;", "call", "Lorg/rust/lang/core/psi/RsMacroCall;", "def", "Lorg/rust/lang/core/psi/RsMacro;", "getPosition", "macroName", "Lcom/intellij/openapi/util/NlsSafe;", "formatMacroArgs", "(Ljava/lang/String;Lorg/rust/lang/core/psi/RsMacroCall;Ljava/util/List;)Ljava/lang/Integer;", "name", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\norg/rust/ide/annotator/format/ImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n1374#2:382\n1460#2,5:383\n*S KotlinDebug\n*F\n+ 1 impl.kt\norg/rust/ide/annotator/format/ImplKt\n*L\n267#1:382\n267#1:383,5\n*E\n"})
public final class ImplKt {
    @NotNull
    private static final Regex formatParser = new Regex("\\{\\{|}}|(\\{([^}]*)}?)|(})");
    @Language(value="Regexp")
    @NotNull
    private static final String ARGUMENT = "( [_\\p{IsAlphabetic}][_\\p{IsAlphabetic}\\d]* | \\d+)";
    @NotNull
    private static final Regex formatParameterParser = new Regex("(?x) # enable comments\n^(?<id>( [_\\p{IsAlphabetic}][_\\p{IsAlphabetic}\\d]* | \\d+))?\n(:\n    (.?[\\^<>])?[+\\-]?\\#?\n    0?(?!\\$) # negative lookahead to parse 0$ as width and 00$ as zero padding followed by width\n    (?<width>( [_\\p{IsAlphabetic}][_\\p{IsAlphabetic}\\d]* | \\d+)\\$|\\d+)?\n    (\\.(?<precision>( [_\\p{IsAlphabetic}][_\\p{IsAlphabetic}\\d]* | \\d+)\\$|\\d+|\\*)?)? # specifying no precision after a dot is allowed\n    (?<type>\\w?\\??)?\n)?\\s*");

    public static final boolean hasParameters(@NotNull RsLitExpr formatStr) {
        Intrinsics.checkNotNullParameter((Object)formatStr, (String)"formatStr");
        Object object = ImplKt.getUnescapedTextAndRawMapAndTextRange(formatStr);
        if (object == null || (object = (String)object.getFirst()) == null) {
            return false;
        }
        Object unescapedText = object;
        return formatParser.containsMatchIn((CharSequence)unescapedText);
    }

    @Nullable
    public static final ParseContext parseParameters(@NotNull RsLitExpr formatStr) {
        Intrinsics.checkNotNullParameter((Object)formatStr, (String)"formatStr");
        Triple<String, int[], TextRange> triple = ImplKt.getUnescapedTextAndRawMapAndTextRange(formatStr);
        if (triple == null) {
            return null;
        }
        Triple<String, int[], TextRange> triple2 = triple;
        String unescapedText = (String)triple2.component1();
        int[] sourceMap = (int[])triple2.component2();
        TextRange rawTextRange = (TextRange)triple2.component3();
        Sequence arguments = Regex.findAll$default((Regex)formatParser, (CharSequence)unescapedText, (int)0, (int)2, null);
        List parsed = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)arguments, ImplKt::parseParameters$lambda$0));
        return new ParseContext(sourceMap, PsiElementKt.getStartOffset(formatStr) + rawTextRange.getStartOffset(), parsed);
    }

    private static final Triple<String, int[], TextRange> getUnescapedTextAndRawMapAndTextRange(RsLitExpr $this$getUnescapedTextAndRawMapAndTextRange) {
        Triple triple;
        RsLiteralKind rsLiteralKind = RsLiteralKindKt.getKind($this$getUnescapedTextAndRawMapAndTextRange);
        RsLiteralKind.String string = rsLiteralKind instanceof RsLiteralKind.String ? (RsLiteralKind.String)rsLiteralKind : null;
        if (string == null) {
            return null;
        }
        RsLiteralKind.String literalKind = string;
        if (RsTokenTypeKt.getRS_BYTE_STRING_LITERALS().contains(literalKind.getNode().getElementType())) {
            return null;
        }
        if (RsTokenTypeKt.getRS_CSTRING_LITERALS().contains(literalKind.getNode().getElementType())) {
            return null;
        }
        TextRange textRange = literalKind.getOffsets().getValue();
        if (textRange == null) {
            return null;
        }
        TextRange rawTextRange = textRange;
        String string2 = literalKind.getRawValue();
        if (string2 == null) {
            return null;
        }
        String text = string2;
        if (Intrinsics.areEqual((Object)literalKind.getNode().getElementType(), (Object)RsElementTypes.RAW_STRING_LITERAL)) {
            int[] map2 = CollectionsKt.toIntArray((Collection)CollectionsKt.toList((Iterable)((Iterable)StringsKt.getIndices((CharSequence)text))));
            triple = new Triple((Object)text, (Object)map2, (Object)rawTextRange);
        } else {
            Triple<StringBuilder, int[], Boolean> triple2 = RsEscapesUtilsKt.parseRustStringCharacters(text);
            StringBuilder parsedText = (StringBuilder)triple2.component1();
            int[] map3 = (int[])triple2.component2();
            triple = new Triple((Object)parsedText.toString(), (Object)map3, (Object)rawTextRange);
        }
        return triple;
    }

    @NotNull
    public static final List<ErrorAnnotation> checkSyntaxErrors(@NotNull ParseContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List errors = new ArrayList();
        for (ParsedParameter parameter : ctx.getParameters()) {
            MatchResult completeMatch = parameter.getCompleteMatch();
            TextRange range = ParseContext.toSourceRange$default(ctx, parameter.getRange(), 0, 2, null);
            if (completeMatch.getGroups().get(3) != null) {
                errors.add(new ErrorAnnotation(range, RsBundle.INSTANCE.message("inspection.message.invalid.format.string.unmatched", new Object[0]), false, null, null, null, 60, null));
            }
            if (parameter.getInnerContent() == null || parameter.getInnerContentMatch() == null) continue;
            MatchGroup innerContent = parameter.getInnerContent();
            MatchGroup content = completeMatch.getGroups().get(1);
            if (content != null && !StringsKt.endsWith$default((String)content.getValue(), (String)"}", (boolean)false, (int)2, null)) {
                int possibleEnd = parameter.getInnerContentMatch().getValue().length() - 1;
                errors.add(new ErrorAnnotation(ctx.toSourceRange(new IntRange(possibleEnd, possibleEnd), innerContent.getRange().getFirst()), RsBundle.INSTANCE.message("inspection.message.invalid.format.string.expected.if.you.intended.to.print.symbol.you.can.escape.it.using", new Object[0]), false, null, null, RsBundle.INSTANCE.message("inline.inspection.message.invalid.format.string.expected", new Object[0]), 28, null));
                continue;
            }
            int validParsedEnd = parameter.getInnerContentMatch().getRange().getLast() + 1;
            if (validParsedEnd == innerContent.getValue().length()) continue;
            errors.add(new ErrorAnnotation(ctx.toSourceRange(RangesKt.until((int)validParsedEnd, (int)innerContent.getValue().length()), innerContent.getRange().getFirst()), RsBundle.INSTANCE.message("inspection.message.invalid.format.string", new Object[0]), false, null, null, null, 60, null));
        }
        return errors;
    }

    public static final void highlightParametersOutside(@NotNull ParseContext ctx, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RsColor key = RsColor.FORMAT_PARAMETER;
        HighlightSeverity highlightSeverity = UtilsKt.isUnitTestMode() ? key.getTestSeverity() : HighlightSeverity.INFORMATION;
        for (ParsedParameter parameter : ctx.getParameters()) {
            holder.newSilentAnnotation(highlightSeverity).range(ParseContext.toSourceRange$default(ctx, parameter.getRange(), 0, 2, null)).textAttributes(key.getTextAttributesKey()).create();
        }
    }

    public static final void highlightParametersInside(@NotNull ParseContext ctx, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        for (ParsedParameter parameter : ctx.getParameters()) {
            MatchResult it2;
            MatchResult match2 = parameter.getInnerContentMatch();
            if (match2 == null) continue;
            boolean bl = false;
            MatchGroup matchGroup2 = parameter.getInnerContent();
            if (matchGroup2 == null || (matchGroup2 = matchGroup2.getRange()) == null) {
                continue;
            }
            int offset = matchGroup2.getFirst();
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it2.getGroups(), (String)"id");
            ImplKt.highlightParametersInside$highlight$default(holder, ctx, (IntRange)(matchGroup3 != null ? matchGroup3.getRange() : null), offset, null, 16, null);
            MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it2.getGroups(), (String)"width");
            ImplKt.highlightParametersInside$highlight$default(holder, ctx, (IntRange)(matchGroup4 != null ? matchGroup4.getRange() : null), offset, null, 16, null);
            MatchGroup matchGroup5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it2.getGroups(), (String)"precision");
            ImplKt.highlightParametersInside$highlight$default(holder, ctx, (IntRange)(matchGroup5 != null ? matchGroup5.getRange() : null), offset, null, 16, null);
            MatchGroup matchGroup6 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it2.getGroups(), (String)"type");
            ImplKt.highlightParametersInside$highlight(holder, ctx, (IntRange)(matchGroup6 != null ? matchGroup6.getRange() : null), offset, RsColor.FUNCTION);
        }
    }

    private static final ParameterLookup buildLookup(String value) {
        Integer identifier = StringsKt.toIntOrNull((String)value);
        return identifier == null ? (ParameterLookup)new ParameterLookup.Named(value) : (ParameterLookup)new ParameterLookup.Positional(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FormatParameter> buildParameters(@NotNull ParseContext ctx) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object[] objectArray = new String[]{"{{", "}}"};
        Set ignored = SetsKt.setOf((Object[])objectArray);
        int implicitPositionCounter = 0;
        Iterable $this$flatMap$iv = ctx.getParameters();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            ParsedParameter param = (ParsedParameter)element$iv$iv;
            boolean bl = false;
            List parameters = new ArrayList();
            MatchGroup matchGroup2 = param.getInnerContent();
            if (matchGroup2 == null || (matchGroup2 = matchGroup2.getRange()) == null) {
                iterable2 = parameters;
            } else {
                MatchGroup innerRange = matchGroup2;
                if (param.getInnerContentMatch() == null) {
                    iterable2 = parameters;
                } else {
                    MatchResult match2;
                    MatchGroup id = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"id");
                    MatchGroup type = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"type");
                    MatchGroup precision = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"precision");
                    boolean isPrecisionAsterisk = precision != null && Intrinsics.areEqual((Object)precision.getValue(), (Object)"*");
                    boolean isPrecisionValueFirst = false;
                    if (ignored.contains(match2.getValue())) {
                        iterable2 = parameters;
                    } else {
                        FormatParameter formatParameter;
                        MatchGroup typeRange;
                        MatchGroup matchGroup3;
                        Object typeStr;
                        Object object = type;
                        if (object == null || (object = object.getValue()) == null) {
                            object = typeStr = "";
                        }
                        if ((matchGroup3 = type) == null || (matchGroup3 = matchGroup3.getRange()) == null) {
                            matchGroup3 = typeRange = new IntRange(0, 0);
                        }
                        if (id != null) {
                            matchInfo = new ParameterMatchInfo(ctx.toSourceRange(id.getRange(), innerRange.getFirst()), param.getCompleteMatch().getValue());
                            isPrecisionValueFirst = true;
                            formatParameter = new FormatParameter.Value(matchInfo, ImplKt.buildLookup(id.getValue()), param, (String)typeStr, ctx.toSourceRange((IntRange)typeRange, innerRange.getFirst()));
                        } else {
                            matchInfo = new ParameterMatchInfo(ParseContext.toSourceRange$default(ctx, param.getRange(), 0, 2, null), param.getCompleteMatch().getValue());
                            if (isPrecisionAsterisk) {
                                int n = implicitPositionCounter;
                                implicitPositionCounter = n + 1;
                                formatParameter = new FormatParameter.Specifier(matchInfo, (ParameterLookup)new ParameterLookup.Positional(n), param, "precision");
                            } else {
                                int n = implicitPositionCounter;
                                implicitPositionCounter = n + 1;
                                formatParameter = new FormatParameter.Value(matchInfo, new ParameterLookup.Positional(n), param, (String)typeStr, ctx.toSourceRange((IntRange)typeRange, innerRange.getFirst()));
                            }
                        }
                        FormatParameter mainParameter = formatParameter;
                        parameters.add(mainParameter);
                        String[] stringArray = new String[]{"width", "precision"};
                        List specifiers = CollectionsKt.listOf((Object[])stringArray);
                        for (String specifier : specifiers) {
                            MatchGroup group2;
                            String text;
                            if (RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)specifier) == null || !StringsKt.endsWith$default((String)(text = group2.getValue()), (String)"$", (boolean)false, (int)2, null)) continue;
                            char[] cArray = new char[]{'$'};
                            parameters.add(new FormatParameter.Specifier(new ParameterMatchInfo(ctx.toSourceRange(group2.getRange(), innerRange.getFirst()), text), ImplKt.buildLookup(StringsKt.trimEnd((String)text, (char[])cArray)), param, specifier));
                        }
                        if (isPrecisionAsterisk) {
                            if (isPrecisionValueFirst) {
                                MatchGroup matchGroup4 = precision;
                                Intrinsics.checkNotNull((Object)matchGroup4);
                                int n = implicitPositionCounter;
                                implicitPositionCounter = n + 1;
                                v6 = parameters.add(new FormatParameter.Specifier(new ParameterMatchInfo(ctx.toSourceRange(matchGroup4.getRange(), innerRange.getFirst()), precision.getValue()), (ParameterLookup)new ParameterLookup.Positional(n), param, "precision"));
                            } else {
                                ParameterMatchInfo matchInfo = new ParameterMatchInfo(ParseContext.toSourceRange$default(ctx, param.getRange(), 0, 2, null), param.getCompleteMatch().getValue());
                                int n = implicitPositionCounter;
                                implicitPositionCounter = n + 1;
                                v6 = parameters.add(new FormatParameter.Value(matchInfo, new ParameterLookup.Positional(n), param, (String)typeStr, ctx.toSourceRange((IntRange)typeRange, innerRange.getFirst())));
                            }
                        }
                        iterable2 = parameters;
                    }
                }
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final RsStructOrEnumItemElement baseType(@NotNull Ty $this$baseType) {
        RsStructOrEnumItemElement rsStructOrEnumItemElement;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$baseType, (String)"<this>");
            while (true) {
                Ty ty2;
                if ((ty2 = $this$baseType) instanceof TyAdt) {
                    rsStructOrEnumItemElement = ((TyAdt)$this$baseType).getItem();
                    break block4;
                }
                if (ty2 instanceof TyRef) {
                    $this$baseType = ((TyRef)$this$baseType).getReferenced();
                    continue;
                }
                if (ty2 instanceof TyArray) {
                    $this$baseType = ((TyArray)$this$baseType).getBase();
                    continue;
                }
                if (!(ty2 instanceof TySlice)) break;
                $this$baseType = ((TySlice)$this$baseType).getElementType();
            }
            rsStructOrEnumItemElement = null;
        }
        return rsStructOrEnumItemElement;
    }

    @Nullable
    public static final Pair<Integer, List<RsFormatMacroArg>> getFormatMacroCtx(@NotNull RsMacroCall call2, @NotNull RsMacro def) {
        List<RsFormatMacroArg> formatMacroArgs;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        String string = def.getName();
        if (string == null) {
            return null;
        }
        String macroName = string;
        Crate crate = def.getContainingCrate();
        RsElement rsElement = RsMacroCallKt.getMacroArgumentElement(call2);
        RsFormatArgumentOwner rsFormatArgumentOwner = rsElement instanceof RsFormatArgumentOwner ? (RsFormatArgumentOwner)rsElement : null;
        List<RsFormatMacroArg> list = formatMacroArgs = rsFormatArgumentOwner != null ? rsFormatArgumentOwner.getFormatMacroArgList() : null;
        if (crate.getOrigin() != PackageOrigin.STDLIB || formatMacroArgs == null) {
            return null;
        }
        Integer n = ImplKt.getPosition(macroName, call2, formatMacroArgs);
        if (n == null) {
            return null;
        }
        int position = n;
        return new Pair((Object)position, formatMacroArgs);
    }

    private static final Integer getPosition(String macroName, RsMacroCall call2, List<? extends RsFormatMacroArg> formatMacroArgs) {
        Integer n;
        String string = macroName;
        if (ArraysKt.contains((Object[])RustParserUtil.INSTANCE.getASSERT_MACROS_NAMES(), (Object)string)) {
            n = 0;
        } else if (ArraysKt.contains((Object[])RustParserUtil.INSTANCE.getASSERT_EQ_MACROS_NAMES(), (Object)string)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)string, (Object)"println") || Intrinsics.areEqual((Object)string, (Object)"print") || Intrinsics.areEqual((Object)string, (Object)"eprintln") || Intrinsics.areEqual((Object)string, (Object)"eprint") || Intrinsics.areEqual((Object)string, (Object)"format") || Intrinsics.areEqual((Object)string, (Object)"format_args") || Intrinsics.areEqual((Object)string, (Object)"format_args_nl")) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)string, (Object)"panic")) {
            CargoWorkspace.Edition edition = call2.getContainingCrate().getEdition();
            n = formatMacroArgs.size() < 2 && edition.compareTo((Enum)CargoWorkspace.Edition.EDITION_2021) < 0 ? null : Integer.valueOf(0);
        } else {
            n = Intrinsics.areEqual((Object)string, (Object)"write") || Intrinsics.areEqual((Object)string, (Object)"writeln") ? Integer.valueOf(1) : null;
        }
        return n;
    }

    @Nullable
    public static final String name(@NotNull RsFormatMacroArg $this$name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        if ($this$name.getEq() != null) {
            ASTNode aSTNode = $this$name.getNode().findChildByType(RsTokenTypeKt.getRS_IDENTIFIER_TOKENS());
            string = aSTNode != null ? aSTNode.getText() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final ParsedParameter parseParameters$lambda$0(MatchResult arg) {
        ParsedParameter parsedParameter;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        if (arg.getGroups().get(1) != null) {
            MatchGroup matchGroup2 = arg.getGroups().get(2);
            if (matchGroup2 == null) {
                throw new IllegalStateException(" should not be null because can match empty string".toString());
            }
            MatchGroup innerContent = matchGroup2;
            MatchResult matchResult = Regex.find$default((Regex)formatParameterParser, (CharSequence)innerContent.getValue(), (int)0, (int)2, null);
            if (matchResult == null) {
                throw new IllegalStateException(" should be not null because can match empty string".toString());
            }
            MatchResult innerContentMatch = matchResult;
            parsedParameter = new ParsedParameter(arg, innerContentMatch);
        } else {
            parsedParameter = new ParsedParameter(arg, null, 2, null);
        }
        return parsedParameter;
    }

    private static final void highlightParametersInside$highlight(AnnotationHolder $holder, ParseContext $ctx, IntRange range, int offset, RsColor color) {
        if (range != null && !range.isEmpty()) {
            HighlightSeverity highlightSeverity = UtilsKt.isUnitTestMode() ? color.getTestSeverity() : HighlightSeverity.INFORMATION;
            $holder.newSilentAnnotation(highlightSeverity).range($ctx.toSourceRange(range, offset)).textAttributes(color.getTextAttributesKey()).create();
        }
    }

    static /* synthetic */ void highlightParametersInside$highlight$default(AnnotationHolder annotationHolder, ParseContext parseContext, IntRange intRange, int n, RsColor rsColor, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            rsColor = RsColor.FORMAT_SPECIFIER;
        }
        ImplKt.highlightParametersInside$highlight(annotationHolder, parseContext, intRange, n, rsColor);
    }
}

