/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator.external;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.toolchain.impl.Applicability;
import org.rust.cargo.toolchain.impl.CargoTopMessage;
import org.rust.cargo.toolchain.impl.ErrorCode;
import org.rust.cargo.toolchain.impl.RustcMessage;
import org.rust.cargo.toolchain.impl.RustcSpan;
import org.rust.ide.annotator.external.RsExternalLinterFilteredMessage;
import org.rust.ide.annotator.external.RsExternalLinterPass;
import org.rust.ide.annotator.external.RsExternalLinterResult;
import org.rust.ide.annotator.external.RsExternalLinterUtilsKt;
import org.rust.ide.fixes.ApplySuggestionFix;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsSuppressQuickFix;
import org.rust.ide.presentation.TypeMismatchKt;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.utils.RsProblemGroup;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0010\u001a\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0010H\u0002\u001a\n\u0010\u0016\u001a\u00020\u000b*\u00020\u0017\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0010*\u0004\u0018\u00010\u001bH\u0002\u001a\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012*\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a,\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\u0010H\u0002\u001a\u0010\u0010$\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002\u001a\u001a\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0010H\u0002\"\u0015\u0010\f\u001a\u00020\u000b*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"addHighlightsForFileTo", "", "Lorg/rust/ide/annotator/external/RsExternalLinterResult;", "result", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "file", "Lorg/rust/lang/core/psi/RsFile;", "minApplicability", "Lorg/rust/cargo/toolchain/impl/Applicability;", "removeDuplicationsFromInspections", "", "isFromExternalLinter", "Lcom/intellij/lang/annotation/ProblemGroup;", "(Lcom/intellij/lang/annotation/ProblemGroup;)Z", "RUST_EXTERNAL_LINTER_ID", "", "convertHighlightsForFile", "", "Lcom/intellij/psi/PsiFile;", "escapeHtmlPreservingUrls", "escapeUrl", "isValid", "Lorg/rust/cargo/toolchain/impl/RustcSpan;", "ERROR_REGEX", "Lkotlin/text/Regex;", "formatAsLink", "Lorg/rust/cargo/toolchain/impl/ErrorCode;", "collectQuickFixes", "Lorg/rust/ide/fixes/ApplySuggestionFix;", "Lorg/rust/cargo/toolchain/impl/RustcMessage;", "document", "Lcom/intellij/openapi/editor/Document;", "createQuickFix", "span", "message", "formatMessage", "parseTypeMismatchHint", "project", "Lcom/intellij/openapi/project/Project;", "hint", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExternalLinterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExternalLinterUtils.kt\norg/rust/ide/annotator/external/RsExternalLinterUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,583:1\n1617#2,9:584\n1869#2:593\n1870#2:595\n1626#2:596\n774#2:597\n865#2,2:598\n1869#2,2:600\n1803#2,3:604\n774#2:607\n865#2,2:608\n1869#2,2:610\n1#3:594\n1#3:602\n19#4:603\n*S KotlinDebug\n*F\n+ 1 RsExternalLinterUtils.kt\norg/rust/ide/annotator/external/RsExternalLinterUtilsKt\n*L\n175#1:584,9\n175#1:593\n175#1:595\n175#1:596\n218#1:597\n218#1:598,2\n239#1:600,2\n506#1:604,3\n468#1:607\n468#1:608,2\n476#1:610,2\n175#1:594\n259#1:603\n*E\n"})
public final class RsExternalLinterUtilsKt {
    @NotNull
    private static final String RUST_EXTERNAL_LINTER_ID = "RsExternalLinterOptions";
    @NotNull
    private static final Regex ERROR_REGEX = new Regex("E\\d{4}");

    /*
     * WARNING - void declaration
     */
    public static final void addHighlightsForFileTo(@NotNull RsExternalLinterResult $this$addHighlightsForFileTo, @NotNull List<HighlightInfo> result2, @NotNull RsFile file, @NotNull Applicability minApplicability, boolean removeDuplicationsFromInspections) {
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addHighlightsForFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)minApplicability), (String)"minApplicability");
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            throw new IllegalStateException(("Can't find document for " + file + " in external linter").toString());
        }
        Document doc = document;
        Iterable iterable = $this$addHighlightsForFileTo.getMessages();
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RsExternalLinterFilteredMessage it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CargoTopMessage topMessage = (CargoTopMessage)element$iv$iv;
            boolean bl2 = false;
            if (RsExternalLinterFilteredMessage.Companion.filterMessage(file, doc, topMessage) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filteredMessages = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)doc, (Project)file.getProject(), (boolean)false);
        MarkupModelEx markup = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
        for (RsExternalLinterFilteredMessage message : filteredMessages) {
            HighlightInfo p0;
            RsProblemGroup rsProblemGroup;
            Object object;
            HighlightInfo.Builder highlightBuilder;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            boolean bl;
            Boolean isError;
            HighlightSeverity $i$f$mapNotNullTo2 = message.getSeverity();
            Boolean bl4 = Intrinsics.areEqual((Object)$i$f$mapNotNullTo2, (Object)HighlightSeverity.ERROR) ? Boolean.valueOf(true) : (isError = Intrinsics.areEqual((Object)$i$f$mapNotNullTo2, (Object)HighlightSeverity.WEAK_WARNING) ? Boolean.valueOf(false) : null);
            if (removeDuplicationsFromInspections && isError != null) {
                Ref.BooleanRef isDuplicate = new Ref.BooleanRef();
                int start2 = message.getTextRange().getStartOffset();
                int end = message.getTextRange().getEndOffset();
                MarkupModelEx markupModelEx = markup;
                if (markupModelEx != null) {
                    markupModelEx.processRangeHighlightersOverlappingWith(start2, end, arg_0 -> RsExternalLinterUtilsKt.addHighlightsForFileTo$lambda$2(arg_0 -> RsExternalLinterUtilsKt.addHighlightsForFileTo$lambda$1(isError, start2, end, isDuplicate, arg_0), arg_0));
                }
                bl = isDuplicate.element;
            } else {
                bl = false;
            }
            boolean isDuplicate = bl;
            Iterable start2 = message.getQuickFixes();
            boolean $i$f$filter = false;
            element$iv$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ApplySuggestionFix it2 = (ApplySuggestionFix)((Object)element$iv$iv);
                boolean bl5 = false;
                if (!(it2.getApplicability().compareTo((Enum)minApplicability) <= 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List applicableQFs = (List)destination$iv$iv2;
            if (isDuplicate && applicableQFs.isEmpty()) continue;
            HighlightInfoType type = !isDuplicate ? message.getHighlightInfoType() : HighlightInfoType.INFORMATION;
            RsProblemGroup problemGroup = RsProblemGroup.Companion.createFromExternalLinter(message.getMessage(), message.getSecondarySpots(), isDuplicate, message.getErrorCode());
            HighlightInfo.Builder $i$f$filterTo22 = HighlightInfo.newHighlightInfo((HighlightInfoType)type).severity(UtilsKt.isUnitTestMode() && isDuplicate ? HighlightSeverity.INFORMATION : message.getSeverity());
            HighlightInfo.Builder $this$addHighlightsForFileTo_u24lambda_u244 = $i$f$filterTo22;
            boolean bl6 = false;
            if (!isDuplicate) {
                $this$addHighlightsForFileTo_u24lambda_u244.description(UtilsKt.isUnitTestMode() ? "RsExternalLint" : message.getMessage());
                $this$addHighlightsForFileTo_u24lambda_u244.escapedToolTip(message.getHtmlTooltip());
            }
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo22.range(message.getTextRange()).problemGroup((ProblemGroup)problemGroup), (String)"problemGroup(...)");
            Iterable $this$forEach$iv = applicableQFs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                HighlightDisplayKey key;
                ApplySuggestionFix fix = (ApplySuggestionFix)((Object)element$iv);
                boolean bl7 = false;
                PsiElement psiElement2 = fix.getStartElement();
                if (psiElement2 == null) {
                    psiElement2 = fix.getEndElement();
                }
                PsiElement element = psiElement2;
                RsLint.ExternalLinterLint lint = message.getLint();
                RsSuppressQuickFix[] actions = element != null && lint != null ? RsSuppressQuickFix.Companion.createSuppressFixes(element, lint) : new RsSuppressQuickFix[]{};
                SuppressIntentionAction[] suppressIntentionActionArray = SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions((SuppressQuickFix[])((SuppressQuickFix[])actions));
                Intrinsics.checkNotNullExpressionValue((Object)suppressIntentionActionArray, (String)"convertBatchToSuppressIntentionActions(...)");
                List options = ArraysKt.toList((Object[])suppressIntentionActionArray);
                String displayName = RsBundle.INSTANCE.message("rust.external.linter", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)HighlightDisplayKey.findOrRegister((String)RUST_EXTERNAL_LINTER_ID, (String)displayName), (String)"findOrRegister(...)");
                highlightBuilder.registerFix((IntentionAction)fix, options, displayName, null, key);
            }
            RsProblemGroup it3 = object = problemGroup;
            boolean bl8 = false;
            RsProblemGroup rsProblemGroup2 = rsProblemGroup = !isDuplicate ? object : null;
            if (rsProblemGroup != null && (object = rsProblemGroup.createExplainFix(file)) != null) {
                Object it4 = object;
                boolean bl9 = false;
                highlightBuilder.registerFix((IntentionAction)it4, null, null, null, null);
            }
            if (highlightBuilder.create() == null) continue;
            boolean bl10 = false;
            result2.add(p0);
        }
    }

    public static /* synthetic */ void addHighlightsForFileTo$default(RsExternalLinterResult rsExternalLinterResult, List list, RsFile rsFile, Applicability applicability, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        RsExternalLinterUtilsKt.addHighlightsForFileTo(rsExternalLinterResult, list, rsFile, applicability, bl);
    }

    public static final boolean isFromExternalLinter(@NotNull ProblemGroup $this$isFromExternalLinter) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromExternalLinter, (String)"<this>");
        ProblemGroup $this$asSafely$iv = $this$isFromExternalLinter;
        boolean $i$f$asSafely = false;
        ProblemGroup problemGroup = $this$asSafely$iv;
        if (!(problemGroup instanceof RsProblemGroup)) {
            problemGroup = null;
        }
        RsProblemGroup rsProblemGroup = (RsProblemGroup)problemGroup;
        return rsProblemGroup != null ? rsProblemGroup.isFromExternalLinter() : false;
    }

    @NotNull
    public static final List<HighlightInfo> convertHighlightsForFile(@NotNull RsExternalLinterResult $this$convertHighlightsForFile, @NotNull PsiFile file) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$convertHighlightsForFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof RsFile) || !((RsFile)file).isValid()) {
            return CollectionsKt.emptyList();
        }
        try {
            List highlights2 = new ArrayList();
            RsExternalLinterUtilsKt.addHighlightsForFileTo($this$convertHighlightsForFile, highlights2, (RsFile)file, Applicability.UNSPECIFIED, true);
        }
        catch (Throwable t) {
            if (t instanceof ProcessCanceledException) {
                throw t;
            }
            RsExternalLinterPass.Companion.getLOG().error(t);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final String escapeHtmlPreservingUrls(@NotNull String $this$escapeHtmlPreservingUrls) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeHtmlPreservingUrls, (String)"<this>");
        int lastEnd = 0;
        TextRange range = URLUtil.findUrl((CharSequence)$this$escapeHtmlPreservingUrls, (int)0, (int)$this$escapeHtmlPreservingUrls.length());
        List result2 = new ArrayList();
        while (range != null && !range.isEmpty()) {
            String string = $this$escapeHtmlPreservingUrls.substring(lastEnd, range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = StringEscapeUtils.escapeHtml4((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeHtml4(...)");
            result2.add(string2);
            String string3 = $this$escapeHtmlPreservingUrls.substring(range.getStartOffset(), range.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            result2.add(RsExternalLinterUtilsKt.escapeUrl(string3));
            lastEnd = range.getEndOffset();
            range = URLUtil.findUrl((CharSequence)$this$escapeHtmlPreservingUrls, (int)range.getEndOffset(), (int)$this$escapeHtmlPreservingUrls.length());
        }
        if (lastEnd < $this$escapeHtmlPreservingUrls.length()) {
            String string = $this$escapeHtmlPreservingUrls.substring(lastEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string4 = StringEscapeUtils.escapeHtml4((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"escapeHtml4(...)");
            result2.add(string4);
        }
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String escapeUrl(String $this$escapeUrl) {
        return "<a href='" + $this$escapeUrl + "'>" + $this$escapeUrl + "</a>";
    }

    public static final boolean isValid(@NotNull RustcSpan $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        return $this$isValid.getLine_end() > $this$isValid.getLine_start() || $this$isValid.getLine_end() == $this$isValid.getLine_start() && $this$isValid.getColumn_end() >= $this$isValid.getColumn_start();
    }

    private static final String formatAsLink(ErrorCode $this$formatAsLink) {
        CharSequence charSequence;
        Object object = $this$formatAsLink;
        if (!(object != null && (object = ((ErrorCode)object).getCode()) != null ? ERROR_REGEX.matches(charSequence = (CharSequence)object) : false)) {
            return null;
        }
        return "<a href=\"https://doc.rust-lang.org/error-index.html#" + $this$formatAsLink.getCode() + "\">" + $this$formatAsLink.getCode() + "</a>";
    }

    private static final List<ApplySuggestionFix> collectQuickFixes(RustcMessage $this$collectQuickFixes, RsFile file, Document document) {
        List quickFixes = new ArrayList();
        RsExternalLinterUtilsKt.collectQuickFixes$go(file, document, quickFixes, $this$collectQuickFixes);
        return quickFixes;
    }

    private static final ApplySuggestionFix createQuickFix(RsFile file, Document document, RustcSpan span, String message) {
        RustcSpan rustcSpan = span;
        if ((rustcSpan != null ? rustcSpan.getSuggested_replacement() : null) == null || span.getSuggestion_applicability() == null) {
            return null;
        }
        String string = span.getFile_name();
        if (string == null) {
            return null;
        }
        String spanFileName = string;
        CargoProject cargoProject = file.getCargoProject();
        if (cargoProject == null || (cargoProject = cargoProject.getRootDir()) == null || (cargoProject = VirtualFileUtil.findFileOrDirectory((VirtualFile)cargoProject, (String)spanFileName)) == null || (cargoProject = UtilsKt.getDocument((VirtualFile)cargoProject)) == null) {
            return null;
        }
        CargoProject actualDocument = cargoProject;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile psiFile = UtilsKt.toPsiFile((Document)actualDocument, project);
        if (psiFile == null) {
            return null;
        }
        PsiFile actualFile = psiFile;
        SmartPsiFileRange smartPsiFileRange = span.toRangePointer(actualFile, (Document)actualDocument);
        if (smartPsiFileRange == null) {
            return null;
        }
        SmartPsiFileRange rangePointer = smartPsiFileRange;
        Segment segment = rangePointer.getRange();
        if (segment == null) {
            return null;
        }
        Segment range = segment;
        PsiElement psiElement2 = actualFile.findElementAt(range.getEndOffset() - 1);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement endElement = psiElement2;
        PsiElement psiElement3 = actualFile.findElementAt(range.getStartOffset());
        if (psiElement3 == null) {
            psiElement3 = endElement;
        }
        PsiElement startElement = psiElement3;
        return new ApplySuggestionFix(message, span.getSuggested_replacement(), span.getSuggestion_applicability(), startElement, endElement, rangePointer);
    }

    /*
     * WARNING - void declaration
     */
    private static final String formatMessage(String message) {
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007H\u00c6\u0003J2\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"org/rust/ide/annotator/external/RsExternalLinterUtilsKt$formatMessage$Group", "", "isList", "", "lines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "<init>", "(ZLjava/util/ArrayList;)V", "()Z", "getLines", "()Ljava/util/ArrayList;", "component1", "component2", "copy", "(ZLjava/util/ArrayList;)Lorg/rust/ide/annotator/external/RsExternalLinterUtilsKt$formatMessage$Group;", "equals", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
        public final class Group {
            private final boolean isList;
            private final ArrayList<String> lines;

            public Group(boolean isList, ArrayList<String> lines) {
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                this.isList = isList;
                this.lines = lines;
            }

            public final boolean isList() {
                return this.isList;
            }

            public final ArrayList<String> getLines() {
                return this.lines;
            }

            public final boolean component1() {
                return this.isList;
            }

            public final ArrayList<String> component2() {
                return this.lines;
            }

            public final Group copy(boolean isList, ArrayList<String> lines) {
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                return new Group(isList, lines);
            }

            public static /* synthetic */ Group copy$default(Group group2, boolean bl, ArrayList arrayList, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = group2.isList;
                }
                if ((n & 2) != 0) {
                    arrayList = group2.lines;
                }
                return group2.copy(bl, arrayList);
            }

            public String toString() {
                return "Group(isList=" + this.isList + ", lines=" + this.lines + ")";
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.isList);
                result2 = result2 * 31 + this.lines.hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Group)) {
                    return false;
                }
                Group group2 = (Group)other;
                if (this.isList != group2.isList) {
                    return false;
                }
                return Intrinsics.areEqual(this.lines, group2.lines);
            }
        }
        void $this$fold$iv;
        Object object = new String[]{"\n"};
        object = StringsKt.split$default((CharSequence)message, (String[])object, (boolean)false, (int)0, (int)6, null);
        Pair initial$iv = new Pair(null, new ArrayList());
        boolean $i$f$fold = false;
        Pair accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Pair pair;
            Pair pair2;
            void lineWithPrefix;
            String string = (String)element$iv;
            Pair pair3 = accumulator$iv;
            boolean bl = false;
            Group group2 = (Group)pair3.component1();
            ArrayList acc = (ArrayList)pair3.component2();
            if (StringsKt.startsWith$default((String)lineWithPrefix, (String)"-", (boolean)false, (int)2, null)) {
                Boolean bl2 = true;
                String string2 = lineWithPrefix.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                pair2 = TuplesKt.to((Object)bl2, (Object)string2);
            } else {
                pair2 = TuplesKt.to((Object)false, (Object)lineWithPrefix);
            }
            Pair pair4 = pair2;
            boolean isListItem = (Boolean)pair4.component1();
            String line = (String)pair4.component2();
            if (group2 == null) {
                var16_15 = new String[]{line};
                pair = new Pair((Object)new Group(isListItem, CollectionsKt.arrayListOf((Object[])var16_15)), (Object)acc);
            } else if (group2.isList() == isListItem) {
                group2.getLines().add(line);
                pair = new Pair((Object)group2, (Object)acc);
            } else {
                acc.add(group2);
                var16_15 = new String[]{line};
                pair = new Pair((Object)new Group(isListItem, CollectionsKt.arrayListOf((Object[])var16_15)), (Object)acc);
            }
            accumulator$iv = pair;
        }
        Pair pair = accumulator$iv;
        Group lastGroup = (Group)pair.component1();
        ArrayList groups = (ArrayList)pair.component2();
        if (lastGroup != null && !((Collection)lastGroup.getLines()).isEmpty()) {
            groups.add(lastGroup);
        }
        return CollectionsKt.joinToString$default((Iterable)groups, null, null, null, (int)0, null, RsExternalLinterUtilsKt::formatMessage$lambda$1, (int)31, null);
    }

    private static final String parseTypeMismatchHint(Project project, String hint2) {
        if (!StringsKt.startsWith$default((String)hint2, (String)"expected", (boolean)false, (int)2, null)) {
            return null;
        }
        Ref.IntRef position = new Ref.IntRef();
        position.element = 8;
        RsExternalLinterUtilsKt.parseTypeMismatchHint$skipWhitespaces(position, hint2);
        String string = RsExternalLinterUtilsKt.parseTypeMismatchHint$parseType(hint2, position);
        if (string == null) {
            return null;
        }
        String expectedType = string;
        RsExternalLinterUtilsKt.parseTypeMismatchHint$skipWhitespaces(position, hint2);
        if (StringsKt.startsWith$default((String)hint2, (String)", found", (int)position.element, (boolean)false, (int)4, null)) {
            position.element += 7;
        } else if (StringsKt.startsWith$default((String)hint2, (String)"found", (int)position.element, (boolean)false, (int)4, null)) {
            position.element += 5;
        } else {
            return null;
        }
        RsExternalLinterUtilsKt.parseTypeMismatchHint$skipWhitespaces(position, hint2);
        String string2 = RsExternalLinterUtilsKt.parseTypeMismatchHint$parseType(hint2, position);
        if (string2 == null) {
            return null;
        }
        String foundType = string2;
        return TypeMismatchKt.unwrapAndLogTypeMismatchViewResult(TypeMismatchKt.buildTypeMismatchReport(project, expectedType, foundType), project, RsCounterUsagesCollector.TypeTextPresentationSource.ExternalLinter);
    }

    private static final boolean addHighlightsForFileTo$lambda$1(Boolean $isError, int $start, int $end, Ref.BooleanRef $isDuplicate, RangeHighlighterEx highlighter) {
        boolean bl;
        boolean isMatchingHighlight;
        HighlightInfo highlightInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)((RangeHighlighter)highlighter));
        if (highlightInfo == null) {
            return true;
        }
        HighlightInfo highlight = highlightInfo;
        ProblemGroup problemGroup = highlight.getProblemGroup();
        boolean bl2 = problemGroup != null ? RsExternalLinterUtilsKt.isFromExternalLinter(problemGroup) : false;
        if (bl2) {
            return true;
        }
        boolean bl3 = $isError != false ? Intrinsics.areEqual((Object)highlight.getSeverity(), (Object)HighlightSeverity.ERROR) : (isMatchingHighlight = highlight.getInspectionToolId() != null && (Intrinsics.areEqual((Object)highlight.getSeverity(), (Object)HighlightSeverity.WARNING) || Intrinsics.areEqual((Object)highlight.getSeverity(), (Object)HighlightSeverity.WEAK_WARNING)) && highlighter.getStartOffset() <= $start && $end <= highlighter.getEndOffset());
        if (isMatchingHighlight) {
            $isDuplicate.element = true;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean addHighlightsForFileTo$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectQuickFixes$go(RsFile $file, Document $document, List<ApplySuggestionFix> quickFixes, RustcMessage message) {
        void $this$filterTo$iv$iv;
        Object $this$filter$iv = message.getSpans();
        int $i$f$filter = 0;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RustcSpan it2 = (RustcSpan)element$iv$iv;
            boolean bl = false;
            if (!(it2.is_primary() && RsExternalLinterUtilsKt.isValid(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List spans = (List)destination$iv$iv;
        if (spans.size() > 1) {
            $this$filter$iv = ((Iterable)spans).iterator();
            $i$f$filter = 0;
            while ($this$filter$iv.hasNext()) {
                ApplySuggestionFix it3;
                int i2 = $i$f$filter++;
                RustcSpan span = (RustcSpan)$this$filter$iv.next();
                if (RsExternalLinterUtilsKt.createQuickFix($file, $document, span, message.getMessage() + " (" + (i2 + 1) + ")") == null) continue;
                boolean bl = false;
                quickFixes.add(it3);
            }
        } else {
            ApplySuggestionFix applySuggestionFix = RsExternalLinterUtilsKt.createQuickFix($file, $document, (RustcSpan)CollectionsKt.firstOrNull((List)spans), message.getMessage());
            if (applySuggestionFix != null) {
                ApplySuggestionFix it4 = applySuggestionFix;
                boolean bl = false;
                quickFixes.add(it4);
            }
        }
        Iterable $this$forEach$iv = message.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RustcMessage p0 = (RustcMessage)element$iv;
            boolean bl = false;
            RsExternalLinterUtilsKt.collectQuickFixes$go($file, $document, quickFixes, p0);
        }
    }

    private static final CharSequence formatMessage$lambda$1(formatMessage.Group it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.isList() ? (CharSequence)("<ul>" + CollectionsKt.joinToString$default((Iterable)it2.getLines(), (CharSequence)"<li>", (CharSequence)"<li>", null, (int)0, null, null, (int)60, null) + "</ul>") : (CharSequence)CollectionsKt.joinToString$default((Iterable)it2.getLines(), (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null);
    }

    private static final void parseTypeMismatchHint$skipWhitespaces(Ref.IntRef position, String $hint) {
        while (position.element < $hint.length() && CharsKt.isWhitespace((char)$hint.charAt(position.element))) {
            int n = position.element;
            position.element = n + 1;
        }
    }

    private static final String parseTypeMismatchHint$parseType(String $hint, Ref.IntRef position) {
        int backtick = StringsKt.indexOf$default((CharSequence)$hint, (char)'`', (int)position.element, (boolean)false, (int)4, null);
        if (backtick != -1) {
            position.element = backtick + 1;
            int end = StringsKt.indexOf$default((CharSequence)$hint, (char)'`', (int)position.element, (boolean)false, (int)4, null);
            if (end == -1) {
                return null;
            }
            String string = $hint.substring(position.element, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String type = string;
            position.element = end + 1;
            return type;
        }
        if (StringsKt.startsWith$default((String)$hint, (String)"integer", (int)position.element, (boolean)false, (int)4, null)) {
            position.element += 7;
            return "{integer}";
        }
        if (StringsKt.startsWith$default((String)$hint, (String)"float", (int)position.element, (boolean)false, (int)4, null)) {
            position.element += 5;
            return "{float}";
        }
        return null;
    }

    public static final /* synthetic */ List access$collectQuickFixes(RustcMessage $receiver, RsFile file, Document document) {
        return RsExternalLinterUtilsKt.collectQuickFixes($receiver, file, document);
    }

    public static final /* synthetic */ String access$formatMessage(String message) {
        return RsExternalLinterUtilsKt.formatMessage(message);
    }

    public static final /* synthetic */ String access$formatAsLink(ErrorCode $receiver) {
        return RsExternalLinterUtilsKt.formatAsLink($receiver);
    }

    public static final /* synthetic */ String access$parseTypeMismatchHint(Project project, String hint2) {
        return RsExternalLinterUtilsKt.parseTypeMismatchHint(project, hint2);
    }
}

