/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator.external;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.CargoCheckArgs;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.ide.annotator.external.DocumentToHighlight;
import org.rust.ide.annotator.external.RsExternalLinterResult;
import org.rust.ide.annotator.external.RsExternalLinterService;
import org.rust.ide.statistics.ExternalLinterUsageCollector;
import org.rust.ide.status.RsExternalLinterWidget;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0007J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/rust/ide/annotator/external/RsExternalLinterUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TEST_MESSAGE", "", "saveDocumentsAndCheck", "Lorg/rust/ide/annotator/external/RsExternalLinterResult;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "Ljava/nio/file/Path;", "args", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs;", "isOnTheFly", "", "check", "setHighlightersToEditorInEdt", "", "documentToHighlight", "Lorg/rust/ide/annotator/external/DocumentToHighlight;", "highlights", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "isDirty", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExternalLinterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExternalLinterUtils.kt\norg/rust/ide/annotator/external/RsExternalLinterUtils\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,583:1\n60#2,4:584\n13#3:588\n*S KotlinDebug\n*F\n+ 1 RsExternalLinterUtils.kt\norg/rust/ide/annotator/external/RsExternalLinterUtils\n*L\n133#1:584,4\n70#1:588\n*E\n"})
public final class RsExternalLinterUtils {
    @NotNull
    public static final RsExternalLinterUtils INSTANCE = new RsExternalLinterUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String TEST_MESSAGE = "RsExternalLint";

    private RsExternalLinterUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RsExternalLinterResult saveDocumentsAndCheck(@NotNull RsToolchainBase toolchain2, @NotNull Project project, @NotNull Path workingDirectory, @NotNull CargoCheckArgs args, boolean isOnTheFly) {
        RsExternalLinterResult rsExternalLinterResult;
        RsExternalLinterWidget widget;
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ExternalLinterUsageCollector.RunMarker statsLogger = new ExternalLinterUsageCollector.RunMarker(project, args.getLinter(), args);
        RsExternalLinterWidget rsExternalLinterWidget = widget = (RsExternalLinterWidget)((Object)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> RsExternalLinterUtils.saveDocumentsAndCheck$lambda$0(statsLogger, project), (int)1, null));
        if (rsExternalLinterWidget != null) {
            rsExternalLinterWidget.setInProgress(true);
        }
        try {
            rsExternalLinterResult = (RsExternalLinterResult)statsLogger.measureAndReportCheck(() -> RsExternalLinterUtils.saveDocumentsAndCheck$lambda$1(toolchain2, project, workingDirectory, args, isOnTheFly));
        }
        finally {
            RsExternalLinterWidget rsExternalLinterWidget2 = widget;
            if (rsExternalLinterWidget2 != null) {
                rsExternalLinterWidget2.setInProgress(false);
            }
        }
        return rsExternalLinterResult;
    }

    /*
     * WARNING - void declaration
     */
    private final RsExternalLinterResult check(RsToolchainBase toolchain2, Project project, Path workingDirectory, CargoCheckArgs args, boolean isOnTheFly) {
        void $this$unwrapOrElse$iv;
        ProgressManager.checkCanceled();
        RsResult<RsExternalLinterResult, RsProcessExecutionException.Start> rsResult = CargoKt.cargoOrWrapper(toolchain2, workingDirectory).checkProject(project, args, isOnTheFly);
        boolean $i$f$unwrapOrElse = false;
        void var8_8 = $this$unwrapOrElse$iv;
        if (!(var8_8 instanceof RsResult.Ok)) {
            if (var8_8 instanceof RsResult.Err) {
                RsProcessExecutionException.Start e = (RsProcessExecutionException.Start)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                LOG.error((Throwable)e);
                return null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return (RsExternalLinterResult)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
    }

    @RequiresEdt
    public final void setHighlightersToEditorInEdt(@NotNull Project project, @NotNull DocumentToHighlight documentToHighlight, @NotNull List<? extends HighlightInfo> highlights2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)documentToHighlight, (String)"documentToHighlight");
        Intrinsics.checkNotNullParameter(highlights2, (String)"highlights");
        UpdateHighlightersUtil.setHighlightersToEditor((Project)project, (Document)documentToHighlight.getDocument(), (int)documentToHighlight.getTextRange().getStartOffset(), (int)documentToHighlight.getTextRange().getEndOffset(), (Collection)highlights2, (EditorColorsScheme)documentToHighlight.getColorsScheme(), (int)documentToHighlight.getPassId());
        DaemonCodeAnalyzerEx.getInstanceEx((Project)project).getFileStatusMap().markFileUpToDate(documentToHighlight.getDocument(), documentToHighlight.getPassId());
        ErrorStripeUpdateManager.Companion.getInstance(project).launchRepaintErrorStripePanel(documentToHighlight.getEditor(), documentToHighlight.getFile());
    }

    public final boolean isDirty(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        return RsExternalLinterService.Companion.getInstance(project2).isToBeProcessed(editor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RsExternalLinterWidget saveDocumentsAndCheck$lambda$0(ExternalLinterUsageCollector.RunMarker $statsLogger, Project $project) {
        RsExternalLinterWidget rsExternalLinterWidget;
        int oldAutoReparseDelay = DaemonCodeAnalyzerSettings.getInstance().getAutoReparseDelay();
        DaemonCodeAnalyzerSettings.getInstance().setAutoReparseDelay(1);
        try {
            rsExternalLinterWidget = (RsExternalLinterWidget)((Object)ActionsKt.runWriteAction(() -> RsExternalLinterUtils.saveDocumentsAndCheck$lambda$0$0($statsLogger, $project)));
        }
        finally {
            DaemonCodeAnalyzerSettings.getInstance().setAutoReparseDelay(oldAutoReparseDelay);
        }
        return rsExternalLinterWidget;
    }

    private static final RsExternalLinterWidget saveDocumentsAndCheck$lambda$0$0(ExternalLinterUsageCollector.RunMarker $statsLogger, Project $project) {
        StatusBar statusBar;
        $statsLogger.measureAndReportSave(FileDocumentManager.getInstance().getUnsavedDocuments().length, RsExternalLinterUtils::saveDocumentsAndCheck$lambda$0$0$0);
        StatusBar statusBar2 = statusBar = WindowManager.getInstance().getStatusBar($project);
        StatusBarWidget statusBarWidget = statusBar2 != null ? statusBar2.getWidget("rustExternalLinterWidget") : null;
        return statusBarWidget instanceof RsExternalLinterWidget ? (RsExternalLinterWidget)statusBarWidget : null;
    }

    private static final Unit saveDocumentsAndCheck$lambda$0$0$0() {
        UtilsKt.saveAllDocuments(true);
        return Unit.INSTANCE;
    }

    private static final RsExternalLinterResult saveDocumentsAndCheck$lambda$1(RsToolchainBase $toolchain, Project $project, Path $workingDirectory, CargoCheckArgs $args, boolean $isOnTheFly) {
        return INSTANCE.check($toolchain, $project, $workingDirectory, $args, $isOnTheFly);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsExternalLinterUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

