/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator.external;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.CargoCheckArgs;
import org.rust.ide.annotator.external.DocumentToHighlight;
import org.rust.ide.annotator.external.RsExternalLinterService;
import org.rust.ide.annotator.external.RsExternalLinterUtils;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/annotator/external/RsExternalLinterPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "textRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "isHighlightingScheduled", "", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "getDocumentToHighlight", "Lorg/rust/ide/annotator/external/DocumentToHighlight;", "isAnnotationPassEnabled", "()Z", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExternalLinterPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExternalLinterPass.kt\norg/rust/ide/annotator/external/RsExternalLinterPass\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,106:1\n13#2:107\n*S KotlinDebug\n*F\n+ 1 RsExternalLinterPass.kt\norg/rust/ide/annotator/external/RsExternalLinterPass\n*L\n84#1:107\n*E\n"})
public final class RsExternalLinterPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Editor editor;
    private final TextRange textRange;
    private boolean isHighlightingScheduled;
    @NotNull
    private static final Logger LOG;

    public RsExternalLinterPass(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super(file.getProject(), editor2.getDocument());
        this.file = file;
        this.editor = editor2;
        this.textRange = this.file.getTextRange();
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        if (!(this.file instanceof RsFile) || !this.isAnnotationPassEnabled()) {
            return;
        }
        CargoWorkspace.Target target = RsElementKt.getContainingCargoTarget((PsiElement)this.file);
        if (target == null) {
            return;
        }
        CargoWorkspace.Target cargoTarget = target;
        if (cargoTarget.getPkg().getOrigin() != PackageOrigin.WORKSPACE) {
            return;
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        RsExternalLinterService rsExternalLinterService = RsExternalLinterService.Companion.getInstance(project);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project2);
        if (rsToolchainBase == null) {
            return;
        }
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        rsExternalLinterService.checkAndHighlightFile(rsToolchainBase, CargoCheckArgs.Companion.forTarget(project3, cargoTarget), this.getDocumentToHighlight());
        this.isHighlightingScheduled = true;
    }

    @RequiresEdt
    public void doApplyInformationToEditor() {
        if (!this.isHighlightingScheduled) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            RsExternalLinterUtils.INSTANCE.setHighlightersToEditorInEdt(project, this.getDocumentToHighlight(), CollectionsKt.emptyList());
        } else if (UtilsKt.isUnitTestMode()) {
            long start2 = System.currentTimeMillis();
            while (FileStatusMap.getDirtyTextRange((Document)this.editor.getDocument(), (PsiFile)this.file, (int)this.getId()) != null) {
                Thread.sleep(10L);
                UIUtil.dispatchAllInvocationEvents();
                if (System.currentTimeMillis() - start2 <= 60000L) continue;
                break;
            }
        }
    }

    private final DocumentToHighlight getDocumentToHighlight() {
        long l = this.getDocument().getModificationStamp();
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        TextRange textRange = this.textRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRange");
        return new DocumentToHighlight(l, this.editor, document, this.file, textRange, this.getColorsScheme(), this.getId());
    }

    private final boolean isAnnotationPassEnabled() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings(project).getRunOnTheFly();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsExternalLinterPass.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/annotator/external/RsExternalLinterPass$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

