/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.colors.RsColor;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsForeignModItem;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsConstantKind;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsMethodCallKt;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.TyRawPtr;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0018\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/rust/ide/annotator/RsUnsafeExpressionAnnotator;", "Lorg/rust/ide/annotator/AnnotatorBase;", "<init>", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateUnsafeCall", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "annotateUnsafeStaticRef", "Lorg/rust/lang/core/psi/RsPathExpr;", "Lorg/rust/lang/core/psi/RsConstant;", "checkDotExpr", "o", "Lorg/rust/lang/core/psi/ext/RsDotExpr;", "checkCall", "Lorg/rust/lang/core/psi/RsCallExpr;", "checkPathExpr", "checkUnary", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "createUnsafeAnnotation", "textRange", "Lcom/intellij/openapi/util/TextRange;", "message", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsUnsafeExpressionAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnsafeExpressionAnnotator.kt\norg/rust/ide/annotator/RsUnsafeExpressionAnnotator\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,111:1\n19#2:112\n*S KotlinDebug\n*F\n+ 1 RsUnsafeExpressionAnnotator.kt\norg/rust/ide/annotator/RsUnsafeExpressionAnnotator\n*L\n68#1:112\n*E\n"})
public final class RsUnsafeExpressionAnnotator
extends AnnotatorBase {
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RsVisitor visitor2 = new RsVisitor(this, holder){
            final /* synthetic */ RsUnsafeExpressionAnnotator this$0;
            final /* synthetic */ AnnotationHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCallExpr(RsCallExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeExpressionAnnotator.access$checkCall(this.this$0, o, this.$holder);
            }

            public void visitFieldLookupExpr(RsFieldLookupExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeExpressionAnnotator.access$checkDotExpr(this.this$0, o, this.$holder);
            }

            public void visitMethodCallExpr(RsMethodCallExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeExpressionAnnotator.access$checkDotExpr(this.this$0, o, this.$holder);
            }

            public void visitPathExpr(RsPathExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeExpressionAnnotator.access$checkPathExpr(this.this$0, o, this.$holder);
            }

            public void visitUnaryExpr(RsUnaryExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeExpressionAnnotator.access$checkUnary(this.this$0, o, this.$holder);
            }
        };
        element.accept((PsiElementVisitor)visitor2);
    }

    private final void annotateUnsafeCall(RsExpr expr, AnnotationHolder holder) {
        if (!CfgUtilsKt.getExistsAfterExpansion(expr)) {
            return;
        }
        if (RsExprKt.isInUnsafeContext(expr)) {
            TextRange textRange;
            RsExpr rsExpr = expr;
            if (rsExpr instanceof RsCallExpr) {
                RsExpr rsExpr2 = ((RsCallExpr)expr).getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"getExpr(...)");
                RsExpr callee = rsExpr2;
                if (callee instanceof RsPathExpr) {
                    RsPath rsPath = ((RsPathExpr)callee).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"getPath(...)");
                    textRange = RsPathKt.getTextRangeOfLastSegment(rsPath);
                    if (textRange == null) {
                        return;
                    }
                } else {
                    textRange = callee.getTextRange();
                }
            } else if (rsExpr instanceof RsMethodCallExpr) {
                RsMethodCall rsMethodCall = ((RsMethodCallExpr)expr).getMethodCall();
                Intrinsics.checkNotNullExpressionValue((Object)rsMethodCall, (String)"getMethodCall(...)");
                textRange = RsMethodCallKt.getTextRangeWithoutValueArguments(rsMethodCall);
            } else {
                return;
            }
            TextRange textRange2 = textRange;
            Intrinsics.checkNotNull((Object)textRange2);
            this.createUnsafeAnnotation(holder, textRange2, RsBundle.INSTANCE.message("inspection.message.call.to.unsafe.function", new Object[0]));
        }
    }

    private final void annotateUnsafeStaticRef(RsPathExpr expr, RsConstant element, AnnotationHolder holder) {
        String string;
        if (RsConstantKt.getKind(element) == RsConstantKind.MUT_STATIC) {
            string = RsBundle.INSTANCE.message("inspection.message.mutable", new Object[0]);
        } else if (RsConstantKt.getKind(element) == RsConstantKind.STATIC && element.getContext() instanceof RsForeignModItem) {
            string = RsBundle.INSTANCE.message("inspection.message.extern", new Object[0]);
        } else {
            return;
        }
        String constantType = string;
        if (RsExprKt.isInUnsafeContext(expr)) {
            RsPath rsPath = expr.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"getPath(...)");
            TextRange textRange = RsPathKt.getTextRangeOfLastSegment(rsPath);
            if (textRange == null) {
                return;
            }
            TextRange textRange2 = textRange;
            Object[] objectArray = new Object[]{constantType};
            this.createUnsafeAnnotation(holder, textRange2, RsBundle.INSTANCE.message("inspection.message.use.unsafe.static", objectArray));
        }
    }

    private final void checkDotExpr(RsDotExpr o, AnnotationHolder holder) {
        block3: {
            RsElement rsElement;
            RsDotExpr $this$asSafely$iv = o;
            boolean $i$f$asSafely = false;
            RsDotExpr rsDotExpr = $this$asSafely$iv;
            if (!(rsDotExpr instanceof RsMethodCallExpr)) {
                rsDotExpr = null;
            }
            if ((rsElement = (RsMethodCallExpr)rsDotExpr) == null || (rsElement = rsElement.getMethodCall()) == null) break block3;
            RsElement it2 = rsElement;
            boolean bl = false;
            RsElement rsElement2 = it2.getReference().resolve();
            RsFunction rsFunction = rsElement2 instanceof RsFunction ? (RsFunction)rsElement2 : null;
            if (rsFunction == null) {
                return;
            }
            RsFunction fn = rsFunction;
            if (RsFunctionKt.getUnsafetyStatus(fn).isActuallyUnsafe(o)) {
                this.annotateUnsafeCall(o, holder);
            }
        }
    }

    private final void checkCall(RsCallExpr element, AnnotationHolder holder) {
        RsExpr rsExpr = element.getExpr();
        StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
        if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
            return;
        }
        StubBasedPsiElement<RsPlaceholderStub<?>> path = stubBasedPsiElement;
        RsPathReference rsPathReference = path.getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
        if (rsFunction == null) {
            return;
        }
        RsFunction fn = rsFunction;
        if (RsFunctionKt.getUnsafetyStatus(fn).isActuallyUnsafe(element)) {
            this.annotateUnsafeCall(element, holder);
        }
    }

    private final void checkPathExpr(RsPathExpr expr, AnnotationHolder holder) {
        RsPathReference rsPathReference = expr.getPath().getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsConstant rsConstant = rsElement instanceof RsConstant ? (RsConstant)rsElement : null;
        if (rsConstant == null) {
            return;
        }
        RsConstant constant = rsConstant;
        this.annotateUnsafeStaticRef(expr, constant, holder);
    }

    private final void checkUnary(RsUnaryExpr element, AnnotationHolder holder) {
        PsiElement psiElement2 = element.getMul();
        if (psiElement2 == null) {
            return;
        }
        PsiElement mul = psiElement2;
        RsExpr rsExpr = element.getExpr();
        if (!((rsExpr != null ? ExtensionsKt.getType(rsExpr) : null) instanceof TyRawPtr)) {
            return;
        }
        if (RsExprKt.isInUnsafeContext(element)) {
            TextRange textRange = mul.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            this.createUnsafeAnnotation(holder, textRange, RsBundle.INSTANCE.message("inspection.message.unsafe.dereference.raw.pointer", new Object[0]));
        }
    }

    private final void createUnsafeAnnotation(AnnotationHolder $this$createUnsafeAnnotation, TextRange textRange, @InspectionMessage String message) {
        if ($this$createUnsafeAnnotation.isBatchMode()) {
            return;
        }
        RsColor color = RsColor.UNSAFE_CODE;
        HighlightSeverity severity = UtilsKt.isUnitTestMode() ? color.getTestSeverity() : HighlightInfoType.SYMBOL_TYPE_SEVERITY;
        $this$createUnsafeAnnotation.newAnnotation(severity, message).range(textRange).textAttributes(color.getTextAttributesKey()).create();
    }

    public static final /* synthetic */ void access$checkCall(RsUnsafeExpressionAnnotator $this, RsCallExpr element, AnnotationHolder holder) {
        $this.checkCall(element, holder);
    }

    public static final /* synthetic */ void access$checkDotExpr(RsUnsafeExpressionAnnotator $this, RsDotExpr o, AnnotationHolder holder) {
        $this.checkDotExpr(o, holder);
    }

    public static final /* synthetic */ void access$checkPathExpr(RsUnsafeExpressionAnnotator $this, RsPathExpr expr, AnnotationHolder holder) {
        $this.checkPathExpr(expr, holder);
    }

    public static final /* synthetic */ void access$checkUnary(RsUnsafeExpressionAnnotator $this, RsUnaryExpr element, AnnotationHolder holder) {
        $this.checkUnary(element, holder);
    }
}

