/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.ExtensionsKt;
import org.rust.lang.core.mir.MirNotBuiltReason;
import org.rust.lang.core.mir.borrowck.MoveCause;
import org.rust.lang.core.mir.dataflow.move.MoveData;
import org.rust.lang.core.mir.dataflow.move.MoveError;
import org.rust.lang.core.mir.dataflow.move.MoveOut;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.psi.RsFieldLookup;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsMacroBodyIdent;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;
import org.rust.lang.core.psi.ext.RsInferenceContextOwnerKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002\" \u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"=\u0010\n\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001 \r*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"moveOuts", "", "Lcom/intellij/psi/PsiElement;", "Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "getMoveOuts", "(Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;)Ljava/util/Set;", "calculateMoveOuts", "shouldShowMoveFrom", "", "element", "MOVE_OUTS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "MOVE_HIGHLIGHTING", "Lcom/intellij/lang/annotation/HighlightSeverity;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMoveAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMoveAnnotator.kt\norg/rust/ide/annotator/RsMoveAnnotatorKt\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n*L\n1#1,110:1\n60#2,4:111\n*S KotlinDebug\n*F\n+ 1 RsMoveAnnotator.kt\norg/rust/ide/annotator/RsMoveAnnotatorKt\n*L\n66#1:111,4\n*E\n"})
public final class RsMoveAnnotatorKt {
    @NotNull
    private static final Key<CachedValue<Set<PsiElement>>> MOVE_OUTS_KEY;
    @NotNull
    private static final HighlightSeverity MOVE_HIGHLIGHTING;

    private static final Set<PsiElement> getMoveOuts(RsInferenceContextOwner $this$moveOuts) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)$this$moveOuts, MOVE_OUTS_KEY, () -> RsMoveAnnotatorKt._get_moveOuts_$lambda$0($this$moveOuts));
    }

    private static final Set<PsiElement> calculateMoveOuts(RsInferenceContextOwner $this$calculateMoveOuts) {
        try {
            RsInferenceContextOwner owner = $this$calculateMoveOuts;
            RsResult<List<MirBody>, MirNotBuiltReason> $this$unwrapOrElse$iv = ExtensionsKt.getMirBodiesForBorrowChecker(owner);
            boolean $i$f$unwrapOrElse = false;
            RsResult<List<MirBody>, MirNotBuiltReason> rsResult = $this$unwrapOrElse$iv;
            if (!(rsResult instanceof RsResult.Ok)) {
                if (rsResult instanceof RsResult.Err) {
                    MirNotBuiltReason it2 = (MirNotBuiltReason)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                    boolean bl = false;
                    return null;
                }
                throw new NoWhenBranchMatchedException();
            }
            List mirBodies = (List)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
            Set moves = new LinkedHashSet();
            for (MirBody mir : mirBodies) {
                Pair pair;
                RsResult<MoveData, Pair<MoveData, List<Pair<MirPlace, MoveError>>>> moveDat = MoveData.Companion.gatherMoves(mir);
                if (moveDat instanceof RsResult.Ok) {
                    pair = TuplesKt.to(((RsResult.Ok)moveDat).getOk(), (Object)CollectionsKt.emptyList());
                } else if (moveDat instanceof RsResult.Err) {
                    pair = TuplesKt.to((Object)((Pair)((RsResult.Err)moveDat).getErr()).getFirst(), (Object)((Pair)((RsResult.Err)moveDat).getErr()).getSecond());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                MoveData moveData = (MoveData)pair.component1();
                Iterator<Map.Entry<MirLocation, List<MoveOut>>> iterator2 = moveData.getLocMap().entrySet().iterator();
                while (iterator2.hasNext()) {
                    List<MoveOut> moveOuts = iterator2.next().getValue();
                    for (MoveOut moveOut : moveOuts) {
                        MoveCause.Move<PsiElement> move;
                        PsiElement movePsi;
                        if (MoveCause.Move.Companion.create(mir, moveOut) == null || !RsMoveAnnotatorKt.shouldShowMoveFrom(movePsi = move.getElementExpandedFrom())) continue;
                        CollectionsKt.addAll((Collection)moves, (Sequence)PsiTreeUtilKt.childLeafs$default((PsiElement)movePsi, (boolean)false, (int)1, null));
                    }
                }
            }
            return moves;
        }
        catch (NotImplementedError notImplementedError) {
            return null;
        }
    }

    private static final boolean shouldShowMoveFrom(PsiElement element) {
        boolean bl;
        if (element instanceof RsPathExpr) {
            bl = true;
        } else if (element instanceof RsFieldLookupExpr) {
            RsFieldLookup rsFieldLookup = ((RsFieldLookupExpr)element).getFieldLookup();
            Intrinsics.checkNotNullExpressionValue((Object)rsFieldLookup, (String)"getFieldLookup(...)");
            RsFieldLookup fieldLookup = rsFieldLookup;
            PsiElement psiElement2 = fieldLookup.getIdentifier();
            bl = !Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)"await") || !RsElementKt.isAtLeastEdition2018(fieldLookup);
        } else {
            bl = element.getParent() instanceof RsMacroBodyIdent;
        }
        return bl;
    }

    private static final CachedValueProvider.Result _get_moveOuts_$lambda$0(RsInferenceContextOwner $this_moveOuts) {
        return RsInferenceContextOwnerKt.createCachedResult($this_moveOuts, RsMoveAnnotatorKt.calculateMoveOuts($this_moveOuts));
    }

    public static final /* synthetic */ Set access$getMoveOuts(RsInferenceContextOwner $receiver) {
        return RsMoveAnnotatorKt.getMoveOuts($receiver);
    }

    public static final /* synthetic */ HighlightSeverity access$getMOVE_HIGHLIGHTING$p() {
        return MOVE_HIGHLIGHTING;
    }

    static {
        Key key = Key.create((String)"org.rust.ide.annotator.MOVE_OUTS_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MOVE_OUTS_KEY = key;
        MOVE_HIGHLIGHTING = new HighlightSeverity("MOVE_HIGHLIGHTING", HighlightSeverity.INFORMATION.myVal + 1);
    }
}

