/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.annotator.RsMacroExpansionHighlightingPass;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionMode;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/annotator/RsMacroExpansionHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/DirtyScopeTrackingHighlightingPassFactory;", "project", "Lcom/intellij/openapi/project/Project;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myPassId", "", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPassId", "Companion", "intellij.rustrover.core"})
public final class RsMacroExpansionHighlightingPassFactory
implements DirtyScopeTrackingHighlightingPassFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final int myPassId;
    @NotNull
    private static final RegistryValue MACRO_HIGHLIGHTING_ENABLED_KEY = Registry.Companion.get("org.rust.lang.highlight.macro.body");

    public RsMacroExpansionHighlightingPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.project = project;
        this.myPassId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!(MacroExpansionManagerKt.getMacroExpansionManager(this.project).getMacroExpansionMode() instanceof MacroExpansionMode.New)) {
            return null;
        }
        if (!MACRO_HIGHLIGHTING_ENABLED_KEY.asBoolean()) {
            return null;
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange((Document)editor2.getDocument(), (PsiFile)file, (int)this.getPassId());
        if (textRange == null) {
            return null;
        }
        TextRange restrictedRange = textRange;
        if (!(file instanceof RsFile) || !Intrinsics.areEqual((Object)((RsFile)file).getLanguage(), (Object)((Object)RsLanguage.INSTANCE))) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return new RsMacroExpansionHighlightingPass(file, restrictedRange, document);
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lorg/rust/ide/annotator/RsMacroExpansionHighlightingPassFactory$Companion;", "", "<init>", "()V", "MACRO_HIGHLIGHTING_ENABLED_KEY", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getMACRO_HIGHLIGHTING_ENABLED_KEY$annotations", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getMACRO_HIGHLIGHTING_ENABLED_KEY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

