/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationSessionImpl;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.annotator.AnnotationSessionExKt;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.annotator.RsAttrHighlightingAnnotator;
import org.rust.ide.annotator.RsCfgDisabledCodeAnnotator;
import org.rust.ide.annotator.RsEdition2018KeywordsAnnotator;
import org.rust.ide.annotator.RsHighlightingMutableAnnotator;
import org.rust.ide.annotator.RsMacroExpansionHighlightingPassKt;
import org.rust.ide.annotator.RsUnsafeExpressionAnnotator;
import org.rust.ide.annotator.format.RsFormatMacroAnnotator;
import org.rust.ide.colors.RsColor;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.statistics.IntentionPlace;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateKt;
import org.rust.lang.core.macros.MacroCallPreparedForHighlighting;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.MacroHighlightingUtilKt;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.AttrCache;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsAttrProcMacroOwner;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J8\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J8\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J4\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u0010%\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/rust/ide/annotator/RsMacroExpansionHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "restrictedRange", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/editor/Document;)V", "createAnnotators", "Lorg/rust/ide/annotator/RsMacroExpansionHighlightingPass$Annotators;", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "mapAndCollectAnnotation", "macro", "Lorg/rust/lang/core/macros/MacroCallPreparedForHighlighting;", "ann", "Lcom/intellij/lang/annotation/Annotation;", "results", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "mapAndCollectHighlightInfo", "originInfo", "originRange", "withQuickFixes", "", "mapAndEmit", "mappedRange", "highlightCfgDisabledRanges", "crate", "Lorg/rust/lang/core/crate/Crate;", "cfgDisabledElements", "", "Lcom/intellij/psi/PsiElement;", "doApplyInformationToEditor", "Annotators", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMacroExpansionHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMacroExpansionHighlightingPass.kt\norg/rust/ide/annotator/RsMacroExpansionHighlightingPass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1460#2,5:281\n774#2:286\n865#2:287\n1761#2,3:288\n866#2:291\n*S KotlinDebug\n*F\n+ 1 RsMacroExpansionHighlightingPass.kt\norg/rust/ide/annotator/RsMacroExpansionHighlightingPass\n*L\n223#1:281,5\n225#1:286\n225#1:287\n228#1:288,3\n225#1:291\n*E\n"})
public final class RsMacroExpansionHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange restrictedRange;

    public RsMacroExpansionHighlightingPass(@NotNull PsiFile file, @NotNull TextRange restrictedRange, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)restrictedRange, (String)"restrictedRange");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(file.getProject(), document);
        this.file = file;
        this.restrictedRange = restrictedRange;
    }

    private final Annotators createAnnotators() {
        Object[] objectArray = new AnnotatorBase[]{new RsEdition2018KeywordsAnnotator(), new RsAttrHighlightingAnnotator(), new RsHighlightingMutableAnnotator(), new RsFormatMacroAnnotator()};
        List highlightingAnnotators = CollectionsKt.listOf((Object[])objectArray);
        List allAnnotators = CollectionsKt.plus((Collection)highlightingAnnotators, (Iterable)CollectionsKt.listOf((Object)new RsUnsafeExpressionAnnotator()));
        List annotatorsForDeclMacros = Registry.Companion.is("org.rust.lang.highlight.error.decl.macro.body") ? allAnnotators : highlightingAnnotators;
        return new Annotators(annotatorsForDeclMacros, allAnnotators);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        List results = new ArrayList();
        List macros = new ArrayList();
        PsiTreeUtil.processElements((PsiElement)((PsiElement)this.file), (PsiElementProcessor)new PsiElementProcessor(this, macros){
            final /* synthetic */ RsMacroExpansionHighlightingPass this$0;
            final /* synthetic */ List<MacroCallPreparedForHighlighting> $macros;
            {
                this.this$0 = $receiver;
                this.$macros = $macros;
            }

            public final boolean execute(PsiElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (it2 instanceof RsAttrProcMacroOwner) {
                    TextRange textRange = ((RsAttrProcMacroOwner)it2).getTextRange();
                    if (!(textRange != null ? textRange.intersects(RsMacroExpansionHighlightingPass.access$getRestrictedRange$p(this.this$0)) : false)) {
                        return true;
                    }
                    Collection collection = this.$macros;
                    MacroCallPreparedForHighlighting macroCallPreparedForHighlighting = MacroHighlightingUtilKt.prepareForExpansionHighlighting$default((RsAttrProcMacroOwner)it2, null, 1, null);
                    if (macroCallPreparedForHighlighting == null) {
                        return true;
                    }
                    collection.add(macroCallPreparedForHighlighting);
                }
                return true;
            }
        });
        if (!((Collection)macros).isEmpty()) {
            PsiFile psiFile = this.file;
            UserDataHolderEx userDataHolderEx = psiFile instanceof RsFile ? (RsFile)psiFile : null;
            Crate crate = userDataHolderEx != null && (userDataHolderEx = userDataHolderEx.getCrate()) != null ? CrateKt.getAsNotFake((Crate)userDataHolderEx) : null;
            Annotators annotators = this.createAnnotators();
            List<Annotator> annotatorsForDeclMacros = annotators.component1();
            List<Annotator> annotatorsForAttrMacros = annotators.component2();
            while (!((Collection)macros).isEmpty()) {
                Object e = macros.removeLast();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                MacroCallPreparedForHighlighting macro = (MacroCallPreparedForHighlighting)e;
                AnnotationSessionImpl.computeWithSession((PsiFile)((PsiFile)macro.getExpansion().getFile()), (boolean)false, arg_0 -> RsMacroExpansionHighlightingPass.doCollectInformation$lambda$1(arg_0 -> RsMacroExpansionHighlightingPass.doCollectInformation$lambda$0(crate, macro, annotatorsForAttrMacros, annotatorsForDeclMacros, macros, this, results, arg_0), arg_0));
            }
        }
        BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.file, (Document)this.myDocument, (int)this.restrictedRange.getStartOffset(), (int)this.restrictedRange.getEndOffset(), (Collection)results, (int)this.getId());
    }

    private final void mapAndCollectAnnotation(MacroCallPreparedForHighlighting macro, Annotation ann, List<HighlightInfo> results) {
        TextRange originRange = new TextRange(ann.getStartOffset(), ann.getEndOffset());
        HighlightInfo highlightInfo = HighlightInfo.fromAnnotation((Annotation)ann, (Document)this.getDocument());
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"fromAnnotation(...)");
        HighlightInfo originInfo = highlightInfo;
        this.mapAndCollectHighlightInfo(macro, originInfo, originRange, true, results);
    }

    private final void mapAndCollectHighlightInfo(MacroCallPreparedForHighlighting macro, HighlightInfo originInfo, TextRange originRange, boolean withQuickFixes, List<HighlightInfo> results) {
        List<TextRange> mappedRanges = RsExpandedElementKt.mapRangeFromExpansionToCallBody(macro.getExpansion(), macro.getMacroCall(), originRange);
        if (!((Collection)mappedRanges).isEmpty()) {
            for (TextRange mappedRange : mappedRanges) {
                this.mapAndEmit(originInfo, mappedRange, macro, withQuickFixes, results);
            }
        } else if (Intrinsics.areEqual((Object)originInfo.type, (Object)HighlightInfoType.ERROR) && Registry.Companion.is("org.rust.lang.highlight.error.macro.ident")) {
            RsPath rsPath = macro.getMacroCall().getPath();
            if (rsPath == null) {
                return;
            }
            RsPath macroCallPath = rsPath;
            if (macro.getParentMacro() != null) {
                MacroCallPreparedForHighlighting macroCallPreparedForHighlighting = macro.getParentMacro();
                TextRange textRange = macroCallPath.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                this.mapAndCollectHighlightInfo(macroCallPreparedForHighlighting, originInfo, textRange, false, results);
            } else {
                TextRange textRange = macroCallPath.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                this.mapAndEmit(originInfo, textRange, macro, false, results);
            }
        }
    }

    static /* synthetic */ void mapAndCollectHighlightInfo$default(RsMacroExpansionHighlightingPass rsMacroExpansionHighlightingPass, MacroCallPreparedForHighlighting macroCallPreparedForHighlighting, HighlightInfo highlightInfo, TextRange textRange, boolean bl, List list, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        rsMacroExpansionHighlightingPass.mapAndCollectHighlightInfo(macroCallPreparedForHighlighting, highlightInfo, textRange, bl, list);
    }

    private final void mapAndEmit(HighlightInfo originInfo, TextRange mappedRange, MacroCallPreparedForHighlighting macro, boolean withQuickFixes, List<HighlightInfo> results) {
        HighlightInfo.Builder newInfo = RsMacroExpansionHighlightingPassKt.access$copyWithRange(originInfo, mappedRange);
        if (withQuickFixes) {
            originInfo.findRegisteredQuickFix((arg_0, arg_1) -> RsMacroExpansionHighlightingPass.mapAndEmit$lambda$1((arg_0, arg_1) -> RsMacroExpansionHighlightingPass.mapAndEmit$lambda$0(macro, newInfo, arg_0, arg_1), arg_0, arg_1));
        }
        ((Collection)results).add(newInfo.createUnconditionally());
    }

    static /* synthetic */ void mapAndEmit$default(RsMacroExpansionHighlightingPass rsMacroExpansionHighlightingPass, HighlightInfo highlightInfo, TextRange textRange, MacroCallPreparedForHighlighting macroCallPreparedForHighlighting, boolean bl, List list, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        rsMacroExpansionHighlightingPass.mapAndEmit(highlightInfo, textRange, macroCallPreparedForHighlighting, bl, list);
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightCfgDisabledRanges(Crate crate, MacroCallPreparedForHighlighting macro, List<? extends PsiElement> cfgDisabledElements, List<HighlightInfo> results) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$flatMapTo$iv;
        AttrCache.HashMapCache cache = new AttrCache.HashMapCache(crate);
        Iterable iterable = cfgDisabledElements;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            MacroExpansion macroExpansion = macro.getExpansion();
            RsPossibleMacroCall rsPossibleMacroCall = macro.getMacroCall();
            TextRange textRange = it2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            Iterable list$iv = RsExpandedElementKt.mapRangeFromExpansionToCallBody(macroExpansion, rsPossibleMacroCall, textRange);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = destination$iv;
        boolean $i$f$filter = false;
        void $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement element;
            boolean bl;
            TextRange range = (TextRange)element$iv$iv;
            boolean bl2 = false;
            if (this.file.findElementAt(range.getStartOffset()) == null) {
                bl = false;
            } else if (RsExpandedElementKt.findExpansionElements(element, cache) == null) {
                bl = false;
            } else {
                boolean bl3;
                block10: {
                    List<PsiElement> expansionElements;
                    Iterable $this$any$iv = expansionElements;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it3 = (PsiElement)element$iv;
                            boolean bl4 = false;
                            if (!CfgUtilsKt.isEnabledByCfg(it3, crate)) continue;
                            bl3 = true;
                            break block10;
                        }
                        bl3 = false;
                    }
                }
                bl = !bl3;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cfgDisabledMappedRanges = (List)destination$iv$iv;
        for (TextRange mappedRange : cfgDisabledMappedRanges) {
            RsColor color = RsColor.CFG_DISABLED_CODE;
            HighlightSeverity severity = UtilsKt.isUnitTestMode() ? color.getTestSeverity() : RsCfgDisabledCodeAnnotator.Helper.INSTANCE.getCONDITIONALLY_DISABLED_CODE_SEVERITY();
            ((Collection)results).add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).severity(severity).textAttributes(color.getTextAttributesKey()).range(mappedRange).descriptionAndTooltip(RsBundle.INSTANCE.message("text.conditionally.disabled.code", new Object[0])).createUnconditionally());
        }
    }

    public void doApplyInformationToEditor() {
    }

    private static final Unit doCollectInformation$lambda$0(Crate $crate, MacroCallPreparedForHighlighting $macro, List $annotatorsForAttrMacros, List $annotatorsForDeclMacros, List $macros, RsMacroExpansionHighlightingPass this$0, List $results, AnnotationHolderImpl holder) {
        AnnotationSession annotationSession = holder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSession, (String)"getCurrentAnnotationSession(...)");
        AnnotationSession annotationSession2 = annotationSession;
        AnnotationSessionExKt.setCurrentCrate(annotationSession2, $crate);
        IntentionPlace place = $macro.isDeeplyAttrMacro() ? IntentionPlace.ATTR_MACRO : IntentionPlace.BANG_MACRO;
        AnnotationSessionExKt.setIntentionPlace(annotationSession2, place);
        List annotators = $macro.isDeeplyAttrMacro() ? $annotatorsForAttrMacros : $annotatorsForDeclMacros;
        List cfgDisabledElements = new ArrayList();
        for (PsiElement element : $macro.getElementsForHighlighting()) {
            Intrinsics.checkNotNull((Object)holder);
            if (RsCfgDisabledCodeAnnotator.Helper.INSTANCE.shouldHighlightAsCfsDisabled(element, (AnnotationHolder)holder)) {
                ((Collection)cfgDisabledElements).add(element);
            }
            for (Annotator ann : annotators) {
                ProgressManager.checkCanceled();
                holder.runAnnotatorWithContext(element, ann);
            }
            if (!(element instanceof RsAttrProcMacroOwner)) continue;
            Collection collection = $macros;
            MacroCallPreparedForHighlighting macroCallPreparedForHighlighting = MacroHighlightingUtilKt.prepareForExpansionHighlighting((RsAttrProcMacroOwner)element, $macro);
            if (macroCallPreparedForHighlighting == null) continue;
            collection.add(macroCallPreparedForHighlighting);
        }
        Iterator iterator2 = holder.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Annotation ann = (Annotation)e;
            this$0.mapAndCollectAnnotation($macro, ann, $results);
        }
        if ($crate != null && AnnotatorBase.Companion.isEnabled(RsCfgDisabledCodeAnnotator.class)) {
            this$0.highlightCfgDisabledRanges($crate, $macro, cfgDisabledElements, $results);
        }
        return Unit.INSTANCE;
    }

    private static final Unit doCollectInformation$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Object mapAndEmit$lambda$0(MacroCallPreparedForHighlighting $macro, HighlightInfo.Builder $newInfo, HighlightInfo.IntentionActionDescriptor descriptor, TextRange quickfixTextRange) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)quickfixTextRange, (String)"quickfixTextRange");
        List<TextRange> mappedQfRanges = RsExpandedElementKt.mapRangeFromExpansionToCallBody($macro.getExpansion(), $macro.getMacroCall(), quickfixTextRange);
        for (TextRange mappedQfRange : mappedQfRanges) {
            if (!(descriptor.getAction() instanceof RsQuickFixBase)) continue;
            $newInfo.registerFix(descriptor.getAction(), CollectionsKt.emptyList(), descriptor.getDisplayName(), mappedQfRange, null);
        }
        return null;
    }

    private static final Object mapAndEmit$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ TextRange access$getRestrictedRange$p(RsMacroExpansionHighlightingPass $this) {
        return $this.restrictedRange;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/annotator/RsMacroExpansionHighlightingPass$Annotators;", "", "annotatorsForDeclMacros", "", "Lcom/intellij/lang/annotation/Annotator;", "annotatorsForAttrMacros", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getAnnotatorsForDeclMacros", "()Ljava/util/List;", "getAnnotatorsForAttrMacros", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    private static final class Annotators {
        @NotNull
        private final List<Annotator> annotatorsForDeclMacros;
        @NotNull
        private final List<Annotator> annotatorsForAttrMacros;

        public Annotators(@NotNull List<? extends Annotator> annotatorsForDeclMacros, @NotNull List<? extends Annotator> annotatorsForAttrMacros) {
            Intrinsics.checkNotNullParameter(annotatorsForDeclMacros, (String)"annotatorsForDeclMacros");
            Intrinsics.checkNotNullParameter(annotatorsForAttrMacros, (String)"annotatorsForAttrMacros");
            this.annotatorsForDeclMacros = annotatorsForDeclMacros;
            this.annotatorsForAttrMacros = annotatorsForAttrMacros;
        }

        @NotNull
        public final List<Annotator> getAnnotatorsForDeclMacros() {
            return this.annotatorsForDeclMacros;
        }

        @NotNull
        public final List<Annotator> getAnnotatorsForAttrMacros() {
            return this.annotatorsForAttrMacros;
        }

        @NotNull
        public final List<Annotator> component1() {
            return this.annotatorsForDeclMacros;
        }

        @NotNull
        public final List<Annotator> component2() {
            return this.annotatorsForAttrMacros;
        }

        @NotNull
        public final Annotators copy(@NotNull List<? extends Annotator> annotatorsForDeclMacros, @NotNull List<? extends Annotator> annotatorsForAttrMacros) {
            Intrinsics.checkNotNullParameter(annotatorsForDeclMacros, (String)"annotatorsForDeclMacros");
            Intrinsics.checkNotNullParameter(annotatorsForAttrMacros, (String)"annotatorsForAttrMacros");
            return new Annotators(annotatorsForDeclMacros, annotatorsForAttrMacros);
        }

        public static /* synthetic */ Annotators copy$default(Annotators annotators, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = annotators.annotatorsForDeclMacros;
            }
            if ((n & 2) != 0) {
                list2 = annotators.annotatorsForAttrMacros;
            }
            return annotators.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "Annotators(annotatorsForDeclMacros=" + this.annotatorsForDeclMacros + ", annotatorsForAttrMacros=" + this.annotatorsForAttrMacros + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.annotatorsForDeclMacros).hashCode();
            result2 = result2 * 31 + ((Object)this.annotatorsForAttrMacros).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Annotators)) {
                return false;
            }
            Annotators annotators = (Annotators)other;
            if (!Intrinsics.areEqual(this.annotatorsForDeclMacros, annotators.annotatorsForDeclMacros)) {
                return false;
            }
            return Intrinsics.areEqual(this.annotatorsForAttrMacros, annotators.annotatorsForAttrMacros);
        }
    }
}

