/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.ChangeStructToFunctionCallFix;
import org.rust.ide.annotator.RsInvalidFieldsInStructLiteralInspectionKt;
import org.rust.ide.fixes.AddStructFieldsFix;
import org.rust.ide.fixes.CreateStructFieldFromConstructorFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.utils.StructFieldsExpanderKt;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.RsStructLiteralBody;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsAbstractableAndIsDocAlias;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.psi.ext.RsStructKind;
import org.rust.lang.core.psi.ext.RsStructLiteralBodyKt;
import org.rust.lang.core.resolve.TraitImplSource;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.SubstitutionKt;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.infer.TypeInferenceKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyInfer;
import org.rust.lang.core.types.ty.TyTypeParameter;
import org.rust.lang.utils.QuickFixWithRange;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.lang.utils.Severity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/annotator/RsInvalidFieldsInStructLiteralInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkStructLiteral", "", "decl", "Lorg/rust/lang/core/psi/ext/RsFieldsOwner;", "literal", "Lorg/rust/lang/core/psi/RsStructLiteral;", "checkStructLiteralMissingFields", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsInvalidFieldsInStructLiteralInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsInvalidFieldsInStructLiteralInspection.kt\norg/rust/ide/annotator/RsInvalidFieldsInStructLiteralInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,149:1\n774#2:150\n865#2:151\n2746#2,3:152\n866#2:155\n1869#2:156\n1870#2:159\n1285#2,2:161\n1299#2,4:163\n1563#2:170\n1634#2,3:171\n37#3,2:157\n1#4:160\n188#5,3:167\n*S KotlinDebug\n*F\n+ 1 RsInvalidFieldsInStructLiteralInspection.kt\norg/rust/ide/annotator/RsInvalidFieldsInStructLiteralInspection\n*L\n55#1:150\n55#1:151\n56#1:152,3\n55#1:155\n58#1:156\n58#1:159\n89#1:161,2\n89#1:163,4\n102#1:170\n102#1:171,3\n59#1:157,2\n93#1:167,3\n*E\n"})
public final class RsInvalidFieldsInStructLiteralInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsInvalidFieldsInStructLiteralInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitStructLiteral(RsStructLiteral element) {
                RsFieldsOwner decl;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                RsPathReference rsPathReference = element.getPath().getReference();
                RsElement rsElement = rsPathReference != null ? RsPathReferenceImplKt.deepResolve(rsPathReference) : null;
                RsFieldsOwner rsFieldsOwner = decl = rsElement instanceof RsFieldsOwner ? (RsFieldsOwner)rsElement : null;
                if (decl != null) {
                    RsInvalidFieldsInStructLiteralInspection.access$checkStructLiteral(this.this$0, this.$holder, decl, element);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void checkStructLiteral(RsProblemsHolder holder, RsFieldsOwner decl, RsStructLiteral literal) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        RsStructLiteralBody rsStructLiteralBody = literal.getStructLiteralBody();
        Intrinsics.checkNotNullExpressionValue((Object)rsStructLiteralBody, (String)"getStructLiteralBody(...)");
        RsStructLiteralBody body = rsStructLiteralBody;
        Iterable iterable = RsStructLiteralBodyKt.getExpandedFields(body);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                RsStructLiteralField field = (RsStructLiteralField)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = field.getReference().multiResolve();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        RsElement it2 = (RsElement)element$iv;
                        boolean bl3 = false;
                        if (!(it2 instanceof RsFieldDecl)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RsStructLiteralField field = (RsStructLiteralField)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object)((Object)CreateStructFieldFromConstructorFix.Companion.tryCreate(field)));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CreateStructFieldFromConstructorFix[] createStructFieldFromConstructorFixArray = thisCollection$iv.toArray(new CreateStructFieldFromConstructorFix[0]);
            RsProblemsHolder.registerProblem$default(holder, field.getReferenceNameElement(), RsBundle.INSTANCE.message("inspection.message.no.such.field", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, Arrays.copyOf(createStructFieldFromConstructorFixArray, createStructFieldFromConstructorFixArray.length), null, 16, null);
        }
        for (RsStructLiteralField field : RsInvalidFieldsInStructLiteralInspectionKt.access$findDuplicateReferences(RsStructLiteralBodyKt.getExpandedFields(body))) {
            holder.registerProblem(field.getReferenceNameElement(), RsBundle.INSTANCE.message("inspection.message.duplicate.field", new Object[0]), new LocalQuickFix[0]);
        }
        this.checkStructLiteralMissingFields(holder, decl, literal);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkStructLiteralMissingFields(RsProblemsHolder holder, RsFieldsOwner decl, RsStructLiteral literal) {
        void $this$mapTo$iv$iv;
        Object result$iv;
        Object it2;
        List list;
        if (literal.getStructLiteralBody().getDotdot() != null) {
            return;
        }
        if (decl instanceof RsStructItem && RsStructItemKt.getKind((RsStructItem)decl) == RsStructKind.UNION) {
            return;
        }
        RsStructLiteralBody rsStructLiteralBody = literal.getStructLiteralBody();
        Intrinsics.checkNotNullExpressionValue((Object)rsStructLiteralBody, (String)"getStructLiteralBody(...)");
        Collection collection = RsInvalidFieldsInStructLiteralInspectionKt.calculateMissingFields(rsStructLiteralBody, decl);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        List missingFields = (List)collection;
        if (!CfgUtilsKt.getExistsAfterExpansion(literal)) {
            return;
        }
        boolean needRecursive = StructFieldsExpanderKt.canAddFieldsRecursively(literal);
        List $this$checkStructLiteralMissingFields_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (RsFieldsOwnerKt.canBeInstantiatedIn(decl, literal.getContainingMod())) {
            $this$checkStructLiteralMissingFields_u24lambda_u241.add(new QuickFixWithRange(new AddStructFieldsFix(literal, false, 2, null), literal.getTextRange()));
            if (needRecursive) {
                $this$checkStructLiteralMissingFields_u24lambda_u241.add(new QuickFixWithRange(new AddStructFieldsFix(literal, true), literal.getTextRange()));
            }
        } else {
            boolean shouldOfferNew;
            TraitImplSource traitImplSource;
            RsStructItem rsStructItem = decl instanceof RsStructItem ? (RsStructItem)decl : null;
            if (rsStructItem != null) {
                Object v3;
                block19: {
                    Object object;
                    Object $this$associateWithTo$iv$iv2;
                    void $this$associateWith$iv;
                    it2 = rsStructItem;
                    boolean bl2 = false;
                    Iterable iterable = TypeInferenceKt.getGenerics((RsGenericDeclaration)it2);
                    TypeFoldable typeFoldable = it2.getDeclaredType();
                    boolean $i$f$associateWith22 = false;
                    result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    void var16_21 = $this$associateWith$iv;
                    Map destination$iv$iv = (Map)result$iv;
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
                        void it3;
                        object = (TyTypeParameter)element$iv$iv;
                        Object t = element$iv$iv;
                        Map map2 = destination$iv$iv;
                        boolean bl3 = false;
                        TyInfer.TyVar tyVar = new TyInfer.TyVar(it3, null, 2, null);
                        map2.put(t, tyVar);
                    }
                    Ty ty2 = (Ty)FoldKt.substitute(typeFoldable, SubstitutionKt.toTypeSubst(destination$iv$iv));
                    Sequence $i$f$associateWith22 = SequencesKt.filter(ExtensionsKt.getImplLookup((RsElement)it2).findImplsAndTraits(ty2), RsInvalidFieldsInStructLiteralInspection::checkStructLiteralMissingFields$lambda$1$0$1);
                    for (Object $this$associateWithTo$iv$iv2 : $i$f$associateWith22) {
                        boolean bl4;
                        block18: {
                            TraitImplSource it4 = (TraitImplSource)$this$associateWithTo$iv$iv2;
                            boolean bl5 = false;
                            Map<String, List<RsAbstractableAndIsDocAlias>> $this$any$iv = it4.getTraitOrImplExpandedMembers();
                            boolean $i$f$any = false;
                            if ($this$any$iv.isEmpty()) {
                                bl4 = false;
                            } else {
                                object = $this$any$iv.entrySet().iterator();
                                while (object.hasNext()) {
                                    Map.Entry element$iv;
                                    Map.Entry it5 = element$iv = (Map.Entry)object.next();
                                    boolean bl6 = false;
                                    if (!Intrinsics.areEqual(it5.getKey(), (Object)"new")) continue;
                                    bl4 = true;
                                    break block18;
                                }
                                bl4 = false;
                            }
                        }
                        if (!bl4) continue;
                        v3 = $this$associateWithTo$iv$iv2;
                        break block19;
                    }
                    v3 = null;
                }
                traitImplSource = v3;
            } else {
                traitImplSource = null;
            }
            boolean bl7 = shouldOfferNew = traitImplSource != null;
            if (shouldOfferNew) {
                $this$checkStructLiteralMissingFields_u24lambda_u241.add(new QuickFixWithRange(new ChangeStructToFunctionCallFix(literal, "new"), literal.getTextRange()));
            }
        }
        List fixes = CollectionsKt.build((List)list);
        Iterable $this$map$iv = missingFields;
        boolean $i$f$map = false;
        it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            result$iv = (RsFieldDecl)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl8 = false;
            String string = it6.getName();
            if (string == null) {
                return;
            }
            collection2.add(string);
        }
        List missingFieldsNames = (List)destination$iv$iv;
        String string = decl.getName();
        if (string == null) {
            return;
        }
        String itemName = string;
        RsPath rsPath = literal.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"getPath(...)");
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingFieldsInStructLiteral((PsiElement)rsPath, Severity.ERROR, itemName, missingFieldsNames, fixes), holder, false, null, 6, null);
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingFieldsInStructLiteral((PsiElement)literal, Severity.INFO, itemName, missingFieldsNames, fixes), holder, false, null, 6, null);
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    private static final boolean checkStructLiteralMissingFields$lambda$1$0$1(TraitImplSource traitImpl) {
        Intrinsics.checkNotNullParameter((Object)traitImpl, (String)"traitImpl");
        return traitImpl.isInherent() && traitImpl instanceof TraitImplSource.ExplicitImpl;
    }

    public static final /* synthetic */ void access$checkStructLiteral(RsInvalidFieldsInStructLiteralInspection $this, RsProblemsHolder holder, RsFieldsOwner decl, RsStructLiteral literal) {
        $this.checkStructLiteral(holder, decl, literal);
    }
}

