/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.annotator.RsAnnotationHolderKt;
import org.rust.ide.annotator.RsHighlightingMutableAnnotatorKt;
import org.rust.ide.colors.RsColor;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/annotator/RsHighlightingMutableAnnotator;", "Lorg/rust/ide/annotator/AnnotatorBase;", "<init>", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotationFor", "Lorg/rust/ide/colors/RsColor;", "ref", "Lorg/rust/lang/core/psi/ext/RsElement;", "distinctAnnotation", "partToHighlight", "addHighlightingAnnotation", "target", "key", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsHighlightingMutableAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsHighlightingMutableAnnotator.kt\norg/rust/ide/annotator/RsHighlightingMutableAnnotator\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,86:1\n9#2:87\n*S KotlinDebug\n*F\n+ 1 RsHighlightingMutableAnnotator.kt\norg/rust/ide/annotator/RsHighlightingMutableAnnotator\n*L\n43#1:87\n*E\n"})
public final class RsHighlightingMutableAnnotator
extends AnnotatorBase {
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (RsAnnotationHolderKt.isBatchModeEnabled(holder)) {
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!this.isSmartModeAndNoScanning(project)) {
            return;
        }
        PsiElement psiElement2 = element;
        if (psiElement2 instanceof RsPath) {
            object = ((RsPath)element).getReference();
            if (object == null || (object = object.resolve()) == null) {
                return;
            }
        } else if (psiElement2 instanceof RsSelfParameter) {
            object = (RsElement)element;
        } else if (psiElement2 instanceof RsPatBinding) {
            object = (RsElement)element;
        } else {
            return;
        }
        Object ref = object;
        this.distinctAnnotation(element, (RsElement)ref, holder);
    }

    private final RsColor annotationFor(RsElement ref) {
        RsColor rsColor;
        RsElement rsElement = ref;
        if (rsElement instanceof RsSelfParameter) {
            rsColor = RsColor.MUT_SELF_PARAMETER;
        } else if (rsElement instanceof RsPatBinding) {
            PsiElement $this$ancestorStrict$iv = ref;
            boolean $i$f$ancestorStrict = false;
            rsColor = PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsValueParameter.class, (boolean)true) != null ? RsColor.MUT_PARAMETER : RsColor.MUT_BINDING;
        } else {
            rsColor = null;
        }
        return rsColor;
    }

    private final void distinctAnnotation(PsiElement element, RsElement ref, AnnotationHolder holder) {
        RsColor rsColor = this.annotationFor(ref);
        if (rsColor == null) {
            return;
        }
        RsColor color = rsColor;
        if (RsHighlightingMutableAnnotatorKt.access$isMut(ref)) {
            if (!CfgUtilsKt.getExistsAfterExpansion(element)) {
                return;
            }
            PsiElement element2 = this.partToHighlight(element);
            this.addHighlightingAnnotation(holder, element2, color);
        }
    }

    private final PsiElement partToHighlight(PsiElement element) {
        PsiElement psiElement2;
        PsiElement psiElement3 = element;
        if (psiElement3 instanceof RsSelfParameter) {
            PsiElement psiElement4 = ((RsSelfParameter)element).getSelf();
            psiElement2 = psiElement4;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getSelf(...)");
        } else if (psiElement3 instanceof RsPatBinding) {
            PsiElement psiElement5 = ((RsPatBinding)element).getIdentifier();
            psiElement2 = psiElement5;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getIdentifier(...)");
        } else {
            psiElement2 = element;
        }
        return psiElement2;
    }

    private final void addHighlightingAnnotation(AnnotationHolder holder, PsiElement target, RsColor key) {
        HighlightSeverity annotationSeverity = UtilsKt.isUnitTestMode() ? key.getTestSeverity() : RsHighlightingMutableAnnotatorKt.access$getMUTABLE_HIGHLIGHTING$p();
        holder.newSilentAnnotation(annotationSeverity).range(target.getTextRange()).textAttributes(key.getTextAttributesKey()).create();
    }
}

