/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.annotator.RsAnnotationHolderKt;
import org.rust.ide.annotator.RsEditionHighlighter;
import org.rust.ide.colors.RsColor;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/annotator/RsEditionKeywordsAnnotator;", "Lorg/rust/ide/annotator/AnnotatorBase;", "Lorg/rust/ide/annotator/RsEditionHighlighter;", "<init>", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.rustrover.core"})
public abstract class RsEditionKeywordsAnnotator
extends AnnotatorBase
implements RsEditionHighlighter {
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (RsElementKt.getEdition(element) == null) {
            return;
        }
        if (!this.isEditionKeyword(element)) {
            return;
        }
        boolean isAtLeastEdition = this.isAtLeastEdition(element);
        boolean isIdentifier = Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(element), (Object)RsElementTypes.IDENTIFIER);
        boolean isEnabledByCfg = CfgUtilsKt.isEnabledByCfg(element);
        if (isAtLeastEdition && !isIdentifier && isEnabledByCfg) {
            if (!RsAnnotationHolderKt.isBatchModeEnabled(holder)) {
                HighlightSeverity severity = UtilsKt.isUnitTestMode() ? RsColor.KEYWORD.getTestSeverity() : HighlightInfoType.SYMBOL_TYPE_SEVERITY;
                holder.newSilentAnnotation(severity).textAttributes(RsColor.KEYWORD.getTextAttributesKey()).create();
            }
        } else if (isAtLeastEdition && !isIdentifier && !isEnabledByCfg && !RsAnnotationHolderKt.isBatchModeEnabled(holder)) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
            EditorColorsScheme colorScheme = editorColorsScheme;
            TextAttributes keywordTextAttributes = colorScheme.getAttributes(RsColor.KEYWORD.getTextAttributesKey());
            TextAttributes cfgDisabledCodeTextAttributes = colorScheme.getAttributes(RsColor.CFG_DISABLED_CODE.getTextAttributesKey());
            TextAttributes cfgDisabledKeywordTextAttributes = TextAttributes.merge((TextAttributes)keywordTextAttributes, (TextAttributes)cfgDisabledCodeTextAttributes);
            holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).enforcedTextAttributes(cfgDisabledKeywordTextAttributes).create();
        }
    }
}

