/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.annotator.RsAnnotationHolderKt;
import org.rust.ide.colors.RsColor;
import org.rust.ide.injected.RsDoctestLanguageInjectorKt;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.doc.psi.RsDocAtxHeading;
import org.rust.lang.doc.psi.RsDocCodeBlock;
import org.rust.lang.doc.psi.RsDocCodeFence;
import org.rust.lang.doc.psi.RsDocCodeFenceLang;
import org.rust.lang.doc.psi.RsDocCodeFenceStartEnd;
import org.rust.lang.doc.psi.RsDocCodeSpan;
import org.rust.lang.doc.psi.RsDocElementTypes;
import org.rust.lang.doc.psi.RsDocEmphasis;
import org.rust.lang.doc.psi.RsDocGap;
import org.rust.lang.doc.psi.RsDocLink;
import org.rust.lang.doc.psi.RsDocStrong;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/annotator/RsDocHighlightingAnnotator;", "Lorg/rust/ide/annotator/AnnotatorBase;", "<init>", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isDoctestInjected", "", "Lorg/rust/lang/doc/psi/RsDocCodeFence;", "(Lorg/rust/lang/doc/psi/RsDocCodeFence;)Z", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDocHighlightingAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocHighlightingAnnotator.kt\norg/rust/ide/annotator/RsDocHighlightingAnnotator\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,57:1\n9#2:58\n121#3:59\n*S KotlinDebug\n*F\n+ 1 RsDocHighlightingAnnotator.kt\norg/rust/ide/annotator/RsDocHighlightingAnnotator\n*L\n32#1:58\n43#1:59\n*E\n"})
public final class RsDocHighlightingAnnotator
extends AnnotatorBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        RsColor rsColor;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (RsAnnotationHolderKt.isBatchModeEnabled(holder)) {
            return;
        }
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(element), (Object)((Object)RsDocElementTypes.INSTANCE.getDOC_DATA()))) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof RsDocCodeFence) {
                if (this.isDoctestInjected((RsDocCodeFence)parent2)) {
                    return;
                }
                rsColor = RsColor.DOC_CODE;
            } else if (parent2 instanceof RsDocCodeFenceStartEnd || parent2 instanceof RsDocCodeFenceLang) {
                rsColor = RsColor.DOC_CODE;
            } else if (parent2 instanceof RsDocCodeSpan) {
                PsiElement $this$ancestorStrict$iv = element;
                boolean $i$f$ancestorStrict = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsDocLink.class, (boolean)true) != null) return;
                rsColor = RsColor.DOC_CODE;
            } else {
                if (!(parent2 instanceof RsDocCodeBlock)) return;
                rsColor = RsColor.DOC_CODE;
            }
        } else if (element instanceof RsDocEmphasis) {
            rsColor = RsColor.DOC_EMPHASIS;
        } else if (element instanceof RsDocStrong) {
            rsColor = RsColor.DOC_STRONG;
        } else if (element instanceof RsDocAtxHeading) {
            rsColor = RsColor.DOC_HEADING;
        } else {
            if (!(element instanceof RsDocLink)) return;
            PsiElement $this$descendantOfTypeStrict$iv = element;
            boolean $i$f$descendantOfTypeStrict = false;
            if (PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeStrict$iv, RsDocGap.class, (boolean)true) != null) return;
            rsColor = RsColor.DOC_LINK;
        }
        if (rsColor == null) {
            return;
        }
        RsColor color = rsColor;
        if (!CfgUtilsKt.isEnabledByCfg(element)) {
            return;
        }
        HighlightSeverity severity = UtilsKt.isUnitTestMode() ? color.getTestSeverity() : HighlightSeverity.INFORMATION;
        holder.newSilentAnnotation(severity).textAttributes(color.getTextAttributesKey()).create();
    }

    private final boolean isDoctestInjected(RsDocCodeFence $this$isDoctestInjected) {
        return RsDoctestLanguageInjectorKt.doctestInfo($this$isDoctestInjected) != null;
    }
}

