/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.AnnotationSessionExKt;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.annotator.RsAnnotationHolderKt;
import org.rust.ide.colors.RsColor;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.lang.core.psi.ext.RsAttrKt;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\f\u0010\n\u001a\u00020\u0005*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/rust/ide/annotator/RsCfgDisabledCodeAnnotator;", "Lorg/rust/ide/annotator/AnnotatorBase;", "<init>", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "createCondDisabledAnnotation", "Helper", "intellij.rustrover.core"})
public final class RsCfgDisabledCodeAnnotator
extends AnnotatorBase {
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (RsAnnotationHolderKt.isBatchModeEnabled(holder)) {
            return;
        }
        if (Helper.INSTANCE.shouldHighlightAsCfsDisabled(element, holder)) {
            this.createCondDisabledAnnotation(holder);
        }
    }

    private final void createCondDisabledAnnotation(AnnotationHolder $this$createCondDisabledAnnotation) {
        RsColor color = RsColor.CFG_DISABLED_CODE;
        HighlightSeverity severity = UtilsKt.isUnitTestMode() ? color.getTestSeverity() : Helper.INSTANCE.getCONDITIONALLY_DISABLED_CODE_SEVERITY();
        $this$createCondDisabledAnnotation.newAnnotation(severity, RsBundle.INSTANCE.message("text.conditionally.disabled.code", new Object[0])).textAttributes(color.getTextAttributesKey()).create();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/annotator/RsCfgDisabledCodeAnnotator$Helper;", "", "<init>", "()V", "shouldHighlightAsCfsDisabled", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "CONDITIONALLY_DISABLED_CODE_SEVERITY", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getCONDITIONALLY_DISABLED_CODE_SEVERITY", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();
        @NotNull
        private static final HighlightSeverity CONDITIONALLY_DISABLED_CODE_SEVERITY = new HighlightSeverity("CONDITIONALLY_DISABLED_CODE", HighlightSeverity.INFORMATION.myVal + 1);

        private Helper() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean shouldHighlightAsCfsDisabled(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Crate crate = AnnotationSessionExKt.currentCrate(holder);
            if (crate == null) {
                return false;
            }
            Crate crate2 = crate;
            if (element instanceof RsDocAndAttributeOwner && !RsDocAndAttributeOwnerKt.isEnabledByCfgSelfOrInAttrProcMacroBody((RsDocAndAttributeOwner)element, crate2)) {
                return true;
            }
            if (!(element instanceof RsAttr)) return false;
            if (!CfgUtilsKt.isDisabledCfgAttrAttribute((RsAttr)element, crate2)) return false;
            RsDocAndAttributeOwner rsDocAndAttributeOwner = RsAttrKt.getOwner((RsAttr)element);
            if (rsDocAndAttributeOwner == null) return false;
            if (!RsDocAndAttributeOwnerKt.isEnabledByCfgSelfOrInAttrProcMacroBody(rsDocAndAttributeOwner, crate2)) return false;
            return true;
        }

        @NotNull
        public final HighlightSeverity getCONDITIONALLY_DISABLED_CODE_SEVERITY() {
            return CONDITIONALLY_DISABLED_CODE_SEVERITY;
        }
    }
}

