/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.annotator.AnnotatorBase;
import org.rust.ide.annotator.RsAnnotationHolderKt;
import org.rust.ide.colors.RsColor;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/annotator/RsAttrHighlightingAnnotator;", "Lorg/rust/ide/annotator/AnnotatorBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.rustrover.core"})
public final class RsAttrHighlightingAnnotator
extends AnnotatorBase
implements DumbAware {
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (RsAnnotationHolderKt.isBatchModeEnabled(holder)) {
            return;
        }
        RsColor rsColor = element instanceof RsAttr ? RsColor.ATTRIBUTE : null;
        if (rsColor == null) {
            return;
        }
        RsColor color = rsColor;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (this.isSmartModeAndNoScanning(project) && !CfgUtilsKt.getExistsAfterExpansion(element)) {
            return;
        }
        HighlightSeverity severity = UtilsKt.isUnitTestMode() ? color.getTestSeverity() : HighlightInfoType.SYMBOL_TYPE_SEVERITY;
        holder.newSilentAnnotation(severity).textAttributes(color.getTextAttributesKey()).create();
    }
}

