/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.rust.RsBundle;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.ide.annotator.ReplaceGeneratorsWithCoroutinesFix;
import org.rust.ide.annotator.RsRemoveMetaItemFix;
import org.rust.ide.annotator.RsRemoveQuotesFix;
import org.rust.ide.annotator.RsRemoveSuffixFix;
import org.rust.ide.annotator.RsReplaceBracketsFix;
import org.rust.ide.fixes.AddAttrParenthesesFix;
import org.rust.ide.fixes.ConvertMalformedCfgNotPatternToCfgAllPatternFix;
import org.rust.ide.fixes.ConvertToUnsuffixedIntegerFix;
import org.rust.ide.fixes.NameSuggestionFix;
import org.rust.ide.fixes.RemoveAttrFix;
import org.rust.ide.fixes.RemoveElementFix;
import org.rust.ide.fixes.RemoveMetaItemFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.lang.core.CompilerFeature;
import org.rust.lang.core.FeatureAvailability;
import org.rust.lang.core.RsPsiPattern;
import org.rust.lang.core.psi.AttributeDuplicates;
import org.rust.lang.core.psi.AttributeInfo;
import org.rust.lang.core.psi.AttributeTemplate;
import org.rust.lang.core.psi.BuiltinAttributeInfo;
import org.rust.lang.core.psi.BuiltinAttributesKt;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsInnerAttr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsLiteralWithSuffix;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsMetaItemArgs;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.ext.AttributeTemplateType;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsLitExprKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.stubs.common.RsMetaItemPsiOrStub;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a \u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010 \u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001cH\u0002\u001a\u0018\u0010 \u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u0018\u0010 \u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\u0018\u0010$\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010%\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a \u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a&\u0010-\u001a\u00020\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0\u001b2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"checkDeprecatedAttr", "", "element", "Lorg/rust/lang/core/psi/RsMetaItem;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "checkRsDocAndAttributeOwner", "Lorg/rust/lang/core/psi/ext/RsDocAndAttributeOwner;", "checkLiteralSuffix", "metaItem", "checkAttrTemplateCompatible", "emitMalformedAttribute", "name", "", "template", "Lorg/rust/lang/core/psi/AttributeTemplate;", "setParen", "text", "checkMetaBadDelim", "checkFeatureAttribute", "item", "context", "Lcom/intellij/util/ProcessingContext;", "checkRootCfgPredicate", "allowMultiple", "", "allArgs", "", "Lorg/rust/lang/core/psi/ext/RsElement;", "Lorg/rust/lang/core/psi/RsMetaItemArgs;", "getAllArgs", "(Lorg/rust/lang/core/psi/RsMetaItemArgs;)Ljava/util/List;", "checkCfgPredicate", "predicate", "litExpr", "Lorg/rust/lang/core/psi/RsLitExpr;", "checkDeriveAttr", "checkReprAttr", "checkReprArg", "reprArg", "owner", "checkReprArgIsCorrectlyApplied", "reprName", "checkReprAlign", "align", "checkReprAlignArgs", "args", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsAttrErrorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsAttrErrorInspection.kt\norg/rust/ide/annotator/RsAttrErrorInspectionKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,484:1\n996#2:485\n1025#2,3:486\n1028#2,3:496\n382#3,7:489\n774#4:499\n865#4,2:500\n1869#4,2:524\n170#5,6:502\n158#5,6:508\n1400#6,2:514\n1400#6,2:516\n2443#6,5:519\n1#7:518\n*S KotlinDebug\n*F\n+ 1 RsAttrErrorInspection.kt\norg/rust/ide/annotator/RsAttrErrorInspectionKt\n*L\n97#1:485\n97#1:486,3\n97#1:496,3\n97#1:489,7\n116#1:499\n116#1:500,2\n341#1:524,2\n218#1:502,6\n219#1:508,6\n231#1:514,2\n235#1:516,2\n244#1:519,5\n*E\n"})
public final class RsAttrErrorInspectionKt {
    /*
     * Unable to fully structure code
     */
    private static final void checkDeprecatedAttr(RsMetaItem element, RsProblemsHolder holder) {
        if (RsMetaItemKt.getTemplateType(element) != AttributeTemplateType.List) {
            return;
        }
        usedArgs = new LinkedHashSet<E>();
        block5: for (RsMetaItemPsiOrStub arg : element.getMetaItemArgsList()) {
            if (!(arg instanceof RsMetaItem) || RsMetaItemKt.getName(arg) == null) continue;
            var6_6 = argName;
            switch (var6_6.hashCode()) {
                case 3387378: {
                    if (!var6_6.equals("note")) {
                        break;
                    }
                    ** GOTO lbl18
                }
                case 1197722116: {
                    if (!var6_6.equals("suggestion")) {
                        break;
                    }
                    ** GOTO lbl18
                }
                case 109441850: {
                    if (!var6_6.equals("since")) break;
lbl18:
                    // 3 sources

                    if (((RsMetaItem)arg).getEq() == null) {
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IncorrectItemInDeprecatedAttr((PsiElement)arg), holder, false, null, 6, null);
                        continue block5;
                    }
                    if (usedArgs.contains(argName)) {
                        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MultipleItemsInDeprecatedAttr((PsiElement)arg, argName), holder, false, null, 6, null);
                    }
                    usedArgs.add(argName);
                    continue block5;
                }
            }
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnknownItemInDeprecatedAttr((PsiElement)arg, argName), holder, false, null, 6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkRsDocAndAttributeOwner(RsDocAndAttributeOwner element, RsProblemsHolder holder) {
        Iterable $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Sequence<RsMetaItem> attrs = RsDocAndAttributeOwnerKt.getQueryPsiAttributes(element).getMetaItems();
        Sequence $this$groupBy$iv = SequencesKt.filter(attrs, RsAttrErrorInspectionKt::checkRsDocAndAttributeOwner$lambda$0);
        boolean $i$f$groupBy = false;
        Sequence sequence2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            RsMetaItem it2 = (RsMetaItem)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = RsMetaItemKt.getName(it2);
            Map map2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map duplicates = destination$iv$iv;
        block10: for (Map.Entry entry2 : duplicates.entrySet()) {
            BuiltinAttributeInfo attrInfo;
            AttributeInfo attributeInfo;
            String name2 = (String)entry2.getKey();
            List entries2 = (List)entry2.getValue();
            if (name2 == null || entries2.size() == 1 || ((attributeInfo = BuiltinAttributesKt.getRS_BUILTIN_ATTRIBUTES().get(name2)) instanceof BuiltinAttributeInfo ? (BuiltinAttributeInfo)attributeInfo : null) == null) continue;
            attrInfo = attrInfo;
            switch (WhenMappings.$EnumSwitchMapping$0[attrInfo.getDuplicates().ordinal()]) {
                case 1: {
                    continue block10;
                }
                case 2: {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnusedAttribute((PsiElement)CollectionsKt.first((List)entries2), RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner$getFix((RsMetaItem)CollectionsKt.last((List)entries2)), false, 4, null), holder, false, null, 6, null);
                    continue block10;
                }
                case 3: {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = entries2;
                    boolean $i$f$filter = false;
                    $this$getOrPut$iv$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        RsMetaItem it3 = (RsMetaItem)element$iv$iv;
                        boolean bl = false;
                        if (!(RsMetaItemKt.getTemplateType(it3) == AttributeTemplateType.Word)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List wordStyleArgs = (List)destination$iv$iv2;
                    if (wordStyleArgs.size() == 1) continue block10;
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnusedAttribute((PsiElement)CollectionsKt.first((List)wordStyleArgs), RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner$getFix((RsMetaItem)CollectionsKt.last((List)wordStyleArgs)), false, 4, null), holder, false, null, 6, null);
                    continue block10;
                }
                case 4: {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MultipleAttributes((PsiElement)CollectionsKt.first((List)entries2), name2, RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner$getFix((RsMetaItem)CollectionsKt.last((List)entries2))), holder, false, null, 6, null);
                    continue block10;
                }
                case 5: {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MultipleAttributes((PsiElement)CollectionsKt.last((List)entries2), name2, RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner$getFix((RsMetaItem)CollectionsKt.first((List)entries2))), holder, false, null, 6, null);
                    continue block10;
                }
                case 6: {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnusedAttribute((PsiElement)CollectionsKt.first((List)entries2), RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner$getFix((RsMetaItem)CollectionsKt.last((List)entries2)), true), holder, false, null, 6, null);
                    continue block10;
                }
                case 7: {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnusedAttribute((PsiElement)CollectionsKt.last((List)entries2), RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner$getFix((RsMetaItem)CollectionsKt.first((List)entries2)), true), holder, false, null, 6, null);
                    continue block10;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void checkLiteralSuffix(RsMetaItem metaItem, RsProblemsHolder holder) {
        String string = RsMetaItemKt.getName(metaItem);
        if (string == null) {
            return;
        }
        String name2 = string;
        if (!BuiltinAttributesKt.getRS_BUILTIN_ATTRIBUTES().containsKey(name2)) {
            return;
        }
        Object object = metaItem.getMetaItemArgs();
        if (object == null || (object = object.getLitExprList()) == null) {
            return;
        }
        Object exprList = object;
        Iterator iterator2 = exprList.iterator();
        while (iterator2.hasNext()) {
            String suffix;
            RsLitExpr expr = (RsLitExpr)iterator2.next();
            Intrinsics.checkNotNull((Object)expr);
            RsLiteralKind kind2 = RsLiteralKindKt.getKind(expr);
            if (!(kind2 instanceof RsLiteralWithSuffix) || ((RsLiteralWithSuffix)((Object)kind2)).getSuffix() == null) continue;
            String string2 = expr.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String editedText = StringsKt.removeSuffix((String)string2, (CharSequence)suffix);
            PsiFile psiFile = metaItem.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            TextRange textRange = expr.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            RsRemoveSuffixFix fix = new RsRemoveSuffixFix(psiFile, textRange, editedText);
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.AttributeSuffixedLiteral(expr, fix), holder, false, null, 6, null);
        }
    }

    private static final void checkAttrTemplateCompatible(RsMetaItem metaItem, RsProblemsHolder holder) {
        String string = RsMetaItemKt.getName(metaItem);
        if (string == null) {
            return;
        }
        String name2 = string;
        AttributeInfo attributeInfo = BuiltinAttributesKt.getRS_BUILTIN_ATTRIBUTES().get(name2);
        BuiltinAttributeInfo builtinAttributeInfo = attributeInfo instanceof BuiltinAttributeInfo ? (BuiltinAttributeInfo)attributeInfo : null;
        if (builtinAttributeInfo == null) {
            return;
        }
        BuiltinAttributeInfo attrInfo = builtinAttributeInfo;
        AttributeTemplate template2 = attrInfo.getTemplate();
        boolean isError = false;
        switch (WhenMappings.$EnumSwitchMapping$1[RsMetaItemKt.getTemplateType(metaItem).ordinal()]) {
            case 1: {
                if (template2.getList() != null) break;
                isError = true;
                break;
            }
            case 2: {
                if (template2.getNameValueStr() != null) break;
                isError = true;
                break;
            }
            case 3: {
                if (template2.getWord()) break;
                isError = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (isError) {
            RsAttrErrorInspectionKt.emitMalformedAttribute(metaItem, name2, template2, holder);
        }
    }

    private static final void emitMalformedAttribute(RsMetaItem metaItem, String name2, AttributeTemplate template2, RsProblemsHolder holder) {
        String inner = metaItem.getContext() instanceof RsInnerAttr ? "!" : "";
        boolean first = true;
        StringBuilder stringBuilder = new StringBuilder();
        if (template2.getWord()) {
            first = false;
            stringBuilder.append("#" + inner + "[" + name2 + "]");
        }
        if (template2.getList() != null) {
            if (!first) {
                stringBuilder.append(" or ");
            }
            first = false;
            stringBuilder.append("#" + inner + "[" + name2 + "(" + template2.getList().get(0) + ")]");
        }
        if (template2.getNameValueStr() != null) {
            if (!first) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append("#" + inner + "[" + name2 + " = \"" + template2.getNameValueStr().get(0) + "\"]");
        }
        String msg = first ? RsBundle.INSTANCE.message("tooltip.must.be.form", new Object[0]) : RsBundle.INSTANCE.message("tooltip.following.are.possible.correct.uses", new Object[0]);
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MalformedAttributeInput(metaItem, name2, msg + " " + stringBuilder), holder, false, null, 6, null);
    }

    private static final String setParen(String text) {
        int n;
        block4: {
            int n2;
            int index$iv;
            block3: {
                CharSequence $this$indexOfLast$iv = text;
                boolean $i$f$indexOfLast = false;
                int n3 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n3) {
                    do {
                        index$iv = n3--;
                        char it2 = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it2 == '[' || it2 == '{')) continue;
                        n2 = index$iv;
                        break block3;
                    } while (0 <= n3);
                }
                n2 = -1;
            }
            int leftIdx = n2;
            CharSequence $this$indexOfFirst$iv = text;
            boolean $i$f$indexOfFirst = false;
            int n4 = $this$indexOfFirst$iv.length();
            for (index$iv = 0; index$iv < n4; ++index$iv) {
                char it3 = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it3 == ']' || it3 == '}')) continue;
                n = index$iv;
                break block4;
            }
            n = -1;
        }
        int rightIdx = n;
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        chars[leftIdx] = 40;
        chars[rightIdx] = 41;
        return StringsKt.concatToString((char[])chars);
    }

    private static final void checkMetaBadDelim(RsMetaItem element, RsProblemsHolder holder) {
        PsiElement[] psiElementArray;
        PsiElement[] openDelim;
        block32: {
            Object object;
            PsiElement[] psiElementArray2;
            block31: {
                PsiElement[] psiElementArray3;
                block28: {
                    PsiElement[] psiElementArray4;
                    block30: {
                        Object object2;
                        PsiElement[] psiElementArray5;
                        block29: {
                            PsiElement[] psiElementArray6;
                            block27: {
                                PsiElement[] it2;
                                PsiElement[] element$iv;
                                int n;
                                int n2;
                                boolean $i$f$firstOrNull;
                                PsiElement[] $this$firstOrNull$iv;
                                PsiElement psiElement2;
                                RsPath rsPath = element.getPath();
                                if (rsPath != null) {
                                    psiElement2 = rsPath;
                                } else {
                                    PsiElement[] psiElementArray7;
                                    block26: {
                                        PsiElement[] psiElementArray8 = element.getCompactTT();
                                        if (psiElementArray8 != null && (psiElementArray8 = psiElementArray8.getChildren()) != null) {
                                            $this$firstOrNull$iv = psiElementArray8;
                                            $i$f$firstOrNull = false;
                                            n2 = $this$firstOrNull$iv.length;
                                            for (n = 0; n < n2; ++n) {
                                                it2 = element$iv = $this$firstOrNull$iv[n];
                                                boolean bl = false;
                                                Intrinsics.checkNotNull((Object)it2);
                                                if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it2), (Object)RsElementTypes.IDENTIFIER)) continue;
                                                psiElementArray7 = element$iv;
                                                break block26;
                                            }
                                            psiElementArray7 = null;
                                        } else {
                                            psiElementArray7 = psiElement2 = null;
                                        }
                                    }
                                    if (psiElementArray7 == null) {
                                        return;
                                    }
                                }
                                PsiElement name2 = psiElement2;
                                if (!BuiltinAttributesKt.getRS_BUILTIN_ATTRIBUTES().containsKey(name2.getText())) {
                                    return;
                                }
                                psiElementArray4 = element.getCompactTT();
                                if (psiElementArray4 == null || (psiElementArray4 = psiElementArray4.getChildren()) == null) break block29;
                                $this$firstOrNull$iv = psiElementArray4;
                                $i$f$firstOrNull = false;
                                n2 = $this$firstOrNull$iv.length;
                                for (n = 0; n < n2; ++n) {
                                    it2 = element$iv = $this$firstOrNull$iv[n];
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)it2);
                                    if (!(Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it2), (Object)RsElementTypes.EQ) || Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it2), (Object)RsElementTypes.LBRACE) || Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it2), (Object)RsElementTypes.LBRACK))) continue;
                                    psiElementArray6 = element$iv;
                                    break block27;
                                }
                                psiElementArray6 = psiElementArray4 = null;
                            }
                            if (psiElementArray6 != null) break block30;
                        }
                        if ((psiElementArray5 = element.getMetaItemArgs()) != null && (psiElementArray5 = psiElementArray5.getFirstChild()) != null) {
                            PsiElement[] psiElementArray9;
                            PsiElement[] it3 = psiElementArray9 = psiElementArray5;
                            boolean bl = false;
                            object2 = Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it3), (Object)RsElementTypes.LBRACE) ? psiElementArray9 : null;
                        } else {
                            object2 = psiElementArray4 = null;
                        }
                        if (object2 == null) {
                            return;
                        }
                    }
                    if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)(openDelim = psiElementArray4)), (Object)RsElementTypes.EQ)) {
                        return;
                    }
                    psiElementArray = element.getCompactTT();
                    if (psiElementArray == null || (psiElementArray = psiElementArray.getChildren()) == null) break block31;
                    PsiElement[] $this$lastOrNull$iv = psiElementArray;
                    boolean $i$f$lastOrNull = false;
                    int n = $this$lastOrNull$iv.length + -1;
                    if (0 <= n) {
                        do {
                            PsiElement[] element$iv;
                            int index$iv = n--;
                            PsiElement[] it4 = element$iv = $this$lastOrNull$iv[index$iv];
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it4);
                            if (!(Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it4), (Object)RsElementTypes.RBRACE) || Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it4), (Object)RsElementTypes.RBRACK))) continue;
                            psiElementArray3 = element$iv;
                            break block28;
                        } while (0 <= n);
                    }
                    psiElementArray3 = psiElementArray = null;
                }
                if (psiElementArray3 != null) break block32;
            }
            if ((psiElementArray2 = element.getMetaItemArgs()) != null && (psiElementArray2 = psiElementArray2.getLastChild()) != null) {
                PsiElement[] psiElementArray10;
                PsiElement[] it5 = psiElementArray10 = psiElementArray2;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType((PsiElement)it5), (Object)RsElementTypes.RBRACE) ? psiElementArray10 : null;
            } else {
                object = psiElementArray = null;
            }
            if (object == null) {
                return;
            }
        }
        PsiElement[] closingDelim = psiElementArray;
        Pair pair = new Pair((Object)PsiElementExtensionsKt.getElementType((PsiElement)openDelim), (Object)PsiElementExtensionsKt.getElementType((PsiElement)closingDelim));
        if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)RsElementTypes.LBRACE, (Object)RsElementTypes.RBRACE)) || Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)RsElementTypes.LBRACK, (Object)RsElementTypes.RBRACK))) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String fixedText = RsAttrErrorInspectionKt.setParen(string);
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            RsReplaceBracketsFix fix = new RsReplaceBracketsFix(psiFile, textRange, fixedText);
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.WrongMetaDelimiters((PsiElement)openDelim, (PsiElement)closingDelim, fix), holder, false, null, 6, null);
        }
    }

    private static final void checkFeatureAttribute(RsMetaItem item, RsProblemsHolder holder, ProcessingContext context) {
        List metaItemList;
        RsAttr attr = (RsAttr)context.get(RsPsiPattern.INSTANCE.getMETA_ITEM_ATTR());
        if (!(attr instanceof RsInnerAttr)) {
            return;
        }
        RsPath rsPath = item.getPath();
        if (rsPath == null) {
            return;
        }
        RsPath path = rsPath;
        if (!item.getContainingMod().isCrateRoot()) {
            return;
        }
        RsMetaItemArgs rsMetaItemArgs = item.getMetaItemArgs();
        List list = rsMetaItemArgs != null ? rsMetaItemArgs.getMetaItemList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((metaItemList = list).isEmpty()) {
            return;
        }
        for (RsMetaItem metaItem : metaItemList) {
            CompilerFeature feature;
            FeatureAvailability availability;
            String featureName;
            Intrinsics.checkNotNull((Object)metaItem);
            if (RsMetaItemKt.getName(metaItem) == null || CompilerFeature.Companion.find(featureName) == null || (availability = feature.availability(item)) != FeatureAvailability.REMOVED) continue;
            boolean isRemoveAvailable = metaItemList.size() > 1 || metaItemList.size() == 1 && Intrinsics.areEqual((Object)item.getParent(), (Object)attr);
            RsQuickFixBase fix = Intrinsics.areEqual((Object)featureName, (Object)"generators") ? new ReplaceGeneratorsWithCoroutinesFix(metaItem) : (isRemoveAvailable ? new RemoveMetaItemFix(metaItem) : null);
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.FeatureAttributeHasBeenRemoved(metaItem, featureName, fix), holder, false, null, 6, null);
        }
        Object object = RsElementKt.getCargoProject(item);
        if (object == null || (object = object.getRustcInfo()) == null || (object = ((RustcInfo)object).getVersion()) == null) {
            return;
        }
        Object version = object;
        if (RsDiagnosticKt.areUnstableFeaturesAvailable(item, (RustcVersion)version) != ThreeState.NO) {
            return;
        }
        String string = ((RustcVersion)version).getChannel().getChannel();
        if (string == null) {
            return;
        }
        String channelName = string;
        RemoveAttrFix fix = Intrinsics.areEqual((Object)item.getParent(), (Object)attr) ? new RemoveAttrFix(attr) : null;
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.FeatureAttributeInNonNightlyChannel(path, channelName, fix), holder, false, null, 6, null);
    }

    private static final void checkRootCfgPredicate(RsMetaItem element, RsProblemsHolder holder, boolean allowMultiple) {
        RsMetaItemArgs rsMetaItemArgs = element.getMetaItemArgs();
        if (rsMetaItemArgs == null) {
            return;
        }
        RsMetaItemArgs argsElement = rsMetaItemArgs;
        List<RsElement> args = RsAttrErrorInspectionKt.getAllArgs(argsElement);
        if (!allowMultiple && args.size() > 1) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CfgMultiplePredicatesSpecified(argsElement), holder, false, null, 6, null);
        } else if (args.isEmpty()) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CfgPredicateNotSpecified(argsElement), holder, false, null, 6, null);
        } else {
            RsAttrErrorInspectionKt.checkCfgPredicate(holder, (RsElement)CollectionsKt.first(args));
        }
    }

    private static final List<RsElement> getAllArgs(RsMetaItemArgs $this$allArgs) {
        List<RsMetaItem> list = $this$allArgs.getMetaItemList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"<get-metaItemList>(...)");
        Collection collection = list;
        List<RsLitExpr> list2 = $this$allArgs.getLitExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"<get-litExprList>(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private static final void checkCfgPredicate(RsProblemsHolder holder, RsElement predicate) {
        RsElement rsElement = predicate;
        if (rsElement instanceof RsMetaItem) {
            RsAttrErrorInspectionKt.checkCfgPredicate(holder, (RsMetaItem)predicate);
        } else if (rsElement instanceof RsLitExpr) {
            RsAttrErrorInspectionKt.checkCfgPredicate(holder, (RsLitExpr)predicate);
        } else {
            throw new IllegalStateException(("unexpected predicate: " + predicate.getClass().getSimpleName()).toString());
        }
    }

    private static final void checkCfgPredicate(RsProblemsHolder holder, RsLitExpr litExpr) {
        if (RsLitExprKt.getBooleanValue(litExpr) == null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CfgKeyCannotBeStringLiteral(litExpr), holder, false, null, 6, null);
        }
    }

    private static final void checkCfgPredicate(RsProblemsHolder holder, RsMetaItem item) {
        RsPath rsPath = item.getPath();
        if (rsPath != null) {
            RsPath path = rsPath;
            boolean bl = false;
            if (path.getHasColonColon()) {
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CfgKeyMustBeIdentifier(path), holder, false, null, 6, null);
                return;
            }
        }
        String string = RsMetaItemKt.getName(item);
        if (string == null) {
            return;
        }
        String itemName = string;
        RsMetaItemArgs rsMetaItemArgs = item.getMetaItemArgs();
        if (rsMetaItemArgs == null) {
            return;
        }
        RsMetaItemArgs argsElement = rsMetaItemArgs;
        List<RsElement> args = RsAttrErrorInspectionKt.getAllArgs(argsElement);
        switch (itemName) {
            case "all": 
            case "any": {
                Iterable $this$forEach$iv = args;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RsElement it2 = (RsElement)element$iv;
                    boolean bl = false;
                    RsAttrErrorInspectionKt.checkCfgPredicate(holder, it2);
                }
                break;
            }
            case "not": {
                if (args.size() == 1) {
                    RsAttrErrorInspectionKt.checkCfgPredicate(holder, (RsElement)CollectionsKt.first(args));
                    break;
                }
                List fixes = CollectionsKt.listOfNotNull((Object)((Object)ConvertMalformedCfgNotPatternToCfgAllPatternFix.Companion.createIfCompatible(item)));
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.CfgNotPatternIsMalformed(item, fixes), holder, false, null, 6, null);
                break;
            }
            default: {
                RsPath rsPath2 = item.getPath();
                if (rsPath2 == null) {
                    return;
                }
                RsPath path = rsPath2;
                Object[] objectArray = new String[]{"all", "any", "not"};
                List<NameSuggestionFix<PsiElement>> fixes = NameSuggestionFix.Companion.createApplicable((PsiElement)path, itemName, CollectionsKt.listOf((Object[])objectArray), 1, arg_0 -> RsAttrErrorInspectionKt.checkCfgPredicate$lambda$2(path, arg_0));
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnknownCfgPredicate(path, itemName, fixes), holder, false, null, 4, null);
            }
            case "version": 
        }
    }

    private static final void checkDeriveAttr(RsMetaItem element, RsProblemsHolder holder) {
        Object object = element.getMetaItemArgs();
        if (object == null || (object = object.getLitExprList()) == null) {
            return;
        }
        Object args = object;
        Iterator iterator2 = args.iterator();
        while (iterator2.hasNext()) {
            RsRemoveQuotesFix rsRemoveQuotesFix;
            RsLitExpr arg = (RsLitExpr)iterator2.next();
            Intrinsics.checkNotNull((Object)arg);
            if (RsLitExprKt.getStringValue(arg) != null) {
                String it2;
                boolean bl = false;
                PsiFile psiFile = arg.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                TextRange textRange = arg.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                rsRemoveQuotesFix = new RsRemoveQuotesFix(psiFile, textRange, it2);
            } else {
                rsRemoveQuotesFix = null;
            }
            List fixes = CollectionsKt.listOfNotNull(rsRemoveQuotesFix);
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.LiteralValueInsideDeriveError(arg, fixes), holder, false, null, 6, null);
        }
    }

    private static final void checkReprAttr(RsMetaItem element, RsProblemsHolder holder, ProcessingContext context) {
        Object object = element.getMetaItemArgs();
        if (object == null || (object = object.getMetaItemList()) == null) {
            return;
        }
        Object args = object;
        RsDocAndAttributeOwner rsDocAndAttributeOwner = RsMetaItemKt.getOwner(element);
        if (rsDocAndAttributeOwner == null) {
            return;
        }
        RsDocAndAttributeOwner owner = rsDocAndAttributeOwner;
        Iterator iterator2 = args.iterator();
        while (iterator2.hasNext()) {
            RsMetaItem arg = (RsMetaItem)iterator2.next();
            Intrinsics.checkNotNull((Object)arg);
            RsAttrErrorInspectionKt.checkReprArg(arg, owner, holder);
        }
        RsEnumItem rsEnumItem = owner instanceof RsEnumItem ? (RsEnumItem)owner : null;
        if (rsEnumItem == null) {
            return;
        }
        RsEnumItem rsEnumItem2 = rsEnumItem;
        Object object2 = rsEnumItem2.getEnumBody();
        boolean bl = object2 != null && (object2 = object2.getEnumVariantList()) != null ? object2.isEmpty() : false;
        if (bl) {
            Object object3 = context.get(RsPsiPattern.INSTANCE.getMETA_ITEM_ATTR());
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.ReprForEmptyEnumError((RsAttr)object3, null, 2, null), holder, false, null, 6, null);
        }
    }

    private static final void checkReprArg(RsMetaItem reprArg, RsDocAndAttributeOwner owner, RsProblemsHolder holder) {
        String string = RsMetaItemKt.getName(reprArg);
        if (string == null) {
            return;
        }
        String reprName = string;
        if (Intrinsics.areEqual((Object)reprName, (Object)"align")) {
            RsAttrErrorInspectionKt.checkReprAlign(reprArg, holder);
        }
        RsAttrErrorInspectionKt.checkReprArgIsCorrectlyApplied(reprName, owner, reprArg, holder);
    }

    private static final void checkReprArgIsCorrectlyApplied(String reprName, RsDocAndAttributeOwner owner, RsMetaItem reprArg, RsProblemsHolder holder) {
        String string;
        String string2 = reprName;
        if (Intrinsics.areEqual((Object)string2, (Object)"C") || Intrinsics.areEqual((Object)string2, (Object)"Rust") || Intrinsics.areEqual((Object)string2, (Object)"transparent") || Intrinsics.areEqual((Object)string2, (Object)"align")) {
            RsDocAndAttributeOwner rsDocAndAttributeOwner = owner;
            if (rsDocAndAttributeOwner instanceof RsStructItem || rsDocAndAttributeOwner instanceof RsEnumItem) {
                return;
            }
            var7_6 = new Object[]{reprName};
            string = RsBundle.INSTANCE.message("inspection.message.attribute.should.be.applied.to.struct.enum.or.union", var7_6);
        } else if (TyInteger.Companion.getNAMES().contains(string2)) {
            if (owner instanceof RsEnumItem) {
                return;
            }
            var7_6 = new Object[]{reprName};
            string = RsBundle.INSTANCE.message("inspection.message.attribute.should.be.applied.to.enum", var7_6);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"packed") || Intrinsics.areEqual((Object)string2, (Object)"simd")) {
            if (owner instanceof RsStructItem) {
                return;
            }
            var7_6 = new Object[]{reprName};
            string = RsBundle.INSTANCE.message("inspection.message.attribute.should.be.applied.to.struct.or.union", var7_6);
        } else {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnrecognizedReprAttribute(reprArg, reprName), holder, false, null, 6, null);
            return;
        }
        String errorText = string;
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.ReprAttrUnsupportedItem(reprArg, errorText), holder, false, null, 6, null);
    }

    private static final void checkReprAlign(RsMetaItem align, RsProblemsHolder holder) {
        RsMetaItemArgs rsMetaItemArgs = align.getMetaItemArgs();
        List<RsLitExpr> args = rsMetaItemArgs != null ? rsMetaItemArgs.getLitExprList() : null;
        PsiElement eq = align.getEq();
        if (args == null && eq == null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.InvalidReprAlign(align, RsBundle.INSTANCE.message("inspection.message.align.needs.argument", new Object[0]), CollectionsKt.listOf((Object)((Object)new AddAttrParenthesesFix(align, "align")))), holder, false, null, 6, null);
        } else if (args == null && eq != null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IncorrectlyDeclaredAlignRepresentationHint((PsiElement)align, RsBundle.INSTANCE.message("inspection.message.incorrect.repr.align.attribute.format", new Object[0]), null, 4, null), holder, false, null, 6, null);
        } else if (args != null) {
            RsAttrErrorInspectionKt.checkReprAlignArgs(args, align, holder);
        }
    }

    private static final void checkReprAlignArgs(List<? extends RsLitExpr> args, RsMetaItem align, RsProblemsHolder holder) {
        if (args.size() != 1) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IncorrectlyDeclaredAlignRepresentationHint((PsiElement)align, RsBundle.INSTANCE.message("inspection.message.align.takes.exactly.one.argument.in.parentheses", new Object[0]), null, 4, null), holder, false, null, 6, null);
            return;
        }
        RsLitExpr arg = (RsLitExpr)CollectionsKt.first(args);
        RsLiteralKind kind2 = RsLiteralKindKt.getKind(arg);
        if (kind2 == null || !(kind2 instanceof RsLiteralKind.Integer) || ((RsLiteralKind.Integer)kind2).getSuffix() != null) {
            Object[] objectArray = new Object[]{"align(%s)"};
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.InvalidReprAlign(align, RsBundle.INSTANCE.message("inspection.message.align.argument.must.be.unsuffixed.integer", new Object[0]), CollectionsKt.listOfNotNull((Object)((Object)ConvertToUnsuffixedIntegerFix.Companion.createIfCompatible(arg, RsBundle.INSTANCE.message("intention.name.change.to1", objectArray))))), holder, false, null, 6, null);
            return;
        }
        Long l = RsLitExprKt.getIntegerValue(arg);
        if (l == null) {
            return;
        }
        long value = l;
        if (!UtilsKt.isPowerOfTwo(value)) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.InvalidReprAlign((PsiElement)align, RsBundle.INSTANCE.message("inspection.message.align.argument.must.be.power.two", new Object[0]), null, 4, null), holder, false, null, 6, null);
            return;
        }
        if (value > 0x20000000L) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.InvalidReprAlign((PsiElement)align, RsBundle.INSTANCE.message("inspection.message.align.argument.must.not.be.larger.than", new Object[0]), null, 4, null), holder, false, null, 6, null);
        }
    }

    private static final boolean checkRsDocAndAttributeOwner$lambda$0(RsMetaItem it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return BuiltinAttributesKt.getRS_BUILTIN_ATTRIBUTES().containsKey(RsMetaItemKt.getName(it2));
    }

    private static final RemoveElementFix checkRsDocAndAttributeOwner$getFix(RsMetaItem item) {
        PsiElement parent2 = item.getParent();
        return parent2 instanceof RsAttr ? (RemoveElementFix)new RsRemoveMetaItemFix(parent2) : (RemoveElementFix)new RsRemoveMetaItemFix(item);
    }

    private static final RsPath checkCfgPredicate$lambda$2(RsPath $path, String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Project project = $path.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPath rsPath = RsPsiFactory.tryCreatePath$default(new RsPsiFactory(project, false, false, 6, null), name2, null, 2, null);
        if (rsPath == null) {
            throw new IllegalStateException(("Cannot create path out of " + name2).toString());
        }
        return rsPath;
    }

    public static final /* synthetic */ void access$checkMetaBadDelim(RsMetaItem element, RsProblemsHolder holder) {
        RsAttrErrorInspectionKt.checkMetaBadDelim(element, holder);
    }

    public static final /* synthetic */ void access$checkAttrTemplateCompatible(RsMetaItem metaItem, RsProblemsHolder holder) {
        RsAttrErrorInspectionKt.checkAttrTemplateCompatible(metaItem, holder);
    }

    public static final /* synthetic */ void access$checkLiteralSuffix(RsMetaItem metaItem, RsProblemsHolder holder) {
        RsAttrErrorInspectionKt.checkLiteralSuffix(metaItem, holder);
    }

    public static final /* synthetic */ void access$checkDeprecatedAttr(RsMetaItem element, RsProblemsHolder holder) {
        RsAttrErrorInspectionKt.checkDeprecatedAttr(element, holder);
    }

    public static final /* synthetic */ void access$checkFeatureAttribute(RsMetaItem item, RsProblemsHolder holder, ProcessingContext context) {
        RsAttrErrorInspectionKt.checkFeatureAttribute(item, holder, context);
    }

    public static final /* synthetic */ void access$checkRootCfgPredicate(RsMetaItem element, RsProblemsHolder holder, boolean allowMultiple) {
        RsAttrErrorInspectionKt.checkRootCfgPredicate(element, holder, allowMultiple);
    }

    public static final /* synthetic */ void access$checkReprAttr(RsMetaItem element, RsProblemsHolder holder, ProcessingContext context) {
        RsAttrErrorInspectionKt.checkReprAttr(element, holder, context);
    }

    public static final /* synthetic */ void access$checkDeriveAttr(RsMetaItem element, RsProblemsHolder holder) {
        RsAttrErrorInspectionKt.checkDeriveAttr(element, holder);
    }

    public static final /* synthetic */ void access$checkRsDocAndAttributeOwner(RsDocAndAttributeOwner element, RsProblemsHolder holder) {
        RsAttrErrorInspectionKt.checkRsDocAndAttributeOwner(element, holder);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AttributeDuplicates.values().length];
            try {
                nArray[AttributeDuplicates.DuplicatesOk.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeDuplicates.WarnFollowing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeDuplicates.WarnFollowingWordOnly.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeDuplicates.ErrorFollowing.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeDuplicates.ErrorPreceding.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeDuplicates.FutureWarnFollowing.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeDuplicates.FutureWarnPreceding.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AttributeTemplateType.values().length];
            try {
                nArray[AttributeTemplateType.List.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeTemplateType.NameValueStr.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeTemplateType.Word.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

