/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/annotator/AnnotatorBase;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateInternal", "isSmartModeAndNoScanning", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.rustrover.core"})
public abstract class AnnotatorBase
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Class<? extends AnnotatorBase>> enabledAnnotators;

    public final void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (Companion.isEnabled(this.getClass())) {
            this.annotateInternal(element, holder);
        }
    }

    protected abstract void annotateInternal(@NotNull PsiElement var1, @NotNull AnnotationHolder var2);

    protected final boolean isSmartModeAndNoScanning(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DumbService.Companion.getInstance(project).canRunSmart();
    }

    static {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        enabledAnnotators = keySetView;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/annotator/AnnotatorBase$Companion;", "", "<init>", "()V", "enabledAnnotators", "", "Ljava/lang/Class;", "Lorg/rust/ide/annotator/AnnotatorBase;", "enableAnnotator", "", "annotatorClass", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "isEnabled", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void enableAnnotator(@NotNull Class<? extends AnnotatorBase> annotatorClass, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(annotatorClass, (String)"annotatorClass");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ((Collection)enabledAnnotators).add(annotatorClass);
            Disposer.register((Disposable)parentDisposable, () -> Companion.enableAnnotator$lambda$0(annotatorClass));
        }

        public final boolean isEnabled(@NotNull Class<? extends AnnotatorBase> annotatorClass) {
            Intrinsics.checkNotNullParameter(annotatorClass, (String)"annotatorClass");
            return !UtilsKt.isUnitTestMode() || enabledAnnotators.contains(annotatorClass);
        }

        private static final void enableAnnotator$lambda$0(Class $annotatorClass) {
            ((Collection)enabledAnnotators).remove($annotatorClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

