/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.actions.ui.CargoNewCrateSettings;
import org.rust.ide.actions.ui.CargoNewCrateUI;
import org.rust.ide.newProject.RsPackageNameValidator;
import org.rust.openapiext.UiKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/rust/ide/actions/ui/CargoNewCrateDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lorg/rust/ide/actions/ui/CargoNewCrateUI;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "typeCombobox", "Lcom/intellij/openapi/ui/ComboBox;", "", "kotlin.jvm.PlatformType", "name", "Lcom/intellij/ui/components/JBTextField;", "binary", "", "getBinary", "()Z", "crateName", "getCrateName", "()Ljava/lang/String;", "selectCargoCrateSettings", "Lorg/rust/ide/actions/ui/CargoNewCrateSettings;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.rustrover.core"})
public final class CargoNewCrateDialog
extends DialogWrapper
implements CargoNewCrateUI {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final ComboBox<String> typeCombobox;
    @NotNull
    private final JBTextField name;

    public CargoNewCrateDialog(@NotNull Project project, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(project);
        this.root = root;
        Object[] objectArray = new String[]{"Binary", "Library"};
        this.typeCombobox = new ComboBox(objectArray);
        this.name = new JBTextField(20);
        this.setTitle(RsBundle.INSTANCE.message("dialog.title.new.cargo.crate", new Object[0]));
        this.init();
    }

    public final boolean getBinary() {
        return this.typeCombobox.getSelectedIndex() == 0;
    }

    @NotNull
    public final String getCrateName() {
        return UiKt.getTrimmedText(this.name);
    }

    @Override
    @Nullable
    public CargoNewCrateSettings selectCargoCrateSettings() {
        boolean result2 = this.showAndGet();
        if (!result2) {
            return null;
        }
        return new CargoNewCrateSettings(this.getBinary(), this.getCrateName());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> CargoNewCrateDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.name;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String validationError;
        String name2 = this.getCrateName();
        String string = validationError = RsPackageNameValidator.INSTANCE.validate(name2, this.getBinary());
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            String error = it2;
            return new ValidationInfo(error, (JComponent)this.name);
        }
        if (this.root.findChild(name2) != null) {
            Object[] objectArray = new Object[]{name2};
            return new ValidationInfo(RsBundle.INSTANCE.message("dialog.message.directory.already.exists", objectArray), (JComponent)this.name);
        }
        return null;
    }

    private static final Unit createCenterPanel$lambda$0(CargoNewCrateDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(RsBundle.INSTANCE.message("name", new Object[0]), arg_0 -> CargoNewCrateDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        $this$panel.row(RsBundle.INSTANCE.message("type", new Object[0]), arg_0 -> CargoNewCrateDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(CargoNewCrateDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.name);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(CargoNewCrateDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.typeCombobox);
        return Unit.INSTANCE;
    }
}

