/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions.mover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H$J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0014J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0014J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0014\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/actions/mover/RsLineMover;", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineMover;", "<init>", "()V", "checkAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "info", "Lcom/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover$MoveInfo;", "down", "findMovableAncestor", "Lcom/intellij/psi/PsiElement;", "psi", "endpoint", "Lorg/rust/ide/actions/mover/RsLineMover$Companion$RangeEndpoint;", "findTargetElement", "sibling", "fixupSibling", "canApply", "firstMovableElement", "secondMovableElement", "findTargetWhitespace", "Lcom/intellij/psi/PsiWhiteSpace;", "Companion", "intellij.rustrover.core"})
public abstract class RsLineMover
extends LineMover {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange sourceRange;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!(file instanceof RsFile)) {
            return false;
        }
        if (!super.checkAvailable(editor2, file, info, down)) {
            return false;
        }
        LineRange lineRange = info.toMove;
        if (lineRange == null) {
            return false;
        }
        LineRange originalRange = lineRange;
        Pair pair = StatementUpDownMover.getElementRange((Editor)editor2, (PsiFile)file, (LineRange)originalRange);
        if (pair == null) {
            return false;
        }
        Pair psiRange = pair;
        if (psiRange.first == null || psiRange.second == null) {
            return false;
        }
        Object object = psiRange.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        PsiElement psiElement2 = this.findMovableAncestor((PsiElement)object, Companion.RangeEndpoint.START);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement firstItem = psiElement2;
        Object object2 = psiRange.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        PsiElement psiElement3 = this.findMovableAncestor((PsiElement)object2, Companion.RangeEndpoint.END);
        if (psiElement3 == null) {
            return false;
        }
        PsiElement lastItem = psiElement3;
        if (!this.canApply(firstItem, lastItem)) {
            info.toMove2 = null;
            return true;
        }
        PsiElement sibling = StatementUpDownMover.firstNonWhiteElement((PsiElement)(down ? lastItem.getNextSibling() : firstItem.getPrevSibling()), (boolean)down);
        if (sibling != null) {
            sibling = this.fixupSibling(sibling, down);
        }
        if (sibling == null) {
            info.toMove2 = null;
            return true;
        }
        info.toMove = sourceRange = new LineRange(firstItem, lastItem);
        info.toMove.firstElement = firstItem;
        info.toMove.lastElement = lastItem;
        PsiWhiteSpace whitespace = this.findTargetWhitespace(sibling, down);
        if (whitespace != null) {
            int nearLine = down ? sourceRange.endLine : sourceRange.startLine - 1;
            info.toMove2 = new LineRange(nearLine, nearLine + 1);
            info.toMove2.firstElement = (PsiElement)whitespace;
        } else {
            PsiElement target = this.findTargetElement(sibling, down);
            if (target != null) {
                info.toMove2 = new LineRange(target);
                info.toMove2.firstElement = target;
            } else {
                info.toMove2 = null;
            }
        }
        return true;
    }

    @Nullable
    protected abstract PsiElement findMovableAncestor(@NotNull PsiElement var1, @NotNull Companion.RangeEndpoint var2);

    @Nullable
    protected abstract PsiElement findTargetElement(@NotNull PsiElement var1, boolean var2);

    @Nullable
    protected PsiElement fixupSibling(@NotNull PsiElement sibling, boolean down) {
        Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
        return sibling;
    }

    protected boolean canApply(@NotNull PsiElement firstMovableElement, @NotNull PsiElement secondMovableElement) {
        Intrinsics.checkNotNullParameter((Object)firstMovableElement, (String)"firstMovableElement");
        Intrinsics.checkNotNullParameter((Object)secondMovableElement, (String)"secondMovableElement");
        return true;
    }

    @Nullable
    protected PsiWhiteSpace findTargetWhitespace(@NotNull PsiElement sibling, boolean down) {
        Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/actions/mover/RsLineMover$Companion;", "", "<init>", "()V", "isMovingOutOfBraceBlock", "", "sibling", "Lcom/intellij/psi/PsiElement;", "down", "isMovingOutOfParenBlock", "isMovingOutOfBracketBlock", "isMovingOutOfFunctionBody", "isMovingOutOfMatchArmBlock", "isMovingOutOfBlockExprInsideArgList", "RangeEndpoint", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsLineMover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLineMover.kt\norg/rust/ide/actions/mover/RsLineMover$Companion\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,112:1\n9#2:113\n9#2:114\n*S KotlinDebug\n*F\n+ 1 RsLineMover.kt\norg/rust/ide/actions/mover/RsLineMover$Companion\n*L\n100#1:113\n101#1:114\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMovingOutOfBraceBlock(@NotNull PsiElement sibling, boolean down) {
            Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
            return Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(sibling), (Object)(down ? RsElementTypes.RBRACE : RsElementTypes.LBRACE));
        }

        public final boolean isMovingOutOfParenBlock(@NotNull PsiElement sibling, boolean down) {
            Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
            return Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(sibling), (Object)(down ? RsElementTypes.RPAREN : RsElementTypes.LPAREN));
        }

        public final boolean isMovingOutOfBracketBlock(@NotNull PsiElement sibling, boolean down) {
            Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
            return Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(sibling), (Object)(down ? RsElementTypes.RBRACK : RsElementTypes.LBRACK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isMovingOutOfFunctionBody(@NotNull PsiElement sibling, boolean down) {
            Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
            if (!this.isMovingOutOfBraceBlock(sibling, down)) return false;
            PsiElement psiElement2 = sibling.getParent();
            if (!((psiElement2 != null ? psiElement2.getParent() : null) instanceof RsFunction)) return false;
            return true;
        }

        public final boolean isMovingOutOfMatchArmBlock(@NotNull PsiElement sibling, boolean down) {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
            return this.isMovingOutOfBraceBlock(sibling, down) && ((psiElement2 = sibling.getParent()) != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getParent() : null) instanceof RsMatchArm;
        }

        public final boolean isMovingOutOfBlockExprInsideArgList(@NotNull PsiElement sibling, boolean down) {
            Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
            if (!this.isMovingOutOfBraceBlock(sibling, down)) {
                return false;
            }
            PsiElement $this$ancestorStrict$iv = sibling;
            boolean $i$f$ancestorStrict = false;
            RsBlockExpr rsBlockExpr = (RsBlockExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsBlockExpr.class, (boolean)true);
            if (rsBlockExpr == null) {
                return false;
            }
            RsBlockExpr blockExpr = rsBlockExpr;
            PsiElement $this$ancestorStrict$iv2 = blockExpr;
            boolean $i$f$ancestorStrict2 = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv2, RsValueArgumentList.class, (boolean)true) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/actions/mover/RsLineMover$Companion$RangeEndpoint;", "", "<init>", "(Ljava/lang/String;I)V", "START", "END", "intellij.rustrover.core"})
        public static final class RangeEndpoint
        extends Enum<RangeEndpoint> {
            public static final /* enum */ RangeEndpoint START = new RangeEndpoint();
            public static final /* enum */ RangeEndpoint END = new RangeEndpoint();
            private static final /* synthetic */ RangeEndpoint[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static RangeEndpoint[] values() {
                return (RangeEndpoint[])$VALUES.clone();
            }

            public static RangeEndpoint valueOf(String value) {
                return Enum.valueOf(RangeEndpoint.class, value);
            }

            @NotNull
            public static EnumEntries<RangeEndpoint> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = rangeEndpointArray = new RangeEndpoint[]{RangeEndpoint.START, RangeEndpoint.END};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

