/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions.mover;

import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.actions.mover.RsLineMover;
import org.rust.ide.actions.mover.UpDownMoverTestMarks;
import org.rust.ide.formatter.impl.CommaList;
import org.rust.ide.formatter.processors.RsTrailingCommaFormatProcessorKt;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0014J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/actions/mover/RsCommaListElementUpDownMover;", "Lorg/rust/ide/actions/mover/RsLineMover;", "<init>", "()V", "findMovableAncestor", "Lcom/intellij/psi/PsiElement;", "psi", "endpoint", "Lorg/rust/ide/actions/mover/RsLineMover$Companion$RangeEndpoint;", "findListElement", "fixupSibling", "sibling", "down", "", "findTargetElement", "beforeMove", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "info", "Lcom/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover$MoveInfo;", "intellij.rustrover.core"})
public final class RsCommaListElementUpDownMover
extends RsLineMover {
    @Override
    @Nullable
    protected PsiElement findMovableAncestor(@NotNull PsiElement psi, @NotNull RsLineMover.Companion.RangeEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        if (psi instanceof RsMatchArm) {
            return null;
        }
        PsiElement psi2 = endpoint == RsLineMover.Companion.RangeEndpoint.END && Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(psi), (Object)RsElementTypes.COMMA) ? psi.getPrevSibling() : psi;
        Intrinsics.checkNotNull((Object)psi2);
        return this.findListElement(psi2);
    }

    private final PsiElement findListElement(PsiElement psi) {
        for (Pair pair : PsiElementKt.getAncestorPairs(psi)) {
            PsiElement child = (PsiElement)pair.component1();
            PsiElement parent2 = (PsiElement)pair.component2();
            if (parent2 instanceof RsBlockExpr) {
                return null;
            }
            CommaList list = CommaList.Companion.forElement(parent2);
            if (list == null || !((Boolean)list.isElement().invoke((Object)child)).booleanValue()) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiElement fixupSibling(@NotNull PsiElement sibling, boolean down) {
        Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
        return Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(sibling), (Object)RsElementTypes.COMMA) ? StatementUpDownMover.firstNonWhiteElement((PsiElement)(down ? sibling.getNextSibling() : sibling.getPrevSibling()), (boolean)down) : sibling;
    }

    @Override
    @Nullable
    protected PsiElement findTargetElement(@NotNull PsiElement sibling, boolean down) {
        Intrinsics.checkNotNullParameter((Object)sibling, (String)"sibling");
        if (RsLineMover.Companion.isMovingOutOfParenBlock(sibling, down) || RsLineMover.Companion.isMovingOutOfBraceBlock(sibling, down) || RsLineMover.Companion.isMovingOutOfBracketBlock(sibling, down)) {
            UpDownMoverTestMarks.MoveOutOfBlock.INSTANCE.hit();
            return null;
        }
        return sibling;
    }

    public void beforeMove(@NotNull Editor editor2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Project project = editor2.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        Object[] objectArray = new PsiElement[]{info.toMove.firstElement, info.toMove.lastElement, info.toMove2.firstElement};
        for (PsiElement element : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            CommaList commaList;
            PsiElement list = element.getParent();
            Intrinsics.checkNotNull((Object)list);
            if (CommaList.Companion.forElement(list) == null || !((Boolean)commaList.isElement().invoke((Object)element)).booleanValue() || !RsTrailingCommaFormatProcessorKt.isOnSameLineAsLastElement(commaList, list, element)) continue;
            RsTrailingCommaFormatProcessorKt.addTrailingCommaForElement(commaList, list);
        }
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
    }
}

