/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions.macroExpansion;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.actions.macroExpansion.MacroExpansionViewDetails;
import org.rust.ide.actions.macroExpansion.MacroExpansionViewUtilsKt;
import org.rust.ide.actions.macroExpansion.RsShowMacroExpansionActionsKt;
import org.rust.lang.core.macros.errors.GetMacroExpansionError;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.openapiext.EditorKt;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0015J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/actions/macroExpansion/RsShowMacroExpansionActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "expandRecursively", "", "<init>", "(Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "performForContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "showExpansion", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expansionDetails", "Lorg/rust/ide/actions/macroExpansion/MacroExpansionViewDetails;", "showError", "error", "Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "Companion", "intellij.rustrover.core"})
public abstract class RsShowMacroExpansionActionBase
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean expandRecursively;

    public RsShowMacroExpansionActionBase(boolean expandRecursively) {
        this.expandRecursively = expandRecursively;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        presentation.setEnabledAndVisible(RsShowMacroExpansionActionsKt.getMacroUnderCaret(dataContext) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        this.performForContext(dataContext);
    }

    @VisibleForTesting
    public final void performForContext(@NotNull DataContext e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = UtilsKt.getProject(e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor2 = UtilsKt.getEditor(e);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        RsPossibleMacroCall rsPossibleMacroCall = RsShowMacroExpansionActionsKt.getMacroUnderCaret(e);
        if (rsPossibleMacroCall == null) {
            return;
        }
        RsPossibleMacroCall macroToExpand = rsPossibleMacroCall;
        RsResult<MacroExpansionViewDetails, GetMacroExpansionError> expansionDetails = MacroExpansionViewUtilsKt.expandMacroForViewWithProgress(project2, macroToExpand, this.expandRecursively);
        if (expansionDetails instanceof RsResult.Ok) {
            this.showExpansion(project2, editor3, (MacroExpansionViewDetails)((RsResult.Ok)expansionDetails).getOk());
        } else if (expansionDetails instanceof RsResult.Err) {
            this.showError(editor3, (GetMacroExpansionError)((RsResult.Err)expansionDetails).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @VisibleForTesting
    protected void showExpansion(@NotNull Project project, @NotNull Editor editor2, @NotNull MacroExpansionViewDetails expansionDetails) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expansionDetails, (String)"expansionDetails");
        MacroExpansionViewUtilsKt.showMacroExpansionPopup(project, editor2, expansionDetails);
    }

    @VisibleForTesting
    protected void showError(@NotNull Editor editor2, @NotNull GetMacroExpansionError error) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Companion.showMacroExpansionError(editor2, error);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/ide/actions/macroExpansion/RsShowMacroExpansionActionBase$Companion;", "", "<init>", "()V", "showMacroExpansionError", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "error", "Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void showMacroExpansionError(@NotNull Editor editor2, @NotNull GetMacroExpansionError error) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Object[] objectArray = new Object[]{error.toUserViewableMessage()};
            EditorKt.showErrorHint(editor2, RsBundle.INSTANCE.message("macro.expansion.error.start", objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

