/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions.macroExpansion;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.DocumentUtil;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.actions.macroExpansion.MacroExpansionViewComponent;
import org.rust.ide.actions.macroExpansion.MacroExpansionViewDetails;
import org.rust.lang.RsFileType;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.MacroExpansionContext;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.macros.errors.GetMacroExpansionError;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsProcMacroPsiUtil;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsPsiManager;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKind;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a6\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\t\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003\u001a8\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\tH\u0002\u001a \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\t\u001a\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u001a\u0010\u001d\u001a\u00020\u001e*\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u001a\n\u0010\"\u001a\u00020#*\u00020\u0005\u00a8\u0006$"}, d2={"expandMacroForViewWithProgress", "Lorg/rust/stdext/RsResult;", "Lorg/rust/ide/actions/macroExpansion/MacroExpansionViewDetails;", "Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "project", "Lcom/intellij/openapi/project/Project;", "ctx", "Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;", "expandRecursively", "", "showMacroExpansionPopup", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "expansionDetails", "expandMacroForView", "macroToExpand", "sizeLimit", "", "hasWriteAccess", "getMacroExpansionViewTitle", "", "getMacroExpansions", "Lorg/rust/lang/core/macros/MacroExpansion;", "reformatMacroExpansion", "expansion", "formatPsiFile", "element", "Lcom/intellij/psi/PsiFile;", "createReadOnlyEditorWithElements", "Lcom/intellij/openapi/editor/ex/EditorEx;", "expansions", "", "Lcom/intellij/psi/PsiElement;", "createRustHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionViewUtils.kt\norg/rust/ide/actions/macroExpansion/MacroExpansionViewUtilsKt\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 3 RsResult.kt\norg/rust/stdext/RsResult\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n60#2,4:231\n34#3,4:235\n1#4:239\n*S KotlinDebug\n*F\n+ 1 MacroExpansionViewUtils.kt\norg/rust/ide/actions/macroExpansion/MacroExpansionViewUtilsKt\n*L\n90#1:231,4\n141#1:235,4\n*E\n"})
public final class MacroExpansionViewUtilsKt {
    @NotNull
    public static final RsResult<MacroExpansionViewDetails, GetMacroExpansionError> expandMacroForViewWithProgress(@NotNull Project project, @NotNull RsPossibleMacroCall ctx, boolean expandRecursively) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object[] objectArray = new Object[]{expandRecursively ? 0 : 1};
        String progressTitle = RsBundle.INSTANCE.message("progress.title.choice.recursive.single.step.expansion.progress", objectArray);
        return (RsResult)UtilsKt.computeWithCancelableProgress(project, progressTitle, () -> MacroExpansionViewUtilsKt.expandMacroForViewWithProgress$lambda$0(ctx, expandRecursively));
    }

    public static final void showMacroExpansionPopup(@NotNull Project project, @NotNull Editor editor2, @NotNull MacroExpansionViewDetails expansionDetails) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expansionDetails, (String)"expansionDetails");
        MacroExpansion formattedExpansion = MacroExpansionViewUtilsKt.reformatMacroExpansion$default(expansionDetails.getMacroToExpand(), expansionDetails.getExpansion(), false, 4, null);
        MacroExpansionViewComponent component = new MacroExpansionViewComponent(formattedExpansion);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setProject(project).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(expansionDetails.getTitle()).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        PopupPositionManager.positionPopupInBestPosition((JBPopup)popup2, (Editor)editor2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RsResult<MacroExpansionViewDetails, GetMacroExpansionError> expandMacroForView(@NotNull RsPossibleMacroCall macroToExpand, boolean expandRecursively, int sizeLimit, boolean hasWriteAccess) {
        void $this$unwrapOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)macroToExpand, (String)"macroToExpand");
        RsResult<MacroExpansion, GetMacroExpansionError> rsResult = MacroExpansionViewUtilsKt.getMacroExpansions(macroToExpand, expandRecursively, sizeLimit, hasWriteAccess);
        boolean $i$f$unwrapOrElse = false;
        void var7_6 = $this$unwrapOrElse$iv;
        if (!(var7_6 instanceof RsResult.Ok)) {
            if (var7_6 instanceof RsResult.Err) {
                GetMacroExpansionError it2 = (GetMacroExpansionError)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return new RsResult.Err<GetMacroExpansionError>(it2);
            }
            throw new NoWhenBranchMatchedException();
        }
        MacroExpansion expansions = (MacroExpansion)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        return new RsResult.Ok<MacroExpansionViewDetails>(new MacroExpansionViewDetails(macroToExpand, MacroExpansionViewUtilsKt.getMacroExpansionViewTitle(macroToExpand, expandRecursively), expansions));
    }

    public static /* synthetic */ RsResult expandMacroForView$default(RsPossibleMacroCall rsPossibleMacroCall, boolean bl, int n, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return MacroExpansionViewUtilsKt.expandMacroForView(rsPossibleMacroCall, bl, n, bl2);
    }

    @NlsContexts.PopupTitle
    private static final String getMacroExpansionViewTitle(RsPossibleMacroCall macroToExpand, boolean expandRecursively) {
        String string;
        Object object;
        RsPath rsPath = macroToExpand.getPath();
        String path = rsPath != null ? rsPath.getText() : null;
        RsPossibleMacroCallKind kind2 = RsPossibleMacroCallKt.getKind(macroToExpand);
        if (kind2 instanceof RsPossibleMacroCallKind.MacroCall) {
            Object[] objectArray = new Object[1];
            String string2 = path;
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = string2;
            object = RsBundle.INSTANCE.message("popup.title.macro", objectArray);
        } else if (kind2 instanceof RsPossibleMacroCallKind.MetaItem) {
            object = RsProcMacroPsiUtil.INSTANCE.canBeCustomDerive(((RsPossibleMacroCallKind.MetaItem)kind2).getMeta()) ? "#[derive(" + path + ")]" : "#[" + path + "]";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Object name2 = object;
        if (expandRecursively) {
            var4_3 = new Object[]{name2};
            string = RsBundle.INSTANCE.message("popup.title.recursive.expansion", var4_3);
        } else {
            var4_3 = new Object[]{name2};
            string = RsBundle.INSTANCE.message("popup.title.first.level.expansion", var4_3);
        }
        return string;
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> getMacroExpansions(RsPossibleMacroCall macroToExpand, boolean expandRecursively, int sizeLimit, boolean hasWriteAccess) {
        RsResult rsResult;
        RsResult<MacroExpansion, GetMacroExpansionError> singleStepExpansion = RsPossibleMacroCallKt.getExpansionResult(macroToExpand);
        if (singleStepExpansion instanceof RsResult.Err) {
            return singleStepExpansion;
        }
        int depthLimit = expandRecursively ? Integer.MAX_VALUE : 1;
        String string = RsPossibleMacroCallKt.expandMacrosRecursively$default(macroToExpand, depthLimit, true, sizeLimit, null, 8, null);
        if (string == null) {
            return new RsResult.Err<GetMacroExpansionError.TooLargeExpansion>(GetMacroExpansionError.TooLargeExpansion.INSTANCE);
        }
        String expansionText = string;
        MacroExpansionContext macroExpansionContext = MacroExpansionKt.getExpansionContext(macroToExpand);
        Project project = macroToExpand.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsResult<MacroExpansion, Unit> this_$iv = RsResultKt.toResult(MacroExpansionKt.parseExpandedTextWithContext(macroExpansionContext, new RsPsiFactory(project, false, hasWriteAccess), expansionText));
        boolean $i$f$mapErr = false;
        RsResult<MacroExpansion, Unit> rsResult2 = this_$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            rsResult = new RsResult.Ok(((RsResult.Ok)this_$iv).getOk());
        } else if (rsResult2 instanceof RsResult.Err) {
            Unit it2 = (Unit)((RsResult.Err)this_$iv).getErr();
            boolean bl = false;
            GetMacroExpansionError.MemExpParsingError memExpParsingError = new GetMacroExpansionError.MemExpParsingError(expansionText, MacroExpansionKt.getExpansionContext(macroToExpand));
            rsResult = new RsResult.Err<GetMacroExpansionError.MemExpParsingError>(memExpParsingError);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    static /* synthetic */ RsResult getMacroExpansions$default(RsPossibleMacroCall rsPossibleMacroCall, boolean bl, int n, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return MacroExpansionViewUtilsKt.getMacroExpansions(rsPossibleMacroCall, bl, n, bl2);
    }

    @NotNull
    public static final MacroExpansion reformatMacroExpansion(@NotNull RsPossibleMacroCall macroToExpand, @NotNull MacroExpansion expansion, boolean hasWriteAccess) {
        RsFile rsFile;
        Intrinsics.checkNotNullParameter((Object)macroToExpand, (String)"macroToExpand");
        Intrinsics.checkNotNullParameter((Object)expansion, (String)"expansion");
        RsFile it2 = rsFile = expansion.getFile();
        boolean bl = false;
        RsFile rsFile2 = it2.getVirtualFile() == null ? rsFile : null;
        if (rsFile2 == null) {
            Project project = expansion.getFile().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsPsiFactory rsPsiFactory = new RsPsiFactory(project, false, true, 2, null);
            String string = expansion.getFile().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            rsFile2 = rsPsiFactory.createFile(string);
        }
        RsFile file = rsFile2;
        RsPsiManager.Companion.withIgnoredPsiEvents((PsiFile)file, () -> MacroExpansionViewUtilsKt.reformatMacroExpansion$lambda$1(hasWriteAccess, file));
        MacroExpansion macroExpansion = MacroExpansionKt.getExpansionFromExpandedFile(MacroExpansionKt.getExpansionContext(macroToExpand), file);
        if (macroExpansion == null) {
            throw new IllegalStateException("Can't recover macro expansion after reformat".toString());
        }
        return macroExpansion;
    }

    public static /* synthetic */ MacroExpansion reformatMacroExpansion$default(RsPossibleMacroCall rsPossibleMacroCall, MacroExpansion macroExpansion, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return MacroExpansionViewUtilsKt.reformatMacroExpansion(rsPossibleMacroCall, macroExpansion, bl);
    }

    private static final void formatPsiFile(PsiFile element) {
        CodeStyleManager.getInstance((Project)element.getProject()).reformatText(element, PsiElementKt.getStartOffset((PsiElement)element), PsiElementKt.getEndOffset((PsiElement)element));
    }

    private static final EditorEx createReadOnlyEditorWithElements(Project $this$createReadOnlyEditorWithElements, Collection<? extends PsiElement> expansions) {
        EditorFactory factory2 = EditorFactory.getInstance();
        String text = !expansions.isEmpty() ? CollectionsKt.joinToString$default((Iterable)expansions, (CharSequence)"\n", null, null, (int)0, null, MacroExpansionViewUtilsKt::createReadOnlyEditorWithElements$lambda$0, (int)30, null) : "/* " + RsBundle.INSTANCE.message("macro.expansion.view.empty.comment", new Object[0]) + " */";
        Document document = factory2.createDocument((CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document doc = document;
        doc.setReadOnly(true);
        Editor editor2 = factory2.createEditor(doc, $this$createReadOnlyEditorWithElements);
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        return (EditorEx)editor2;
    }

    @NotNull
    public static final EditorHighlighter createRustHighlighter(@NotNull Project $this$createRustHighlighter) {
        Intrinsics.checkNotNullParameter((Object)$this$createRustHighlighter, (String)"<this>");
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((Project)$this$createRustHighlighter, (FileType)((FileType)RsFileType.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
        return editorHighlighter;
    }

    private static final RsResult expandMacroForViewWithProgress$lambda$0(RsPossibleMacroCall $ctx, boolean $expandRecursively) {
        return (RsResult)ActionsKt.runReadAction(() -> MacroExpansionViewUtilsKt.expandMacroForViewWithProgress$lambda$0$0($ctx, $expandRecursively));
    }

    private static final RsResult expandMacroForViewWithProgress$lambda$0$0(RsPossibleMacroCall $ctx, boolean $expandRecursively) {
        return MacroExpansionViewUtilsKt.expandMacroForView$default($ctx, $expandRecursively, 0, false, 12, null);
    }

    private static final Unit reformatMacroExpansion$lambda$1(boolean $hasWriteAccess, RsFile $file) {
        if ($hasWriteAccess) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> MacroExpansionViewUtilsKt.reformatMacroExpansion$lambda$1$0($file));
        } else {
            MacroExpansionViewUtilsKt.formatPsiFile((PsiFile)$file);
        }
        return Unit.INSTANCE;
    }

    private static final void reformatMacroExpansion$lambda$1$0(RsFile $file) {
        MacroExpansionViewUtilsKt.formatPsiFile((PsiFile)$file);
    }

    private static final CharSequence createReadOnlyEditorWithElements$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        String string = it2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public static final /* synthetic */ EditorEx access$createReadOnlyEditorWithElements(Project $receiver, Collection expansions) {
        return MacroExpansionViewUtilsKt.createReadOnlyEditorWithElements($receiver, expansions);
    }
}

