/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions.diagnostic;

import com.intellij.ide.FeedbackDescriptionProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u000f\u001a\u00020\u0005*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/actions/diagnostic/RsFeedbackDescriptionProvider;", "Lcom/intellij/ide/FeedbackDescriptionProvider;", "<init>", "()V", "getDescription", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEnvironmentInfo", "buildEnvironmentInfo", "pluginVersion", "toolchainVersion", "macroExpansionState", "additionalRegistryOptions", "displayText", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "getDisplayText", "(Lorg/rust/cargo/toolchain/impl/RustcVersion;)Ljava/lang/String;", "logLicenseMetadata", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsFeedbackDescriptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsFeedbackDescriptionProvider.kt\norg/rust/ide/actions/diagnostic/RsFeedbackDescriptionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n13#3:100\n*S KotlinDebug\n*F\n+ 1 RsFeedbackDescriptionProvider.kt\norg/rust/ide/actions/diagnostic/RsFeedbackDescriptionProvider\n*L\n45#1:97\n45#1:98,2\n93#1:100\n*E\n"})
public final class RsFeedbackDescriptionProvider
implements FeedbackDescriptionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Nullable
    public Object getDescription(@Nullable Project project, @NotNull Continuation<? super String> $completion) {
        String string;
        if (project != null && (PlatformUtils.isRustRover() || org.rust.cargo.runconfig.UtilsKt.getHasCargoProject(project))) {
            this.logLicenseMetadata();
            string = this.getEnvironmentInfo(project);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getEnvironmentInfo(Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String pluginVersion = UtilsKt.plugin().getVersion();
        RustcVersion rustcVersion = (RustcVersion)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CargoProjectServiceKt.getCargoProjects(project).getAllProjects()), RsFeedbackDescriptionProvider::getEnvironmentInfo$lambda$0));
        String toolchainVersion = rustcVersion != null ? this.getDisplayText(rustcVersion) : null;
        String macroExpansionState = WhenMappings.$EnumSwitchMapping$0[RustProjectSettingsServiceKt.getRustSettings(project).getMacroExpansionEngine().ordinal()] == 1 ? "disabled" : "enabled";
        Iterable iterable = Registry.Companion.getAll();
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RegistryValue it2 = (RegistryValue)element$iv$iv;
            boolean bl = false;
            if (!it2.isChangedFromDefault()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String additionalRegistryOptions = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, RsFeedbackDescriptionProvider::getEnvironmentInfo$lambda$2, (int)30, null);
        Intrinsics.checkNotNull((Object)pluginVersion);
        return this.buildEnvironmentInfo(pluginVersion, toolchainVersion, macroExpansionState, additionalRegistryOptions);
    }

    private final String buildEnvironmentInfo(String pluginVersion, String toolchainVersion, String macroExpansionState, String additionalRegistryOptions) {
        return StringsKt.trimIndent((String)((Object)StringsKt.trimEnd((CharSequence)("\n            *Rust plugin version:* " + pluginVersion + "\n            *Rust toolchain version:* " + toolchainVersion + "\n            *Macro expansion:* " + macroExpansionState + "\n            " + (String)(((CharSequence)additionalRegistryOptions).length() > 0 ? "*Registry options:* " + additionalRegistryOptions : "") + "\n        "))).toString());
    }

    private final String getDisplayText(RustcVersion $this$displayText) {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_displayText__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_displayText__u24lambda_u240.append($this$displayText.getSemver().getParsedVersion());
        if ($this$displayText.getCommitHash() != null) {
            $this$_get_displayText__u24lambda_u240.append(" (");
            $this$_get_displayText__u24lambda_u240.append(StringsKt.take((String)$this$displayText.getCommitHash(), (int)9));
            if ($this$displayText.getCommitDate() != null) {
                $this$_get_displayText__u24lambda_u240.append(" ");
                $this$_get_displayText__u24lambda_u240.append($this$displayText.getCommitDate());
            }
            $this$_get_displayText__u24lambda_u240.append(")");
        }
        $this$_get_displayText__u24lambda_u240.append(" ");
        $this$_get_displayText__u24lambda_u240.append($this$displayText.getHost());
        return stringBuilder.toString();
    }

    private final void logLicenseMetadata() {
        if (!PlatformUtils.isRustRover()) {
            return;
        }
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        LOG.info("RustRover license metadata: " + (licensingFacade != null ? licensingFacade.metadata : null));
    }

    private static final RustcVersion getEnvironmentInfo$lambda$0(CargoProject it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        RustcInfo rustcInfo = it2.getRustcInfo();
        return rustcInfo != null ? rustcInfo.getVersion() : null;
    }

    private static final CharSequence getEnvironmentInfo$lambda$2(RegistryValue it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getKey() + "=" + it2.asString();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsFeedbackDescriptionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/actions/diagnostic/RsFeedbackDescriptionProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RustProjectSettingsService.MacroExpansionEngine.values().length];
            try {
                nArray[RustProjectSettingsService.MacroExpansionEngine.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

