/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.ide.actions.ShareInPlaygroundAction;
import org.rust.ide.actions.ShareInPlaygroundActionKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.openapiext.JsonUtils;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/actions/ShareInPlaygroundAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "Context", "PlaygroundCode", "intellij.rustrover.core"})
public final class ShareInPlaygroundAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SHOW_SHARE_IN_PLAYGROUND_CONFIRMATION = "rs.show.share.in.playground.confirmation";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        RsFile file = object instanceof RsFile ? (RsFile)object : null;
        e.getPresentation().setEnabledAndVisible(file != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        RsFile rsFile = object instanceof RsFile ? (RsFile)object : null;
        if (rsFile == null) {
            return;
        }
        RsFile file = rsFile;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        object = (Pair)ActionsKt.runReadAction(() -> ShareInPlaygroundAction.actionPerformed$lambda$0(editor2, file));
        String text = (String)object.component1();
        boolean hasSelection = (Boolean)object.component2();
        Context context = new Context(file, text, hasSelection);
        Companion.performAction(project2, context);
    }

    private static final Pair actionPerformed$lambda$0(Editor $editor, RsFile $file) {
        Editor editor2 = $editor;
        String selectedText = editor2 != null && (editor2 = editor2.getSelectionModel()) != null ? editor2.getSelectedText() : null;
        return selectedText != null ? TuplesKt.to((Object)selectedText, (Object)true) : TuplesKt.to((Object)$file.getText(), (Object)false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/actions/ShareInPlaygroundAction$Companion;", "", "<init>", "()V", "SHOW_SHARE_IN_PLAYGROUND_CONFIRMATION", "", "performAction", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lorg/rust/ide/actions/ShareInPlaygroundAction$Context;", "createHttpClient", "Ljava/net/http/HttpClient;", "confirmShare", "", "file", "Lorg/rust/lang/core/psi/RsFile;", "hasSelection", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void performAction(@NotNull Project project, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            RsFile file = context.component1();
            String text = context.component2();
            boolean hasSelection = context.component3();
            if (!this.confirmShare(file, hasSelection)) {
                return;
            }
            Object object = file.getCargoProject();
            if (object == null || (object = object.getRustcInfo()) == null || (object = ((RustcInfo)object).getVersion()) == null || (object = ((RustcVersion)object).getChannel()) == null || (object = ((RustChannel)((Object)object)).getChannel()) == null) {
                object = "stable";
            }
            Object channel = object;
            String edition = file.getCrate().getEdition().getPresentation();
            String string = RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.progress.title", new Object[0]);
            new Task.Backgroundable(project, text, (String)channel, edition, string){
                private volatile String gistId;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $text;
                final /* synthetic */ String $channel;
                final /* synthetic */ String $edition;
                {
                    this.$project = $project;
                    this.$text = $text;
                    this.$channel = $channel;
                    this.$edition = $edition;
                    super($project, $super_call_param$1);
                }

                public boolean shouldStartInBackground() {
                    return true;
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    String json = new Gson().toJson((Object)new PlaygroundCode(this.$text));
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(ShareInPlaygroundActionKt.access$getPlaygroundHost() + "/meta/gist/")).header("Content-Type", "application/json; charset=utf-8").header("User-Agent", "IntelliJ Rust Plugin (https://github.com/intellij-rust/intellij-rust)").timeout(Duration.ofMillis(HttpRequests.READ_TIMEOUT)).POST(HttpRequest.BodyPublishers.ofString(json)).build();
                    HttpClient client = org.rust.ide.actions.ShareInPlaygroundAction$Companion.access$createHttpClient(ShareInPlaygroundAction.Companion);
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    this.gistId = JsonUtils.parseJsonObject$default(JsonUtils.INSTANCE, response.body(), false, 2, null).getAsJsonPrimitive("id").getAsString();
                }

                public void onSuccess() {
                    String url = "https://play.rust-lang.org/?version=" + this.$channel + "&edition=" + this.$edition + "&gist=" + this.gistId;
                    NotificationAction notificationAction = NotificationAction.createSimple((String)RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.notification.copy.url.text", new Object[0]), () -> performAction.1.onSuccess$lambda$0(url));
                    Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
                    NotificationAction copyUrlAction = notificationAction;
                    Object[] objectArray = new Object[]{url};
                    org.rust.ide.notifications.UtilsKt.showBalloon(this.$project, "file.was.shared.on.playground", RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.notification.title", new Object[0]), RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.notification.text", objectArray), NotificationType.INFORMATION, (AnAction)copyUrlAction, NotificationListener.URL_OPENING_LISTENER);
                }

                public void onThrowable(Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    if (!UtilsKt.isUnitTestMode()) {
                        super.onThrowable(error);
                    }
                    org.rust.ide.notifications.UtilsKt.showBalloon$default(this.$project, "failure.to.share.on.playground", RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.notification.title", new Object[0]), RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.notification.error", new Object[0]), NotificationType.ERROR, null, null, 48, null);
                }

                private static final void onSuccess$lambda$0(String $url) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($url));
                }
            }.queue();
        }

        private final HttpClient createHttpClient() {
            HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(HttpRequests.CONNECTION_TIMEOUT)).executor(ProcessIOExecutorService.INSTANCE).sslContext(CertificateManager.Companion.getInstance().getSslContext()).proxy((ProxySelector)CommonProxy.getInstance()).build();
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"build(...)");
            return httpClient;
        }

        private final boolean confirmShare(RsFile file, boolean hasSelection) {
            String string;
            boolean showConfirmation = PropertiesComponent.getInstance().getBoolean(ShareInPlaygroundAction.SHOW_SHARE_IN_PLAYGROUND_CONFIRMATION, true);
            if (!showConfirmation) {
                return true;
            }
            DoNotAskOption.Adapter doNotAskOption2 = new DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (isSelected && exitCode == 0) {
                        PropertiesComponent.getInstance().setValue("rs.show.share.in.playground.confirmation", false, true);
                    }
                }
            };
            if (hasSelection) {
                string = RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.confirmation.selected.text", new Object[0]);
            } else {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                string = RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.confirmation", objectArray);
            }
            String message = string;
            OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(RsBundle.INSTANCE.message("action.Rust.ShareInPlayground.text", new Object[0]), message);
            String string2 = Messages.getOkButton();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOkButton(...)");
            OkCancelDialogBuilder okCancelDialogBuilder2 = (OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string2);
            String string3 = Messages.getCancelButton();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButton(...)");
            return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)okCancelDialogBuilder2.noText(string3)).icon(Messages.getQuestionIcon())).doNotAsk((DoNotAskOption)doNotAskOption2)).ask(file.getProject());
        }

        public static final /* synthetic */ HttpClient access$createHttpClient(Companion $this) {
            return $this.createHttpClient();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/actions/ShareInPlaygroundAction$Context;", "", "file", "Lorg/rust/lang/core/psi/RsFile;", "text", "", "hasSelection", "", "<init>", "(Lorg/rust/lang/core/psi/RsFile;Ljava/lang/String;Z)V", "getFile", "()Lorg/rust/lang/core/psi/RsFile;", "getText", "()Ljava/lang/String;", "getHasSelection", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsFile file;
        @NotNull
        private final String text;
        private final boolean hasSelection;

        public Context(@NotNull RsFile file, @NotNull String text, boolean hasSelection) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.file = file;
            this.text = text;
            this.hasSelection = hasSelection;
        }

        @NotNull
        public final RsFile getFile() {
            return this.file;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getHasSelection() {
            return this.hasSelection;
        }

        @NotNull
        public final RsFile component1() {
            return this.file;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        public final boolean component3() {
            return this.hasSelection;
        }

        @NotNull
        public final Context copy(@NotNull RsFile file, @NotNull String text, boolean hasSelection) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Context(file, text, hasSelection);
        }

        public static /* synthetic */ Context copy$default(Context context, RsFile rsFile, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                rsFile = context.file;
            }
            if ((n & 2) != 0) {
                string = context.text;
            }
            if ((n & 4) != 0) {
                bl = context.hasSelection;
            }
            return context.copy(rsFile, string, bl);
        }

        @NotNull
        public String toString() {
            return "Context(file=" + this.file + ", text=" + this.text + ", hasSelection=" + this.hasSelection + ")";
        }

        public int hashCode() {
            int result2 = this.file.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasSelection);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)context.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)context.text)) {
                return false;
            }
            return this.hasSelection == context.hasSelection;
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/actions/ShareInPlaygroundAction$PlaygroundCode;", "", "code", "", "<init>", "(Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class PlaygroundCode {
        @NotNull
        private final String code;

        public PlaygroundCode(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        @NotNull
        public final PlaygroundCode copy(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new PlaygroundCode(code);
        }

        public static /* synthetic */ PlaygroundCode copy$default(PlaygroundCode playgroundCode, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = playgroundCode.code;
            }
            return playgroundCode.copy(string);
        }

        @NotNull
        public String toString() {
            return "PlaygroundCode(code=" + this.code + ")";
        }

        public int hashCode() {
            return this.code.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlaygroundCode)) {
                return false;
            }
            PlaygroundCode playgroundCode = (PlaygroundCode)other;
            return Intrinsics.areEqual((Object)this.code, (Object)playgroundCode.code);
        }
    }
}

