/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.Rustfmt;
import org.rust.cargo.toolchain.tools.RustfmtKt;
import org.rust.cargo.toolchain.tools.Rustup;
import org.rust.ide.actions.RustfmtFileAction;
import org.rust.ide.statistics.RustfmtUsagesCollector;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/actions/RustfmtFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "reformatDocumentAndGetText", "", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "rustfmt", "Lorg/rust/cargo/toolchain/tools/Rustfmt;", "document", "Lcom/intellij/openapi/editor/Document;", "getContext", "Lkotlin/Triple;", "intellij.rustrover.core"})
public final class RustfmtFileAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabled(this.getContext(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String string;
        String fileName;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Triple<CargoProject, Rustfmt, Document> triple = this.getContext(e);
        if (triple == null) {
            return;
        }
        Triple<CargoProject, Rustfmt, Document> triple2 = triple;
        CargoProject cargoProject = (CargoProject)triple2.component1();
        Rustfmt rustfmt = (Rustfmt)triple2.component2();
        Document document = (Document)triple2.component3();
        UtilsKt.checkWriteAccessNotAllowed();
        String string2 = (String)TasksKt.runWithModalProgressBlocking((Project)cargoProject.getProject(), (String)RsBundle.INSTANCE.message("action.Cargo.RustfmtFile.progress.default.text", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, cargoProject, rustfmt, document, null){
            int label;
            final /* synthetic */ RustfmtFileAction this$0;
            final /* synthetic */ CargoProject $cargoProject;
            final /* synthetic */ Rustfmt $rustfmt;
            final /* synthetic */ Document $document;
            {
                this.this$0 = $receiver;
                this.$cargoProject = $cargoProject;
                this.$rustfmt = $rustfmt;
                this.$document = $document;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.this$0, this.$cargoProject, this.$rustfmt, this.$document, null){
                            int label;
                            final /* synthetic */ RustfmtFileAction this$0;
                            final /* synthetic */ CargoProject $cargoProject;
                            final /* synthetic */ Rustfmt $rustfmt;
                            final /* synthetic */ Document $document;
                            {
                                this.this$0 = $receiver;
                                this.$cargoProject = $cargoProject;
                                this.$rustfmt = $rustfmt;
                                this.$document = $document;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> actionPerformed.formattedText.1.invokeSuspend$lambda$0(this.this$0, this.$cargoProject, this.$rustfmt, this.$document, arg_0), (Continuation)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final String invokeSuspend$lambda$0(RustfmtFileAction this$0, CargoProject $cargoProject, Rustfmt $rustfmt, Document $document, ProgressIndicator it2) {
                                return RustfmtFileAction.access$reformatDocumentAndGetText(this$0, $cargoProject, $rustfmt, $document);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (string2 == null) {
            return;
        }
        String formattedText2 = string2;
        VirtualFile virtualFile = UtilsKt.getVirtualFile(document);
        String string3 = fileName = virtualFile != null ? virtualFile.getPresentableName() : null;
        if (fileName != null) {
            Object[] objectArray = new Object[]{fileName};
            string = RsBundle.INSTANCE.message("action.Cargo.RustfmtFile.file.text", objectArray);
        } else {
            string = RsBundle.INSTANCE.message("action.Cargo.RustfmtFile.default.text", new Object[0]);
        }
        String commandName = string;
        UtilsKt.runWriteCommandAction(cargoProject.getProject(), commandName, new PsiFile[0], () -> RustfmtFileAction.actionPerformed$lambda$0(document, formattedText2));
    }

    private final String reformatDocumentAndGetText(CargoProject cargoProject, Rustfmt rustfmt, Document document) {
        String string;
        try {
            if (!Rustup.Companion.checkRustfmt$default(Rustup.Companion, cargoProject.getProject(), cargoProject.getRootDirPath(), false, 4, null)) {
                return null;
            }
            string = rustfmt.reformatDocumentTextOrNull(cargoProject, document, RustfmtUsagesCollector.Place.EXPLICIT);
        }
        catch (ExecutionException e) {
            if (UtilsKt.isUnitTestMode()) {
                throw e;
            }
            string = null;
        }
        return string;
    }

    private final Triple<CargoProject, Rustfmt, Document> getContext(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Object object = RustProjectSettingsServiceKt.getToolchain(project2);
        if (object == null || (object = RustfmtKt.rustfmt((RsToolchainBase)object)) == null) {
            return null;
        }
        Object rustfmt = object;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return null;
        }
        Editor editor3 = editor2;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile virtualFile = UtilsKt.getVirtualFile(document2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (!file.isInLocalFileSystem() || !RsFileKt.isRustFile(file)) {
            return null;
        }
        CargoProject cargoProject = CargoProjectServiceKt.getCargoProjects(project2).findProjectForFile(file);
        if (cargoProject == null) {
            return null;
        }
        CargoProject cargoProject2 = cargoProject;
        return new Triple((Object)cargoProject2, rustfmt, (Object)document2);
    }

    private static final Unit actionPerformed$lambda$0(Document $document, String $formattedText) {
        $document.setText((CharSequence)$formattedText);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$reformatDocumentAndGetText(RustfmtFileAction $this, CargoProject cargoProject, Rustfmt rustfmt, Document document) {
        return $this.reformatDocumentAndGetText(cargoProject, rustfmt, document);
    }
}

