/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.parser.RustParserUtil;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsBlockExprKt;
import org.rust.lang.core.psi.ext.RsBlockKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005H\u0002J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/actions/RsJoinRawLinesHandler;", "Lcom/intellij/codeInsight/editorActions/JoinRawLinesHandlerDelegate;", "<init>", "()V", "tryJoinRawLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "joinLineDocComment", "tryJoinSingleExpressionBlock", "Lorg/rust/lang/core/psi/RsFile;", "tryJoinLines", "intellij.rustrover.core"})
public final class RsJoinRawLinesHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof RsFile)) {
            return -1;
        }
        if (start2 == 0) {
            return -1;
        }
        int tryJoinSingleExpressionBlock = this.tryJoinSingleExpressionBlock((RsFile)file, start2);
        if (tryJoinSingleExpressionBlock != -1) {
            return tryJoinSingleExpressionBlock;
        }
        PsiElement psiElement2 = ((RsFile)file).findElementAt(start2);
        if (psiElement2 == null || (psiElement2 = org.rust.lang.doc.psi.ext.PsiElementKt.getContainingDoc(psiElement2)) == null) {
            return -1;
        }
        PsiElement leftPsi = psiElement2;
        PsiElement psiElement3 = ((RsFile)file).findElementAt(end);
        if (psiElement3 == null || (psiElement3 = org.rust.lang.doc.psi.ext.PsiElementKt.getContainingDoc(psiElement3)) == null) {
            return -1;
        }
        PsiElement rightPsi = psiElement3;
        if (!Intrinsics.areEqual((Object)leftPsi, (Object)rightPsi)) {
            return -1;
        }
        IElementType iElementType = PsiElementExtensionsKt.getElementType(leftPsi);
        return Intrinsics.areEqual((Object)iElementType, (Object)RustParserUtil.Helper.INNER_EOL_DOC_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)RustParserUtil.Helper.OUTER_EOL_DOC_COMMENT) ? this.joinLineDocComment(document, start2, end) : -1;
    }

    private final int joinLineDocComment(Document document, int start2, int end) {
        String prefix = ((Object)document.getCharsSequence().subSequence(end, end + 3)).toString();
        if (!Intrinsics.areEqual((Object)prefix, (Object)"///") && !Intrinsics.areEqual((Object)prefix, (Object)"//!")) {
            return -1;
        }
        document.deleteString(start2, end + prefix.length());
        return start2;
    }

    private final int tryJoinSingleExpressionBlock(RsFile file, int start2) {
        PsiElement psiElement2 = file.findElementAt(start2 - 1);
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement lbrace = psiElement2;
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(lbrace), (Object)RsElementTypes.LBRACE)) {
            return -1;
        }
        PsiElement psiElement3 = lbrace.getParent();
        RsBlock rsBlock = psiElement3 instanceof RsBlock ? (RsBlock)psiElement3 : null;
        if (rsBlock == null) {
            return -1;
        }
        RsBlock block = rsBlock;
        RsExprStmt rsExprStmt = RsBlockKt.singleTailStmt(block);
        if (rsExprStmt == null) {
            return -1;
        }
        RsExprStmt tailStmt = rsExprStmt;
        ASTNode[] aSTNodeArray = block.getNode().getChildren(RsTokenTypeKt.getRS_COMMENTS());
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        if (!(((Object[])aSTNodeArray).length == 0)) {
            return -1;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        PsiElement parent2 = block.getParent();
        if (parent2 instanceof RsBlockExpr) {
            int n;
            PsiElement grandpa = ((RsBlockExpr)parent2).getParent();
            if (grandpa instanceof RsIfExpr || grandpa instanceof RsElseBranch) {
                String string = tailStmt.getExpr().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                RsBlock rsBlock2 = psiFactory.createBlockExpr(string).getBlock();
                Intrinsics.checkNotNullExpressionValue((Object)rsBlock2, (String)"<get-block>(...)");
                RsBlock newBlock = rsBlock2;
                PsiElement psiElement4 = block.replace(newBlock);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"replace(...)");
                return PsiElementKt.getStartOffset(psiElement4);
            }
            if (RsBlockExprKt.getHasAnyModifier((RsBlockExpr)parent2)) {
                n = -1;
            } else {
                PsiElement newExpr = ((RsBlockExpr)parent2).replace(tailStmt.getExpr());
                if (grandpa instanceof RsMatchArm) {
                    PsiElement psiElement5 = ((RsMatchArm)grandpa).getLastChild();
                    if (!Intrinsics.areEqual((Object)(psiElement5 != null ? PsiElementExtensionsKt.getElementType(psiElement5) : null), (Object)RsElementTypes.COMMA)) {
                        ((RsMatchArm)grandpa).add(psiFactory.createComma());
                    }
                }
                Intrinsics.checkNotNull((Object)newExpr);
                n = PsiElementKt.getStartOffset(newExpr);
            }
            return n;
        }
        return -1;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return -1;
    }
}

