/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharSequenceSubSequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.formatter.impl.CommaList;
import org.rust.ide.typing.UtilsKt;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/actions/RsJoinLinesHandler;", "Lcom/intellij/codeInsight/editorActions/JoinLinesHandlerDelegate;", "<init>", "()V", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "offsetNear", "end", "joinCommaList", "leftPsi", "Lcom/intellij/psi/PsiElement;", "rightPsi", "joinStringLiteral", "intellij.rustrover.core"})
public final class RsJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int offsetNear, int end) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof RsFile)) {
            return -1;
        }
        PsiElement psiElement2 = ((RsFile)file).findElementAt(offsetNear);
        if (psiElement2 == null) {
            return -1;
        }
        PsiElement leftPsi = psiElement2;
        PsiElement psiElement3 = ((RsFile)file).findElementAt(end);
        if (psiElement3 == null) {
            return -1;
        }
        PsiElement rightPsi = psiElement3;
        int tryJoinCommaList = this.joinCommaList(document, leftPsi, rightPsi);
        if (tryJoinCommaList != -1) {
            return tryJoinCommaList;
        }
        if (!Intrinsics.areEqual((Object)leftPsi, (Object)rightPsi)) {
            return -1;
        }
        IElementType iElementType = PsiElementExtensionsKt.getElementType(leftPsi);
        return RsTokenTypeKt.getRS_STRING_LITERALS().contains(iElementType) ? this.joinStringLiteral(document, offsetNear, end) : -1;
    }

    private final int joinCommaList(Document document, PsiElement leftPsi, PsiElement rightPsi) {
        if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(leftPsi), (Object)RsElementTypes.COMMA)) {
            return -1;
        }
        PsiElement psiElement2 = leftPsi.getParent();
        if (psiElement2 == null) {
            return -1;
        }
        PsiElement parent2 = psiElement2;
        IElementType rightType = PsiElementExtensionsKt.getElementType(rightPsi);
        CommaList commaList = CommaList.Companion.forElement(parent2);
        if (commaList == null) {
            return -1;
        }
        CommaList list = commaList;
        if (Intrinsics.areEqual((Object)rightType, (Object)list.getClosingBrace())) {
            String replaceWith = list.getNeedsSpaceBeforeClosingBrace() ? " " : "";
            document.replaceString(leftPsi.getTextOffset(), rightPsi.getTextOffset(), (CharSequence)replaceWith);
            return leftPsi.getTextOffset();
        }
        return -1;
    }

    private final int joinStringLiteral(Document document, int offsetNear, int end) {
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text = charSequence;
        int start2 = offsetNear;
        if (UtilsKt.endsWithUnescapedBackslash((CharSequence)new CharSequenceSubSequence(text, 0, start2 + 1))) {
            --start2;
            while (start2 >= 0 && (text.charAt(start2) == ' ' || text.charAt(start2) == '\t')) {
                --start2;
            }
        }
        document.deleteString(start2 + 1, end);
        document.insertString(start2 + 1, (CharSequence)" ");
        return start2 + 1;
    }
}

