/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.rust.RsBundle;
import org.rust.RsCoroutineService;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.ide.actions.FileNameValidator;
import org.rust.ide.actions.RsCreateModuleAction;
import org.rust.ide.fixes.AttachFileToModuleFix;
import org.rust.ide.icons.RsIcons;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.RsModFileResolutionAnchorKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J,\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0011H\u0007J(\u0010\u001b\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0014J0\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001fH\u0014J\u001e\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0007J\u0018\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0007J5\u0010%\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b&2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000b\u0010'\u001a\u00070\u0018\u00a2\u0006\u0002\b(2\r\u0010\u0019\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b(H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/rust/ide/actions/RsCreateModuleAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "selectedFile", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAvailable", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "createFileForTesting", "Lcom/intellij/psi/PsiFile;", "selected", "name", "", "templateName", "dir", "createFile", "postProcess", "createdElement", "customProperties", "", "addModuleDeclaration", "rsFile", "Lorg/rust/lang/core/psi/RsFile;", "findParentModule", "createdFile", "getActionName", "Lcom/intellij/openapi/util/NlsContexts$Command;", "newName", "Lorg/jetbrains/annotations/NonNls;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCreateModuleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCreateModuleAction.kt\norg/rust/ide/actions/RsCreateModuleAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,154:1\n1761#2,3:155\n1761#2,3:158\n30#3,2:161\n*S KotlinDebug\n*F\n+ 1 RsCreateModuleAction.kt\norg/rust/ide/actions/RsCreateModuleAction\n*L\n60#1:155,3\n92#1:158,3\n121#1:161,2\n*E\n"})
public final class RsCreateModuleAction
extends CreateFileFromTemplateAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<VirtualFile> selectedFile = new AtomicReference<Object>(null);
    @NotNull
    public static final String RUST_MODULE_SINGLE = "single";
    @NotNull
    public static final String RUST_MODULE_MOD_RS = "mod.rs";

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (!super.isAvailable(dataContext)) {
                return false;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            Project project2 = project;
            if (DumbService.Companion.isDumb(project2)) {
                return false;
            }
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile virtualFile2 = virtualFile;
            this.selectedFile.set(virtualFile2);
            Iterable $this$any$iv = CargoProjectServiceKt.getCargoProjects(project2).getAllProjects();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile rootDir;
                    CargoProject it2 = (CargoProject)element$iv;
                    boolean bl2 = false;
                    if (!(it2.getRootDir() == null ? false : VfsUtilCore.isAncestor((VirtualFile)rootDir, (VirtualFile)virtualFile2, (boolean)false))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setTitle(RsBundle.INSTANCE.message("action.Rust.NewRustModule.description", new Object[0])).addKind(RsBundle.INSTANCE.message("list.item.new.single.module", new Object[0]), RsIcons.INSTANCE.getRUST_FILE(), RUST_MODULE_SINGLE).addKind(RsBundle.INSTANCE.message("list.item.new.module.with.mod", new Object[0]), RsIcons.INSTANCE.getMODULE(), RUST_MODULE_MOD_RS).setValidator((InputValidator)FileNameValidator.INSTANCE);
    }

    @VisibleForTesting
    @Nullable
    public final PsiFile createFileForTesting(@Nullable VirtualFile selected, @NotNull String name2, @NotNull String templateName, @NotNull PsiDirectory dir) {
        RsFile created;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            this.selectedFile.set(selected);
            PsiFile psiFile = this.createFile(name2, templateName, dir);
            RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
            if (rsFile == null) {
                return null;
            }
            created = rsFile;
            VirtualFile virtualFile = selected;
            if (virtualFile == null) {
                return null;
            }
            RsFile rsFile2 = this.findParentModule(created, virtualFile);
            if (rsFile2 == null) break block2;
            RsFile it2 = rsFile2;
            boolean bl = false;
            AttachFileToModuleFix.Companion.insertFileToModule(created, it2, RsBundle.INSTANCE.message("attach.file", new Object[0]));
        }
        return (PsiFile)created;
    }

    @Nullable
    protected PsiFile createFile(@Nullable String name2, @Nullable String templateName, @Nullable PsiDirectory dir) {
        PsiFile psiFile;
        Object object;
        if (dir == null || name2 == null) {
            return null;
        }
        Project project = dir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = this.selectedFile.get();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile selectedFile = virtualFile;
        if (selectedFile.isDirectory()) {
            object = dir;
        } else {
            boolean isRoot;
            block18: {
                CargoWorkspace.Package package_ = CargoProjectServiceKt.getCargoProjects(project2).findPackageForFile(selectedFile);
                if (package_ == null) {
                    return null;
                }
                CargoWorkspace.Package pkg = package_;
                Iterable $this$any$iv = pkg.getTargets();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CargoWorkspace.Target it2 = (CargoWorkspace.Target)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getCrateRoot(), (Object)selectedFile)) continue;
                        v4 = true;
                        break block18;
                    }
                    v4 = isRoot = false;
                }
            }
            if (isRoot || Intrinsics.areEqual((Object)selectedFile.getName(), (Object)RUST_MODULE_MOD_RS)) {
                object = selectedFile.getParent();
                if (object == null || (object = UtilsKt.toPsiDirectory((VirtualFile)object, project2)) == null) {
                    return null;
                }
            } else {
                Object object2 = UtilsKt.toPsiFile(selectedFile, project2);
                if (object2 == null || (object2 = RsFileKt.getRustFile(object2)) == null) {
                    return null;
                }
                Object rsFile = object2;
                object = RsModFileResolutionAnchorKt.getModFileResolutionAnchor((RsElement)rsFile, true);
                if (object == null || (object = object.getOwnedDirectory(true)) == null) {
                    return null;
                }
            }
        }
        PsiDirectory directory = object;
        String string = templateName;
        if (Intrinsics.areEqual((Object)string, (Object)RUST_MODULE_SINGLE)) {
            psiFile = super.createFile(name2, "Rust File", directory);
        } else if (Intrinsics.areEqual((Object)string, (Object)RUST_MODULE_MOD_RS)) {
            PsiDirectory psiDirectory = directory.findSubdirectory(name2);
            if (psiDirectory == null) {
                PsiDirectory psiDirectory2 = directory.createSubdirectory(name2);
                psiDirectory = psiDirectory2;
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory2, (String)"createSubdirectory(...)");
            }
            PsiDirectory thisDir = psiDirectory;
            psiFile = super.createFile(RUST_MODULE_MOD_RS, "Rust File", thisDir);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    protected void postProcess(@NotNull PsiFile createdElement, @Nullable String templateName, @Nullable Map<String, String> customProperties) {
        Intrinsics.checkNotNullParameter((Object)createdElement, (String)"createdElement");
        RsFile rsFile = createdElement instanceof RsFile ? (RsFile)createdElement : null;
        if (rsFile == null) {
            return;
        }
        String string = templateName;
        if (string == null) {
            return;
        }
        VirtualFile virtualFile = this.selectedFile.get();
        if (virtualFile == null) {
            return;
        }
        this.addModuleDeclaration(rsFile, string, virtualFile);
    }

    public final void addModuleDeclaration(@NotNull RsFile rsFile, @NotNull String templateName, @NotNull VirtualFile selectedFile) {
        Intrinsics.checkNotNullParameter((Object)rsFile, (String)"rsFile");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter((Object)selectedFile, (String)"selectedFile");
        Project project = rsFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RsCoroutineService> serviceClass$iv = RsCoroutineService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((RsCoroutineService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, rsFile, selectedFile, templateName, null){
            int label;
            final /* synthetic */ RsCreateModuleAction this$0;
            final /* synthetic */ RsFile $rsFile;
            final /* synthetic */ VirtualFile $selectedFile;
            final /* synthetic */ String $templateName;
            {
                this.this$0 = $receiver;
                this.$rsFile = $rsFile;
                this.$selectedFile = $selectedFile;
                this.$templateName = $templateName;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.readAndEdtWriteAction(arg_0 -> addModuleDeclaration.1.invokeSuspend$lambda$0(this.this$0, this.$rsFile, this.$selectedFile, this.$templateName, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final ReadResult invokeSuspend$lambda$0(RsCreateModuleAction this$0, RsFile $rsFile, VirtualFile $selectedFile, String $templateName, ReadAndWriteScope $this$readAndEdtWriteAction) {
                RsFile rsFile = this$0.findParentModule($rsFile, $selectedFile);
                if (rsFile == null) {
                    return ReadResult.Companion.value((Object)Unit.INSTANCE);
                }
                RsFile moduleToInsert = rsFile;
                return $this$readAndEdtWriteAction.writeAction(() -> addModuleDeclaration.1.invokeSuspend$lambda$0$0($rsFile, moduleToInsert, $templateName, $selectedFile));
            }

            private static final Unit invokeSuspend$lambda$0$0(RsFile $rsFile, RsFile $moduleToInsert, String $templateName, VirtualFile $selectedFile) {
                AttachFileToModuleFix.Companion.insertFileToModule($rsFile, $moduleToInsert, RsBundle.INSTANCE.message("attach.file", new Object[0]));
                RsCounterUsagesCollector.INSTANCE.logNewModuleCreated((PsiFile)$moduleToInsert, Intrinsics.areEqual((Object)$templateName, (Object)"single") ? RsCounterUsagesCollector.NewModuleKind.SINGLE_FILE : RsCounterUsagesCollector.NewModuleKind.DIR_MOD_RS, $selectedFile.isDirectory() ? RsCounterUsagesCollector.NewModuleActionTarget.DIRECTORY : RsCounterUsagesCollector.NewModuleActionTarget.FILE);
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    @Nullable
    public final RsFile findParentModule(@NotNull RsFile createdFile, @NotNull VirtualFile selectedFile) {
        RsFile rsFile;
        Intrinsics.checkNotNullParameter((Object)createdFile, (String)"createdFile");
        Intrinsics.checkNotNullParameter((Object)selectedFile, (String)"selectedFile");
        Project project = createdFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (selectedFile.isDirectory()) {
            rsFile = (RsFile)CollectionsKt.singleOrNull(AttachFileToModuleFix.Companion.findAvailableModulesForFile(project2, createdFile));
        } else {
            PsiFile psiFile = UtilsKt.toPsiFile(selectedFile, project2);
            rsFile = psiFile != null ? RsFileKt.getRustFile(psiFile) : null;
        }
        return rsFile;
    }

    @Nullable
    protected String getActionName(@Nullable PsiDirectory directory, @NotNull String newName, @Nullable String templateName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return RsBundle.INSTANCE.message("action.Rust.NewRustModule.text", new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/rust/ide/actions/RsCreateModuleAction$Companion;", "", "<init>", "()V", "RUST_MODULE_SINGLE", "", "RUST_MODULE_MOD_RS", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

