/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.ide.actions.FileNameValidator;
import org.rust.ide.actions.RsCreateFileActionKt;
import org.rust.ide.fixes.AttachFileToModuleFix;
import org.rust.ide.fixes.ReloadProjectQuickFix;
import org.rust.ide.icons.RsIcons;
import org.rust.ide.inspections.RsDetachedFileInspection;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J0\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0019H\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u001c\u001a\u0004\u0018\u00010\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0014\u00a8\u0006 "}, d2={"Lorg/rust/ide/actions/RsCreateFileAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionName", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "newName", "templateName", "isAvailable", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "postProcess", "createdElement", "Lcom/intellij/psi/PsiFile;", "customProperties", "", "createPostProcessCallback", "Lkotlin/Function0;", "createFile", "name", "dir", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCreateFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCreateFileAction.kt\norg/rust/ide/actions/RsCreateFileAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1761#2,3:163\n*S KotlinDebug\n*F\n+ 1 RsCreateFileAction.kt\norg/rust/ide/actions/RsCreateFileAction\n*L\n57#1:163,3\n*E\n"})
public final class RsCreateFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nls
    @NotNull
    private static final String CAPTION = RsBundle.INSTANCE.message("rust.file", new Object[0]);

    public RsCreateFileAction() {
        super(CAPTION, "", RsIcons.INSTANCE.getRUST_FILE());
    }

    @NotNull
    protected String getActionName(@Nullable PsiDirectory directory, @NotNull String newName, @Nullable String templateName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return CAPTION;
    }

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (!super.isAvailable(dataContext)) {
                return false;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            Project project2 = project;
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile vFile = virtualFile;
            Iterable $this$any$iv = CargoProjectServiceKt.getCargoProjects(project2).getAllProjects();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile rootDir;
                    CargoProject it2 = (CargoProject)element$iv;
                    boolean bl2 = false;
                    if (!(it2.getRootDir() == null ? false : VfsUtil.isAncestor((VirtualFile)rootDir, (VirtualFile)vFile, (boolean)false))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setTitle(CAPTION);
        if (DumbService.Companion.isDumb(project)) {
            builder.addKind(RsBundle.INSTANCE.message("list.item.new.file", new Object[0]), RsIcons.INSTANCE.getRUST_FILE(), "Rust File in Dumb Mode");
            return;
        }
        CreateFileFromTemplateDialog.Builder builder2 = PropertiesComponent.getInstance().getBoolean("rs.new.file.attach.selected", false) ? builder.addKind(RsBundle.INSTANCE.message("list.item.don.t.attach.to.module", new Object[0]), RsIcons.INSTANCE.getRUST_FILE(), "Rust File").addKind(RsBundle.INSTANCE.message("list.item.attach.to.module", new Object[0]), RsIcons.INSTANCE.getRUST_FILE(), "Rust File Attached") : builder.addKind(RsBundle.INSTANCE.message("list.item.attach.to.module", new Object[0]), RsIcons.INSTANCE.getRUST_FILE(), "Rust File Attached").addKind(RsBundle.INSTANCE.message("list.item.don.t.attach.to.module", new Object[0]), RsIcons.INSTANCE.getRUST_FILE(), "Rust File");
        builder.setValidator((InputValidator)FileNameValidator.INSTANCE);
    }

    protected void postProcess(@NotNull PsiFile createdElement, @Nullable String templateName, @Nullable Map<String, String> customProperties) {
        Intrinsics.checkNotNullParameter((Object)createdElement, (String)"createdElement");
        RsCounterUsagesCollector.INSTANCE.logNewFileCreated(createdElement, templateName);
        if (Intrinsics.areEqual((Object)templateName, (Object)"Rust File Attached")) {
            PropertiesComponent.getInstance().setValue("rs.new.file.attach.selected", false, true);
            ReadAction.nonBlocking(() -> RsCreateFileAction.postProcess$lambda$0(this, createdElement)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> RsCreateFileAction.postProcess$lambda$2(RsCreateFileAction::postProcess$lambda$1, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        } else if (Intrinsics.areEqual((Object)templateName, (Object)"Rust File")) {
            PropertiesComponent.getInstance().setValue("rs.new.file.attach.selected", true, false);
        }
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
    }

    private final Function0<Unit> createPostProcessCallback(PsiFile createdElement) {
        Project project = createdElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = createdElement.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Set<VirtualFile> set = RsDetachedFileInspection.Helper.INSTANCE.collectImplicitTargets(project, virtualFile);
        if (set == null) {
            return RsCreateFileActionKt.access$getEMPTY_CALLBACK$p();
        }
        Set<VirtualFile> implicitTargets = set;
        if (implicitTargets.contains(createdElement.getVirtualFile())) {
            if (RsDetachedFileInspection.Helper.INSTANCE.isFileDetached(createdElement) == ThreeState.YES) {
                return () -> RsCreateFileAction.createPostProcessCallback$lambda$0(createdElement);
            }
            return RsCreateFileActionKt.access$getEMPTY_CALLBACK$p();
        }
        Project project2 = createdElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project2)) {
            return RsCreateFileActionKt.access$getEMPTY_CALLBACK$p();
        }
        RsFile rsFile = createdElement instanceof RsFile ? (RsFile)createdElement : null;
        if (rsFile == null) {
            return RsCreateFileActionKt.access$getEMPTY_CALLBACK$p();
        }
        RsFile rsFile2 = rsFile;
        Project project3 = ((RsFile)createdElement).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        RsFile availableModule = (RsFile)CollectionsKt.singleOrNull(AttachFileToModuleFix.Companion.findAvailableModulesForFile(project3, rsFile2));
        return () -> RsCreateFileAction.createPostProcessCallback$lambda$1(availableModule, createdElement, rsFile2);
    }

    @Nullable
    protected PsiFile createFile(@Nullable String name2, @Nullable String templateName, @Nullable PsiDirectory dir) {
        return super.createFile(name2, Intrinsics.areEqual((Object)templateName, (Object)"Rust File Attached") ? "Rust File" : templateName, dir);
    }

    private static final Function0 postProcess$lambda$0(RsCreateFileAction this$0, PsiFile $createdElement) {
        return this$0.createPostProcessCallback($createdElement);
    }

    private static final Unit postProcess$lambda$1(Function0 postProcessCallback) {
        postProcessCallback.invoke();
        return Unit.INSTANCE;
    }

    private static final void postProcess$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createPostProcessCallback$lambda$0(PsiFile $createdElement) {
        ActionsKt.runWriteAction(() -> RsCreateFileAction.createPostProcessCallback$lambda$0$0($createdElement));
        return Unit.INSTANCE;
    }

    private static final Unit createPostProcessCallback$lambda$0$0(PsiFile $createdElement) {
        Project project = $createdElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReloadProjectQuickFix.Companion.reloadProject(project);
        return Unit.INSTANCE;
    }

    private static final Unit createPostProcessCallback$lambda$1(RsFile $availableModule, PsiFile $createdElement, RsFile $rsFile) {
        if ($availableModule != null && !Intrinsics.areEqual((Object)$availableModule, (Object)$createdElement)) {
            AttachFileToModuleFix.Companion.insertFileToModule($rsFile, $availableModule, RsBundle.INSTANCE.message("attach.file", new Object[0]));
            Project project = $rsFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsCounterUsagesCollector.INSTANCE.logCreatedFileAttachedToModule(project, $availableModule);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/actions/RsCreateFileAction$Companion;", "", "<init>", "()V", "CAPTION", "", "intellij.rustrover.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

