/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.Rustup;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.cargo.util.DownloadResult;
import org.rust.ide.notifications.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/rust/ide/actions/InstallTargetAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "projectDirectory", "Ljava/nio/file/Path;", "targetName", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rustrover.core"})
public final class InstallTargetAction
extends DumbAwareAction {
    @NotNull
    private final Path projectDirectory;
    @NotNull
    private final String targetName;

    public InstallTargetAction(@NotNull Path projectDirectory, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        super(RsBundle.INSTANCE.message("action.install.text", new Object[0]));
        this.projectDirectory = projectDirectory;
        this.targetName = targetName;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = RustProjectSettingsServiceKt.getToolchain(project2);
        if (object == null || (object = RustupKt.rustup((RsToolchainBase)object, this.projectDirectory)) == null) {
            return;
        }
        Object rustup = object;
        Notification.get((AnActionEvent)e).expire();
        Object[] objectArray = new Object[]{this.targetName};
        String string = RsBundle.INSTANCE.message("progress.title.installing", objectArray);
        new Task.Backgroundable(project2, (Rustup)rustup, this, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Rustup $rustup;
            final /* synthetic */ InstallTargetAction this$0;
            {
                this.$project = $project;
                this.$rustup = $rustup;
                this.this$0 = $receiver;
                super($project, $super_call_param$1);
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                DownloadResult<Unit> result2 = this.$rustup.downloadTarget(this.$project, InstallTargetAction.access$getTargetName$p(this.this$0));
                if (result2 instanceof DownloadResult.Err) {
                    UtilsKt.showBalloon$default(this.$project, "install.target.error", ((DownloadResult.Err)result2).getError(), NotificationType.ERROR, null, 8, null);
                }
            }
        }.queue();
    }

    public static final /* synthetic */ String access$getTargetName$p(InstallTargetAction $this) {
        return $this.targetName;
    }
}

