/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.Rustup;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.cargo.util.DownloadResult;
import org.rust.ide.notifications.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/actions/InstallComponentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "projectDirectory", "Ljava/nio/file/Path;", "componentName", "", "text", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rustrover.core"})
public final class InstallComponentAction
extends DumbAwareAction {
    @NotNull
    private final Path projectDirectory;
    @NotNull
    private final String componentName;

    public InstallComponentAction(@NotNull Path projectDirectory, @NotNull String componentName, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        super(text);
        this.projectDirectory = projectDirectory;
        this.componentName = componentName;
    }

    public /* synthetic */ InstallComponentAction(Path path, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = RsBundle.INSTANCE.message("action.install.text", new Object[0]);
        }
        this(path, string, string2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = RustProjectSettingsServiceKt.getToolchain(project2);
        if (object == null || (object = RustupKt.rustup((RsToolchainBase)object, this.projectDirectory)) == null) {
            return;
        }
        Object rustup = object;
        Notification.get((AnActionEvent)e).expire();
        Object[] objectArray = new Object[]{this.componentName};
        String string = RsBundle.INSTANCE.message("progress.title.installing2", objectArray);
        new Task.Backgroundable(project2, (Rustup)rustup, this, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Rustup $rustup;
            final /* synthetic */ InstallComponentAction this$0;
            {
                this.$project = $project;
                this.$rustup = $rustup;
                this.this$0 = $receiver;
                super($project, $super_call_param$1);
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                DownloadResult<Unit> downloadResult = this.$rustup.downloadComponent(this.$project, InstallComponentAction.access$getComponentName$p(this.this$0));
                DownloadResult.Err err = downloadResult instanceof DownloadResult.Err ? (DownloadResult.Err)downloadResult : null;
                if (err == null) {
                    return;
                }
                DownloadResult.Err result2 = err;
                UtilsKt.showBalloon$default(this.$project, "install.component.error", result2.getError(), NotificationType.ERROR, null, 8, null);
            }
        }.queue();
    }

    public static final /* synthetic */ String access$getComponentName$p(InstallComponentAction $this) {
        return $this.componentName;
    }
}

