/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.settings;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.StoredPropertyBase;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.debugger.DebuggerKind;
import org.rust.debugger.GDBRenderers;
import org.rust.debugger.LLDBRenderers;
import org.rust.debugger.LldbFlavor;
import org.rust.debugger.RsDebuggerBundle;
import org.rust.debugger.settings.RsDebuggerDataViewConfigurableUi;
import org.rust.debugger.settings.RsDebuggerGeneralSettingsConfigurableUi;
import org.rust.debugger.settings.RsDebuggerSteppingSettingsConfigurableUi;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0004789:B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010)\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020.H\u0002J\b\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020.H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020.H\u0016J\b\u00106\u001a\u00020\u0000H\u0016R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR$\u0010#\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001fR$\u0010&\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010\u001f\u00a8\u0006;"}, d2={"Lorg/rust/debugger/settings/RsDebuggerSettings;", "Lcom/intellij/xdebugger/settings/XDebuggerSettings;", "Lorg/rust/debugger/settings/RsDebuggerSettings$State;", "Ljava/util/function/Supplier;", "<init>", "()V", "state", "value", "Lorg/rust/debugger/LLDBRenderers;", "lldbRenderers", "getLldbRenderers", "()Lorg/rust/debugger/LLDBRenderers;", "setLldbRenderers", "(Lorg/rust/debugger/LLDBRenderers;)V", "Lorg/rust/debugger/GDBRenderers;", "gdbRenderers", "getGdbRenderers", "()Lorg/rust/debugger/GDBRenderers;", "setGdbRenderers", "(Lorg/rust/debugger/GDBRenderers;)V", "Lorg/rust/debugger/DebuggerKind;", "debuggerKind", "getDebuggerKind", "()Lorg/rust/debugger/DebuggerKind;", "setDebuggerKind", "(Lorg/rust/debugger/DebuggerKind;)V", "", "downloadAutomatically", "getDownloadAutomatically", "()Z", "setDownloadAutomatically", "(Z)V", "breakOnPanic", "getBreakOnPanic", "setBreakOnPanic", "skipStdlibInStepping", "getSkipStdlibInStepping", "setSkipStdlibInStepping", "decorateMsvcTypeNames", "getDecorateMsvcTypeNames", "setDecorateMsvcTypeNames", "getState", "loadState", "", "createConfigurables", "", "Lcom/intellij/openapi/options/Configurable;", "category", "Lcom/intellij/xdebugger/settings/DebuggerSettingsCategory;", "createDataViewConfigurable", "createGeneralSettingsConfigurable", "createSteppingConfigurable", "isTargetedToProduct", "configurable", "get", "State", "SettingsDebuggerKind", "Helper", "Companion", "intellij.rustrover.debugger"})
public final class RsDebuggerSettings
extends XDebuggerSettings<State>
implements Supplier<RsDebuggerSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State();
    @NotNull
    public static final String GENERAL_SETTINGS_ID = "Debugger.Rust.General";
    @NotNull
    public static final String DATA_VIEW_ID = "Debugger.Rust.DataView";
    @NotNull
    public static final String STEPPING_ID = "Debugger.Rust.Stepping";

    public RsDebuggerSettings() {
        super("Rust");
    }

    @NotNull
    public final LLDBRenderers getLldbRenderers() {
        return this.state.getLldbRenderers();
    }

    public final void setLldbRenderers(@NotNull LLDBRenderers value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.state.setLldbRenderers(value);
    }

    @NotNull
    public final GDBRenderers getGdbRenderers() {
        return this.state.getGdbRenderers();
    }

    public final void setGdbRenderers(@NotNull GDBRenderers value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.state.setGdbRenderers(value);
    }

    @NotNull
    public final DebuggerKind getDebuggerKind() {
        return this.state.getDebuggerKind().toDebuggerKind(this.state.getUserDebuggerPath());
    }

    public final void setDebuggerKind(@NotNull DebuggerKind value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Pair<SettingsDebuggerKind, String> pair = SettingsDebuggerKind.Companion.fromDebuggerKind(value);
        SettingsDebuggerKind kind2 = (SettingsDebuggerKind)((Object)pair.component1());
        String path = (String)pair.component2();
        this.state.setDebuggerKind(kind2);
        this.state.setUserDebuggerPath(path);
    }

    public final boolean getDownloadAutomatically() {
        return this.state.getDownloadAutomatically();
    }

    public final void setDownloadAutomatically(boolean value) {
        this.state.setDownloadAutomatically(value);
    }

    public final boolean getBreakOnPanic() {
        return this.state.getBreakOnPanic();
    }

    public final void setBreakOnPanic(boolean value) {
        this.state.setBreakOnPanic(value);
    }

    public final boolean getSkipStdlibInStepping() {
        return this.state.getSkipStdlibInStepping();
    }

    public final void setSkipStdlibInStepping(boolean value) {
        this.state.setSkipStdlibInStepping(value);
    }

    public final boolean getDecorateMsvcTypeNames() {
        return this.state.getDecorateMsvcTypeNames();
    }

    public final void setDecorateMsvcTypeNames(boolean value) {
        this.state.setDecorateMsvcTypeNames(value);
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.state = state;
    }

    @NotNull
    public Collection<Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Configurable configurable = switch (WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1 -> this.createDataViewConfigurable();
            case 2 -> this.createGeneralSettingsConfigurable();
            case 3 -> this.createSteppingConfigurable();
            default -> null;
        };
        return CollectionsKt.listOfNotNull((Object)configurable);
    }

    private final Configurable createDataViewConfigurable() {
        SimpleConfigurable simpleConfigurable = SimpleConfigurable.create((String)DATA_VIEW_ID, (String)RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.data.view.name", new Object[0]), (String)"rust.settings.typerenderers", RsDebuggerDataViewConfigurableUi.class, (Supplier)this);
        Intrinsics.checkNotNullExpressionValue((Object)simpleConfigurable, (String)"create(...)");
        return (Configurable)simpleConfigurable;
    }

    private final Configurable createGeneralSettingsConfigurable() {
        SimpleConfigurable simpleConfigurable = SimpleConfigurable.create((String)GENERAL_SETTINGS_ID, (String)RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.title", new Object[0]), RsDebuggerGeneralSettingsConfigurableUi.class, (Supplier)this);
        Intrinsics.checkNotNullExpressionValue((Object)simpleConfigurable, (String)"create(...)");
        return (Configurable)simpleConfigurable;
    }

    private final Configurable createSteppingConfigurable() {
        SimpleConfigurable simpleConfigurable = SimpleConfigurable.create((String)STEPPING_ID, (String)RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.title", new Object[0]), RsDebuggerSteppingSettingsConfigurableUi.class, (Supplier)this);
        Intrinsics.checkNotNullExpressionValue((Object)simpleConfigurable, (String)"create(...)");
        return (Configurable)simpleConfigurable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        if (!(configurable instanceof SearchableConfigurable)) {
            return false;
        }
        String string = ((SearchableConfigurable)configurable).getId();
        switch (string.hashCode()) {
            case 315479372: {
                if (string.equals(DATA_VIEW_ID)) return true;
                return false;
            }
            case -543326869: {
                if (string.equals(GENERAL_SETTINGS_ID)) return true;
                return false;
            }
            case -44278245: {
                if (!string.equals(STEPPING_ID)) return false;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public RsDebuggerSettings get() {
        return this;
    }

    public static final /* synthetic */ XDebuggerSettings access$getInstance$s1389033436(Class p0) {
        return XDebuggerSettings.getInstance((Class)p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/debugger/settings/RsDebuggerSettings$Companion;", "", "<init>", "()V", "GENERAL_SETTINGS_ID", "", "DATA_VIEW_ID", "STEPPING_ID", "intellij.rustrover.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/rust/debugger/settings/RsDebuggerSettings$Helper;", "", "<init>", "()V", "getInstance", "Lorg/rust/debugger/settings/RsDebuggerSettings;", "intellij.rustrover.debugger"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        @JvmStatic
        @NotNull
        public static final RsDebuggerSettings getInstance() {
            XDebuggerSettings xDebuggerSettings = RsDebuggerSettings.access$getInstance$s1389033436(RsDebuggerSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)xDebuggerSettings, (String)"access$getInstance$s1389033436(...)");
            return (RsDebuggerSettings)xDebuggerSettings;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\r"}, d2={"Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind;", "", "<init>", "(Ljava/lang/String;I)V", "LLDB", "RIDER_LLDB", "GDB", "USER_GDB", "toDebuggerKind", "Lorg/rust/debugger/DebuggerKind;", "userDebuggerPath", "", "Companion", "intellij.rustrover.debugger"})
    public static final class SettingsDebuggerKind
    extends Enum<SettingsDebuggerKind> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ SettingsDebuggerKind LLDB;
        public static final /* enum */ SettingsDebuggerKind RIDER_LLDB;
        public static final /* enum */ SettingsDebuggerKind GDB;
        public static final /* enum */ SettingsDebuggerKind USER_GDB;
        private static final /* synthetic */ SettingsDebuggerKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final DebuggerKind toDebuggerKind(@Nullable String userDebuggerPath) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> new DebuggerKind.LLDB(LldbFlavor.RustLldb);
                case 2 -> new DebuggerKind.LLDB(LldbFlavor.RiderLldb);
                case 3 -> DebuggerKind.GDB.INSTANCE;
                case 4 -> {
                    String v1 = userDebuggerPath;
                    if (v1 == null) {
                        v1 = "";
                    }
                    Path v2 = Path.of(v1, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"of(...)");
                    yield new DebuggerKind.UserGDB(v2);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static SettingsDebuggerKind[] values() {
            return (SettingsDebuggerKind[])$VALUES.clone();
        }

        public static SettingsDebuggerKind valueOf(String value) {
            return Enum.valueOf(SettingsDebuggerKind.class, value);
        }

        @NotNull
        public static EnumEntries<SettingsDebuggerKind> getEntries() {
            return $ENTRIES;
        }

        static {
            LLDB = new SettingsDebuggerKind();
            RIDER_LLDB = new SettingsDebuggerKind();
            GDB = new SettingsDebuggerKind();
            USER_GDB = new SettingsDebuggerKind();
            $VALUES = settingsDebuggerKindArray = new SettingsDebuggerKind[]{SettingsDebuggerKind.LLDB, SettingsDebuggerKind.RIDER_LLDB, SettingsDebuggerKind.GDB, SettingsDebuggerKind.USER_GDB};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind$Companion;", "", "<init>", "()V", "fromDebuggerKind", "Lkotlin/Pair;", "Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind;", "", "debuggerKind", "Lorg/rust/debugger/DebuggerKind;", "intellij.rustrover.debugger"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Pair<SettingsDebuggerKind, String> fromDebuggerKind(@NotNull DebuggerKind debuggerKind) {
                Pair pair;
                block9: {
                    DebuggerKind debuggerKind2;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)debuggerKind, (String)"debuggerKind");
                        debuggerKind2 = debuggerKind;
                        if (!(debuggerKind2 instanceof DebuggerKind.LLDB)) break block8;
                        switch (WhenMappings.$EnumSwitchMapping$0[((DebuggerKind.LLDB)debuggerKind).getFlavor().ordinal()]) {
                            case 1: {
                                pair = TuplesKt.to((Object)((Object)LLDB), null);
                                break block9;
                            }
                            case 2: {
                                pair = TuplesKt.to((Object)((Object)RIDER_LLDB), null);
                                break block9;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (Intrinsics.areEqual((Object)debuggerKind2, (Object)DebuggerKind.GDB.INSTANCE)) {
                        pair = TuplesKt.to((Object)((Object)GDB), null);
                    } else if (debuggerKind2 instanceof DebuggerKind.UserGDB) {
                        pair = TuplesKt.to((Object)((Object)USER_GDB), (Object)((Object)((DebuggerKind.UserGDB)debuggerKind).getPath()).toString());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return pair;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LldbFlavor.values().length];
                    try {
                        nArray[LldbFlavor.RustLldb.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LldbFlavor.RiderLldb.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SettingsDebuggerKind.values().length];
                try {
                    nArray[SettingsDebuggerKind.LLDB.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SettingsDebuggerKind.RIDER_LLDB.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SettingsDebuggerKind.GDB.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SettingsDebuggerKind.USER_GDB.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R/\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u001b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R+\u0010#\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\"8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R+\u0010)\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\"8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b,\u0010\f\u001a\u0004\b*\u0010%\"\u0004\b+\u0010'R+\u0010-\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\"8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u0010\f\u001a\u0004\b.\u0010%\"\u0004\b/\u0010'R+\u00101\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\"8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b4\u0010\f\u001a\u0004\b2\u0010%\"\u0004\b3\u0010'\u00a8\u00065"}, d2={"Lorg/rust/debugger/settings/RsDebuggerSettings$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "Lorg/rust/debugger/LLDBRenderers;", "lldbRenderers", "getLldbRenderers", "()Lorg/rust/debugger/LLDBRenderers;", "setLldbRenderers", "(Lorg/rust/debugger/LLDBRenderers;)V", "lldbRenderers$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lorg/rust/debugger/GDBRenderers;", "gdbRenderers", "getGdbRenderers", "()Lorg/rust/debugger/GDBRenderers;", "setGdbRenderers", "(Lorg/rust/debugger/GDBRenderers;)V", "gdbRenderers$delegate", "Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind;", "debuggerKind", "getDebuggerKind", "()Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind;", "setDebuggerKind", "(Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind;)V", "debuggerKind$delegate", "", "userDebuggerPath", "getUserDebuggerPath", "()Ljava/lang/String;", "setUserDebuggerPath", "(Ljava/lang/String;)V", "userDebuggerPath$delegate", "", "downloadAutomatically", "getDownloadAutomatically", "()Z", "setDownloadAutomatically", "(Z)V", "downloadAutomatically$delegate", "breakOnPanic", "getBreakOnPanic", "setBreakOnPanic", "breakOnPanic$delegate", "skipStdlibInStepping", "getSkipStdlibInStepping", "setSkipStdlibInStepping", "skipStdlibInStepping$delegate", "decorateMsvcTypeNames", "getDecorateMsvcTypeNames", "setDecorateMsvcTypeNames", "decorateMsvcTypeNames$delegate", "intellij.rustrover.debugger"})
    @SourceDebugExtension(value={"SMAP\nRsDebuggerSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebuggerSettings.kt\norg/rust/debugger/settings/RsDebuggerSettings$State\n+ 2 BaseState.kt\ncom/intellij/openapi/components/BaseState\n*L\n1#1,171:1\n87#2:172\n87#2:173\n87#2:174\n*S KotlinDebug\n*F\n+ 1 RsDebuggerSettings.kt\norg/rust/debugger/settings/RsDebuggerSettings$State\n*L\n121#1:172\n122#1:173\n124#1:174\n*E\n"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty lldbRenderers$delegate;
        @NotNull
        private final ReadWriteProperty gdbRenderers$delegate;
        @NotNull
        private final ReadWriteProperty debuggerKind$delegate;
        @NotNull
        private final ReadWriteProperty userDebuggerPath$delegate;
        @NotNull
        private final ReadWriteProperty downloadAutomatically$delegate;
        @NotNull
        private final ReadWriteProperty breakOnPanic$delegate;
        @NotNull
        private final ReadWriteProperty skipStdlibInStepping$delegate;
        @NotNull
        private final ReadWriteProperty decorateMsvcTypeNames$delegate;

        public State() {
            BaseState this_$iv;
            BaseState baseState = this;
            Enum defaultValue$iv = LLDBRenderers.Companion.getDEFAULT();
            boolean $i$f$enum = false;
            StoredPropertyBase storedPropertyBase = this_$iv.doEnum(defaultValue$iv, LLDBRenderers.class);
            Intrinsics.checkNotNull((Object)storedPropertyBase, (String)"null cannot be cast to non-null type com.intellij.openapi.components.StoredPropertyBase<T of com.intellij.openapi.components.BaseState.enum>");
            this.lldbRenderers$delegate = storedPropertyBase.provideDelegate((Object)this, $$delegatedProperties[0]);
            this_$iv = this;
            defaultValue$iv = GDBRenderers.Companion.getDEFAULT();
            $i$f$enum = false;
            StoredPropertyBase storedPropertyBase2 = this_$iv.doEnum(defaultValue$iv, GDBRenderers.class);
            Intrinsics.checkNotNull((Object)storedPropertyBase2, (String)"null cannot be cast to non-null type com.intellij.openapi.components.StoredPropertyBase<T of com.intellij.openapi.components.BaseState.enum>");
            this.gdbRenderers$delegate = storedPropertyBase2.provideDelegate((Object)this, $$delegatedProperties[1]);
            this_$iv = this;
            defaultValue$iv = (Enum)SettingsDebuggerKind.Companion.fromDebuggerKind(DebuggerKind.LLDB.Companion.defaultLldb()).getFirst();
            $i$f$enum = false;
            StoredPropertyBase storedPropertyBase3 = this_$iv.doEnum(defaultValue$iv, SettingsDebuggerKind.class);
            Intrinsics.checkNotNull((Object)storedPropertyBase3, (String)"null cannot be cast to non-null type com.intellij.openapi.components.StoredPropertyBase<T of com.intellij.openapi.components.BaseState.enum>");
            this.debuggerKind$delegate = storedPropertyBase3.provideDelegate((Object)this, $$delegatedProperties[2]);
            this.userDebuggerPath$delegate = this.string(null).provideDelegate((Object)this, $$delegatedProperties[3]);
            this.downloadAutomatically$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[4]);
            this.breakOnPanic$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[5]);
            this.skipStdlibInStepping$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[6]);
            this.decorateMsvcTypeNames$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[7]);
        }

        @NotNull
        public final LLDBRenderers getLldbRenderers() {
            return (LLDBRenderers)((Object)this.lldbRenderers$delegate.getValue((Object)this, $$delegatedProperties[0]));
        }

        public final void setLldbRenderers(@NotNull LLDBRenderers lLDBRenderers) {
            Intrinsics.checkNotNullParameter((Object)((Object)lLDBRenderers), (String)"<set-?>");
            this.lldbRenderers$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)lLDBRenderers);
        }

        @NotNull
        public final GDBRenderers getGdbRenderers() {
            return (GDBRenderers)((Object)this.gdbRenderers$delegate.getValue((Object)this, $$delegatedProperties[1]));
        }

        public final void setGdbRenderers(@NotNull GDBRenderers gDBRenderers) {
            Intrinsics.checkNotNullParameter((Object)((Object)gDBRenderers), (String)"<set-?>");
            this.gdbRenderers$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)gDBRenderers);
        }

        @NotNull
        public final SettingsDebuggerKind getDebuggerKind() {
            return (SettingsDebuggerKind)((Object)this.debuggerKind$delegate.getValue((Object)this, $$delegatedProperties[2]));
        }

        public final void setDebuggerKind(@NotNull SettingsDebuggerKind settingsDebuggerKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)settingsDebuggerKind), (String)"<set-?>");
            this.debuggerKind$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)settingsDebuggerKind);
        }

        @Nullable
        public final String getUserDebuggerPath() {
            return (String)this.userDebuggerPath$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        public final void setUserDebuggerPath(@Nullable String string) {
            this.userDebuggerPath$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
        }

        public final boolean getDownloadAutomatically() {
            return (Boolean)this.downloadAutomatically$delegate.getValue((Object)this, $$delegatedProperties[4]);
        }

        public final void setDownloadAutomatically(boolean bl) {
            this.downloadAutomatically$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)bl);
        }

        public final boolean getBreakOnPanic() {
            return (Boolean)this.breakOnPanic$delegate.getValue((Object)this, $$delegatedProperties[5]);
        }

        public final void setBreakOnPanic(boolean bl) {
            this.breakOnPanic$delegate.setValue((Object)this, $$delegatedProperties[5], (Object)bl);
        }

        public final boolean getSkipStdlibInStepping() {
            return (Boolean)this.skipStdlibInStepping$delegate.getValue((Object)this, $$delegatedProperties[6]);
        }

        public final void setSkipStdlibInStepping(boolean bl) {
            this.skipStdlibInStepping$delegate.setValue((Object)this, $$delegatedProperties[6], (Object)bl);
        }

        public final boolean getDecorateMsvcTypeNames() {
            return (Boolean)this.decorateMsvcTypeNames$delegate.getValue((Object)this, $$delegatedProperties[7]);
        }

        public final void setDecorateMsvcTypeNames(boolean bl) {
            this.decorateMsvcTypeNames$delegate.setValue((Object)this, $$delegatedProperties[7], (Object)bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "lldbRenderers", "getLldbRenderers()Lorg/rust/debugger/LLDBRenderers;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "gdbRenderers", "getGdbRenderers()Lorg/rust/debugger/GDBRenderers;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "debuggerKind", "getDebuggerKind()Lorg/rust/debugger/settings/RsDebuggerSettings$SettingsDebuggerKind;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "userDebuggerPath", "getUserDebuggerPath()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "downloadAutomatically", "getDownloadAutomatically()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "breakOnPanic", "getBreakOnPanic()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "skipStdlibInStepping", "getSkipStdlibInStepping()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "decorateMsvcTypeNames", "getDecorateMsvcTypeNames()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DebuggerSettingsCategory.values().length];
            try {
                nArray[DebuggerSettingsCategory.DATA_VIEWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebuggerSettingsCategory.GENERAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebuggerSettingsCategory.STEPPING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

