/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.util.ListenerWithValueUiUtil;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrSeparator;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.debugger.DebuggerAvailability;
import org.rust.debugger.DebuggerKind;
import org.rust.debugger.LldbFlavor;
import org.rust.debugger.RsDebuggerBundle;
import org.rust.debugger.RsDebuggerToolchainService;
import org.rust.debugger.settings.RsDebuggerKindComboBoxKt;
import org.rust.debugger.settings.RsDebuggerKindPathAccessor;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J.\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010!\u0012\u0004\u0012\u00020\u00150 J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/rust/debugger/settings/RsDebuggerKindComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/rust/debugger/DebuggerKind;", "model", "Lcom/intellij/ui/MutableCollectionComboBoxModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/ui/MutableCollectionComboBoxModel;Lcom/intellij/openapi/Disposable;)V", "comment", "Ljavax/swing/JEditorPane;", "firstCustomItem", "browseAction", "Lcom/intellij/openapi/ui/BrowseFolderRunnable;", "value", "selectedKind", "getSelectedKind", "()Lorg/rust/debugger/DebuggerKind;", "setSelectedKind", "(Lorg/rust/debugger/DebuggerKind;)V", "setSelectedItem", "", "newItem", "", "setupEditablePath", "updateEditability", "addUnique", "item", "buildUi", "row", "Lcom/intellij/ui/dsl/builder/Row;", "adjustCell", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Cell;", "downloadDebugger", "update", "Companion", "intellij.rustrover.debugger"})
public class RsDebuggerKindComboBox
extends ComboBox<DebuggerKind> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableCollectionComboBoxModel<DebuggerKind> model;
    @Nullable
    private JEditorPane comment;
    @Nullable
    private DebuggerKind firstCustomItem;
    @NotNull
    private final BrowseFolderRunnable<RsDebuggerKindComboBox> browseAction;
    @NotNull
    private static final Supplier<String> DEFAULT_LABEL = RsDebuggerBundle.INSTANCE.messagePointer("settings.rust.debugger.toolchain.debugger.label", new Object[0]);

    public RsDebuggerKindComboBox(@NotNull MutableCollectionComboBoxModel<DebuggerKind> model, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super((ComboBoxModel)model);
        this.model = model;
        this.browseAction = new BrowseFolderRunnable(null, FileChooserDescriptorFactory.singleFile().withTitle(RsDebuggerBundle.INSTANCE.message("gdb.user.select", new Object[0])), (JComponent)((Object)this), (TextComponentAccessor)new RsDebuggerKindPathAccessor());
        this.setPrototypeDisplayValue(new DebuggerKind.LLDB(LldbFlavor.RustLldb));
        this.setupEditablePath(parentDisposable);
    }

    @NotNull
    public final DebuggerKind getSelectedKind() {
        Object object = this.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (DebuggerKind)object;
    }

    public final void setSelectedKind(@NotNull DebuggerKind value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addUnique(value);
        this.setItem(value);
    }

    public void setSelectedItem(@Nullable Object newItem) {
        super.setSelectedItem(newItem);
        if (Intrinsics.areEqual((Object)newItem, (Object)RsDebuggerKindComboBoxKt.access$getCUSTOM_GDB_EXECUTABLE$p())) {
            this.browseAction.run();
        }
    }

    private final void setupEditablePath(Disposable parentDisposable) {
        this.initBrowsableEditor((Runnable)this.browseAction, parentDisposable);
        this.renderer = BuilderKt.listCellRenderer(arg_0 -> RsDebuggerKindComboBox.setupEditablePath$lambda$0(this, arg_0));
        this.addActionListener(arg_0 -> RsDebuggerKindComboBox.setupEditablePath$lambda$1(this, arg_0));
        this.updateEditability();
    }

    private final void updateEditability() {
        this.setEditable(this.getItem() instanceof DebuggerKind.UserGDB);
    }

    private final void addUnique(DebuggerKind item) {
        if (this.model.getItems().contains(item)) {
            return;
        }
        this.model.insertElementAt((Object)item, this.model.getSize() - 1);
        if (this.firstCustomItem == null) {
            this.firstCustomItem = item;
        }
    }

    public final void buildUi(@NotNull Row row, @NotNull Function1<? super Cell<? extends ComboBox<DebuggerKind>>, Unit> adjustCell) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter(adjustCell, (String)"adjustCell");
        RsDebuggerKindComboBox comboBox = this;
        Row $this$buildUi_u24lambda_u240 = row;
        boolean bl = false;
        Cell box = $this$buildUi_u24lambda_u240.cell((JComponent)((Object)comboBox)).applyToComponent(RsDebuggerKindComboBox::buildUi$lambda$0$0);
        adjustCell.invoke((Object)box);
        this.comment = Cell.comment$default((Cell)box, (String)"", (int)0, arg_0 -> RsDebuggerKindComboBox.buildUi$lambda$0$1(this, arg_0), (int)2, null).getComment();
        this.update();
    }

    public final void buildUi(@NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        this.buildUi(row, (Function1<? super Cell<? extends ComboBox<DebuggerKind>>, Unit>)((Function1)RsDebuggerKindComboBox::buildUi$lambda$1));
    }

    private final void downloadDebugger() {
        RsDebuggerToolchainService.DownloadResult result2 = RsDebuggerToolchainService.downloadDebugger$default(RsDebuggerToolchainService.Companion.getInstance(), null, this.getSelectedKind(), 1, null);
        if (result2 instanceof RsDebuggerToolchainService.DownloadResult.Ok) {
            this.update();
        }
    }

    private final void update() {
        block1: {
            DebuggerAvailability<?> availability = RsDebuggerToolchainService.Companion.getInstance().debuggerAvailability(this.getSelectedKind(), null);
            DebuggerAvailability<?> debuggerAvailability = availability;
            String text = Intrinsics.areEqual(debuggerAvailability, (Object)DebuggerAvailability.NeedToDownload.INSTANCE) ? RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.toolchain.download.comment", new Object[0]) : (Intrinsics.areEqual(debuggerAvailability, (Object)DebuggerAvailability.NeedToUpdate.INSTANCE) ? RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.toolchain.update.comment", new Object[0]) : null);
            JEditorPane jEditorPane = this.comment;
            if (jEditorPane != null) {
                jEditorPane.setText(text);
            }
            JEditorPane jEditorPane2 = this.comment;
            if (jEditorPane2 == null) break block1;
            jEditorPane2.setVisible(text != null);
        }
    }

    private static final Unit setupEditablePath$lambda$0(RsDebuggerKindComboBox this$0, LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        DebuggerKind item = (DebuggerKind)$this$listCellRenderer.getValue();
        if (Intrinsics.areEqual((Object)item, (Object)RsDebuggerKindComboBoxKt.access$getCUSTOM_GDB_EXECUTABLE$p())) {
            $this$listCellRenderer.separator(RsDebuggerKindComboBox::setupEditablePath$lambda$0$0);
            $this$listCellRenderer.text(RsDebuggerBundle.INSTANCE.message("gdb.user.select", new Object[0]), RsDebuggerKindComboBox::setupEditablePath$lambda$0$1);
        } else if (item instanceof DebuggerKind.UserGDB) {
            if (Intrinsics.areEqual((Object)item, (Object)this$0.firstCustomItem)) {
                $this$listCellRenderer.separator(RsDebuggerKindComboBox::setupEditablePath$lambda$0$2);
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(((DebuggerKind.UserGDB)item).getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path = ((DebuggerKind.UserGDB)item).getPath().getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFileName(...)");
                LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)UtilsKt.nlsSafeToString(path), null, (int)2, null);
            }
            $this$listCellRenderer.text(UtilsKt.nlsSafeToString(((DebuggerKind.UserGDB)item).getPath()), RsDebuggerKindComboBox::setupEditablePath$lambda$0$3);
        } else {
            Intrinsics.checkNotNull((Object)item);
            LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)UtilsKt.nlsSafeToString(item), null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupEditablePath$lambda$0$0(LcrSeparator $this$separator) {
        Intrinsics.checkNotNullParameter((Object)$this$separator, (String)"$this$separator");
        return Unit.INSTANCE;
    }

    private static final Unit setupEditablePath$lambda$0$1(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAttributes(SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit setupEditablePath$lambda$0$2(LcrSeparator $this$separator) {
        Intrinsics.checkNotNullParameter((Object)$this$separator, (String)"$this$separator");
        return Unit.INSTANCE;
    }

    private static final Unit setupEditablePath$lambda$0$3(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAttributes(SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final void setupEditablePath$lambda$1(RsDebuggerKindComboBox this$0, ActionEvent it2) {
        Object object = this$0.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        this$0.addUnique((DebuggerKind)object);
        this$0.updateEditability();
    }

    private static final Unit buildUi$lambda$0$0(RsDebuggerKindComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyToComponent), (String)"$this$applyToComponent");
        ListenerWithValueUiUtil.whenItemSelected$default((JComboBox)((JComboBox)((Object)$this$applyToComponent)), null, arg_0 -> RsDebuggerKindComboBox.buildUi$lambda$0$0$0($this$applyToComponent, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$0$0$0(RsDebuggerKindComboBox $this_applyToComponent, DebuggerKind it2) {
        $this_applyToComponent.update();
        return Unit.INSTANCE;
    }

    private static final void buildUi$lambda$0$1(RsDebuggerKindComboBox this$0, HyperlinkEvent it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        this$0.downloadDebugger();
    }

    private static final Unit buildUi$lambda$1(Cell it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        ComboBoxKt.columns((Cell)it2, (int)18);
        return Unit.INSTANCE;
    }

    @NotNull
    public static final Supplier<String> getDEFAULT_LABEL() {
        return Companion.getDEFAULT_LABEL();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/rust/debugger/settings/RsDebuggerKindComboBox$Companion;", "", "<init>", "()V", "DEFAULT_LABEL", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "getDEFAULT_LABEL$annotations", "getDEFAULT_LABEL", "()Ljava/util/function/Supplier;", "intellij.rustrover.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<String> getDEFAULT_LABEL() {
            return DEFAULT_LABEL;
        }

        @JvmStatic
        public static /* synthetic */ void getDEFAULT_LABEL$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

