/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.settings;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.debugger.DebuggerAvailability;
import org.rust.debugger.GDBRenderers;
import org.rust.debugger.LLDBRenderers;
import org.rust.debugger.RsDebuggerBundle;
import org.rust.debugger.RsDebuggerToolchainService;
import org.rust.debugger.settings.RsDebuggerSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/debugger/settings/RsDebuggerDataViewConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/rust/debugger/settings/RsDebuggerSettings;", "<init>", "()V", "lldbRenderers", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/rust/debugger/LLDBRenderers;", "gdbRenderers", "Lorg/rust/debugger/GDBRenderers;", "decorateMsvcTypeNames", "Lcom/intellij/ui/components/JBCheckBox;", "isModified", "", "settings", "apply", "", "reset", "getComponent", "Ljavax/swing/JComponent;", "intellij.rustrover.debugger"})
@SourceDebugExtension(value={"SMAP\nRsDebuggerDataViewConfigurableUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebuggerDataViewConfigurableUi.kt\norg/rust/debugger/settings/RsDebuggerDataViewConfigurableUi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1869#2,2:62\n1869#2,2:64\n*S KotlinDebug\n*F\n+ 1 RsDebuggerDataViewConfigurableUi.kt\norg/rust/debugger/settings/RsDebuggerDataViewConfigurableUi\n*L\n19#1:62,2\n23#1:64,2\n*E\n"})
public final class RsDebuggerDataViewConfigurableUi
implements ConfigurableUi<RsDebuggerSettings> {
    @NotNull
    private final ComboBox<LLDBRenderers> lldbRenderers;
    @NotNull
    private final ComboBox<GDBRenderers> gdbRenderers;
    @NotNull
    private final JBCheckBox decorateMsvcTypeNames;

    /*
     * WARNING - void declaration
     */
    public RsDebuggerDataViewConfigurableUi() {
        ComboBox $this$lldbRenderers_u24lambda_u240;
        Enum it2;
        ComboBox comboBox;
        ComboBox comboBox2 = comboBox = new ComboBox();
        RsDebuggerDataViewConfigurableUi rsDebuggerDataViewConfigurableUi = this;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)LLDBRenderers.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (LLDBRenderers)((Object)element$iv);
            boolean bl2 = false;
            $this$lldbRenderers_u24lambda_u240.addItem((Object)it2);
        }
        rsDebuggerDataViewConfigurableUi.lldbRenderers = comboBox;
        $this$lldbRenderers_u24lambda_u240 = comboBox = new ComboBox();
        rsDebuggerDataViewConfigurableUi = this;
        boolean bl3 = false;
        $this$forEach$iv = (Iterable)GDBRenderers.getEntries();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$gdbRenderers_u24lambda_u240;
            it2 = (GDBRenderers)((Object)element$iv);
            boolean bl4 = false;
            $this$gdbRenderers_u24lambda_u240.addItem((Object)it2);
        }
        rsDebuggerDataViewConfigurableUi.gdbRenderers = comboBox;
        this.decorateMsvcTypeNames = new JBCheckBox(RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.decorate.msvc.type.names.checkbox", new Object[0]), RsDebuggerSettings.Helper.getInstance().getDecorateMsvcTypeNames());
    }

    public boolean isModified(@NotNull RsDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.lldbRenderers.getSelectedIndex() != settings.getLldbRenderers().ordinal() || this.gdbRenderers.getSelectedIndex() != settings.getGdbRenderers().ordinal() || this.decorateMsvcTypeNames.isSelected() != settings.getDecorateMsvcTypeNames();
    }

    public void apply(@NotNull RsDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        settings.setLldbRenderers(LLDBRenderers.Companion.fromIndex(this.lldbRenderers.getSelectedIndex()));
        settings.setGdbRenderers(GDBRenderers.Companion.fromIndex(this.gdbRenderers.getSelectedIndex()));
        settings.setDecorateMsvcTypeNames(this.decorateMsvcTypeNames.isSelected());
    }

    public void reset(@NotNull RsDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.lldbRenderers.setSelectedIndex(settings.getLldbRenderers().ordinal());
        this.gdbRenderers.setSelectedIndex(settings.getGdbRenderers().ordinal());
        this.decorateMsvcTypeNames.setSelected(settings.getDecorateMsvcTypeNames());
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> RsDebuggerDataViewConfigurableUi.getComponent$lambda$0(this, arg_0));
    }

    private static final Unit getComponent$lambda$0(RsDebuggerDataViewConfigurableUi this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.data.view.lldb.renderers.label", new Object[0]), arg_0 -> RsDebuggerDataViewConfigurableUi.getComponent$lambda$0$0(this$0, arg_0));
        if (!Intrinsics.areEqual((Object)RsDebuggerToolchainService.gdbAvailability$default(RsDebuggerToolchainService.Companion.getInstance(), null, 1, null), (Object)DebuggerAvailability.Unavailable.INSTANCE)) {
            $this$panel.row(RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.data.view.gdb.renderers.label", new Object[0]), arg_0 -> RsDebuggerDataViewConfigurableUi.getComponent$lambda$0$1(this$0, arg_0));
        }
        if (SystemInfo.isWindows) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> RsDebuggerDataViewConfigurableUi.getComponent$lambda$0$2(this$0, arg_0), (int)1, null);
        }
        Panel.row$default((Panel)$this$panel, null, RsDebuggerDataViewConfigurableUi::getComponent$lambda$0$3, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0(RsDebuggerDataViewConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.lldbRenderers);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$1(RsDebuggerDataViewConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.gdbRenderers);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$2(RsDebuggerDataViewConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.decorateMsvcTypeNames);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)RsDebuggerBundle.INSTANCE.message("settings.rust.debugger.data.view.change.renderers.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }
}

