/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.runconfig;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.runconfig.BuildResult;
import org.rust.cargo.runconfig.CargoRunStateBase;
import org.rust.cargo.runconfig.CargoTestRunState;
import org.rust.cargo.runconfig.RsExecutableRunner;
import org.rust.cargo.runconfig.RsToolchainHost;
import org.rust.cargo.runconfig.console.RsBasicConsoleBuilder;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.eel.RsEelToolchain;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.debugger.DebuggerAvailability;
import org.rust.debugger.DebuggerKind;
import org.rust.debugger.RsDebuggerBundle;
import org.rust.debugger.RsDebuggerToolchainService;
import org.rust.debugger.UtilsKt;
import org.rust.debugger.runconfig.RsDebugRunParameters;
import org.rust.debugger.runconfig.RsLocalDebugProcess;
import org.rust.debugger.settings.RsDebuggerSettings;
import org.rust.ide.notifications.RsNotifications;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010 \u001a\u00020\u00052\b\b\u0001\u0010!\u001a\u00020\u0005H\u0002R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/rust/debugger/runconfig/RsDebugRunnerUtils;", "", "<init>", "()V", "ERROR_MESSAGE_TITLE", "", "getERROR_MESSAGE_TITLE", "()Ljava/lang/String;", "showRunContent", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lorg/rust/cargo/runconfig/CargoRunStateBase;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "runExecutable", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "isEmulateTerminalSupported", "", "debuggerKind", "Lorg/rust/debugger/DebuggerKind;", "configureAfterSessionStart", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "checkToolchainSupported", "Lorg/rust/cargo/runconfig/BuildResult$ToolchainError;", "project", "Lcom/intellij/openapi/project/Project;", "host", "Lorg/rust/cargo/runconfig/RsToolchainHost;", "checkToolchainConfigured", "showDialog", "message", "action", "intellij.rustrover.debugger"})
@SourceDebugExtension(value={"SMAP\nRsDebugRunnerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebugRunnerUtils.kt\norg/rust/debugger/runconfig/RsDebugRunnerUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class RsDebugRunnerUtils {
    @NotNull
    public static final RsDebugRunnerUtils INSTANCE = new RsDebugRunnerUtils();
    @Nls
    @NotNull
    private static final String ERROR_MESSAGE_TITLE = RsBundle.INSTANCE.message("unable.to.run.debugger", new Object[0]);

    private RsDebugRunnerUtils() {
    }

    @NotNull
    public final String getERROR_MESSAGE_TITLE() {
        return ERROR_MESSAGE_TITLE;
    }

    @NotNull
    public final RunContentDescriptor showRunContent(@NotNull CargoRunStateBase state, @NotNull ExecutionEnvironment environment, @NotNull GeneralCommandLine runExecutable) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)runExecutable, (String)"runExecutable");
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DebuggerKind debuggerKind = this.debuggerKind(project, RsExecutableRunner.Companion.getRustToolchainHost(environment));
        boolean emulationSupported = this.isEmulateTerminalSupported(state, debuggerKind);
        RsDebugRunParameters runParameters = new RsDebugRunParameters(environment, runExecutable, state.getCargoProject(), !(state instanceof CargoTestRunState) && state.getRunConfiguration().getWithSudo(), emulationSupported && state.getRunConfiguration().getEmulateTerminal());
        TextConsoleBuilder consoleBuilder = !emulationSupported && !(state instanceof CargoTestRunState) && state.getRunConfiguration().getEmulateTerminal() ? (TextConsoleBuilder)new RsBasicConsoleBuilder(state.getProject(), state.getRunConfiguration()) : state.getConsoleBuilder();
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(runParameters, consoleBuilder, environment){
            final /* synthetic */ RsDebugRunParameters $runParameters;
            final /* synthetic */ TextConsoleBuilder $consoleBuilder;
            final /* synthetic */ ExecutionEnvironment $environment;
            {
                this.$runParameters = $runParameters;
                this.$consoleBuilder = $consoleBuilder;
                this.$environment = $environment;
            }

            public XDebugProcess start(XDebugSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                Object object = this.$consoleBuilder;
                Intrinsics.checkNotNull((Object)object);
                object = new RsLocalDebugProcess(this.$runParameters, session2, (TextConsoleBuilder)object);
                ExecutionEnvironment executionEnvironment = this.$environment;
                Object $this$start_u24lambda_u240 = object;
                boolean bl = false;
                ProcessTerminatedListener.attach((ProcessHandler)$this$start_u24lambda_u240.getProcessHandler(), (Project)executionEnvironment.getProject());
                $this$start_u24lambda_u240.start();
                return (XDebugProcess)object;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
        XDebugSession session2 = xDebugSession;
        this.configureAfterSessionStart(session2);
        RunContentDescriptor runContentDescriptor = session2.getRunContentDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"getRunContentDescriptor(...)");
        return runContentDescriptor;
    }

    private final boolean isEmulateTerminalSupported(CargoRunStateBase state, DebuggerKind debuggerKind) {
        if (state instanceof CargoTestRunState) {
            return false;
        }
        return !(debuggerKind instanceof DebuggerKind.GDB) || !SystemInfo.isWindows;
    }

    private final void configureAfterSessionStart(XDebugSession session2) {
        XDebugProcess xDebugProcess = session2.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"getDebugProcess(...)");
        XDebugProcess debugProcess = xDebugProcess;
        if (debugProcess instanceof CidrDebugProcess) {
            ((CidrDebugProcess)debugProcess).afterDebugSessionStarted();
        }
    }

    @Nullable
    public final BuildResult.ToolchainError checkToolchainSupported(@NotNull Project project, @NotNull RsToolchainHost host) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (SystemInfo.isWindows) {
            String notificationMessage;
            boolean isGdbAvailable;
            boolean bl = isGdbAvailable = !(RsDebuggerToolchainService.Companion.getInstance().gdbAvailability(project) instanceof DebuggerAvailability.Unavailable);
            if (RustProjectSettingsServiceKt.getToolchain(project) instanceof RsWslToolchain) {
                return isGdbAvailable ? null : (BuildResult.ToolchainError)BuildResult.ToolchainError.UnsupportedWSL.INSTANCE;
            }
            if (host.isGNUToolchain() && !isGdbAvailable) {
                return BuildResult.ToolchainError.UnsupportedGNU.INSTANCE;
            }
            DebuggerKind debuggerKind = RsDebuggerSettings.Helper.getInstance().getDebuggerKind();
            String string = host.isGNUToolchain() && debuggerKind instanceof DebuggerKind.LLDB ? RsDebuggerBundle.INSTANCE.message("notification.content.lldb.with.gnu.toolchain.warning", new Object[0]) : (notificationMessage = host.isMSVCToolchain() && Intrinsics.areEqual((Object)debuggerKind, (Object)DebuggerKind.GDB.INSTANCE) ? RsDebuggerBundle.INSTANCE.message("notification.content.gdb.with.msvc.toolchain.warning", new Object[0]) : null);
            if (notificationMessage != null) {
                UtilsKt.debuggingNotifications(RsNotifications.INSTANCE).createNotification(RsDebuggerBundle.INSTANCE.message("notification.title.mismatched.toolchain.and.debugger", new Object[0]), notificationMessage, NotificationType.WARNING).notify(project);
            }
        }
        return null;
    }

    public final boolean checkToolchainConfigured(@NotNull Project project, @NotNull RsToolchainHost host) {
        RsDebuggerToolchainService.DownloadResult result2;
        boolean downloadDebugger;
        Pair pair;
        DebuggerAvailability<?> debuggerAvailability;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        DebuggerKind debuggerKind = this.debuggerKind(project, host);
        DebuggerAvailability<?> debuggerAvailability2 = debuggerAvailability = RsDebuggerToolchainService.Companion.getInstance().debuggerAvailability(debuggerKind, project);
        if (Intrinsics.areEqual(debuggerAvailability2, (Object)DebuggerAvailability.Unavailable.INSTANCE)) {
            return false;
        }
        if (Intrinsics.areEqual(debuggerAvailability2, (Object)DebuggerAvailability.NeedToDownload.INSTANCE)) {
            pair = TuplesKt.to((Object)"Debugger is not loaded yet", (Object)"Download");
        } else if (Intrinsics.areEqual(debuggerAvailability2, (Object)DebuggerAvailability.NeedToUpdate.INSTANCE)) {
            pair = TuplesKt.to((Object)"Debugger is outdated", (Object)"Update");
        } else {
            if (Intrinsics.areEqual(debuggerAvailability2, (Object)DebuggerAvailability.Bundled.INSTANCE) || debuggerAvailability2 instanceof DebuggerAvailability.WSL || debuggerAvailability2 instanceof DebuggerAvailability.Eel || debuggerAvailability2 instanceof DebuggerAvailability.Binaries) {
                return true;
            }
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String message = (String)pair2.component1();
        String action2 = (String)pair2.component2();
        boolean bl = downloadDebugger = !RsDebuggerSettings.Helper.getInstance().getDownloadAutomatically() ? this.showDialog(project, message, action2) : true;
        return downloadDebugger && (result2 = RsDebuggerToolchainService.Companion.getInstance().downloadDebugger(project, debuggerKind)) instanceof RsDebuggerToolchainService.DownloadResult.Ok;
    }

    @NotNull
    public final DebuggerKind debuggerKind(@NotNull Project project, @NotNull RsToolchainHost host) {
        DebuggerKind debuggerKind;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
        DebuggerKind configuredDebuggerKind = RsDebuggerSettings.Helper.getInstance().getDebuggerKind();
        if (toolchain2 instanceof RsEelToolchain) {
            return DebuggerKind.GDB.INSTANCE;
        }
        if (SystemInfo.isWindows) {
            if (toolchain2 instanceof RsWslToolchain) {
                debuggerKind = DebuggerKind.GDB.INSTANCE;
            } else if (host.isGNUToolchain()) {
                debuggerKind = DebuggerKind.GDB.INSTANCE;
            } else if (host.isMSVCToolchain()) {
                DebuggerKind debuggerKind2;
                DebuggerKind it2 = debuggerKind2 = configuredDebuggerKind;
                boolean bl = false;
                debuggerKind = it2 instanceof DebuggerKind.LLDB ? debuggerKind2 : null;
                if (debuggerKind == null) {
                    debuggerKind = DebuggerKind.LLDB.Companion.defaultLldb();
                }
            } else {
                debuggerKind = configuredDebuggerKind;
            }
        } else {
            debuggerKind = configuredDebuggerKind;
        }
        return debuggerKind;
    }

    private final boolean showDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.Button String action2) {
        DoNotAskOption.Adapter doNotAsk2 = new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (exitCode == 0) {
                    RsDebuggerSettings.Helper.getInstance().setDownloadAutomatically(isSelected);
                }
            }
        };
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(ERROR_MESSAGE_TITLE, message).yesText(action2)).icon(Messages.getErrorIcon())).doNotAsk((DoNotAskOption)doNotAsk2)).ask(project);
    }
}

