/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.runconfig;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.debugger.runconfig.RsDebugProcessConfigurationHelper;
import org.rust.debugger.runconfig.RsLocalDebugProcess;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/rust/debugger/runconfig/RsDebugProcessConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "Helper", "intellij.rustrover.debugger"})
public final class RsDebugProcessConfigurator
implements CidrDebugProcessConfigurator {
    public void configure(@NotNull CidrDebugProcess process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        CargoProject cargoProject = Helper.INSTANCE.findCargoProject(process2);
        if (cargoProject == null) {
            return;
        }
        CargoProject cargoProject2 = cargoProject;
        new RsDebugProcessConfigurationHelper(process2, cargoProject2).configure();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/debugger/runconfig/RsDebugProcessConfigurator$Helper;", "", "<init>", "()V", "findCargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "intellij.rustrover.debugger"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        @Nullable
        public final CargoProject findCargoProject(@NotNull CidrDebugProcess process2) {
            CargoProject cargoProject;
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            if (process2 instanceof RsLocalDebugProcess) {
                cargoProject = ((RsLocalDebugProcess)process2).getRunParameters().getCargoProject();
            } else {
                Project project = process2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                if (CargoProjectServiceKt.getCargoProjects(project).getHasAtLeastOneValidProject()) {
                    Project project2 = process2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"<get-project>(...)");
                    cargoProject = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(project2).getAllProjects());
                } else {
                    cargoProject = null;
                }
            }
            return cargoProject;
        }
    }
}

