/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.runconfig;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.debugger.GDBRenderers;
import org.rust.debugger.LLDBRenderers;
import org.rust.debugger.PrettyPrintersKt;
import org.rust.debugger.settings.RsDebuggerSettings;
import org.rust.ide.notifications.UtilsKt;
import org.rust.openapiext.RsPathManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001c\u001a\u00020\u001b*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001b*\u00020\u001dH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u001dH\u0002J\f\u0010!\u001a\u00020\u001b*\u00020\u001dH\u0002J\f\u0010\"\u001a\u00020\u001b*\u00020\u001dH\u0002J\f\u0010\"\u001a\u00020\u001b*\u00020#H\u0002J\f\u0010\"\u001a\u00020\u001b*\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u001b2\b\b\u0001\u0010&\u001a\u00020\u0014H\u0002J\u001e\u0010'\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010&\u001a\u00020\u0014H\u0002J\f\u0010(\u001a\u00020\u0014*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/rust/debugger/runconfig/RsDebugProcessConfigurationHelper;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lorg/rust/cargo/project/model/CargoProject;)V", "settings", "Lorg/rust/debugger/settings/RsDebuggerSettings;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "threadId", "", "frameIndex", "", "prettyPrintersPath", "", "projectRootDir", "Ljava/nio/file/Path;", "rustcInfo", "Lorg/rust/cargo/project/model/RustcInfo;", "sysroot", "configure", "", "setBreakOnPanic", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "setSteppingFilters", "addStdlibPathMapping", "", "addRealToLinkedPathMapping", "loadPrettyPrinters", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "showWarning", "message", "checkSysroot", "systemDependentAndEscaped", "Companion", "intellij.rustrover.debugger"})
@SourceDebugExtension(value={"SMAP\nRsDebugProcessConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebugProcessConfigurationHelper.kt\norg/rust/debugger/runconfig/RsDebugProcessConfigurationHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,221:1\n1#2:222\n13#3:223\n*S KotlinDebug\n*F\n+ 1 RsDebugProcessConfigurationHelper.kt\norg/rust/debugger/runconfig/RsDebugProcessConfigurationHelper\n*L\n218#1:223\n*E\n"})
public final class RsDebugProcessConfigurationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CidrDebugProcess process;
    @NotNull
    private final RsDebuggerSettings settings;
    @NotNull
    private final Project project;
    @Nullable
    private final RsToolchainBase toolchain;
    private final long threadId;
    private final int frameIndex;
    @Nullable
    private final String prettyPrintersPath;
    @NotNull
    private final Path projectRootDir;
    @Nullable
    private final RustcInfo rustcInfo;
    @Nullable
    private final String sysroot;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public RsDebugProcessConfigurationHelper(@NotNull CidrDebugProcess process2, @NotNull CargoProject cargoProject) {
        String string;
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        this.process = process2;
        this.settings = RsDebuggerSettings.Helper.getInstance();
        Project project = this.process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        this.project = project;
        Project project2 = this.process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"<get-project>(...)");
        this.toolchain = RustProjectSettingsServiceKt.getToolchain(project2);
        this.threadId = this.process.getCurrentThreadId();
        this.frameIndex = this.process.getCurrentFrameIndex();
        RsToolchainBase rsToolchainBase = this.toolchain;
        this.prettyPrintersPath = rsToolchainBase != null ? rsToolchainBase.toRemotePath(PrettyPrintersKt.getPP_PATH()) : null;
        this.projectRootDir = cargoProject.getRootDirPath();
        this.rustcInfo = cargoProject.getRustcInfo();
        RsDebugProcessConfigurationHelper rsDebugProcessConfigurationHelper = this;
        Object object = this.rustcInfo;
        if (object != null && (object = ((RustcInfo)object).getSysroot()) != null) {
            void it2;
            Object object2 = object;
            RsDebugProcessConfigurationHelper rsDebugProcessConfigurationHelper2 = rsDebugProcessConfigurationHelper;
            boolean bl = false;
            RsToolchainBase rsToolchainBase2 = this.toolchain;
            string = rsToolchainBase2 != null ? rsToolchainBase2.toRemotePath((String)it2) : null;
            rsDebugProcessConfigurationHelper = rsDebugProcessConfigurationHelper2;
        } else {
            string = null;
        }
        rsDebugProcessConfigurationHelper.sysroot = string;
    }

    public final void configure() {
        this.process.postCommand(arg_0 -> RsDebugProcessConfigurationHelper.configure$lambda$0(this, arg_0));
    }

    private final void setBreakOnPanic(DebuggerDriver $this$setBreakOnPanic) {
        List list;
        DebuggerDriver debuggerDriver = $this$setBreakOnPanic;
        if (debuggerDriver instanceof LLDBDriver) {
            list = CollectionsKt.listOf((Object)"breakpoint set -n rust_panic");
        } else if (debuggerDriver instanceof GDBDriver) {
            Object[] objectArray = new String[]{"set breakpoint pending on", "break rust_panic", "break __rustc::rust_panic"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            return;
        }
        List commands = list;
        for (String command : commands) {
            $this$setBreakOnPanic.executeInterpreterCommand(this.threadId, this.frameIndex, command);
        }
    }

    private final void setSteppingFilters(DebuggerDriver $this$setSteppingFilters) {
        String string;
        Object object;
        List regexes = new ArrayList();
        if (this.settings.getSkipStdlibInStepping()) {
            regexes.add("^(std|core|alloc)::.*");
        }
        if ((object = $this$setSteppingFilters) instanceof LLDBDriver) {
            string = "settings set target.process.thread.step-avoid-regexp";
        } else if (object instanceof GDBDriver) {
            string = "skip -rfu";
        } else {
            return;
        }
        String command = string;
        for (String regex : regexes) {
            $this$setSteppingFilters.executeInterpreterCommand(this.threadId, this.frameIndex, command + " " + regex);
        }
    }

    private final boolean addStdlibPathMapping(DebuggerDriver $this$addStdlibPathMapping) {
        if (this.toolchain == null) {
            return false;
        }
        Object object = this.rustcInfo;
        if (object == null || (object = ((RustcInfo)object).getVersion()) == null) {
            return false;
        }
        Object version = object;
        String string = ((RustcVersion)version).getCommitHash();
        if (string == null) {
            return false;
        }
        String commitHash = string;
        Path sysrootPath = Path.of(this.rustcInfo.getSysroot(), new String[0]);
        Intrinsics.checkNotNull((Object)sysrootPath);
        Path stdlibPath = RsPathManager.INSTANCE.sysrootStdlibDir(sysrootPath);
        Path stdlibCopyPath = RsPathManager.INSTANCE.stdlibCopyDir(stdlibPath, (RustcVersion)version);
        String rustcHash = "/rustc/" + commitHash + "/";
        String stdlibCopyFinal = this.systemDependentAndEscaped(this.toolchain.toRemotePath(((Object)stdlibCopyPath).toString()));
        if (((RustcVersion)version).getSemver().isGreaterOrEqualThan(1, 85, 0)) {
            String stdlibPathFinal = this.systemDependentAndEscaped(this.toolchain.toRemotePath(((Object)stdlibPath).toString()));
            $this$addStdlibPathMapping.addPathMapping(-1, stdlibPathFinal, stdlibCopyFinal);
        }
        $this$addStdlibPathMapping.addPathMapping(-1, rustcHash, stdlibCopyFinal);
        return true;
    }

    private final void addRealToLinkedPathMapping(DebuggerDriver $this$addRealToLinkedPathMapping) {
        if ($this$addRealToLinkedPathMapping instanceof GDBDriver) {
            return;
        }
        if (this.toolchain == null || OS.CURRENT == OS.Windows && !(this.toolchain instanceof RsWslToolchain)) {
            return;
        }
        try {
            Path realPath = this.projectRootDir.toRealPath(new LinkOption[0]);
            String realRemotePath = this.toolchain.toRemotePath(((Object)realPath).toString());
            String rootRemotePath = this.toolchain.toRemotePath(((Object)this.projectRootDir).toString());
            if (!Intrinsics.areEqual((Object)rootRemotePath, (Object)realRemotePath)) {
                $this$addRealToLinkedPathMapping.addPathMapping(-1, realRemotePath, rootRemotePath);
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't get a real project path", (Throwable)e);
        }
    }

    private final void loadPrettyPrinters(DebuggerDriver $this$loadPrettyPrinters) {
        DebuggerDriver debuggerDriver = $this$loadPrettyPrinters;
        if (debuggerDriver instanceof LLDBDriver) {
            this.loadPrettyPrinters((LLDBDriver)$this$loadPrettyPrinters);
        } else if (debuggerDriver instanceof GDBDriver) {
            this.loadPrettyPrinters((GDBDriver)$this$loadPrettyPrinters);
        }
    }

    private final void loadPrettyPrinters(LLDBDriver $this$loadPrettyPrinters) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.settings.getLldbRenderers().ordinal()]) {
            case 1: {
                String string = this.checkSysroot(this.sysroot, RsBundle.INSTANCE.message("notification.content.cannot.load.rustc.renderers", new Object[0]));
                if (string == null) {
                    return;
                }
                String sysroot = string;
                String basePath = sysroot + "/lib/rustlib/etc";
                String lldbLookupPath = this.systemDependentAndEscaped(basePath + "/lldb_lookup.py");
                String lldbCommandsPath = this.systemDependentAndEscaped(basePath + "/lldb_commands");
                if (StringsKt.contains$default((CharSequence)basePath, (CharSequence)"windows-msvc", (boolean)false, (int)2, null)) {
                    Path path = Path.of(lldbLookupPath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    Path path2 = path;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        return;
                    }
                }
                $this$loadPrettyPrinters.executeInterpreterCommand(this.threadId, this.frameIndex, "command script import \"" + lldbLookupPath + "\" ");
                String string2 = $this$loadPrettyPrinters.executeInterpreterCommand(this.threadId, this.frameIndex, "command source \"" + lldbCommandsPath + "\" ");
                Intrinsics.checkNotNull((Object)string2);
                break;
            }
            case 2: {
                String string = this.prettyPrintersPath;
                if (string == null || (string = this.systemDependentAndEscaped(string)) == null) {
                    return;
                }
                String path = string;
                String string3 = $this$loadPrettyPrinters.executeInterpreterCommand(this.threadId, this.frameIndex, "command script import \"" + path + "/lldb_formatters\" ");
                Intrinsics.checkNotNull((Object)string3);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void loadPrettyPrinters(GDBDriver $this$loadPrettyPrinters) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$1[this.settings.getGdbRenderers().ordinal()]) {
            case 1: {
                String string2 = this.checkSysroot(this.sysroot, RsBundle.INSTANCE.message("notification.content.cannot.load.rustc.renderers", new Object[0]));
                if (string2 == null) {
                    return;
                }
                String sysroot = string2;
                string = this.systemDependentAndEscaped(sysroot + "/lib/rustlib/etc");
                break;
            }
            case 2: {
                string = this.prettyPrintersPath;
                if (string != null && (string = this.systemDependentAndEscaped(string)) != null) break;
                return;
            }
            case 3: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String path = string;
        String command = "python sys.path.insert(0, \"" + path + "\"); import gdb_formatters.gdb_lookup; gdb_formatters.gdb_lookup.register_printers(gdb); ";
        $this$loadPrettyPrinters.executeInterpreterCommand(this.threadId, this.frameIndex, command);
    }

    private final void showWarning(@NlsContexts.NotificationContent String message) {
        UtilsKt.showBalloon$default(this.project, "cannot.load.rustc.for.debugger", message, NotificationType.WARNING, null, 8, null);
    }

    private final String checkSysroot(String sysroot, @NlsContexts.NotificationContent String message) {
        if (sysroot == null) {
            this.showWarning(message);
        }
        return sysroot;
    }

    private final String systemDependentAndEscaped(String $this$systemDependentAndEscaped) {
        String string = this.toolchain instanceof RsWslToolchain ? FileUtil.toSystemIndependentName((String)$this$systemDependentAndEscaped) : FileUtil.toSystemDependentName((String)$this$systemDependentAndEscaped);
        Intrinsics.checkNotNull((Object)string);
        String path = string;
        String string2 = StringUtil.escapeStringCharacters((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeStringCharacters(...)");
        return string2;
    }

    private static final void configure$lambda$0(RsDebugProcessConfigurationHelper this$0, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        try {
            if (!this$0.addStdlibPathMapping(driver)) {
                this$0.showWarning(RsBundle.INSTANCE.message("notification.content.cannot.load.rustc.sources", new Object[0]));
            }
            this$0.addRealToLinkedPathMapping(driver);
            this$0.loadPrettyPrinters(driver);
            if (this$0.settings.getBreakOnPanic()) {
                this$0.setBreakOnPanic(driver);
            }
            this$0.setSteppingFilters(driver);
        }
        catch (DebuggerCommandException e) {
            this$0.process.printlnToConsole(e.getMessage());
            LOG.warn((Throwable)e);
        }
        catch (InvalidPathException e) {
            LOG.warn((Throwable)e);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsDebugProcessConfigurationHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/debugger/runconfig/RsDebugProcessConfigurationHelper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LLDBRenderers.values().length];
            try {
                nArray[LLDBRenderers.COMPILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLDBRenderers.BUNDLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLDBRenderers.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GDBRenderers.values().length];
            try {
                nArray[GDBRenderers.COMPILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GDBRenderers.BUNDLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GDBRenderers.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

