/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.lang;

import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.rust.debugger.lang.RsMSVCTypeNameDecoratorVisitor;
import org.rust.debugger.lang.RsTypeNameParser;
import org.rust.debugger.lang.RsTypeNameParserFacade;
import org.rust.debugger.settings.RsDebuggerSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rust/debugger/lang/RsFrameTypeDecorator;", "Lcom/jetbrains/cidr/execution/debugger/CidrFrameTypeDecorator;", "frame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;)V", "getValueDisplayType", "", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;", "renderForUiLabel", "", "Companion", "intellij.rustrover.debugger"})
public final class RsFrameTypeDecorator
implements CidrFrameTypeDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CidrStackFrame frame;

    public RsFrameTypeDecorator(@NotNull CidrStackFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
    }

    @NotNull
    public String getValueDisplayType(@NotNull CidrPhysicalValue value, boolean renderForUiLabel) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean shouldDecorate = RsDebuggerSettings.Helper.getInstance().getDecorateMsvcTypeNames();
        DebuggerDriverConfiguration debuggerDriverConfiguration = this.frame.getProcess().getRunParameters().getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerDriverConfiguration, (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration driverConfiguration = debuggerDriverConfiguration;
        if (shouldDecorate && RsFrameTypeDecorator.Companion.isMsvcLldb(driverConfiguration)) {
            String string = value.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
            return Companion.decorate(string);
        }
        return super.getValueDisplayType(value, renderForUiLabel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/rust/debugger/lang/RsFrameTypeDecorator$Companion;", "", "<init>", "()V", "decorate", "", "typeName", "isMsvcLldb", "", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "intellij.rustrover.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final String decorate(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            RsTypeNameParser.TypeNameContext typeNameContext = RsTypeNameParserFacade.INSTANCE.parse(typeName);
            if (typeNameContext == null) {
                String string = ValueRendererUtils.shortenTemplateType((String)typeName);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTemplateType(...)");
                return string;
            }
            RsTypeNameParser.TypeNameContext typeNameParsed = typeNameContext;
            RsMSVCTypeNameDecoratorVisitor visitor2 = new RsMSVCTypeNameDecoratorVisitor();
            typeNameParsed.accept(visitor2);
            return visitor2.getDecoratedTypeName();
        }

        private final boolean isMsvcLldb(DebuggerDriverConfiguration $this$isMsvcLldb) {
            return $this$isMsvcLldb.getHostMachine().getOS() == OS.Windows && $this$isMsvcLldb instanceof LLDBDriverConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

