/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.lang;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerArchitecture;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.rust.debugger.RsDebuggerBundle;
import org.rust.debugger.UtilsKt;
import org.rust.debugger.lang.EvaluationResult;
import org.rust.debugger.lang.RsEvaluatedValue;
import org.rust.debugger.statistics.RsDebuggerUsageCollector;
import org.rust.debugger.statistics.RsEvalTimings;
import org.rust.debugger.statistics.RsMirEvalTimings;
import org.rust.lang.core.mir.MirBuildEvent;
import org.rust.lang.core.mir.TargetProcessParams;
import org.rust.lang.core.mir.lldb.MirLldbBridge;
import org.rust.lang.core.mir.lldb.MirLldbException;
import org.rust.lang.core.mir.lldb.MirLldbVerifier;
import org.rust.lang.core.mir.lldb.SuppressedErrors;
import org.rust.lang.core.psi.RsDebuggerExpressionCodeFragment;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 E2\u00020\u0001:\u0004EFGHB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J@\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010$\u001a\u00020\u0015*\u00020%2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010&\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(0\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J(\u0010)\u001a\u00020\u001e*\u00020*2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J8\u00101\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0006\u0012\u0004\u0018\u00010(0\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u00103\u001a\u000204*\u0002052\u0006\u00106\u001a\u000207H\u0002J@\u00108\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002070\u001d\u0012\u0004\u0012\u00020!092\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<H\u0002J\f\u0010=\u001a\u00020:*\u00020:H\u0002JO\u0010>\u001a\u00020#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\bC\u0010D\u00a8\u0006I"}, d2={"Lorg/rust/debugger/lang/RsEvaluator;", "Lcom/jetbrains/cidr/execution/debugger/CidrEvaluator;", "frame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;)V", "getExpressionRangeAtOffset", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "sideEffectsAllowed", "", "findSuitableExpression", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "doEvaluate", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrEvaluatedValue;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "expr", "Lcom/intellij/xdebugger/XExpression;", "handleFailure", "Lkotlin/Pair;", "Lorg/rust/debugger/lang/RsEvaluatedValue;", "Lkotlin/time/Duration;", "evaluationResult", "Lorg/rust/debugger/lang/EvaluationResult$MirBased$Failure;", "reportMirFailureToFus", "", "toCidrValue", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "evaluateExpression", "Lorg/rust/debugger/lang/EvaluationResult;", "Lorg/rust/debugger/statistics/RsMirEvalTimings;", "asRsEvaluatedValue", "Lorg/rust/debugger/lang/EvaluationResult$LldbBased;", "backend", "Lorg/rust/debugger/lang/RsEvaluator$EvaluationBackend;", "doNativeEvaluation", "contextRetrievalError", "error", "Lorg/rust/debugger/lang/RsEvaluator$MirEvalContextRetrievalError;", "doMirEvaluation", "Lorg/rust/debugger/lang/EvaluationResult$MirBased;", "asMirBasedFailure", "Lorg/rust/debugger/lang/EvaluationResult$MirBased$Failure$LldbEvaluationError;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerEvaluationException;", "suppressedErrors", "Lorg/rust/lang/core/mir/lldb/SuppressedErrors;", "transformToMirAtPosition", "Lorg/rust/stdext/RsResult;", "", "targetParams", "Lorg/rust/lang/core/mir/TargetProcessParams;", "wrapWithMirProtocol", "logEvaluatedElements", "success", "timings", "Lorg/rust/debugger/statistics/RsEvalTimings;", "duration", "logEvaluatedElements-Kk497nc", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;Lcom/intellij/xdebugger/XExpression;Lcom/intellij/xdebugger/XSourcePosition;ZLorg/rust/debugger/lang/RsEvaluator$EvaluationBackend;Lorg/rust/debugger/statistics/RsEvalTimings;J)V", "Companion", "EvaluationBackend", "MirEvalContextRetrievalError", "LldbEvaluationErrorReason", "intellij.rustrover.debugger"})
@SourceDebugExtension(value={"SMAP\nRsEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsEvaluator.kt\norg/rust/debugger/lang/RsEvaluator\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 RsResult.kt\norg/rust/stdext/RsResult\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 8 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,570:1\n15#2:571\n15#2:595\n95#3:572\n135#3,3:573\n95#3:576\n135#3,3:577\n95#3:585\n135#3,3:586\n95#3:596\n135#3,3:597\n1#4:580\n34#5,4:581\n19#6:589\n648#7,5:590\n13#8:600\n*S KotlinDebug\n*F\n+ 1 RsEvaluator.kt\norg/rust/debugger/lang/RsEvaluator\n*L\n79#1:571\n380#1:595\n91#1:572\n91#1:573,3\n148#1:576\n148#1:577,3\n326#1:585\n326#1:586,3\n309#1:596\n309#1:597,3\n323#1:581,4\n332#1:589\n343#1:590,5\n445#1:600\n*E\n"})
public final class RsEvaluator
extends CidrEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RUST_MIR_PREFIX = "RustMir$";
    @NotNull
    private static final String LLDB_ERROR_MESSAGE_PREFIX = "error: ";

    public RsEvaluator(@NotNull CidrStackFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        super(frame);
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (TextRange)ActionsKt.runReadAction(() -> RsEvaluator.getExpressionRangeAtOffset$lambda$0(document, project, this, offset));
    }

    private final PsiElement findSuitableExpression(PsiFile file, int offset) {
        RsElement resolved;
        PsiElement psiElement2;
        block3: {
            block2: {
                psiElement2 = file.findElementAt(offset);
                if (psiElement2 == null) break block2;
                PsiElement $this$ancestorOrSelf$iv = psiElement2;
                boolean $i$f$ancestorOrSelf = false;
                psiElement2 = (RsPathExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsPathExpr.class, (boolean)false);
                if (psiElement2 != null) break block3;
            }
            return null;
        }
        PsiElement pathExpr = psiElement2;
        RsPathReference rsPathReference = pathExpr.getPath().getReference();
        RsElement rsElement = resolved = rsPathReference != null ? rsPathReference.resolve() : null;
        return rsElement instanceof RsPatBinding || rsElement instanceof RsSelfParameter ? pathExpr : null;
    }

    @NotNull
    public CidrEvaluatedValue doEvaluate(@NotNull DebuggerDriver driver, @Nullable XSourcePosition position, @NotNull XExpression expr) {
        RsEvaluatedValue rsEvaluatedValue;
        RsMirEvalTimings timings;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Project project = this.myFrame.getProcess().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        Project project2 = project;
        Duration fallbackDuration = null;
        RsMirEvalTimings mirTimings = null;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Pair<EvaluationResult, RsMirEvalTimings> pair = this.evaluateExpression(expr, project2, driver, position);
        EvaluationResult evaluationResult = (EvaluationResult)pair.component1();
        mirTimings = timings = (RsMirEvalTimings)pair.component2();
        EvaluationResult evaluationResult2 = evaluationResult;
        if (evaluationResult2 instanceof EvaluationResult.LldbBased) {
            rsEvaluatedValue = RsEvaluator.asRsEvaluatedValue$default(this, (EvaluationResult.LldbBased)evaluationResult, position, expr, null, 4, null);
        } else if (evaluationResult2 instanceof EvaluationResult.MirBased.Success) {
            rsEvaluatedValue = new RsEvaluatedValue.Success(this.toCidrValue(((EvaluationResult.MirBased.Success)evaluationResult).getValue(), position, expr), EvaluationBackend.MIR);
        } else if (evaluationResult2 instanceof EvaluationResult.MirBased.Failure) {
            Duration duration;
            Pair<RsEvaluatedValue, Duration> pair2 = this.handleFailure(expr, (EvaluationResult.MirBased.Failure)evaluationResult, project2, driver, position);
            RsEvaluatedValue result2 = (RsEvaluatedValue)pair2.component1();
            fallbackDuration = duration = (Duration)pair2.component2();
            rsEvaluatedValue = result2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RsEvaluatedValue result$iv$iv = rsEvaluatedValue;
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        RsEvaluatedValue result3 = (RsEvaluatedValue)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        if (position != null) {
            this.logEvaluatedElements-Kk497nc(project2, driver, expr, position, result3 instanceof RsEvaluatedValue.Success, result3.getBackend(), new RsEvalTimings(mirTimings, fallbackDuration, null), duration);
        }
        return result3.unwrapOrThrow();
    }

    private final Pair<RsEvaluatedValue, Duration> handleFailure(XExpression expr, EvaluationResult.MirBased.Failure evaluationResult, Project project, DebuggerDriver driver, XSourcePosition position) {
        Object object;
        LOG.warn("Failed to evaluate expression `" + expr.getExpression() + "` with MIR: " + evaluationResult);
        this.reportMirFailureToFus(project, evaluationResult);
        if (!Registry.Companion.is("org.rust.debugger.lang.fallback.to.native.evaluation")) {
            DebuggerEvaluationException exception = new DebuggerEvaluationException("error=" + evaluationResult, null);
            return TuplesKt.to((Object)new RsEvaluatedValue.Failure((Throwable)exception, EvaluationBackend.MIR), null);
        }
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        EvaluationResult.LldbBased result$iv$iv = this.doNativeEvaluation(driver, expr);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        EvaluationResult.LldbBased nativeFallbackRes = (EvaluationResult.LldbBased)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        if (!(nativeFallbackRes instanceof EvaluationResult.LldbBased.Failure)) {
            return TuplesKt.to((Object)this.asRsEvaluatedValue(nativeFallbackRes, position, expr, EvaluationBackend.NativeAsFallback), (Object)Duration.box-impl((long)duration));
        }
        EvaluationResult.MirBased.Failure failure = evaluationResult;
        if (failure instanceof EvaluationResult.MirBased.Failure.MirBuildingError) {
            object = null;
        } else if (failure instanceof EvaluationResult.MirBased.Failure.MirTransformError) {
            object = null;
        } else if (Intrinsics.areEqual((Object)failure, (Object)EvaluationResult.MirBased.Failure.Unknown.INSTANCE)) {
            object = null;
        } else if (failure instanceof EvaluationResult.MirBased.Failure.LldbEvaluationError) {
            object = ((EvaluationResult.MirBased.Failure.LldbEvaluationError)evaluationResult).getError();
        } else if (failure instanceof EvaluationResult.MirBased.Failure.MirVerificationDeclined) {
            object = ((EvaluationResult.MirBased.Failure.MirVerificationDeclined)evaluationResult).getReason() == MirLldbVerifier.DeclineReason.DIAGNOSTIC_ERROR || ((EvaluationResult.MirBased.Failure.MirVerificationDeclined)evaluationResult).getReason() == MirLldbVerifier.DeclineReason.SYNTAX_ERROR ? new DebuggerEvaluationException(((EvaluationResult.MirBased.Failure.MirVerificationDeclined)evaluationResult).getMessage(), null) : null;
        } else if (failure instanceof EvaluationResult.MirBased.Failure.ContextRetrievalError) {
            object = ((EvaluationResult.MirBased.Failure.ContextRetrievalError)evaluationResult).getError() == MirEvalContextRetrievalError.DumbMode ? new DebuggerEvaluationException(((EvaluationResult.LldbBased.Failure)nativeFallbackRes).getException().getMessage() + " " + RsDebuggerBundle.INSTANCE.message("rust.debugger.eval.dumb.mode", new Object[0]), null) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DebuggerEvaluationException presentableError = object;
        if (presentableError == null) {
            return TuplesKt.to((Object)this.asRsEvaluatedValue(nativeFallbackRes, position, expr, EvaluationBackend.NativeAsFallback), (Object)Duration.box-impl((long)duration));
        }
        return TuplesKt.to((Object)new RsEvaluatedValue.Failure((Throwable)presentableError, EvaluationBackend.MIR), (Object)Duration.box-impl((long)duration));
    }

    private final void reportMirFailureToFus(Project project, EvaluationResult.MirBased.Failure evaluationResult) {
        EvaluationResult.MirBased.Failure failure = evaluationResult;
        if (failure instanceof EvaluationResult.MirBased.Failure.ContextRetrievalError) {
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, null, null, null, null, ((EvaluationResult.MirBased.Failure.ContextRetrievalError)evaluationResult).getError(), null, null, null, 478, null);
        } else if (failure instanceof EvaluationResult.MirBased.Failure.MirBuildingError) {
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, ((EvaluationResult.MirBased.Failure.MirBuildingError)evaluationResult).getMirBuildResult().getMirError(), ((EvaluationResult.MirBased.Failure.MirBuildingError)evaluationResult).getMirBuildResult().getMirIncomplete(), ((EvaluationResult.MirBased.Failure.MirBuildingError)evaluationResult).getMirBuildResult().getThirError(), ((EvaluationResult.MirBased.Failure.MirBuildingError)evaluationResult).getMirBuildResult().getThirIncomplete(), null, null, null, null, 480, null);
        } else if (failure instanceof EvaluationResult.MirBased.Failure.MirTransformError) {
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, null, null, null, null, null, ((EvaluationResult.MirBased.Failure.MirTransformError)evaluationResult).getTransformationReason(), null, null, 446, null);
        } else if (failure instanceof EvaluationResult.MirBased.Failure.MirVerificationDeclined) {
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, null, null, null, null, null, null, ((EvaluationResult.MirBased.Failure.MirVerificationDeclined)evaluationResult).getReason(), null, 382, null);
        } else if (failure instanceof EvaluationResult.MirBased.Failure.LldbEvaluationError && ((EvaluationResult.MirBased.Failure.LldbEvaluationError)evaluationResult).getSuppressedErrors().getFirstMirNotBuiltReason() != null) {
            MirBuildEvent muted = MirBuildEvent.Companion.getFrom(((EvaluationResult.MirBased.Failure.LldbEvaluationError)evaluationResult).getSuppressedErrors().getFirstMirNotBuiltReason());
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, muted.getMirError(), muted.getMirIncomplete(), muted.getThirError(), muted.getThirIncomplete(), null, null, null, ((EvaluationResult.MirBased.Failure.LldbEvaluationError)evaluationResult).getReason(), 224, null);
        } else if (failure instanceof EvaluationResult.MirBased.Failure.LldbEvaluationError) {
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, null, null, null, null, null, null, null, ((EvaluationResult.MirBased.Failure.LldbEvaluationError)evaluationResult).getReason(), 254, null);
        } else if (Intrinsics.areEqual((Object)failure, (Object)EvaluationResult.MirBased.Failure.Unknown.INSTANCE)) {
            RsDebuggerUsageCollector.logMirEvaluationFailed$default(RsDebuggerUsageCollector.INSTANCE, project, null, null, null, null, null, null, null, null, 510, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final CidrEvaluatedValue toCidrValue(LLValue $this$toCidrValue, XSourcePosition position, XExpression expr) {
        return new CidrEvaluatedValue($this$toCidrValue, this.myFrame.getProcess(), position, this.myFrame, expr.getExpression());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pair<EvaluationResult, RsMirEvalTimings> evaluateExpression(XExpression expr, Project project, DebuggerDriver driver, XSourcePosition position) {
        Pair<EvaluationResult.MirBased, RsMirEvalTimings> pair;
        boolean isMirEvaluations;
        boolean bl = isMirEvaluations = UtilsKt.isMirEvaluationEnabled() && driver.supportsRustMirEvaluation();
        if (isMirEvaluations) {
            String string = expr.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
            if (!StringsKt.startsWith$default((String)string, (String)RUST_MIR_PREFIX, (boolean)false, (int)2, null)) {
                pair = this.doMirEvaluation(project, driver, expr, position);
                return pair;
            }
        }
        pair = TuplesKt.to((Object)this.doNativeEvaluation(driver, expr), null);
        return pair;
    }

    private final RsEvaluatedValue asRsEvaluatedValue(EvaluationResult.LldbBased $this$asRsEvaluatedValue, XSourcePosition position, XExpression expr, EvaluationBackend backend) {
        RsEvaluatedValue rsEvaluatedValue;
        EvaluationResult.LldbBased lldbBased = $this$asRsEvaluatedValue;
        if (lldbBased instanceof EvaluationResult.LldbBased.Success) {
            rsEvaluatedValue = new RsEvaluatedValue.Success(this.toCidrValue(((EvaluationResult.LldbBased.Success)$this$asRsEvaluatedValue).getValue(), position, expr), backend);
        } else if (lldbBased instanceof EvaluationResult.LldbBased.Failure) {
            rsEvaluatedValue = new RsEvaluatedValue.Failure(((EvaluationResult.LldbBased.Failure)$this$asRsEvaluatedValue).getException(), backend);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsEvaluatedValue;
    }

    static /* synthetic */ RsEvaluatedValue asRsEvaluatedValue$default(RsEvaluator rsEvaluator, EvaluationResult.LldbBased lldbBased, XSourcePosition xSourcePosition, XExpression xExpression, EvaluationBackend evaluationBackend, int n, Object object) {
        if ((n & 4) != 0) {
            evaluationBackend = EvaluationBackend.Native;
        }
        return rsEvaluator.asRsEvaluatedValue(lldbBased, xSourcePosition, xExpression, evaluationBackend);
    }

    private final EvaluationResult.LldbBased doNativeEvaluation(DebuggerDriver driver, XExpression expr) {
        Object object;
        Object object2;
        Object it2;
        Object $this$doNativeEvaluation_u24lambda_u240;
        Object object3 = this;
        try {
            $this$doNativeEvaluation_u24lambda_u240 = object3;
            boolean bl = false;
            $this$doNativeEvaluation_u24lambda_u240 = Result.constructor-impl((Object)driver.evaluate($this$doNativeEvaluation_u24lambda_u240.myFrame.getThread(), $this$doNativeEvaluation_u24lambda_u240.myFrame.getFrame(), expr.getExpression()));
        }
        catch (Throwable bl) {
            $this$doNativeEvaluation_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$doNativeEvaluation_u24lambda_u240;
        if (Result.isSuccess-impl((Object)object3)) {
            it2 = (LLValue)object3;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            object2 = Result.constructor-impl((Object)new EvaluationResult.LldbBased.Success((LLValue)it2));
        } else {
            object2 = Result.constructor-impl((Object)object3);
        }
        object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            it2 = throwable;
            boolean bl = false;
            object = new EvaluationResult.LldbBased.Failure((Throwable)it2);
        }
        return (EvaluationResult.LldbBased)object;
    }

    private final EvaluationResult.MirBased.Failure contextRetrievalError(MirEvalContextRetrievalError error) {
        return new EvaluationResult.MirBased.Failure.ContextRetrievalError(error);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<EvaluationResult.MirBased, RsMirEvalTimings> doMirEvaluation(Project project, DebuggerDriver driver, XExpression expr, XSourcePosition position) {
        TimedValue timedValue;
        int n;
        if (position == null) {
            return TuplesKt.to((Object)this.contextRetrievalError(MirEvalContextRetrievalError.NoPosition), null);
        }
        String architectureString = driver.getArchitecture();
        CidrDebuggerArchitecture architecture = CidrDebuggerArchitecture.Companion.detectArchitectureByString(architectureString);
        switch (WhenMappings.$EnumSwitchMapping$0[architecture.ordinal()]) {
            case 1: 
            case 2: {
                n = 4;
                break;
            }
            case 3: 
            case 4: {
                n = 8;
                break;
            }
            case 5: 
            case 6: {
                return TuplesKt.to((Object)this.contextRetrievalError(MirEvalContextRetrievalError.UnknownArchitecture), null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int addressByteSize = n;
        TargetProcessParams targetParams = new TargetProcessParams(addressByteSize);
        try {
            CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> RsEvaluator.doMirEvaluation$lambda$0(this, project, expr, position, targetParams)).submit((Executor)AppExecutorUtil.getAppExecutorService());
            Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
            timedValue = (TimedValue)Promises.asCompletableFuture((Promise)((Promise)cancellablePromise)).join();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            LOG.warn("Failed to transform PSI to MIR with an unexpected exception", e);
            return TuplesKt.to((Object)EvaluationResult.MirBased.Failure.Unknown.INSTANCE, null);
        }
        TimedValue timedValue2 = timedValue;
        RsResult result2 = (RsResult)timedValue2.component1();
        long buildDuration = timedValue2.component2-UwyO8pc();
        RsResult this_$iv = result2;
        boolean $i$f$mapErr = false;
        RsResult rsResult = this_$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                void it2;
                EvaluationResult.MirBased.Failure failure = (EvaluationResult.MirBased.Failure)((RsResult.Err)this_$iv).getErr();
                boolean bl = false;
                return TuplesKt.to((Object)it2, (Object)new RsMirEvalTimings(buildDuration, null, 2, null));
            }
            throw new NoWhenBranchMatchedException();
        }
        Pair pair = (Pair)RsResultKt.okOrErr(new RsResult.Ok(((RsResult.Ok)this_$iv).getOk()));
        String mir = (String)pair.component1();
        SuppressedErrors errors = (SuppressedErrors)pair.component2();
        try {
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            LLValue result$iv$iv = driver.evaluate(this.myFrame.getThread(), this.myFrame.getFrame(), mir);
            rsResult = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            Object object = rsResult.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            LLValue evaluated = (LLValue)object;
            long evalDuration = rsResult.component2-UwyO8pc();
            rsResult = TuplesKt.to((Object)new EvaluationResult.MirBased.Success(evaluated), (Object)new RsMirEvalTimings(buildDuration, Duration.box-impl((long)evalDuration), null));
        }
        catch (Throwable exception) {
            EvaluationResult.MirBased.Failure.LldbEvaluationError lldbEvaluationError;
            DebuggerEvaluationException debuggerEvaluationException;
            void $this$asSafely$iv;
            LOG.warn("Failed to evaluate MIR with an unexpected exception", exception);
            Throwable $i$f$measureTimedValue2 = exception;
            boolean $i$f$asSafely = false;
            Object v3 = $this$asSafely$iv;
            if (!(v3 instanceof DebuggerEvaluationException)) {
                v3 = null;
            }
            rsResult = TuplesKt.to((Object)((debuggerEvaluationException = (DebuggerEvaluationException)v3) != null && (lldbEvaluationError = this.asMirBasedFailure(debuggerEvaluationException, errors)) != null ? (EvaluationResult.MirBased.Failure)lldbEvaluationError : (EvaluationResult.MirBased.Failure)EvaluationResult.MirBased.Failure.Unknown.INSTANCE), (Object)new RsMirEvalTimings(buildDuration, null, 2, null));
        }
        return rsResult;
    }

    /*
     * WARNING - void declaration
     */
    private final EvaluationResult.MirBased.Failure.LldbEvaluationError asMirBasedFailure(DebuggerEvaluationException $this$asMirBasedFailure, SuppressedErrors suppressedErrors) {
        LldbEvaluationErrorReason lldbEvaluationErrorReason;
        Object v2;
        String message;
        block7: {
            String reasonString;
            block6: {
                String string;
                message = $this$asMirBasedFailure.getMessage();
                if (message != null && (string = StringsKt.drop((String)message, (int)7)) != null) {
                    void $this$takeWhile$iv;
                    String string2 = string;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it2 = $this$takeWhile$iv.charAt(index$iv);
                        int n2 = 0;
                        if (it2 != ':') continue;
                        void var10_13 = $this$takeWhile$iv;
                        n2 = 0;
                        String string3 = var10_13.substring(n2, index$iv);
                        v1 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        break block6;
                    }
                    v1 = $this$takeWhile$iv;
                } else {
                    v1 = reasonString = null;
                }
            }
            if (reasonString == null) {
                return new EvaluationResult.MirBased.Failure.LldbEvaluationError($this$asMirBasedFailure, LldbEvaluationErrorReason.Unknown, suppressedErrors);
            }
            Iterable iterable = (Iterable)LldbEvaluationErrorReason.getEntries();
            for (Object t : iterable) {
                LldbEvaluationErrorReason it3 = (LldbEvaluationErrorReason)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.name(), reasonString)) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        if ((lldbEvaluationErrorReason = (LldbEvaluationErrorReason)v2) == null) {
            lldbEvaluationErrorReason = LldbEvaluationErrorReason.Unknown;
        }
        LldbEvaluationErrorReason reason = lldbEvaluationErrorReason;
        String description = StringsKt.drop((String)message, (int)7);
        DebuggerEvaluationException newException = new DebuggerEvaluationException(description, $this$asMirBasedFailure.getFixedExpr());
        newException.initCause((Throwable)$this$asMirBasedFailure);
        return new EvaluationResult.MirBased.Failure.LldbEvaluationError(newException, reason, suppressedErrors);
    }

    private final RsResult<Pair<String, SuppressedErrors>, EvaluationResult.MirBased.Failure> transformToMirAtPosition(Project project, XExpression expr, XSourcePosition position, TargetProcessParams targetParams) {
        PsiElement psiElement2;
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return new RsResult.Err<EvaluationResult.MirBased.Failure>(this.contextRetrievalError(MirEvalContextRetrievalError.DumbMode));
        }
        PsiElement psiElement3 = CidrDebuggerTypesHelper.getContextElement((XSourcePosition)position, (Project)project);
        if (psiElement3 == null) {
            RsEvaluator $this$transformToMirAtPosition_u24lambda_u240 = this;
            boolean bl = false;
            LOG.warn("Failed to find a PSI context for position");
            return new RsResult.Err<EvaluationResult.MirBased.Failure>($this$transformToMirAtPosition_u24lambda_u240.contextRetrievalError(MirEvalContextRetrievalError.NoPsiFile));
        }
        PsiElement $this$ancestorOrSelf$iv = psiElement2 = psiElement3;
        boolean $i$f$ancestorOrSelf = false;
        RsElement rsElement = (RsElement)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsElement.class, (boolean)false);
        if (rsElement == null) {
            RsEvaluator $this$transformToMirAtPosition_u24lambda_u241 = this;
            boolean bl = false;
            LOG.warn("Failed to find an RS element for position");
            return new RsResult.Err<EvaluationResult.MirBased.Failure>($this$transformToMirAtPosition_u24lambda_u241.contextRetrievalError(MirEvalContextRetrievalError.NoRsElement));
        }
        RsElement rsElement2 = rsElement;
        String string = expr.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
        RsDebuggerExpressionCodeFragment codeFragment = new RsDebuggerExpressionCodeFragment(project, string, rsElement2);
        RsResult<Pair<String, SuppressedErrors>, MirLldbException> result2 = MirLldbBridge.Companion.transform(codeFragment, false, targetParams);
        if (!(result2 instanceof RsResult.Ok)) {
            if (result2 instanceof RsResult.Err) {
                EvaluationResult.MirBased.Failure failure;
                LOG.warn("Failed to transform PSI to MIR:\n" + ((MirLldbException)((RsResult.Err)result2).getErr()).getFriendlyText());
                MirLldbException.Reason e = ((MirLldbException)((RsResult.Err)result2).getErr()).getReason();
                if (e instanceof MirLldbException.Reason.MirNotBuilt) {
                    failure = new EvaluationResult.MirBased.Failure.MirBuildingError(MirBuildEvent.Companion.getFrom(((MirLldbException.Reason.MirNotBuilt)e).getReason()));
                } else if (e instanceof MirLldbException.Reason.Transformation) {
                    failure = new EvaluationResult.MirBased.Failure.MirTransformError(((MirLldbException.Reason.Transformation)e).getReason());
                } else if (e instanceof MirLldbException.Reason.VerificationDeclined) {
                    failure = new EvaluationResult.MirBased.Failure.MirVerificationDeclined(((MirLldbException.Reason.VerificationDeclined)e).getReason(), ((MirLldbException.Reason.VerificationDeclined)e).getMessage());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                EvaluationResult.MirBased.Failure failure2 = failure;
                return new RsResult.Err<EvaluationResult.MirBased.Failure>(failure2);
            }
            throw new NoWhenBranchMatchedException();
        }
        Pair pair = (Pair)((RsResult.Ok)result2).getOk();
        String transformedMir = (String)pair.component1();
        SuppressedErrors errors = (SuppressedErrors)pair.component2();
        return new RsResult.Ok<Pair>(TuplesKt.to((Object)this.wrapWithMirProtocol(transformedMir), (Object)errors));
    }

    private final String wrapWithMirProtocol(String $this$wrapWithMirProtocol) {
        return RUST_MIR_PREFIX + $this$wrapWithMirProtocol;
    }

    private final void logEvaluatedElements-Kk497nc(Project project, DebuggerDriver driver, XExpression expr, XSourcePosition position, boolean success, EvaluationBackend backend, RsEvalTimings timings, long l) {
        DebuggerDriver debuggerDriver = driver;
        RsDebuggerUsageCollector.DebuggerKind debuggerKind = debuggerDriver instanceof GDBDriver ? RsDebuggerUsageCollector.DebuggerKind.GDB : (debuggerDriver instanceof LLDBDriver ? RsDebuggerUsageCollector.DebuggerKind.LLDB : RsDebuggerUsageCollector.DebuggerKind.Unknown);
        ReadAction.nonBlocking(() -> RsEvaluator.logEvaluatedElements_Kk497nc$lambda$0(project, expr, position)).inSmartMode(project).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> RsEvaluator.logEvaluatedElements_Kk497nc$lambda$2(arg_0 -> RsEvaluator.logEvaluatedElements_Kk497nc$lambda$1(success, debuggerKind, backend, timings, l, arg_0), arg_0)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static final TextRange getExpressionRangeAtOffset$lambda$0(Document $document, Project $project, RsEvaluator this$0, int $offset) {
        Object object;
        PsiFile psiFile = org.rust.openapiext.UtilsKt.toPsiFile($document, $project);
        if (psiFile != null) {
            PsiFile file = psiFile;
            boolean bl = false;
            PsiElement psiElement2 = this$0.findSuitableExpression(file, $offset);
            object = psiElement2 != null ? psiElement2.getTextRange() : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final TimedValue doMirEvaluation$lambda$0(RsEvaluator this$0, Project $project, XExpression $expr, XSourcePosition $position, TargetProcessParams $targetParams) {
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        RsResult<Pair<String, SuppressedErrors>, EvaluationResult.MirBased.Failure> result$iv$iv = this$0.transformToMirAtPosition($project, $expr, $position, $targetParams);
        return new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
    }

    private static final EnumSet logEvaluatedElements_Kk497nc$lambda$0(Project $project, XExpression $expr, XSourcePosition $position) {
        return RsDebuggerUsageCollector.INSTANCE.collectUsedElements($project, $expr, $position);
    }

    private static final Unit logEvaluatedElements_Kk497nc$lambda$1(boolean $success, RsDebuggerUsageCollector.DebuggerKind $debuggerKind, EvaluationBackend $backend, RsEvalTimings $timings, long l, EnumSet features) {
        Intrinsics.checkNotNull((Object)features);
        RsDebuggerUsageCollector.INSTANCE.logEvaluated-17CK4j0($success, $debuggerKind, $backend, features, $timings, l);
        return Unit.INSTANCE;
    }

    private static final void logEvaluatedElements_Kk497nc$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsEvaluator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/rust/debugger/lang/RsEvaluator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RUST_MIR_PREFIX", "", "LLDB_ERROR_MESSAGE_PREFIX", "intellij.rustrover.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/debugger/lang/RsEvaluator$EvaluationBackend;", "", "<init>", "(Ljava/lang/String;I)V", "Native", "MIR", "NativeAsFallback", "intellij.rustrover.debugger"})
    public static final class EvaluationBackend
    extends Enum<EvaluationBackend> {
        public static final /* enum */ EvaluationBackend Native = new EvaluationBackend();
        public static final /* enum */ EvaluationBackend MIR = new EvaluationBackend();
        public static final /* enum */ EvaluationBackend NativeAsFallback = new EvaluationBackend();
        private static final /* synthetic */ EvaluationBackend[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EvaluationBackend[] values() {
            return (EvaluationBackend[])$VALUES.clone();
        }

        public static EvaluationBackend valueOf(String value) {
            return Enum.valueOf(EvaluationBackend.class, value);
        }

        @NotNull
        public static EnumEntries<EvaluationBackend> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = evaluationBackendArray = new EvaluationBackend[]{EvaluationBackend.Native, EvaluationBackend.MIR, EvaluationBackend.NativeAsFallback};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b7\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7\u00a8\u00068"}, d2={"Lorg/rust/debugger/lang/RsEvaluator$LldbEvaluationErrorReason;", "", "<init>", "(Ljava/lang/String;I)V", "AdtTypeCreationError", "BuiltinTypeNotFound", "ChildAccessError", "DifferentTypeAssignment", "DivisionByZero", "DowncastFail", "ElementTypeMismatch", "EmptyInput", "ErrorOnNotOperation", "FailedAssert", "FailedAssertEval", "FailedBinOp", "FailedProcWrite", "FailedSwitchIntDiscr", "FailedToExtractData", "IncorrectScalar", "InvalidAddress", "InvalidElementType", "InvalidEnumDiscriminant", "InvalidIndex", "InvalidOutput", "InvalidState", "NonAggregateChildAccess", "NonAggregateIndexAccess", "NonArrayIndexAccessError", "NonArraySubsliceError", "NonIntegralOperationWithOverflow", "NonPointerDereferenceError", "OutOfBoundsArg", "OutOfBoundsBlock", "OutOfBoundsConstant", "OutOfBoundsFunc", "OutOfBoundsIndexAccess", "OutOfBoundsLocal", "OutOfBoundsSubsliceAccess", "RefTypeCreationError", "StackOverflow", "StuckEvaluation", "TupleTypeCreationError", "UnexpectedProjectionResult", "UnexpectedState", "UnknownByteSize", "UnknownType", "Unreachable", "UnsupportedEmptyArray", "UnsupportedFloatSemantics", "UnsupportedFunction", "UnsupportedMutability", "UnsupportedNonScalarOperation", "VariableNotFound", "VariableNotResolved", "Unknown", "intellij.rustrover.debugger"})
    public static final class LldbEvaluationErrorReason
    extends Enum<LldbEvaluationErrorReason> {
        public static final /* enum */ LldbEvaluationErrorReason AdtTypeCreationError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason BuiltinTypeNotFound = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason ChildAccessError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason DifferentTypeAssignment = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason DivisionByZero = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason DowncastFail = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason ElementTypeMismatch = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason EmptyInput = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason ErrorOnNotOperation = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason FailedAssert = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason FailedAssertEval = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason FailedBinOp = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason FailedProcWrite = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason FailedSwitchIntDiscr = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason FailedToExtractData = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason IncorrectScalar = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason InvalidAddress = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason InvalidElementType = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason InvalidEnumDiscriminant = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason InvalidIndex = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason InvalidOutput = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason InvalidState = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason NonAggregateChildAccess = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason NonAggregateIndexAccess = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason NonArrayIndexAccessError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason NonArraySubsliceError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason NonIntegralOperationWithOverflow = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason NonPointerDereferenceError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsArg = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsBlock = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsConstant = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsFunc = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsIndexAccess = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsLocal = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason OutOfBoundsSubsliceAccess = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason RefTypeCreationError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason StackOverflow = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason StuckEvaluation = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason TupleTypeCreationError = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnexpectedProjectionResult = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnexpectedState = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnknownByteSize = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnknownType = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason Unreachable = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnsupportedEmptyArray = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnsupportedFloatSemantics = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnsupportedFunction = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnsupportedMutability = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason UnsupportedNonScalarOperation = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason VariableNotFound = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason VariableNotResolved = new LldbEvaluationErrorReason();
        public static final /* enum */ LldbEvaluationErrorReason Unknown = new LldbEvaluationErrorReason();
        private static final /* synthetic */ LldbEvaluationErrorReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LldbEvaluationErrorReason[] values() {
            return (LldbEvaluationErrorReason[])$VALUES.clone();
        }

        public static LldbEvaluationErrorReason valueOf(String value) {
            return Enum.valueOf(LldbEvaluationErrorReason.class, value);
        }

        @NotNull
        public static EnumEntries<LldbEvaluationErrorReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lldbEvaluationErrorReasonArray = new LldbEvaluationErrorReason[]{LldbEvaluationErrorReason.AdtTypeCreationError, LldbEvaluationErrorReason.BuiltinTypeNotFound, LldbEvaluationErrorReason.ChildAccessError, LldbEvaluationErrorReason.DifferentTypeAssignment, LldbEvaluationErrorReason.DivisionByZero, LldbEvaluationErrorReason.DowncastFail, LldbEvaluationErrorReason.ElementTypeMismatch, LldbEvaluationErrorReason.EmptyInput, LldbEvaluationErrorReason.ErrorOnNotOperation, LldbEvaluationErrorReason.FailedAssert, LldbEvaluationErrorReason.FailedAssertEval, LldbEvaluationErrorReason.FailedBinOp, LldbEvaluationErrorReason.FailedProcWrite, LldbEvaluationErrorReason.FailedSwitchIntDiscr, LldbEvaluationErrorReason.FailedToExtractData, LldbEvaluationErrorReason.IncorrectScalar, LldbEvaluationErrorReason.InvalidAddress, LldbEvaluationErrorReason.InvalidElementType, LldbEvaluationErrorReason.InvalidEnumDiscriminant, LldbEvaluationErrorReason.InvalidIndex, LldbEvaluationErrorReason.InvalidOutput, LldbEvaluationErrorReason.InvalidState, LldbEvaluationErrorReason.NonAggregateChildAccess, LldbEvaluationErrorReason.NonAggregateIndexAccess, LldbEvaluationErrorReason.NonArrayIndexAccessError, LldbEvaluationErrorReason.NonArraySubsliceError, LldbEvaluationErrorReason.NonIntegralOperationWithOverflow, LldbEvaluationErrorReason.NonPointerDereferenceError, LldbEvaluationErrorReason.OutOfBoundsArg, LldbEvaluationErrorReason.OutOfBoundsBlock, LldbEvaluationErrorReason.OutOfBoundsConstant, LldbEvaluationErrorReason.OutOfBoundsFunc, LldbEvaluationErrorReason.OutOfBoundsIndexAccess, LldbEvaluationErrorReason.OutOfBoundsLocal, LldbEvaluationErrorReason.OutOfBoundsSubsliceAccess, LldbEvaluationErrorReason.RefTypeCreationError, LldbEvaluationErrorReason.StackOverflow, LldbEvaluationErrorReason.StuckEvaluation, LldbEvaluationErrorReason.TupleTypeCreationError, LldbEvaluationErrorReason.UnexpectedProjectionResult, LldbEvaluationErrorReason.UnexpectedState, LldbEvaluationErrorReason.UnknownByteSize, LldbEvaluationErrorReason.UnknownType, LldbEvaluationErrorReason.Unreachable, LldbEvaluationErrorReason.UnsupportedEmptyArray, LldbEvaluationErrorReason.UnsupportedFloatSemantics, LldbEvaluationErrorReason.UnsupportedFunction, LldbEvaluationErrorReason.UnsupportedMutability, LldbEvaluationErrorReason.UnsupportedNonScalarOperation, LldbEvaluationErrorReason.VariableNotFound, LldbEvaluationErrorReason.VariableNotResolved, LldbEvaluationErrorReason.Unknown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/rust/debugger/lang/RsEvaluator$MirEvalContextRetrievalError;", "", "<init>", "(Ljava/lang/String;I)V", "NoPosition", "NoPsiFile", "NoRsElement", "DumbMode", "UnknownArchitecture", "intellij.rustrover.debugger"})
    public static final class MirEvalContextRetrievalError
    extends Enum<MirEvalContextRetrievalError> {
        public static final /* enum */ MirEvalContextRetrievalError NoPosition = new MirEvalContextRetrievalError();
        public static final /* enum */ MirEvalContextRetrievalError NoPsiFile = new MirEvalContextRetrievalError();
        public static final /* enum */ MirEvalContextRetrievalError NoRsElement = new MirEvalContextRetrievalError();
        public static final /* enum */ MirEvalContextRetrievalError DumbMode = new MirEvalContextRetrievalError();
        public static final /* enum */ MirEvalContextRetrievalError UnknownArchitecture = new MirEvalContextRetrievalError();
        private static final /* synthetic */ MirEvalContextRetrievalError[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MirEvalContextRetrievalError[] values() {
            return (MirEvalContextRetrievalError[])$VALUES.clone();
        }

        public static MirEvalContextRetrievalError valueOf(String value) {
            return Enum.valueOf(MirEvalContextRetrievalError.class, value);
        }

        @NotNull
        public static EnumEntries<MirEvalContextRetrievalError> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mirEvalContextRetrievalErrorArray = new MirEvalContextRetrievalError[]{MirEvalContextRetrievalError.NoPosition, MirEvalContextRetrievalError.NoPsiFile, MirEvalContextRetrievalError.NoRsElement, MirEvalContextRetrievalError.DumbMode, MirEvalContextRetrievalError.UnknownArchitecture};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CidrDebuggerArchitecture.values().length];
            try {
                nArray[CidrDebuggerArchitecture.AARCH32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrDebuggerArchitecture.X86.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrDebuggerArchitecture.X86_64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrDebuggerArchitecture.AARCH64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrDebuggerArchitecture.ARM_UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrDebuggerArchitecture.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

