/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger.attach;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.WslAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.jetbrains.cidr.execution.debugger.CidrDefaultAttachDebuggerProvider;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.CidrNativeAttachPresentationGroup;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.runconfig.BuildResult;
import org.rust.cargo.runconfig.RsToolchainHost;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.Rustc;
import org.rust.cargo.toolchain.tools.RustcKt;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.debugger.RsDebuggerBundle;
import org.rust.debugger.RsDebuggerDriverConfigurationProvider;
import org.rust.debugger.attach.RsAttachDebuggerProviderKt;
import org.rust.debugger.runconfig.RsDebugRunnerUtils;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/rust/debugger/attach/RsAttachDebuggerProvider;", "Lcom/intellij/xdebugger/attach/XAttachDebuggerProvider;", "Lcom/jetbrains/cidr/execution/debugger/CidrDefaultAttachDebuggerProvider;", "<init>", "()V", "isAttachHostApplicable", "", "attachHost", "Lcom/intellij/xdebugger/attach/XAttachHost;", "getAvailableDebuggers", "", "Lcom/intellij/xdebugger/attach/XAttachDebugger;", "project", "Lcom/intellij/openapi/project/Project;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "contextHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "computeAvailableDebuggers", "host", "Lorg/rust/cargo/runconfig/RsToolchainHost;", "isElevated", "isEnabled", "currentToolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "getHost", "Lorg/rust/stdext/RsResult;", "", "getPresentationGroup", "Lcom/intellij/xdebugger/attach/XAttachPresentationGroup;", "intellij.rustrover.debugger"})
final class RsAttachDebuggerProvider
implements XAttachDebuggerProvider,
CidrDefaultAttachDebuggerProvider {
    public boolean isAttachHostApplicable(@NotNull XAttachHost attachHost) {
        Intrinsics.checkNotNullParameter((Object)attachHost, (String)"attachHost");
        return attachHost instanceof LocalAttachHost || attachHost instanceof WslAttachHost;
    }

    @NotNull
    public List<XAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost attachHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attachHost, (String)"attachHost");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        if (rsToolchainBase == null) {
            return CollectionsKt.emptyList();
        }
        RsToolchainBase currentToolchain = rsToolchainBase;
        if (!this.isEnabled(currentToolchain, attachHost)) {
            return CollectionsKt.emptyList();
        }
        RsResult<RsToolchainHost, Unit> newHost = this.getHost(project, currentToolchain);
        RsToolchainHost rsToolchainHost = newHost.ok();
        if (rsToolchainHost == null) {
            return CollectionsKt.emptyList();
        }
        RsToolchainHost host = rsToolchainHost;
        return this.computeAvailableDebuggers(project, host, false);
    }

    @NotNull
    public List<XAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        RsToolchainHost rsToolchainHost;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attachHost, (String)"attachHost");
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)contextHolder, (String)"contextHolder");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        if (rsToolchainBase == null) {
            return CollectionsKt.emptyList();
        }
        RsToolchainBase currentToolchain = rsToolchainBase;
        if (!this.isEnabled(currentToolchain, attachHost)) {
            return CollectionsKt.emptyList();
        }
        RsResult cachedHost = (RsResult)contextHolder.getUserData(RsAttachDebuggerProviderKt.access$getCACHED_HOST_KEY$p());
        RsResult rsResult = cachedHost;
        if (rsResult instanceof RsResult.Err) {
            return CollectionsKt.emptyList();
        }
        if (rsResult instanceof RsResult.Ok) {
            rsToolchainHost = (RsToolchainHost)((RsResult.Ok)cachedHost).getOk();
        } else if (rsResult == null) {
            RsResult<RsToolchainHost, Unit> newHost = this.getHost(project, currentToolchain);
            contextHolder.putUserData(RsAttachDebuggerProviderKt.access$getCACHED_HOST_KEY$p(), newHost);
            rsToolchainHost = newHost.ok();
            if (rsToolchainHost == null) {
                return CollectionsKt.emptyList();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RsToolchainHost host = rsToolchainHost;
        boolean isElevated = processInfo.isOwnedByCurrentUser() != ThreeState.YES;
        return this.computeAvailableDebuggers(project, host, isElevated);
    }

    private final List<XAttachDebugger> computeAvailableDebuggers(Project project, RsToolchainHost host, boolean isElevated) {
        DebuggerDriverConfiguration d = RsDebuggerDriverConfigurationProvider.Companion.getDebuggerDriverConfiguration(project, host, isElevated, false);
        if (d == null) {
            return CollectionsKt.emptyList();
        }
        String string = d.getDriverName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDriverName(...)");
        Object name2 = string;
        if (!StringsKt.startsWith$default((String)name2, (String)"Rust", (boolean)false, (int)2, null)) {
            name2 = "Rust " + (String)name2;
        }
        return CollectionsKt.listOf((Object)new CidrLocalAttachDebugger(d, (String)name2));
    }

    private final boolean isEnabled(RsToolchainBase currentToolchain, XAttachHost attachHost) {
        if (currentToolchain instanceof RsWslToolchain && !(attachHost instanceof WslAttachHost)) {
            return false;
        }
        return currentToolchain instanceof RsWslToolchain || !(attachHost instanceof WslAttachHost);
    }

    private final RsResult<RsToolchainHost, Unit> getHost(Project project, RsToolchainBase currentToolchain) {
        Object object = Rustc.queryVersion$default(RustcKt.rustc(currentToolchain), project, null, 2, null);
        if (object == null || (object = ((RustcVersion)object).getHost()) == null) {
            return new RsResult.Err<Unit>(Unit.INSTANCE);
        }
        RsToolchainHost host = new RsToolchainHost((String)object);
        boolean isConfigured2 = (Boolean)com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, host, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ RsToolchainHost $host;
            {
                this.$project = $project;
                this.$host = $host;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)RsDebuggerBundle.INSTANCE.message("rust.attach.debugger.checking.progress.title", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$project, this.$host, null){
                            int label;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ RsToolchainHost $host;
                            {
                                this.$project = $project;
                                this.$host = $host;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$project, this.$host, null){
                                            int label;
                                            final /* synthetic */ Project $project;
                                            final /* synthetic */ RsToolchainHost $host;
                                            {
                                                this.$project = $project;
                                                this.$host = $host;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        return Boxing.boxBoolean((boolean)RsDebugRunnerUtils.INSTANCE.checkToolchainConfigured(this.$project, this.$host));
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (!isConfigured2) {
            return new RsResult.Err<Unit>(Unit.INSTANCE);
        }
        BuildResult.ToolchainError toolchainError = RsDebugRunnerUtils.INSTANCE.checkToolchainSupported(project, host);
        if (toolchainError != null) {
            Messages.showErrorDialog((Project)project, (String)toolchainError.getMessage(), (String)RsDebugRunnerUtils.INSTANCE.getERROR_MESSAGE_TITLE());
        }
        return new RsResult.Ok<RsToolchainHost>(host);
    }

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        CidrNativeAttachPresentationGroup cidrNativeAttachPresentationGroup = CidrNativeAttachPresentationGroup.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)cidrNativeAttachPresentationGroup, (String)"INSTANCE");
        return (XAttachPresentationGroup)cidrNativeAttachPresentationGroup;
    }
}

