/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger;

import com.intellij.util.system.OS;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.debugger.RsLLDBDriver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/rust/debugger/RsLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "isElevated", "", "emulateTerminal", "<init>", "(ZZ)V", "useRustTypeSystem", "useSTLRenderers", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "intellij.rustrover.debugger"})
public class RsLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    private final boolean isElevated;
    private final boolean emulateTerminal;

    public RsLLDBDriverConfiguration(boolean isElevated, boolean emulateTerminal) {
        this.isElevated = isElevated;
        this.emulateTerminal = emulateTerminal;
    }

    public boolean isElevated() {
        return this.isElevated;
    }

    public boolean emulateTerminal() {
        return this.emulateTerminal;
    }

    public boolean useRustTypeSystem() {
        return OS.CURRENT == OS.Windows;
    }

    public boolean useSTLRenderers() {
        return CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().exists();
    }

    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        if (OS.CURRENT == OS.Windows) {
            LLDBDriver lLDBDriver = super.createDriver(handler, architectureType);
            Intrinsics.checkNotNullExpressionValue((Object)lLDBDriver, (String)"createDriver(...)");
            return lLDBDriver;
        }
        return new RsLLDBDriver(handler, this, architectureType);
    }
}

