/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.debugger.DebuggerAvailability;
import org.rust.debugger.DebuggerKind;
import org.rust.debugger.GDBBinaries;
import org.rust.debugger.LLDBBinaries;
import org.rust.debugger.LldbFlavor;
import org.rust.debugger.RsCustomBinariesGDBDriverConfigurationBase;
import org.rust.debugger.RsCustomBinariesLLDBDriverConfiguration;
import org.rust.debugger.RsDebuggerToolchainService;
import org.rust.debugger.RsEelGDBDriverConfiguration;
import org.rust.debugger.RsGDBDriverConfiguration;
import org.rust.debugger.RsLLDBDriverConfiguration;
import org.rust.debugger.RsUserBinariesGDBDriverConfiguration;
import org.rust.debugger.RsWindowsRustLLDBDriverConfiguration;
import org.rust.debugger.RsWslGDBDriverConfiguration;
import org.rust.debugger.UserGDBBinaries;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"createDriverConfiguration", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "debuggerKind", "Lorg/rust/debugger/DebuggerKind;", "isElevated", "", "emulateTerminal", "intellij.rustrover.debugger"})
public final class RsDefaultDebuggerDriverConfigurationProviderKt {
    @Nullable
    public static final DebuggerDriverConfiguration createDriverConfiguration(@Nullable Project project, @NotNull DebuggerKind debuggerKind, boolean isElevated, boolean emulateTerminal) {
        Intrinsics.checkNotNullParameter((Object)debuggerKind, (String)"debuggerKind");
        RsDebuggerToolchainService toolchains = RsDebuggerToolchainService.Companion.getInstance();
        DebuggerKind debuggerKind2 = debuggerKind;
        if (debuggerKind2 instanceof DebuggerKind.LLDB) {
            DebuggerAvailability<LLDBBinaries> lldbAvailability = toolchains.lldbAvailability(((DebuggerKind.LLDB)debuggerKind).getFlavor());
            return Intrinsics.areEqual(lldbAvailability, (Object)DebuggerAvailability.Bundled.INSTANCE) ? (DebuggerDriverConfiguration)(((DebuggerKind.LLDB)debuggerKind).getFlavor() == LldbFlavor.RustLldb && SystemInfo.isWindows ? (RsLLDBDriverConfiguration)new RsWindowsRustLLDBDriverConfiguration(isElevated, emulateTerminal) : new RsLLDBDriverConfiguration(isElevated, emulateTerminal)) : (lldbAvailability instanceof DebuggerAvailability.Binaries ? (DebuggerDriverConfiguration)new RsCustomBinariesLLDBDriverConfiguration((LLDBBinaries)((DebuggerAvailability.Binaries)lldbAvailability).getBinaries(), isElevated, emulateTerminal) : null);
        }
        if (Intrinsics.areEqual((Object)debuggerKind2, (Object)DebuggerKind.GDB.INSTANCE)) {
            DebuggerAvailability<GDBBinaries> gdbAvailability = toolchains.gdbAvailability(project);
            return Intrinsics.areEqual(gdbAvailability, (Object)DebuggerAvailability.Bundled.INSTANCE) ? (DebuggerDriverConfiguration)new RsGDBDriverConfiguration(isElevated, emulateTerminal) : (gdbAvailability instanceof DebuggerAvailability.Binaries ? (DebuggerDriverConfiguration)new RsCustomBinariesGDBDriverConfigurationBase((GDBBinaries)((DebuggerAvailability.Binaries)gdbAvailability).getBinaries(), isElevated, emulateTerminal) : (gdbAvailability instanceof DebuggerAvailability.WSL ? (DebuggerDriverConfiguration)new RsWslGDBDriverConfiguration(((DebuggerAvailability.WSL)gdbAvailability).getDistributionId(), (GDBBinaries)((DebuggerAvailability.WSL)gdbAvailability).getBinaries(), isElevated, emulateTerminal) : (gdbAvailability instanceof DebuggerAvailability.Eel ? (DebuggerDriverConfiguration)new RsEelGDBDriverConfiguration(((DebuggerAvailability.Eel)gdbAvailability).getDescriptor(), (GDBBinaries)((DebuggerAvailability.Eel)gdbAvailability).getBinaries(), isElevated, emulateTerminal) : null)));
        }
        if (debuggerKind2 instanceof DebuggerKind.UserGDB) {
            DebuggerAvailability<UserGDBBinaries> userGdbAvailability = toolchains.userGdbAvailability(((DebuggerKind.UserGDB)debuggerKind).getPath());
            return userGdbAvailability instanceof DebuggerAvailability.Binaries ? (DebuggerDriverConfiguration)new RsUserBinariesGDBDriverConfiguration((UserGDBBinaries)((DebuggerAvailability.Binaries)userGdbAvailability).getBinaries(), isElevated, emulateTerminal) : null;
        }
        throw new NoWhenBranchMatchedException();
    }
}

