/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.fs.EelFileSystemApiKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.bin.UrlProvider;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.eel.RsEelToolchain;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.debugger.DebuggerAvailability;
import org.rust.debugger.DebuggerKind;
import org.rust.debugger.GDBBinaries;
import org.rust.debugger.LLDBBinaries;
import org.rust.debugger.LldbFlavor;
import org.rust.debugger.RsWindowsRustLLDBDriverConfiguration;
import org.rust.debugger.UserGDBBinaries;
import org.rust.openapiext.RsPathManager;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 22\u00020\u0001:\u00042345B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u0007J\u001a\u0010\u001a\u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c*\u00020\rH\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0014\u0010%\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010-\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010.\u001a\u00020,H\u0007J\u0018\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u00162\u0006\u0010.\u001a\u00020,H\u0002J\u0010\u00101\u001a\u00020,2\u0006\u00100\u001a\u00020\u0016H\u0002J\u0016\u00100\u001a\u00020\u0016*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\f\u00100\u001a\u00020\u0016*\u00020\rH\u0002\u00a8\u00066"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService;", "", "<init>", "()V", "debuggerAvailability", "Lorg/rust/debugger/DebuggerAvailability;", "kind", "Lorg/rust/debugger/DebuggerKind;", "project", "Lcom/intellij/openapi/project/Project;", "lldbAvailability", "Lorg/rust/debugger/LLDBBinaries;", "flavor", "Lorg/rust/debugger/LldbFlavor;", "defaultLldbAvailability", "rustLldbOnWindowsAvailability", "nonBundledLldbAvailability", "gdbAvailability", "Lorg/rust/debugger/GDBBinaries;", "userGdbAvailability", "Lorg/rust/debugger/UserGDBBinaries;", "gdbFile", "Ljava/nio/file/Path;", "downloadDebugger", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult;", "debuggerKind", "downloadDebuggerSynchronously", "lldbUrls", "Lkotlin/Pair;", "Ljava/net/URL;", "gdbUrl", "downloadAndUnarchive", "", "baseDir", "binariesToDownload", "", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadableDebuggerBinary;", "createFileDescription", "Lcom/intellij/util/download/DownloadableFileDescription;", "Lcom/intellij/util/download/DownloadableFileService;", "url", "", "fileNameWithoutExtension", "loadDebuggerVersions", "Ljava/util/Properties;", "saveDebuggerVersions", "versions", "saveVersionsFile", "basePath", "loadVersions", "Companion", "Unarchiver", "DownloadResult", "DownloadableDebuggerBinary", "intellij.rustrover.debugger"})
@SourceDebugExtension(value={"SMAP\nRsDebuggerToolchainService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebuggerToolchainService.kt\norg/rust/debugger/RsDebuggerToolchainService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,387:1\n1563#2:388\n1634#2,3:389\n230#2,2:392\n1#3:394\n13#4:395\n*S KotlinDebug\n*F\n+ 1 RsDebuggerToolchainService.kt\norg/rust/debugger/RsDebuggerToolchainService\n*L\n252#1:388\n252#1:389,3\n263#1:392,2\n334#1:395\n*E\n"})
public final class RsDebuggerToolchainService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEBUGGER_VERSIONS = "versions.properties";
    @NotNull
    private static final String LLDB_FRONTEND_PROPERTY_NAME = "lldbFrontend";
    @NotNull
    private static final String LLDB_FRAMEWORK_PROPERTY_NAME = "lldbFramework";
    @NotNull
    private static final String GDB_PROPERTY_NAME = "gdb";
    @NotNull
    public static final String RUST_DEBUGGER_GROUP_ID = "Rust Debugger";

    @NotNull
    public final DebuggerAvailability<?> debuggerAvailability(@NotNull DebuggerKind kind2, @Nullable Project project) {
        DebuggerAvailability<Object> debuggerAvailability;
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        DebuggerKind debuggerKind = kind2;
        if (debuggerKind instanceof DebuggerKind.LLDB) {
            debuggerAvailability = this.lldbAvailability(((DebuggerKind.LLDB)kind2).getFlavor());
        } else if (Intrinsics.areEqual((Object)debuggerKind, (Object)DebuggerKind.GDB.INSTANCE)) {
            debuggerAvailability = this.gdbAvailability(project);
        } else if (debuggerKind instanceof DebuggerKind.UserGDB) {
            debuggerAvailability = this.userGdbAvailability(((DebuggerKind.UserGDB)kind2).getPath());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return debuggerAvailability;
    }

    public static /* synthetic */ DebuggerAvailability debuggerAvailability$default(RsDebuggerToolchainService rsDebuggerToolchainService, DebuggerKind debuggerKind, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return rsDebuggerToolchainService.debuggerAvailability(debuggerKind, project);
    }

    @NotNull
    public final DebuggerAvailability<LLDBBinaries> lldbAvailability(@NotNull LldbFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)((Object)flavor), (String)"flavor");
        return switch (WhenMappings.$EnumSwitchMapping$0[flavor.ordinal()]) {
            case 1 -> {
                if (SystemInfo.isWindows) {
                    yield this.defaultLldbAvailability();
                }
                yield DebuggerAvailability.Unavailable.INSTANCE;
            }
            case 2 -> {
                if (SystemInfo.isWindows) {
                    yield this.rustLldbOnWindowsAvailability();
                }
                yield this.defaultLldbAvailability();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final DebuggerAvailability<LLDBBinaries> defaultLldbAvailability() {
        if (LLDBDriverConfiguration.hasBundledLLDB()) {
            return DebuggerAvailability.Bundled.INSTANCE;
        }
        return this.nonBundledLldbAvailability(SystemInfo.isWindows ? LldbFlavor.RiderLldb : LldbFlavor.RustLldb);
    }

    private final DebuggerAvailability<LLDBBinaries> rustLldbOnWindowsAvailability() {
        if (RsWindowsRustLLDBDriverConfiguration.Companion.isBundled()) {
            return DebuggerAvailability.Bundled.INSTANCE;
        }
        return this.nonBundledLldbAvailability(LldbFlavor.RustLldb);
    }

    private final DebuggerAvailability<LLDBBinaries> nonBundledLldbAvailability(LldbFlavor flavor) {
        Path frontendFile;
        Path frameworkFile;
        block12: {
            block11: {
                kotlin.Pair pair;
                if (SystemInfo.isMac) {
                    pair = TuplesKt.to((Object)"LLDB.framework", (Object)"LLDBFrontend");
                } else if (SystemInfo.isUnix) {
                    pair = TuplesKt.to((Object)"lib/liblldb.so", (Object)"bin/LLDBFrontend");
                } else if (SystemInfo.isWindows) {
                    pair = TuplesKt.to((Object)"bin/liblldb.dll", (Object)"bin/LLDBFrontend.exe");
                } else {
                    return DebuggerAvailability.Unavailable.INSTANCE;
                }
                kotlin.Pair pair2 = pair;
                String frameworkPath = (String)pair2.component1();
                String frontendPath = (String)pair2.component2();
                Path lldbPath = this.basePath(flavor);
                frameworkFile = lldbPath.resolve(frameworkPath);
                frontendFile = lldbPath.resolve(frontendPath);
                Intrinsics.checkNotNull((Object)frameworkFile);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(frameworkFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block11;
                Intrinsics.checkNotNull((Object)frontendFile);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(frontendFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block12;
            }
            return DebuggerAvailability.NeedToDownload.INSTANCE;
        }
        Properties versions = this.loadDebuggerVersions(new DebuggerKind.LLDB(flavor));
        kotlin.Pair<URL, URL> pair = this.lldbUrls(flavor);
        if (pair == null) {
            return DebuggerAvailability.Unavailable.INSTANCE;
        }
        kotlin.Pair<URL, URL> pair3 = pair;
        URL lldbFrameworkUrl = (URL)pair3.component1();
        URL lldbFrontendUrl = (URL)pair3.component2();
        String string = lldbFrameworkUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String lldbFrameworkVersion = this.fileNameWithoutExtension(string);
        String string2 = lldbFrontendUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String lldbFrontendVersion = this.fileNameWithoutExtension(string2);
        if (!Intrinsics.areEqual((Object)versions.get(LLDB_FRAMEWORK_PROPERTY_NAME), (Object)lldbFrameworkVersion) || !Intrinsics.areEqual((Object)versions.get(LLDB_FRONTEND_PROPERTY_NAME), (Object)lldbFrontendVersion)) {
            return DebuggerAvailability.NeedToUpdate.INSTANCE;
        }
        return new DebuggerAvailability.Binaries<LLDBBinaries>(new LLDBBinaries(frameworkFile, frontendFile));
    }

    @NotNull
    public final DebuggerAvailability<GDBBinaries> gdbAvailability(@Nullable Project project) {
        String string;
        boolean isGdbSupportEnabled;
        RsToolchainBase toolchain2;
        Project project2 = project;
        RsToolchainBase rsToolchainBase = toolchain2 = project2 != null ? RustProjectSettingsServiceKt.getToolchain(project2) : null;
        if (toolchain2 instanceof RsEelToolchain) {
            Path gdbBinary = EelNioBridgeServiceKt.asNioPath((EelPath)EelFileSystemApiKt.getPath((EelDescriptor)((RsEelToolchain)toolchain2).getDescriptor(), (String)"/usr/bin/gdb"));
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(gdbBinary, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return DebuggerAvailability.NeedToDownload.INSTANCE;
            }
            GDBBinaries gdb = new GDBBinaries(EelNioBridgeServiceKt.asNioPath((EelPath)EelFileSystemApiKt.getPath((EelDescriptor)((RsEelToolchain)toolchain2).getDescriptor(), (String)"/usr/bin")), gdbBinary);
            return new DebuggerAvailability.Eel<GDBBinaries>(((RsEelToolchain)toolchain2).getDescriptor(), gdb);
        }
        boolean bl = SystemInfo.isLinux ? true : (SystemInfo.isWindows ? true : (isGdbSupportEnabled = SystemInfo.isMac ? false : false));
        if (!isGdbSupportEnabled) {
            return DebuggerAvailability.Unavailable.INSTANCE;
        }
        if (toolchain2 instanceof RsWslToolchain) {
            Path path = Paths.get("/usr/bin", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = Paths.get("/usr/bin/gdb", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            GDBBinaries wslGdb = new GDBBinaries(path, path2);
            return new DebuggerAvailability.WSL<GDBBinaries>(((RsWslToolchain)toolchain2).getWslPath().getDistributionId(), wslGdb);
        }
        if (CidrDebuggerPathManager.getBundledGDBBinary().exists()) {
            return DebuggerAvailability.Bundled.INSTANCE;
        }
        if (SystemInfo.isUnix) {
            string = "bin/gdb";
        } else if (SystemInfo.isWindows) {
            string = "bin/gdb.exe";
        } else {
            return DebuggerAvailability.Unavailable.INSTANCE;
        }
        String gdbBinaryPath = string;
        Path gdbDirPath = RsDebuggerToolchainService.Companion.gdbPath();
        Path gdbFile = gdbDirPath.resolve(gdbBinaryPath);
        Intrinsics.checkNotNull((Object)gdbFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(gdbFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return DebuggerAvailability.NeedToDownload.INSTANCE;
        }
        Properties versions = this.loadDebuggerVersions(DebuggerKind.GDB.INSTANCE);
        URL uRL = this.gdbUrl(project);
        if (uRL == null) {
            return DebuggerAvailability.Unavailable.INSTANCE;
        }
        URL gdbUrl = uRL;
        String string2 = gdbUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String gdbVersion = this.fileNameWithoutExtension(string2);
        if (!Intrinsics.areEqual((Object)versions.get(GDB_PROPERTY_NAME), (Object)gdbVersion)) {
            return DebuggerAvailability.NeedToUpdate.INSTANCE;
        }
        return new DebuggerAvailability.Binaries<GDBBinaries>(new GDBBinaries(gdbDirPath, gdbFile));
    }

    public static /* synthetic */ DebuggerAvailability gdbAvailability$default(RsDebuggerToolchainService rsDebuggerToolchainService, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        return rsDebuggerToolchainService.gdbAvailability(project);
    }

    @NotNull
    public final DebuggerAvailability<UserGDBBinaries> userGdbAvailability(@Nullable Path gdbFile) {
        block3: {
            block2: {
                if (gdbFile == null) break block2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(gdbFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block3;
            }
            return DebuggerAvailability.Unavailable.INSTANCE;
        }
        return new DebuggerAvailability.Binaries<UserGDBBinaries>(new UserGDBBinaries(gdbFile));
    }

    @NotNull
    public final DownloadResult downloadDebugger(@Nullable Project project, @NotNull DebuggerKind debuggerKind) {
        DownloadResult result2;
        Intrinsics.checkNotNullParameter((Object)debuggerKind, (String)"debuggerKind");
        DownloadResult downloadResult = result2 = (DownloadResult)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> RsDebuggerToolchainService.downloadDebugger$lambda$0(this, project, debuggerKind), RsBundle.INSTANCE.message("dialog.title.download.debugger", new Object[0]), true, project);
        if (downloadResult instanceof DownloadResult.Ok) {
            Notifications.Bus.notify((Notification)new Notification(RUST_DEBUGGER_GROUP_ID, RsBundle.INSTANCE.message("notification.title.debugger", new Object[0]), RsBundle.INSTANCE.message("notification.content.debugger.successfully.downloaded", new Object[0]), NotificationType.INFORMATION));
        } else if (downloadResult instanceof DownloadResult.Failed) {
            Notifications.Bus.notify((Notification)new Notification(RUST_DEBUGGER_GROUP_ID, RsBundle.INSTANCE.message("notification.title.debugger", new Object[0]), RsBundle.INSTANCE.message("notification.content.debugger.downloading.failed", new Object[0]), NotificationType.ERROR));
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    public static /* synthetic */ DownloadResult downloadDebugger$default(RsDebuggerToolchainService rsDebuggerToolchainService, Project project, DebuggerKind debuggerKind, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        return rsDebuggerToolchainService.downloadDebugger(project, debuggerKind);
    }

    private final DownloadResult downloadDebuggerSynchronously(Project project, DebuggerKind kind2) {
        List list;
        Path baseDir = this.basePath(kind2, project);
        Object object = kind2;
        if (object instanceof DebuggerKind.LLDB) {
            kotlin.Pair<URL, URL> pair = this.lldbUrls(((DebuggerKind.LLDB)kind2).getFlavor());
            if (pair == null) {
                return DownloadResult.NoUrls.INSTANCE;
            }
            kotlin.Pair<URL, URL> pair2 = pair;
            URL lldbFrameworkUrl = (URL)pair2.component1();
            URL lldbFrontendUrl = (URL)pair2.component2();
            Object[] objectArray = new DownloadableDebuggerBinary[2];
            String string = lldbFrameworkUrl.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            objectArray[0] = new DownloadableDebuggerBinary(string, LLDB_FRAMEWORK_PROPERTY_NAME);
            String string2 = lldbFrontendUrl.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            objectArray[1] = new DownloadableDebuggerBinary(string2, LLDB_FRONTEND_PROPERTY_NAME);
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (Intrinsics.areEqual((Object)object, (Object)DebuggerKind.GDB.INSTANCE)) {
            URL uRL = this.gdbUrl(project);
            if (uRL == null) {
                return DownloadResult.NoUrls.INSTANCE;
            }
            URL gdbUrl = uRL;
            String string = gdbUrl.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            list = CollectionsKt.listOf((Object)new DownloadableDebuggerBinary(string, GDB_PROPERTY_NAME));
        } else {
            if (object instanceof DebuggerKind.UserGDB) {
                return DownloadResult.NoUrls.INSTANCE;
            }
            throw new NoWhenBranchMatchedException();
        }
        List downloadableBinaries = list;
        try {
            this.downloadAndUnarchive(baseDir, downloadableBinaries);
            object = new DownloadResult.Ok(baseDir);
        }
        catch (IOException e) {
            LOG.warn("Can't download debugger", (Throwable)e);
            object = new DownloadResult.Failed(e.getMessage());
        }
        return object;
    }

    private final kotlin.Pair<URL, URL> lldbUrls(LldbFlavor $this$lldbUrls) {
        URL uRL;
        URL uRL2;
        boolean useRustLldb;
        boolean bl = useRustLldb = $this$lldbUrls == LldbFlavor.RustLldb && SystemInfo.isWindows;
        if (useRustLldb) {
            OS oS = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            uRL2 = UrlProvider.rustLldb((OS)oS, (CpuArch)cpuArch);
        } else {
            OS oS = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            uRL2 = UrlProvider.lldb((OS)oS, (CpuArch)cpuArch);
        }
        if (uRL2 == null) {
            return null;
        }
        URL lldb = uRL2;
        if (useRustLldb) {
            OS oS = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            uRL = UrlProvider.rustLldbFrontend((OS)oS, (CpuArch)cpuArch);
        } else {
            OS oS = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            uRL = UrlProvider.lldbFrontend((OS)oS, (CpuArch)cpuArch);
        }
        if (uRL == null) {
            return null;
        }
        URL lldbFrontend = uRL;
        return TuplesKt.to((Object)lldb, (Object)lldbFrontend);
    }

    private final URL gdbUrl(Project project) {
        URL uRL;
        if (project != null && RsEelToolchain.Companion.canUseEel(project)) {
            EelApi eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Project)project));
            uRL = UrlProvider.gdb((OS)EelUtilsKt.toOs((EelPlatform)eel.getPlatform()), (CpuArch)EelUtilsKt.toCpuArch((EelPlatform.Arch)eel.getPlatform().getArch()));
        } else {
            OS oS = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            uRL = UrlProvider.gdb((OS)oS, (CpuArch)cpuArch);
        }
        return uRL;
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadAndUnarchive(Path baseDir, List<DownloadableDebuggerBinary> binariesToDownload) throws IOException {
        void $this$mapTo$iv$iv;
        DownloadableFileService service = DownloadableFileService.getInstance();
        File downloadDir = baseDir.toFile();
        Intrinsics.checkNotNull((Object)downloadDir);
        FilesKt.deleteRecursively((File)downloadDir);
        Iterable $this$map$iv = binariesToDownload;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DownloadableDebuggerBinary downloadableDebuggerBinary = (DownloadableDebuggerBinary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)service);
            collection.add(this.createFileDescription(service, it2.getUrl()));
        }
        List descriptions = (List)destination$iv$iv;
        FileDownloader fileDownloader = service.createDownloader(descriptions, "Debugger downloading");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        FileDownloader downloader = fileDownloader;
        File downloadDirectory = RsDebuggerToolchainService.Companion.downloadPath().toFile();
        List list = downloader.download(downloadDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"download(...)");
        List downloadResults = list;
        Properties versions = new Properties();
        for (Pair result2 : downloadResults) {
            String downloadUrl;
            Object element$iv2;
            block3: {
                Intrinsics.checkNotNullExpressionValue((Object)((DownloadableFileDescription)result2.second).getDownloadUrl(), (String)"getDownloadUrl(...)");
                Iterable $this$first$iv = binariesToDownload;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    DownloadableDebuggerBinary it3 = (DownloadableDebuggerBinary)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it3.getUrl(), (Object)downloadUrl)) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            DownloadableDebuggerBinary binaryToDownload = (DownloadableDebuggerBinary)element$iv2;
            String propertyName = binaryToDownload.getPropertyName();
            File archiveFile = (File)result2.first;
            Intrinsics.checkNotNull((Object)archiveFile);
            Unarchiver.Companion.unarchive(archiveFile, downloadDir);
            archiveFile.delete();
            ((Map)versions).put(propertyName, this.fileNameWithoutExtension(downloadUrl));
        }
        this.saveVersionsFile(baseDir, versions);
    }

    private final DownloadableFileDescription createFileDescription(DownloadableFileService $this$createFileDescription, String url) {
        String fileName = StringsKt.substringAfterLast$default((String)url, (String)"/", null, (int)2, null);
        DownloadableFileDescription downloadableFileDescription = $this$createFileDescription.createFileDescription(url, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"createFileDescription(...)");
        return downloadableFileDescription;
    }

    private final String fileNameWithoutExtension(String url) {
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)url, (String)"/", null, (int)2, null), (CharSequence)".zip"), (CharSequence)".tar.gz");
    }

    @VisibleForTesting
    @NotNull
    public final Properties loadDebuggerVersions(@NotNull DebuggerKind kind2) {
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        return this.loadVersions(this.basePath(kind2, null));
    }

    @VisibleForTesting
    public final void saveDebuggerVersions(@NotNull DebuggerKind kind2, @NotNull Properties versions) {
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
        this.saveVersionsFile(this.basePath(kind2, null), versions);
    }

    private final void saveVersionsFile(Path basePath, Properties versions) {
        File file = basePath.resolve(DEBUGGER_VERSIONS).toFile();
        try {
            Intrinsics.checkNotNull((Object)file);
            File file2 = file;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            Object object = file2;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
            versions.store(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n), "");
        }
        catch (IOException e) {
            LOG.warn("Failed to save `" + PathsKt.getName((Path)basePath) + "/" + file.getName() + "`", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Properties loadVersions(Path basePath) {
        Properties versions = new Properties();
        File versionsFile = basePath.resolve(DEBUGGER_VERSIONS).toFile();
        if (versionsFile.exists()) {
            try {
                Intrinsics.checkNotNull((Object)versionsFile);
                Object object = versionsFile;
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                Object object3 = object;
                object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
                object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                object2 = null;
                try {
                    BufferedReader it2 = (BufferedReader)object;
                    boolean bl = false;
                    versions.load(it2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to load `" + PathsKt.getName((Path)basePath) + "/" + versionsFile.getName() + "`", (Throwable)e);
            }
        }
        return versions;
    }

    private final Path basePath(DebuggerKind $this$basePath, Project project) {
        Path path;
        DebuggerKind debuggerKind = $this$basePath;
        if (debuggerKind instanceof DebuggerKind.LLDB) {
            path = this.basePath(((DebuggerKind.LLDB)$this$basePath).getFlavor());
        } else if (Intrinsics.areEqual((Object)debuggerKind, (Object)DebuggerKind.GDB.INSTANCE)) {
            path = project != null && RsEelToolchain.Companion.canUseEel(project) ? EelPathUtils.getSystemFolder((Project)project).resolve(GDB_PROPERTY_NAME) : RsDebuggerToolchainService.Companion.gdbPath();
        } else if (debuggerKind instanceof DebuggerKind.UserGDB) {
            path = ((DebuggerKind.UserGDB)$this$basePath).getPath().getParent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Path basePath = path;
        Intrinsics.checkNotNull((Object)basePath);
        return basePath;
    }

    private final Path basePath(LldbFlavor $this$basePath) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$basePath.ordinal()]) {
            case 2 -> RsDebuggerToolchainService.Companion.rustLldbPath();
            case 1 -> RsDebuggerToolchainService.Companion.riderLldbPath();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final DownloadResult downloadDebugger$lambda$0(RsDebuggerToolchainService this$0, Project $project, DebuggerKind $debuggerKind) {
        return this$0.downloadDebuggerSynchronously($project, $debuggerKind);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsDebuggerToolchainService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DEBUGGER_VERSIONS", "", "LLDB_FRONTEND_PROPERTY_NAME", "LLDB_FRAMEWORK_PROPERTY_NAME", "GDB_PROPERTY_NAME", "RUST_DEBUGGER_GROUP_ID", "downloadPath", "Ljava/nio/file/Path;", "riderLldbPath", "rustLldbPath", "gdbPath", "getInstance", "Lorg/rust/debugger/RsDebuggerToolchainService;", "intellij.rustrover.debugger"})
    @SourceDebugExtension(value={"SMAP\nRsDebuggerToolchainService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebuggerToolchainService.kt\norg/rust/debugger/RsDebuggerToolchainService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,387:1\n42#2,3:388\n*S KotlinDebug\n*F\n+ 1 RsDebuggerToolchainService.kt\norg/rust/debugger/RsDebuggerToolchainService$Companion\n*L\n349#1:388,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path downloadPath() {
            Path path = Paths.get(PathManager.getTempPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        private final Path riderLldbPath() {
            Path path = RsPathManager.INSTANCE.pluginDirInSystem().resolve("rider-lldb");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Path rustLldbPath() {
            Path path = RsPathManager.INSTANCE.pluginDirInSystem().resolve("rust-lldb");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Path gdbPath() {
            Path path = RsPathManager.INSTANCE.pluginDirInSystem().resolve(RsDebuggerToolchainService.GDB_PROPERTY_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        @NotNull
        public final RsDebuggerToolchainService getInstance() {
            boolean $i$f$service = false;
            Class<RsDebuggerToolchainService> serviceClass$iv = RsDebuggerToolchainService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RsDebuggerToolchainService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult;", "", "<init>", "()V", "Ok", "NoUrls", "Failed", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult$Failed;", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult$NoUrls;", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult$Ok;", "intellij.rustrover.debugger"})
    public static abstract sealed class DownloadResult {
        private DownloadResult() {
        }

        public /* synthetic */ DownloadResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult$Failed;", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "intellij.rustrover.debugger"})
        public static final class Failed
        extends DownloadResult {
            @Nullable
            private final String message;

            public Failed(@Nullable String message) {
                super(null);
                this.message = message;
            }

            @Nullable
            public final String getMessage() {
                return this.message;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult$NoUrls;", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult;", "<init>", "()V", "intellij.rustrover.debugger"})
        public static final class NoUrls
        extends DownloadResult {
            @NotNull
            public static final NoUrls INSTANCE = new NoUrls();

            private NoUrls() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult$Ok;", "Lorg/rust/debugger/RsDebuggerToolchainService$DownloadResult;", "baseDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getBaseDir", "()Ljava/nio/file/Path;", "intellij.rustrover.debugger"})
        public static final class Ok
        extends DownloadResult {
            @NotNull
            private final Path baseDir;

            public Ok(@NotNull Path baseDir) {
                Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
                super(null);
                this.baseDir = baseDir;
            }

            @NotNull
            public final Path getBaseDir() {
                return this.baseDir;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$DownloadableDebuggerBinary;", "", "url", "", "propertyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getPropertyName", "intellij.rustrover.debugger"})
    private static final class DownloadableDebuggerBinary {
        @NotNull
        private final String url;
        @NotNull
        private final String propertyName;

        public DownloadableDebuggerBinary(@NotNull String url, @NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            this.url = url;
            this.propertyName = propertyName;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getPropertyName() {
            return this.propertyName;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tj\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u000f"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$Unarchiver;", "", "<init>", "(Ljava/lang/String;I)V", "ZIP", "TAR", "extension", "", "getExtension", "()Ljava/lang/String;", "createDecompressor", "Lcom/intellij/util/io/Decompressor;", "file", "Ljava/io/File;", "Companion", "intellij.rustrover.debugger"})
    private static final abstract class Unarchiver
    extends Enum<Unarchiver> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Unarchiver ZIP;
        public static final /* enum */ Unarchiver TAR;
        private static final /* synthetic */ Unarchiver[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Unarchiver() {
        }

        @NotNull
        protected abstract String getExtension();

        @NotNull
        protected abstract Decompressor createDecompressor(@NotNull File var1);

        public static Unarchiver[] values() {
            return (Unarchiver[])$VALUES.clone();
        }

        public static Unarchiver valueOf(String value) {
            return Enum.valueOf(Unarchiver.class, value);
        }

        @NotNull
        public static EnumEntries<Unarchiver> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Unarchiver(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            ZIP = new ZIP("ZIP", 0);
            TAR = new TAR("TAR", 1);
            $VALUES = unarchiverArray = new Unarchiver[]{Unarchiver.ZIP, Unarchiver.TAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/rust/debugger/RsDebuggerToolchainService$Unarchiver$Companion;", "", "<init>", "()V", "unarchive", "", "archivePath", "Ljava/io/File;", "dst", "intellij.rustrover.debugger"})
        @SourceDebugExtension(value={"SMAP\nRsDebuggerToolchainService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDebuggerToolchainService.kt\norg/rust/debugger/RsDebuggerToolchainService$Unarchiver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1#2:388\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final void unarchive(@NotNull File archivePath, @NotNull File dst) throws IOException {
                Object v1;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
                    Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
                    Iterable iterable = (Iterable)Unarchiver.getEntries();
                    for (Object t : iterable) {
                        Unarchiver it2 = (Unarchiver)((Object)t);
                        boolean bl = false;
                        String string = archivePath.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)string, (String)it2.getExtension(), (boolean)false, (int)2, null)) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                Unarchiver unarchiver = v1;
                if (unarchiver == null) {
                    throw new IllegalStateException(("Unexpected archive type: " + archivePath).toString());
                }
                Unarchiver unarchiver2 = unarchiver;
                unarchiver2.createDecompressor(archivePath).extract(dst);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"org/rust/debugger/RsDebuggerToolchainService.Unarchiver.TAR", "Lorg/rust/debugger/RsDebuggerToolchainService$Unarchiver;", "extension", "", "getExtension", "()Ljava/lang/String;", "createDecompressor", "Lcom/intellij/util/io/Decompressor;", "file", "Ljava/io/File;", "intellij.rustrover.debugger"})
        static final class TAR
        extends Unarchiver {
            @NotNull
            private final String extension;

            /*
             * WARNING - void declaration
             */
            TAR() {
                void var1_1;
                this.extension = "tar.gz";
            }

            @Override
            @NotNull
            protected String getExtension() {
                return this.extension;
            }

            @Override
            @NotNull
            protected Decompressor createDecompressor(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return (Decompressor)new Decompressor.Tar(file);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"org/rust/debugger/RsDebuggerToolchainService.Unarchiver.ZIP", "Lorg/rust/debugger/RsDebuggerToolchainService$Unarchiver;", "extension", "", "getExtension", "()Ljava/lang/String;", "createDecompressor", "Lcom/intellij/util/io/Decompressor;", "file", "Ljava/io/File;", "intellij.rustrover.debugger"})
        static final class ZIP
        extends Unarchiver {
            @NotNull
            private final String extension;

            /*
             * WARNING - void declaration
             */
            ZIP() {
                void var1_1;
                this.extension = "zip";
            }

            @Override
            @NotNull
            protected String getExtension() {
                return this.extension;
            }

            @Override
            @NotNull
            protected Decompressor createDecompressor(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return (Decompressor)new Decompressor.Zip(file);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LldbFlavor.values().length];
            try {
                nArray[LldbFlavor.RiderLldb.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LldbFlavor.RustLldb.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

